/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.lifecycle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.lifecycleapply.LifeCycleApplyHelper;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ForexBizTypeEnum;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;
import kd.tmc.tm.common.enums.OptionTypeEnum;
import kd.tmc.tm.formplugin.lifecycle.LifeCycleApplyEdit;

public class LifeCycleApplyEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String[] filterTradeTypeNumbers = new String[]{ProductTypeEnum.FOREXSPOT.getValue(), ProductTypeEnum.FOREXFORWARD.getValue(), ProductTypeEnum.FOREXSWAPS.getValue(), ProductTypeEnum.FOREXOPTION.getValue()};
    private static final String OP_TYPE_EXPIREDEY = "expiredey";
    private static final String OP_TYPE_FLAT = "flat";
    private static final String OP_TYPE_DEFER = "defer";
    private static final String OP_TYPE_MAUDATE = "maudate";
    private static final String OP_TYPE_BDELIVERY = "bdelivery";
    private static final String OP_TYPE_EXERCISE = "exercise";
    private static final String OP_TYPE_GIVEUP = "giveup";
    private static final String EMPTY_STR = "";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tradeno = (BasedataEdit)this.getView().getControl("tradeno");
        tradeno.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tradetype = (BasedataEdit)this.getView().getControl("tradetype");
        tradetype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        CardEntry entryEntity = (CardEntry)this.getView().getControl("entryentity");
        entryEntity.addRowClickListener((RowClickEventListener)this);
        BasedataEdit tradebill = (BasedataEdit)this.getView().getControl("tradeno");
        Optional.ofNullable(tradebill).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getRow() == ((Integer)this.getModel().getValue("currentselectedcardindex")).intValue()) {
            return;
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currentselectedcardid", (Object)this.getModel().getValue("lifecyclecardid", evt.getRow()));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currentselectedcardindex", (Object)String.valueOf(evt.getRow()));
        this.clearLifeCycleOperation();
        this.clearApplyInfo();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"applypane"});
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remainingunexpireamount", (Object)this.getModel().getValue("unexpireamount"));
        Object tradeId = ((DynamicObject)this.getModel().getValue("tradeno")).getPkValue();
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        String tradeBillEntityName = this.getTradeBillEntityName(tradeTypeNumber);
        DynamicObject originalTradeBill = LifeCycleApplyHelper.queryTradeBillWithValidateIsExist((String)tradeBillEntityName, (String)"bizdate", (QFilter[])new QFilter("id", "=", tradeId).toArray());
        this.setApplyDate(originalTradeBill, false);
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"swaptype", "farornear"});
        try {
            this.updateContractByTradeType();
            this.updateLifeTypeItemsByTradeType();
            this.updateLifeTypeItemsByFarOrNear();
            if (this.getModel().getValue("opdate") == null) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"lifecycleapplypanel"});
            } else {
                if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
                    this.clearLifeCycleOperation();
                    this.clearApplyInfo();
                    this.tradeNoSelectedEvent((Long)this.getModel().getValue("currentselectedcardid"), true, false);
                } else {
                    this.tradeNoSelectedEvent((Long)this.getModel().getValue("currentselectedcardid"), true, true);
                    this.reset("applydate", "opdate", "applydeliverydate");
                }
                this.initApplyInfoControl((String)this.getModel().getValue("lifecycleoperation"));
            }
            this.setLabelText_forexSpot();
            this.initDealInfoPane();
        }
        catch (KDBizException exception) {
            if ("Invalid bill".equals(exception.getErrorCode().getCode())) {
                this.getModel().setValue("tradeno", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"swaptype", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"farornear", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buycurrency", null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellcurrency", null);
                this.getModel().deleteEntryData("entryentity");
                this.getView().setVisible(Boolean.FALSE, new String[]{"lifecycleapplypanel", "dealinfopane"});
                this.getModel().setDataChanged(false);
                this.getView().showErrorNotification(exception.getErrorCode().getMessage());
            }
            throw exception;
        }
        this.getModel().setDataChanged(false);
    }

    private void reset(String ... keys) {
        HashMap<String, Object> originalValMap = new HashMap<String, Object>(8);
        for (String key : keys) {
            originalValMap.put(key, this.getModel().getValue(key));
        }
        for (String key : keys) {
            Object originalVal = originalValMap.get(key);
            if (!EmptyUtil.isNoEmpty(originalVal)) continue;
            this.getModel().setValue(key, null);
            this.getModel().setValue(key, originalVal);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String FieldKey = arg.getProperty().getName();
        if ("tradeno".equals(FieldKey)) {
            DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
            if (tradeType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea7\u54c1\u7c7b\u578b\u3002", (String)"LifeCycleApplyEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                arg.setCancel(true);
                return;
            }
            Object tradeTypeId = tradeType.getPkValue();
            QFilter filter = new QFilter("protecttype", "=", tradeTypeId).and(new QFilter("billstatus", "=", (Object)TcBillStatusEnum.SURVIVAL.getValue()));
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"08", (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47156aff000000ac");
            if (result == null) {
                filter.and(new QFilter("org", "=", (Object)RequestContext.get().getOrgId()));
            } else if (!result.hasAllOrgPerm()) {
                filter.and(new QFilter("org", "in", (Object)result.getHasPermOrgs()));
            }
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filter);
        } else if ("tradetype".equals(FieldKey)) {
            QFilter filter = new QFilter("number", "in", (Object)filterTradeTypeNumbers);
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("tradeno".equals(propertyName)) {
            this.clearLifeCycleOperation();
            this.clearApplyInfo();
            this.tradeNoSelectedEvent(null, false, false);
            this.setLabelText_forexSpot();
            return;
        }
        if ("tradetype".equals(propertyName)) {
            this.getModel().deleteEntryData("entryentity");
            this.clearLifeCycleApplyInfo();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradeno", null);
            this.updateContractByTradeType();
            this.updateLifeTypeItemsByTradeType();
            return;
        }
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue("tradetype"), this.getModel().getValue("tradeno")})) {
            return;
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        String lifeCycleOperation = this.getModel().getValue("lifecycleoperation") == null ? EMPTY_STR : (String)this.getModel().getValue("lifecycleoperation");
        ProductTypeEnum tradeType = ProductTypeEnum.getEnumByValue((String)tradeTypeNumber);
        if ("applydate".equals(propertyName)) {
            this.applyDateChanged();
        }
        if ("ischoosedate".equals(propertyName)) {
            if (((Boolean)this.getModel().getValue("ischoosedate")).booleanValue()) {
                this.getModel().setValue("applydeliverydate", null);
            } else {
                this.getModel().setValue("expiredateend", null);
                this.getModel().setValue("expiredatestart", null);
                this.getView().updateView("expiredatesection");
            }
        }
        switch (1.$SwitchMap$kd$tmc$fbp$common$enums$ProductTypeEnum[tradeType.ordinal()]) {
            case 1: {
                this.propertyChangedForForward(propertyName, newValue, lifeCycleOperation);
                break;
            }
            case 2: {
                this.propertyChangedForSpot(propertyName, newValue, lifeCycleOperation);
                break;
            }
            case 3: {
                this.propertyChangedForSwaps(propertyName, newValue, lifeCycleOperation);
                break;
            }
            case 4: {
                this.propertyChangedForOptions(propertyName, newValue, lifeCycleOperation);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradeno");
                Object currentSelectedCardId = this.getModel().getValue("currentselectedcardid");
                if (EmptyUtil.isNoEmpty((DynamicObject)tradeBill) && !QueryServiceHelper.exists((String)"tm_forex_forward", (QFilter[])new QFilter("id", "=", tradeBill.getPkValue()).and("billstatus", "=", (Object)TcBillStatusEnum.SURVIVAL.getValue()).toArray()) || EmptyUtil.isNoEmpty((Object)currentSelectedCardId) && !QueryServiceHelper.exists((String)"tm_bizrecord", (QFilter[])new QFilter("id", "=", currentSelectedCardId).toArray())) break;
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "bar_push": {
                if (!TcBillStatusEnum.AUDIT.getValue().equals(this.getModel().getValue("billstatus"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u751f\u547d\u5468\u671f\u7533\u8bf7\u5355\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LifeCycleApplyEdit_19", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    evt.setCancel(true);
                    break;
                }
                if (BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"tm_lifecycle_apply", (String)"isgenaratealready").getBoolean("isgenaratealready")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u751f\u6210\u751f\u547d\u5468\u671f\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LifeCycleApplyEdit_20", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    evt.setCancel(true);
                    break;
                }
                QFilter filter = new QFilter("tradebill", "=", ((DynamicObject)this.getModel().getValue("tradeno")).getPkValue()).and(new QFilter("billstatus", "in", (Object)new String[]{TcBillStatusEnum.SAVE.getValue(), TcBillStatusEnum.SUBMIT.getValue()}));
                if (QueryServiceHelper.exists((String)"tm_businessbill", (QFilter[])new QFilter[]{filter})) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"{0}\u8be5\u4ea4\u6613\u5355\u5b58\u5728\u672a\u5ba1\u6279\u7684\u751f\u547d\u5468\u671f\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LifeCycleApplyEdit_18", (String)"tmc-tm-formplugin", (Object[])new Object[]{((DynamicObject)this.getModel().getValue("tradeno")).getString("number")}), Integer.valueOf(3000));
                    evt.setCancel(true);
                    break;
                }
                String billStatus = ((DynamicObject)this.getModel().getValue("tradeno")).getString("billstatus");
                if (TcBillStatusEnum.SURVIVAL.getValue().equals(billStatus)) break;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"{0}\u8be5\u4ea4\u6613\u5355\u4e0d\u662f\u5b58\u7eed\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"LifeCycleApplyEdit_21", (String)"tmc-tm-formplugin", (Object[])new Object[]{((DynamicObject)this.getModel().getValue("tradeno")).getString("number")}), Integer.valueOf(3000));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (!("opdate".equals(key) || "buyamount".equals(key) || "sellamount".equals(key) || "lifecycleoperation".equals(key) || "applydate".equals(key))) {
            return;
        }
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("tradeno".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
            String number = tradeType.getString("number");
            String formid = "tm_trade";
            if (ProductTypeEnum.FOREXSPOT.getValue().equals(number)) {
                formid = "tm_forex_l";
            } else if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number)) {
                formid = "tm_forex_forward_l";
            } else if (ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
                formid = "tm_forex_swaps_l";
            } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
                formid = "tm_forex_options_l";
            } else if (ProductTypeEnum.STRUCTDEPOSIT.getValue().equals(number)) {
                formid = "tm_structdeposit_l";
            } else if (ProductTypeEnum.SWAP.getValue().equals(number)) {
                formid = "tm_rateswap_l";
            } else if (ProductTypeEnum.FORWRATEAGREE.getValue().equals(number)) {
                formid = "tm_forwrateagree_l";
            }
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void applyDateChanged() {
        Date applyDate = (Date)this.getModel().getValue("applydate");
        Date opDate = (Date)this.getModel().getValue("opdate");
        Date deliveryDate = (Date)this.getModel().getValue("applydeliverydate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{applyDate, opDate}) && applyDate.after(opDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", null);
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{applyDate, deliveryDate}) && applyDate.after(deliveryDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", null);
        }
    }

    private void removeNonSelectedCards() {
        ArrayList<Integer> removeIndexList = new ArrayList<Integer>();
        for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
            long lifeCycleCardId;
            long currentSelectedCardId = (Long)this.getModel().getValue("currentselectedcardid");
            if (currentSelectedCardId == (lifeCycleCardId = ((Long)this.getModel().getValue("lifecyclecardid", i)).longValue())) continue;
            removeIndexList.add(i);
        }
        this.getModel().deleteEntryRows("entryentity", removeIndexList.stream().mapToInt(Integer::valueOf).toArray());
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currentselectedcardindex", (Object)0);
        ((CardEntry)this.getView().getControl("entryentity")).selectCard(Integer.valueOf(0));
    }

    private void propertyChangedForOptions(String propertyName, Object newValue, String lifeCycleOperation) {
        block7 : switch (propertyName) {
            case "lifecycleoperation": {
                this.clearApplyInfo();
                this.initApplyInfoForOptions((String)newValue);
                break;
            }
            case "opdate": {
                if (!OP_TYPE_EXERCISE.equals(lifeCycleOperation)) break;
                this.setDeliveryDate();
                break;
            }
            case "buyamount": {
                this.buyAmountChanged();
                break;
            }
            case "sellamount": {
                this.sellAmountChanged();
                break;
            }
            case "applydate": {
                switch (lifeCycleOperation = lifeCycleOperation == null ? EMPTY_STR : lifeCycleOperation) {
                    case "exercise": {
                        this.setDate_options_exercise();
                        break block7;
                    }
                    case "flat": 
                    case "giveup": {
                        this.setOpDate5();
                        break block7;
                    }
                }
            }
        }
    }

    private void propertyChangedForSwaps(String propertyName, Object newValue, String lifeCycleOperation) {
        block9 : switch (propertyName) {
            case "applydate": {
                switch (lifeCycleOperation = lifeCycleOperation == null ? EMPTY_STR : lifeCycleOperation) {
                    case "expiredey": {
                        this.setDate_swaps_expireDey();
                        break;
                    }
                    case "defer": {
                        this.setDate_swaps_defer();
                        break;
                    }
                    case "flat": {
                        this.setDate_swaps_flat();
                        break;
                    }
                    case "maudate": {
                        this.setDate_swaps_mauDate();
                        break;
                    }
                    case "bdelivery": {
                        this.setDate_swaps_bDelivery();
                        break;
                    }
                }
            }
            case "opdate": {
                switch (lifeCycleOperation) {
                    case "expiredey": {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getModel().getValue("opdate"));
                        break block9;
                    }
                    case "defer": {
                        this.setExpireDateByOpDate();
                        break block9;
                    }
                    case "maudate": {
                        this.setMinDate("applydeliverydate", (Date)this.getModel().getValue("opdate"));
                        break block9;
                    }
                    case "bdelivery": {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getModel().getValue("opdate"));
                        this.setMinDate("applydeliverydate", (Date)this.getModel().getValue("opdate"));
                        break block9;
                    }
                }
                break;
            }
            case "lifecycleoperation": {
                this.clearApplyInfo();
                this.initApplyInfoForSwaps((String)newValue);
                if (!OP_TYPE_BDELIVERY.equals(lifeCycleOperation)) break;
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"applydeliverydate"});
                break;
            }
            case "buyamount": {
                this.buyAmountChanged();
                break;
            }
            case "sellamount": {
                this.sellAmountChanged();
                break;
            }
            case "farornear": {
                DynamicObject originalRow = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)this.getModel().getValue("tradeno")).getPkValue(), (String)"tm_forex_swaps");
                this.setBizTypeAndCurrencyForForexSwaps(originalRow);
                this.getModel().setValue("lifecycleoperation", null);
                Object tradeId = ((DynamicObject)this.getModel().getValue("tradeno")).getPkValue();
                QFilter filter = new QFilter("tradebillid", "=", tradeId);
                DynamicObjectCollection bizRecordCol = LifeCycleApplyHelper.queryBizRecordsWithValidateIsExist((String)"tm_bizrecord", (String)"id,bizdate,enddate,exrate,restamt,swapdir,desc", (QFilter[])new QFilter[]{filter});
                DynamicObject[] bizrecords = (DynamicObject[])bizRecordCol.stream().toArray(DynamicObject[]::new);
                bizrecords = this.dealWithFarOrNear(bizrecords, (String)newValue, true);
                this.initLifeCycleCards(bizrecords, null);
                this.updateLifeTypeItemsByFarOrNear();
                String op = this.getString("lifecycleoperation");
                if (!EmptyUtil.isNoEmpty((String)op)) break;
                this.propertyChangedForSwaps("lifecycleoperation", op, op);
                break;
            }
            case "swaptype": {
                this.setNull("lifecycleoperation");
                this.updateLifeTypeItemsByFarOrNear();
            }
        }
    }

    private void propertyChangedForSpot(String propertyName, Object newValue, String lifeCycleOperation) {
        block7 : switch (propertyName) {
            case "applydate": {
                switch (lifeCycleOperation = lifeCycleOperation == null ? EMPTY_STR : lifeCycleOperation) {
                    case "expiredey": {
                        this.setDate_spot_expireDey();
                        break block7;
                    }
                    case "flat": {
                        this.setOpDate(true);
                        break block7;
                    }
                }
                break;
            }
            case "opdate": {
                switch (lifeCycleOperation) {
                    case "expiredey": {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getModel().getValue("opdate"));
                    }
                }
                break;
            }
            case "lifecycleoperation": {
                this.clearApplyInfo();
                this.initApplyInfoForSpot((String)newValue);
                break;
            }
            case "buyamount": {
                this.buyAmountChanged();
                break;
            }
            case "sellamount": {
                this.sellAmountChanged();
            }
        }
    }

    private void propertyChangedForForward(String propertyName, Object newValue, String lifeCycleOperation) {
        block7 : switch (propertyName) {
            case "applydate": {
                switch (lifeCycleOperation = lifeCycleOperation == null ? EMPTY_STR : lifeCycleOperation) {
                    case "expiredey": {
                        this.setDate_forward_expireDey();
                        break block7;
                    }
                    case "bdelivery": {
                        this.setDate_forward_bDelivery();
                        break block7;
                    }
                    case "flat": {
                        this.setOpDate(true);
                        break block7;
                    }
                    case "defer": {
                        this.setDate_forward_defer();
                        break block7;
                    }
                    case "maudate": {
                        this.setDate_forward_mauDate();
                        break block7;
                    }
                }
                break;
            }
            case "opdate": {
                switch (lifeCycleOperation) {
                    case "expiredey": {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getModel().getValue("opdate"));
                        break block7;
                    }
                    case "bdelivery": {
                        this.setMinDate("applydeliverydate", (Date)this.getModel().getValue("opdate"));
                        break block7;
                    }
                    case "defer": {
                        this.setExpireDateAndSectionByOpDate();
                        break block7;
                    }
                    case "maudate": {
                        Date dOpDate = (Date)this.getModel().getValue("opdate");
                        Date exDateRangeEndDate = (Date)this.getModel().getValue("exdaterange_enddate");
                        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
                        deliveryDate = deliveryDate == null ? (exDateRangeEndDate == null ? null : exDateRangeEndDate) : deliveryDate;
                        Date previousDeliveryDay = null;
                        if (deliveryDate != null) {
                            previousDeliveryDay = TcDateUtils.getNextDay((Date)deliveryDate, (int)-1);
                        }
                        this.setMinDate("applydeliverydate", dOpDate);
                        this.setMaxDate("applydeliverydate", previousDeliveryDay);
                        ((DateRangeEdit)this.getView().getControl("expiredatesection")).setMinDate(dOpDate);
                        ((DateRangeEdit)this.getView().getControl("expiredatesection")).setMaxDate(previousDeliveryDay);
                        break block7;
                    }
                }
                break;
            }
            case "lifecycleoperation": {
                this.clearApplyInfo();
                this.initApplyInfoForForward((String)newValue);
                if (!OP_TYPE_BDELIVERY.equals(lifeCycleOperation)) break;
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"applydeliverydate"});
                break;
            }
            case "buyamount": {
                this.buyAmountChanged();
                break;
            }
            case "sellamount": {
                this.sellAmountChanged();
            }
        }
    }

    private void tradeNoSelectedEvent(Long selectedRowId, boolean isInitForm, boolean isShowApplyPane) {
        if (this.getModel().getValue("tradeno") == null) {
            return;
        }
        Object tradeId = ((DynamicObject)this.getModel().getValue("tradeno")).getPkValue();
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        String tradeBillEntityName = this.getTradeBillEntityName(tradeTypeNumber);
        DynamicObject originalTradeBill = BusinessDataServiceHelper.loadSingle((Object)tradeId, (String)tradeBillEntityName);
        if (!isShowApplyPane && TcBillStatusEnum.FINISH.getValue().equals(originalTradeBill.getString("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"{0}\u4ea4\u6613\u5355\u5df2\u7ed3\u675f\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u4ea4\u6613\u5355\u53f7\u3002", (String)"LifeCycleApplyEdit_17", (String)"tmc-tm-formplugin", (Object[])new Object[]{originalTradeBill.get("billno")}), Integer.valueOf(3000));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradeno", null);
            return;
        }
        this.setValueWhenValueNotNull("org", originalTradeBill, "org");
        if (isInitForm && isShowApplyPane && (TcBillStatusEnum.SUBMIT.getValue().equals(this.getModel().getValue("billstatus")) || TcBillStatusEnum.AUDIT.getValue().equals(this.getModel().getValue("billstatus")))) {
            this.removeNonSelectedCards();
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            cardEntry.setChildVisible(this.getModel().getValue("deliverydate", 0) != null, 0, new String[]{"deliverydatepanelap"});
            cardEntry.setChildVisible(this.getModel().getValue("exdaterange_startdate", 0) != null, 0, new String[]{"exdaterangepanelap"});
            this.setCardLabel();
            this.selectCard(selectedRowId);
        } else {
            QFilter filter = new QFilter("tradebillid", "=", tradeId);
            DynamicObjectCollection bizRecordCol = LifeCycleApplyHelper.queryBizRecordsWithValidateIsExist((String)"tm_bizrecord", (String)"id,bizdate,enddate,exrate,restamt,swapdir,desc", (QFilter[])new QFilter[]{filter}, (String)"lv,seqno asc");
            DynamicObject[] bizRecords = (DynamicObject[])bizRecordCol.stream().toArray(DynamicObject[]::new);
            if (ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"swaptype", (Object)originalTradeBill.get("swaptype"));
                bizRecords = this.dealWithFarOrNear(bizRecords, null, isInitForm);
            }
            this.initLifeCycleCards(bizRecords, selectedRowId);
        }
        this.setValForContract(isInitForm, tradeTypeNumber, originalTradeBill);
        if (ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber)) {
            this.updateLifeTypeItemsByFarOrNear();
        }
        if (this.getModel().getEntryEntity("entryentity").size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"lifecycleapplypanel"});
            this.getView().setVisible(Boolean.valueOf(isShowApplyPane), new String[]{"applypane"});
        }
        if (!isInitForm || !isShowApplyPane) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remainingunexpireamount", (Object)this.getModel().getValue("unexpireamount"));
        }
        this.setApplyDate(originalTradeBill, isInitForm);
    }

    private void setLabelText_forexSpot() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("tradetype"))) {
            return;
        }
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        if (ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber)) {
            ((Label)this.getView().getControl("deliverydatelab")).setText(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\uff1a", (String)"LifeCycleApplyEdit_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        } else {
            ((Label)this.getView().getControl("deliverydatelab")).setText(ResManager.loadKDString((String)"\u8c03\u6574\u4ea4\u5272\u65e5\uff1a", (String)"LifeCycleApplyEdit_7", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setApplyDate(DynamicObject originalTradeBill, boolean isInitForm) {
        DynamicObject bizRecord;
        DynamicObject businessBill;
        Date bizDate = null;
        Object selectedCardId = this.getModel().getValue("currentselectedcardid");
        if (EmptyUtil.isNoEmpty((Object)selectedCardId) && EmptyUtil.isNoEmpty((DynamicObject)(businessBill = QueryServiceHelper.queryOne((String)"tm_businessbill", (String)"bizdate", (QFilter[])new QFilter("id", "=", (bizRecord = LifeCycleApplyHelper.queryTradeBillWithValidateIsExist((String)"tm_bizrecord", (String)"srcbizbill", (QFilter[])new QFilter("id", "=", selectedCardId).toArray())).get("srcbizbill")).toArray())))) {
            bizDate = businessBill.getDate("bizdate");
        }
        if (bizDate == null) {
            bizDate = originalTradeBill.getDate("bizdate");
        }
        Date currentDate = TcDateUtils.getCurrentDate();
        if (!isInitForm && bizDate != null && !bizDate.after(currentDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydate", (Object)currentDate);
        }
        this.setMinDate("applydate", bizDate);
    }

    private String getTradeBillEntityName(String tradeTypeNumber) {
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber)) {
            return "tm_forex_forward";
        }
        if (ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber)) {
            return "tm_forex";
        }
        if (ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber)) {
            return "tm_forex_swaps";
        }
        return "tm_forex_options";
    }

    private void setValForContract(boolean isInitForm, String tradeTypeNumber, DynamicObject originalTradeBill) {
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"adjexpiredate", (Object)originalTradeBill.get("adjexpiredate"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"optionsdirect", (Object)originalTradeBill.get("tradetype"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradedirect", (Object)originalTradeBill.get("tradedirect"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deliveryway", (Object)originalTradeBill.get("deliveryway"));
            this.getModel().setValue("optiontype", originalTradeBill.get("optiontype"));
        } else if (ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deliveryway", (Object)originalTradeBill.get("deliveryway"));
        }
        if (ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber)) {
            this.setBizTypeAndCurrencyForForexSwaps(originalTradeBill);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"biztype", (Object)originalTradeBill.get("biztype"));
            if (!ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber) && TradeDirectionEnum.buy.getValue().equals(originalTradeBill.get("tradedirect")) || ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber) && ("call".equals(this.getString("optionsdirect")) && TradeDirectionEnum.buy.getValue().equals(this.getString("tradedirect")) || "put".equals(this.getString("optionsdirect")) && TradeDirectionEnum.sell.getValue().equals(this.getString("tradedirect")))) {
                this.setValueWhenValueNotNull("buycurrency", originalTradeBill, "currency");
                this.setValueWhenValueNotNull("sellcurrency", originalTradeBill, "sellcurrency");
            } else {
                this.setValueWhenValueNotNull("buycurrency", originalTradeBill, "sellcurrency");
                this.setValueWhenValueNotNull("sellcurrency", originalTradeBill, "currency");
            }
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fxquote", (Object)originalTradeBill.get("fxquote"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pair", (Object)originalTradeBill.get("pair"));
        this.setUnExpireCurrency();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"direction", (Object)(originalTradeBill.getString("pair").startsWith(((DynamicObject)this.getModel().getValue("buycurrency")).getString("number")) ? TradeDirectionEnum.buy.getValue() : TradeDirectionEnum.sell.getValue()));
        if (!isInitForm && ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber)) {
            this.getModel().setValue("ischoosedate", (Object)originalTradeBill.getBoolean("isdaterange"));
        }
    }

    private void setUnExpireCurrency() {
        Object buyCurrency;
        Object pair = this.getModel().getValue("pair");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, buyCurrency = this.getModel().getValue("buycurrency")})) {
            return;
        }
        Object currency = ((String)pair).startsWith(((DynamicObject)buyCurrency).getString("number")) ? buyCurrency : this.getModel().getValue("sellcurrency");
        this.getModel().setValue("currency", currency);
    }

    private void setBizTypeAndCurrencyForForexSwaps(DynamicObject originalRow) {
        if ("spot".equals(this.getModel().getValue("farornear"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"biztype", (Object)originalRow.get("biztype"));
        } else if (ForexBizTypeEnum.buy.getValue().equals(originalRow.get("biztype"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"biztype", (Object)ForexBizTypeEnum.sell.getValue());
        } else if (ForexBizTypeEnum.sell.getValue().equals(originalRow.get("biztype"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"biztype", (Object)ForexBizTypeEnum.buy.getValue());
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"biztype", (Object)"diff");
        }
        if (TradeDirectionEnum.buy.getValue().equals(originalRow.get("tradedirect")) && "spot".equals(this.getModel().getValue("farornear")) || TradeDirectionEnum.sell.getValue().equals(originalRow.get("tradedirect")) && "fwd".equals(this.getModel().getValue("farornear"))) {
            this.setValueWhenValueNotNull("buycurrency", originalRow, "currency");
            this.setValueWhenValueNotNull("sellcurrency", originalRow, "sellcurrency");
        } else {
            this.setValueWhenValueNotNull("buycurrency", originalRow, "sellcurrency");
            this.setValueWhenValueNotNull("sellcurrency", originalRow, "currency");
        }
    }

    private DynamicObject[] dealWithFarOrNear(DynamicObject[] bizrecords, String farOrNear, boolean isInitForm) {
        if (farOrNear == null) {
            farOrNear = "fwd";
            for (DynamicObject bizrecord : bizrecords) {
                BigDecimal restAmt = (BigDecimal)bizrecord.get("restamt");
                if (!"isnear".equals(bizrecord.get("swapdir")) || restAmt == null || restAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                farOrNear = "spot";
                break;
            }
            if (!isInitForm) {
                this.getModel().setValue("farornear", (Object)farOrNear);
            }
        }
        return this.filterCardsByFarOrNear(bizrecords);
    }

    private DynamicObject[] filterCardsByFarOrNear(DynamicObject[] bizrecords) {
        String farOrNear = (String)this.getModel().getValue("farornear");
        List<Object> list = "spot".equals(farOrNear) ? Arrays.stream(bizrecords).filter(row -> "isnear".equals(row.get("swapdir"))).collect(Collectors.toList()) : Arrays.stream(bizrecords).filter(row -> "isfar".equals(row.get("swapdir"))).collect(Collectors.toList());
        return list.toArray(new DynamicObject[0]);
    }

    private void initLifeCycleCards(DynamicObject[] bizrecords, Long selectedRowId) {
        this.getModel().deleteEntryData("entryentity");
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        for (DynamicObject bizrecord : bizrecords) {
            BigDecimal restAmt = bizrecord.getBigDecimal("restamt");
            if (restAmt != null && restAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("cardtitle", (Object)bizrecord.getString("desc"), index);
            this.getModel().setValue("lifecyclecardid", bizrecord.get("id"), index);
            Date bizDate = (Date)bizrecord.get("bizdate");
            Date endDate = (Date)bizrecord.get("enddate");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizDate, endDate})) {
                this.getModel().setValue("exdaterange_startdate", (Object)bizDate, index);
                this.getModel().setValue("exdaterange_enddate", (Object)endDate, index);
                cardEntry.setChildVisible(false, index, new String[]{"deliverydatepanelap"});
            } else {
                cardEntry.setChildVisible(false, index, new String[]{"exdaterangepanelap"});
                if (bizDate == null) {
                    cardEntry.setChildVisible(false, index, new String[]{"deliverydatepanelap"});
                } else {
                    this.getModel().setValue("deliverydate", (Object)bizDate, index);
                }
            }
            this.setCardLabel();
            this.getModel().setValue("rate", bizrecord.get("exrate"), index);
            this.getModel().setValue("unexpireamount", (Object)restAmt, index);
        }
        this.selectCard(selectedRowId);
    }

    private void setCardLabel() {
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        Label rateLabel = (Label)this.getView().getControl("ratelab");
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber) || ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber)) {
            rateLabel.setText(ResManager.loadKDString((String)"\u8fdc\u671f\u6c47\u7387\uff1a", (String)"LifeCycleApplyEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        } else if (ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber)) {
            rateLabel.setText(ResManager.loadKDString((String)"\u5373\u671f\u6c47\u7387\uff1a", (String)"LifeCycleApplyEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber)) {
            rateLabel.setText(ResManager.loadKDString((String)"\u6267\u884c\u6c47\u7387\uff1a", (String)"LifeCycleApplyEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    private void selectCard(Long selectedRowId) {
        if (selectedRowId == null) {
            if (this.getModel().getEntryRowCount("entryentity") == 0) {
                return;
            }
            int selectedIndex = 0;
            Date date = this.getModel().getValue("deliverydate", 0) == null ? (Date)this.getModel().getValue("exdaterange_enddate", 0) : (Date)this.getModel().getValue("deliverydate", 0);
            for (int i = 1; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
                Date rowDate;
                Date date2 = rowDate = this.getModel().getValue("deliverydate", i) == null ? (Date)this.getModel().getValue("exdaterange_enddate", i) : (Date)this.getModel().getValue("deliverydate", i);
                if (rowDate.compareTo(date) >= 0) continue;
                selectedIndex = i;
                date = rowDate;
            }
            ((CardEntry)this.getView().getControl("entryentity")).selectCard(Integer.valueOf(selectedIndex));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currentselectedcardid", (Object)this.getModel().getValue("lifecyclecardid", selectedIndex));
        } else {
            for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
                if (selectedRowId.longValue() != ((Long)this.getModel().getValue("lifecyclecardid", i)).longValue()) continue;
                ((CardEntry)this.getView().getControl("entryentity")).selectCard(Integer.valueOf(i));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currentselectedcardindex", (Object)i);
                break;
            }
        }
    }

    private void initDealInfoPane() {
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        if (tradeType == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dealinfopane"});
            return;
        }
        String tradeTypeNumber = tradeType.getString("number");
        if (!TcBillStatusEnum.AUDIT.getValue().equals(this.getModel().getValue("billstatus")) && !this.isUnitTest()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dealinfopane"});
            return;
        }
        DynamicObject[] targetBill = TmcBotpHelper.getTargetBills((String)"tm_lifecycle_apply", (Object)this.getModel().getValue("id"), (String)"tm_businessbill", null);
        if (targetBill == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dealinfopane"});
            if (this.isUnitTest()) {
                targetBill = new DynamicObject[]{BusinessDataServiceHelper.newDynamicObject((String)"tm_businessbill")};
            } else {
                return;
            }
        }
        DynamicObject dynamicObject = targetBill[0];
        String ope = (String)this.getModel().getValue("lifecycleoperation");
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"dealinfopane"});
        if (OP_TYPE_DEFER.equals(ope)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"beforerate", "closerate", "bdeliveryrate", "settledate", "premium_src"});
        } else if (OP_TYPE_MAUDATE.equals(ope)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"deferrate", "closerate", "bdeliveryrate", "settledate", "premium_src"});
        } else if (!ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber) && OP_TYPE_FLAT.equals(ope)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedeliverydaysection", "tradedeliverydate", "deferrate", "beforerate", "bdeliveryrate", "settledate", "premium_src"});
        } else if (OP_TYPE_BDELIVERY.equals(ope)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedeliverydaysection", "deferrate", "beforerate", "closerate", "settledate", "premium_src"});
        } else if (OP_TYPE_EXPIREDEY.equals(ope)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedeliverydaysection", "deferrate", "beforerate", "closerate", "bdeliveryrate", "settledate", "premium_src"});
        } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber) && OP_TYPE_FLAT.equals(ope)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedeliverydaysection", "tradedeliverydate", "deferrate", "beforerate", "bdeliveryrate", "closerate"});
        } else if (OP_TYPE_EXERCISE.equals(ope)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedeliverydaysection", "deferrate", "beforerate", "closerate", "bdeliveryrate", "settledate", "premium_src"});
        } else if (OP_TYPE_GIVEUP.equals(ope)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedeliverydate", "tradedeliverydaysection", "deferrate", "beforerate", "closerate", "bdeliveryrate", "settledate", "premium_src"});
        }
        if (OP_TYPE_DEFER.equals(ope) || OP_TYPE_MAUDATE.equals(ope)) {
            ((DateEdit)this.getView().getControl("tradedeliverydate")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8c03\u6574\u4ea4\u5272\u65e5", (String)"LifeCycleApplyEdit_25", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
            ((DateRangeEdit)this.getView().getControl("tradedeliverydaysection")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u8c03\u6574\u4ea4\u5272\u65e5\u533a\u95f4", (String)"LifeCycleApplyEdit_26", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
        }
        if (!dynamicObject.getBoolean("isdaterange")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedeliverydaysection"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tradedeliverydate"});
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradebillstatus", (Object)dynamicObject.get("billstatus"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradenumber", (Object)dynamicObject.get("billno"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradeopdate", (Object)dynamicObject.get("bizdate"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradedeliverydate", (Object)dynamicObject.get("deliverydate"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deferrate", (Object)dynamicObject.get("spotrate_dey"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"beforerate", (Object)dynamicObject.get("spotrate_dey"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"closerate", (Object)dynamicObject.get("execexrate"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bdeliveryrate", (Object)dynamicObject.get("spotrate_dey"));
        if (TradeDirectionEnum.buy.getValue().equals(this.getModel().getValue("direction"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradebuyamount", (Object)dynamicObject.get("bizamt1"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradesellamount", (Object)dynamicObject.get("bizamt2"));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradebuyamount", (Object)dynamicObject.get("bizamt2"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradesellamount", (Object)dynamicObject.get("bizamt1"));
        }
        this.getModel().setValue("tradedeliverydaysection_startdate", dynamicObject.get("deydate_start"));
        this.getModel().setValue("tradedeliverydaysection_enddate", dynamicObject.get("deydate_end"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate", (Object)dynamicObject.get("plsettledate"));
        this.getModel().setValue("premcurrency_src", dynamicObject.get("settlecurrency"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_src", (Object)dynamicObject.get("settleamount"));
    }

    private void updateLifeTypeItemsByFarOrNear() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("tradetype"))) {
            return;
        }
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        if (!ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber)) {
            return;
        }
        ComboEdit lifeCycleOperation = (ComboEdit)this.getControl("lifecycleoperation");
        List<Object> data = new ArrayList();
        if (this.getModel().getEntryRowCount("entryentity") == 0) {
            lifeCycleOperation.setComboItems(data);
            return;
        }
        if (EMPTY_STR.equals(this.getModel().getValue("farornear")) || EMPTY_STR.equals(this.getModel().getValue("swaptype"))) {
            return;
        }
        if (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(this.getModel().getValue("swaptype"))) {
            data = this.assembleLifeCycleOpeItems2();
        } else if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(this.getModel().getValue("swaptype"))) {
            data = "spot".equals(this.getModel().getValue("farornear")) ? this.assembleLifeCycleOpeItems2() : this.assembleLifeCycleOpeItems5();
        } else if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(this.getModel().getValue("swaptype"))) {
            data = this.assembleLifeCycleOpeItems5();
        }
        lifeCycleOperation.setComboItems(data);
    }

    private void updateContractByTradeType() {
        if (this.getModel().getValue("tradetype") == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"swaptype", "farornear"});
            return;
        }
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"adjexpiredate", "optionsdirect", "tradedirect", "deliveryway"});
        } else if (ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"deliveryway"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjexpiredate", "optionsdirect", "tradedirect"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"adjexpiredate", "optionsdirect", "tradedirect", "deliveryway"});
        }
    }

    private void updateLifeTypeItemsByTradeType() {
        if (this.getModel().getValue("tradetype") == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"swaptype", "farornear"});
            return;
        }
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        ComboEdit lifeCycleOperation = (ComboEdit)this.getControl("lifecycleoperation");
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(tradeTypeNumber)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"swaptype", "farornear"});
            lifeCycleOperation.setComboItems(this.assembleLifeCycleOpeItems5());
        } else if (ProductTypeEnum.FOREXSPOT.getValue().equals(tradeTypeNumber)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"swaptype", "farornear"});
            lifeCycleOperation.setComboItems(this.assembleLifeCycleOpeItems2());
        } else if (ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"swaptype", "farornear"});
        } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(tradeTypeNumber)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"swaptype", "farornear"});
            lifeCycleOperation.setComboItems(this.assembleLifeCycleOpeItems3());
        }
    }

    private List<ComboItem> assembleLifeCycleOpeItems3() {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u884c\u6743", (String)"LifeCycleApplyEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_EXERCISE));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u653e\u5f03\u884c\u6743", (String)"LifeCycleApplyEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_GIVEUP));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e73\u4ed3", (String)"LifeCycleApplyEdit_14", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_FLAT));
        return data;
    }

    private List<ComboItem> assembleLifeCycleOpeItems2() {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5230\u671f\u4ea4\u5272", (String)"LifeCycleApplyEdit_12", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_EXPIREDEY));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e73\u4ed3", (String)"LifeCycleApplyEdit_14", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_FLAT));
        return data;
    }

    private List<ComboItem> assembleLifeCycleOpeItems5() {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5230\u671f\u4ea4\u5272", (String)"LifeCycleApplyEdit_12", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_EXPIREDEY));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u63d0\u524d\u4ea4\u5272", (String)"LifeCycleApplyEdit_13", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_BDELIVERY));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e73\u4ed3", (String)"LifeCycleApplyEdit_14", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_FLAT));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5c55\u671f", (String)"LifeCycleApplyEdit_15", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_DEFER));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u63d0\u524d", (String)"LifeCycleApplyEdit_16", (String)"tmc-tm-formplugin", (Object[])new Object[0])), OP_TYPE_MAUDATE));
        return data;
    }

    private void buyAmountChanged() {
        DynamicObject buycurrency = (DynamicObject)this.getModel().getValue("buycurrency");
        String pair = (String)this.getModel().getValue("pair");
        if (buycurrency == null || StringUtils.isBlank((CharSequence)pair)) {
            return;
        }
        String fxQuote = (String)this.getModel().getValue("fxquote");
        DynamicObject sellcurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
        if (sellcurrency != null) {
            if (pair.startsWith(sellcurrency.getString("number")) && pair.equals(fxQuote) || pair.endsWith(sellcurrency.getString("number")) && !pair.equals(fxQuote)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellamount", (Object)((BigDecimal)this.getModel().getValue("buyamount")).divide((BigDecimal)this.getModel().getValue("rate"), ((DynamicObject)this.getModel().getValue("sellcurrency")).getInt("amtprecision"), RoundingMode.HALF_UP));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellamount", (Object)((BigDecimal)this.getModel().getValue("buyamount")).multiply((BigDecimal)this.getModel().getValue("rate")));
            }
        }
        if (pair.startsWith(buycurrency.getString("number"))) {
            BigDecimal remainingunexpireamount = (BigDecimal)this.getModel().getValue("unexpireamount");
            remainingunexpireamount = remainingunexpireamount.subtract((BigDecimal)this.getModel().getValue("buyamount"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remainingunexpireamount", (Object)remainingunexpireamount);
        } else if (pair.endsWith(buycurrency.getString("number"))) {
            BigDecimal remainingunexpireamount = (BigDecimal)this.getModel().getValue("unexpireamount");
            remainingunexpireamount = remainingunexpireamount.subtract((BigDecimal)this.getModel().getValue("sellamount"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remainingunexpireamount", (Object)remainingunexpireamount);
        }
    }

    private void sellAmountChanged() {
        DynamicObject buycurrency = (DynamicObject)this.getModel().getValue("buycurrency");
        String pair = (String)this.getModel().getValue("pair");
        String fxQuote = (String)this.getModel().getValue("fxquote");
        if (buycurrency == null || StringUtils.isBlank((CharSequence)pair)) {
            return;
        }
        if (pair.startsWith(buycurrency.getString("number")) && pair.equals(fxQuote) || pair.endsWith(buycurrency.getString("number")) && !pair.equals(fxQuote)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buyamount", (Object)((BigDecimal)this.getModel().getValue("sellamount")).divide((BigDecimal)this.getModel().getValue("rate"), ((DynamicObject)this.getModel().getValue("buycurrency")).getInt("amtprecision"), RoundingMode.HALF_UP));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buyamount", (Object)((BigDecimal)this.getModel().getValue("sellamount")).multiply((BigDecimal)this.getModel().getValue("rate")));
        }
        if (pair.endsWith(buycurrency.getString("number"))) {
            BigDecimal remainingunexpireamount = (BigDecimal)this.getModel().getValue("unexpireamount");
            remainingunexpireamount = remainingunexpireamount.subtract((BigDecimal)this.getModel().getValue("sellamount"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remainingunexpireamount", (Object)remainingunexpireamount);
        } else if (pair.startsWith(buycurrency.getString("number"))) {
            BigDecimal remainingunexpireamount = (BigDecimal)this.getModel().getValue("unexpireamount");
            remainingunexpireamount = remainingunexpireamount.subtract((BigDecimal)this.getModel().getValue("buyamount"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remainingunexpireamount", (Object)remainingunexpireamount);
        }
    }

    private void clearLifeCycleApplyInfo() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"org", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"biztype", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buycurrency", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellcurrency", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fxquote", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"optiontype", null);
        this.clearLifeCycleOperation();
        this.clearApplyInfo();
    }

    private void clearLifeCycleOperation() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"lifecycleoperation", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remainingunexpireamount", null);
    }

    private void clearApplyInfo() {
        this.getModel().setValue("ischoosedate", (Object)false);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredatestart", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expiredateend", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buyamountmax", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buyamount", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellamountmax", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellamount", null);
    }

    private void initApplyInfoForOptions(String opName) {
        this.initApplyInfoControl(opName);
        this.initValueForOptions(opName);
    }

    private void initApplyInfoForSpot(String opName) {
        this.initApplyInfoControl(opName);
        this.initValueForSpot(opName);
    }

    private void initApplyInfoForSwaps(String opName) {
        this.initApplyInfoControl(opName);
        this.initValueForSwaps(opName);
    }

    private void initApplyInfoForForward(String opName) {
        this.initApplyInfoControl(opName);
        this.initValueForForward(opName);
    }

    private void initValueForOptions(String opName) {
        switch (opName = opName == null ? EMPTY_STR : opName) {
            case "exercise": {
                this.setDate_options_exercise();
                this.initBuyAmountAndSellAmount();
                break;
            }
            case "flat": 
            case "giveup": {
                this.setOpDate5();
                this.initBuyAmountAndSellAmount();
                break;
            }
        }
        this.getView().updateView("applypane");
    }

    private void setDate_options_exercise() {
        this.setOpDate5();
        this.setDeliveryDate();
    }

    private void initValueForSpot(String opName) {
        switch (opName = opName == null ? EMPTY_STR : opName) {
            case "expiredey": {
                this.setDate_spot_expireDey();
                this.initBuyAmountAndSellAmount();
                break;
            }
            case "flat": {
                this.setOpDate(true);
                this.initBuyAmountAndSellAmount();
                break;
            }
        }
        this.getView().updateView("applypane");
    }

    private void setDate_spot_expireDey() {
        this.setOpDate2();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getModel().getValue("opdate"));
    }

    private void initValueForSwaps(String opName) {
        switch (opName = opName == null ? EMPTY_STR : opName) {
            case "expiredey": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ischoosedate"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"applydeliverydate", "buyamount", "sellamount"});
                this.setDate_swaps_expireDey();
                this.initBuyAmountAndSellAmount();
                break;
            }
            case "defer": {
                this.enableControls("opdate", "applydeliverydate");
                this.setDate_swaps_defer();
                this.initBuyAmountAndSellAmount(true);
                break;
            }
            case "flat": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ischoosedate", "applydeliverydate"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"buyamount", "sellamount"});
                this.setDate_swaps_flat();
                this.initBuyAmountAndSellAmount();
                this.enableControls("opdate");
                break;
            }
            case "maudate": {
                this.enableControls("opdate", "applydeliverydate");
                this.setDate_swaps_mauDate();
                this.initBuyAmountAndSellAmount(true);
                break;
            }
            case "bdelivery": {
                this.setDate_swaps_bDelivery();
                this.initBuyAmountAndSellAmount(true);
                this.enableControls("opdate", "applydeliverydate");
                break;
            }
        }
        this.getView().updateView("applypane");
    }

    private void setDate_swaps_bDelivery() {
        this.setOpDate4();
        this.setMinDate("opdate", (Date)this.getModel().getValue("applydate"));
        this.setMaxDate("opdate", TcDateUtils.getNextDay((Date)((Date)this.getModel().getValue("deliverydate")), (int)-1));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getModel().getValue("opdate"));
        this.setMinDate("applydeliverydate", (Date)this.getModel().getValue("opdate"));
        this.setMaxDate("applydeliverydate", TcDateUtils.getNextDay((Date)((Date)this.getModel().getValue("deliverydate")), (int)-1));
    }

    private void setDate_swaps_mauDate() {
        this.setOpDate6();
        Date endDate = TcDateUtils.getNextDay((Date)((Date)this.getModel().getValue("deliverydate")), (int)-1);
        this.setMinDate("opdate", (Date)this.getModel().getValue("applydate"));
        this.setMaxDate("opdate", endDate);
        this.setMinDate("applydeliverydate", (Date)this.getModel().getValue("opdate"));
        this.setMaxDate("applydeliverydate", endDate);
    }

    private void setDate_swaps_flat() {
        this.setOpDate3();
        this.setMinDate("opdate", (Date)this.getModel().getValue("applydate"));
        this.setMaxDate("opdate", (Date)this.getModel().getValue("deliverydate"));
    }

    private void setDate_swaps_defer() {
        this.setOpDate3();
        this.setMinDate("opdate", (Date)this.getModel().getValue("applydate"));
        this.setMaxDate("opdate", (Date)this.getModel().getValue("deliverydate"));
        this.setExpireDateByOpDate();
    }

    private void setDate_swaps_expireDey() {
        this.setOpDate2();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getModel().getValue("opdate"));
    }

    private void initValueForForward(String opName) {
        switch (opName = opName == null ? EMPTY_STR : opName) {
            case "expiredey": {
                this.setDate_forward_expireDey();
                this.initBuyAmountAndSellAmount();
                break;
            }
            case "bdelivery": {
                this.setDate_forward_bDelivery();
                this.initBuyAmountAndSellAmount(true);
                break;
            }
            case "flat": {
                this.setOpDate(true);
                this.initBuyAmountAndSellAmount();
                break;
            }
            case "defer": {
                this.setDate_forward_defer();
                this.initBuyAmountAndSellAmount(true);
                break;
            }
            case "maudate": {
                this.setDate_forward_mauDate();
                this.initBuyAmountAndSellAmount(true);
                break;
            }
        }
        this.getView().updateView("applypane");
    }

    private void setDate_forward_mauDate() {
        this.setOpDate7();
        Date dOpDate = (Date)this.getModel().getValue("opdate");
        Date exDateRangeEndDate = (Date)this.getModel().getValue("exdaterange_enddate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        deliveryDate = deliveryDate == null ? (exDateRangeEndDate == null ? null : exDateRangeEndDate) : deliveryDate;
        Date previousDeliveryDay = null;
        if (deliveryDate != null) {
            previousDeliveryDay = TcDateUtils.getNextDay((Date)deliveryDate, (int)-1);
        }
        this.setMinDate("applydeliverydate", dOpDate);
        this.setMaxDate("applydeliverydate", previousDeliveryDay);
        ((DateRangeEdit)this.getView().getControl("expiredatesection")).setMinDate(dOpDate);
        ((DateRangeEdit)this.getView().getControl("expiredatesection")).setMaxDate(previousDeliveryDay);
    }

    private void setDate_forward_defer() {
        this.setOpDate(true);
        this.setExpireDateAndSectionByOpDate();
    }

    private void setDate_forward_bDelivery() {
        Date date;
        Date applyDate = (Date)this.getModel().getValue("applydate");
        Date exDateRangeStartDate = (Date)this.getModel().getValue("exdaterange_startdate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        Object object = deliveryDate == null ? (exDateRangeStartDate == null ? null : exDateRangeStartDate) : (date = deliveryDate);
        if (date != null && this.getDiffDays(applyDate, date) > 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)applyDate);
        }
        Date maxDate = date == null ? null : TcDateUtils.getNextDay((Date)date, (int)-1);
        this.setMinDate("opdate", applyDate);
        this.setMaxDate("opdate", maxDate);
        this.setMinDate("applydeliverydate", (Date)this.getModel().getValue("opdate"));
        this.setMaxDate("applydeliverydate", maxDate);
    }

    private void setDate_forward_expireDey() {
        this.setOpDate6(false);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getModel().getValue("opdate"));
    }

    private void setOpDate6(boolean applyDateChanged) {
        Date applyDate = (Date)this.getModel().getValue("applydate");
        Date exDateRangeStartDate = (Date)this.getModel().getValue("exdaterange_startdate");
        Date exDateRangeEndDate = (Date)this.getModel().getValue("exdaterange_enddate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exDateRangeStartDate, exDateRangeEndDate})) {
            if (this.getDiffDays(applyDate, exDateRangeStartDate) <= 0 && this.getDiffDays(applyDate, exDateRangeEndDate) >= 0) {
                if (!applyDateChanged || EmptyUtil.isEmpty((Object)this.getModel().getValue("opdate"))) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)applyDate);
                }
            } else if (this.getDiffDays(applyDate, exDateRangeStartDate) > 0 && (!applyDateChanged || EmptyUtil.isEmpty((Object)this.getModel().getValue("opdate")))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)exDateRangeStartDate);
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"opdate"});
            this.setMinDate("opdate", this.getDiffDays(applyDate, exDateRangeStartDate) <= 0 ? applyDate : exDateRangeStartDate);
            this.setMaxDate("opdate", exDateRangeEndDate);
        } else if (deliveryDate != null && this.getDiffDays(applyDate, deliveryDate) >= 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)deliveryDate);
        }
    }

    private int getDiffDays(Date d1, Date d2) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{d1, d2})) {
            return 0;
        }
        return TcDateUtils.getDiffDays((Date)TcDateUtils.getDataFormat((Date)d1, (boolean)true), (Date)TcDateUtils.getDataFormat((Date)d2, (boolean)true));
    }

    private Date getMaxDate(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return TcDateUtils.getDiffDays((Date)TcDateUtils.getDataFormat((Date)d1, (boolean)true), (Date)TcDateUtils.getDataFormat((Date)d2, (boolean)true)) > 0 ? d2 : d1;
    }

    private void setExpireDateByOpDate() {
        Date dOpDate = (Date)this.getModel().getValue("opdate");
        Date nextDeliveryDate = null;
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        if (deliveryDate != null) {
            nextDeliveryDate = TcDateUtils.getNextDay((Date)deliveryDate, (int)1);
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{nextDeliveryDate, dOpDate})) {
            if (this.getDiffDays(nextDeliveryDate, dOpDate) > 0) {
                this.setMinDate("applydeliverydate", dOpDate);
                this.setMaxDate("applydeliverydate", TcDateUtils.getNextYear((Date)dOpDate, (int)10));
            } else {
                this.setMinDate("applydeliverydate", nextDeliveryDate);
                this.setMaxDate("applydeliverydate", TcDateUtils.getNextYear((Date)nextDeliveryDate, (int)10));
            }
        } else {
            this.setMinDate("applydeliverydate", null);
        }
    }

    private void setExpireDateAndSectionByOpDate() {
        Date dOpDate = (Date)this.getModel().getValue("opdate");
        Date exDateRangeStartDate = (Date)this.getModel().getValue("exdaterange_startdate");
        Date nextDeliveryDate = null;
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        if (deliveryDate != null) {
            nextDeliveryDate = TcDateUtils.getNextDay((Date)deliveryDate, (int)1);
        } else if (exDateRangeStartDate != null) {
            nextDeliveryDate = TcDateUtils.getNextDay((Date)exDateRangeStartDate, (int)1);
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dOpDate, nextDeliveryDate})) {
            if (this.getDiffDays(nextDeliveryDate, dOpDate) > 0) {
                this.setMinDate("applydeliverydate", dOpDate);
                this.setMaxDate("applydeliverydate", TcDateUtils.getNextYear((Date)dOpDate, (int)10));
                ((DateRangeEdit)this.getView().getControl("expiredatesection")).setMinDate(dOpDate);
            } else {
                this.setMinDate("applydeliverydate", nextDeliveryDate);
                this.setMaxDate("applydeliverydate", TcDateUtils.getNextYear((Date)nextDeliveryDate, (int)10));
                ((DateRangeEdit)this.getView().getControl("expiredatesection")).setMinDate(nextDeliveryDate);
            }
            ((DateRangeEdit)this.getView().getControl("expiredatesection")).setMaxDate(TcDateUtils.getNextYear((Date)dOpDate, (int)100));
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"expiredatesection"});
        } else {
            this.setMinDate("applydeliverydate", null);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"expiredatesection"});
        }
    }

    private void enableControls(String ... keys) {
        this.getView().setEnable(Boolean.valueOf(true), keys);
    }

    private void initApplyInfoControl(String opName) {
        opName = opName == null ? EMPTY_STR : opName;
        boolean isShowApplyPane = true;
        String opTypeLabelText = null;
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"applydeliverydate"});
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        switch (opName) {
            case "": {
                isShowApplyPane = false;
                break;
            }
            case "expiredey": {
                opTypeLabelText = ResManager.loadKDString((String)"\u5230\u671f\u4ea4\u5272", (String)"LifeCycleApplyEdit_12", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ischoosedate", "expiredatesection"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"applydeliverydate", "buyamount", "sellamount"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"applydeliverydate"});
                Date exDateRangeStartDate = (Date)this.getModel().getValue("exdaterange_startdate");
                Date exDateRangeEndDate = (Date)this.getModel().getValue("exdaterange_enddate");
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exDateRangeStartDate, exDateRangeEndDate})) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"opdate"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"opdate"});
                break;
            }
            case "exercise": {
                opTypeLabelText = ResManager.loadKDString((String)"\u884c\u6743", (String)"LifeCycleApplyEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ischoosedate", "expiredatesection"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"applydeliverydate", "buyamount", "sellamount"});
                break;
            }
            case "bdelivery": {
                opTypeLabelText = ResManager.loadKDString((String)"\u63d0\u524d\u4ea4\u5272", (String)"LifeCycleApplyEdit_13", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ischoosedate", "expiredatesection"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"applydeliverydate", "buyamount", "sellamount"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"opdate", "applydeliverydate"});
                break;
            }
            case "flat": {
                opTypeLabelText = ResManager.loadKDString((String)"\u5e73\u4ed3", (String)"LifeCycleApplyEdit_14", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ischoosedate", "expiredatesection", "applydeliverydate"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"buyamount", "sellamount"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"opdate"});
                break;
            }
            case "giveup": {
                opTypeLabelText = ResManager.loadKDString((String)"\u653e\u5f03\u884c\u6743", (String)"LifeCycleApplyEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ischoosedate", "expiredatesection", "applydeliverydate"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"buyamount", "sellamount"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"opdate"});
                break;
            }
            case "defer": {
                opTypeLabelText = ResManager.loadKDString((String)"\u5c55\u671f", (String)"LifeCycleApplyEdit_15", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                if (ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"ischoosedate"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"ischoosedate"});
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"applydeliverydate", "expiredatesection", "buyamount", "sellamount"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"opdate"});
                break;
            }
            case "maudate": {
                opTypeLabelText = ResManager.loadKDString((String)"\u63d0\u524d", (String)"LifeCycleApplyEdit_16", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
                if (ProductTypeEnum.FOREXSWAPS.getValue().equals(tradeTypeNumber)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"ischoosedate"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"ischoosedate"});
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"applydeliverydate", "expiredatesection", "buyamount", "sellamount"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"opdate"});
                break;
            }
        }
        ((Label)this.getView().getControl("optypelabel")).setText(opTypeLabelText);
        this.getView().setVisible(Boolean.valueOf(isShowApplyPane), new String[]{"applypane"});
        this.getView().updateView("applypane");
    }

    private Date getOffsetWorkDate(DynamicObjectCollection workCalendars, Date curDate, int offset) {
        int count = 0;
        while (count < offset || !WorkCalendarHelper.isWorkDay((DynamicObjectCollection)workCalendars, (Date)curDate)) {
            if (WorkCalendarHelper.isWorkDay((DynamicObjectCollection)workCalendars, (Date)curDate)) {
                ++count;
            }
            curDate = TcDateUtils.getLastDay((Date)curDate, (int)-1);
        }
        return curDate;
    }

    private void setDeliveryDate() {
        Object tradeId = ((DynamicObject)this.getModel().getValue("tradeno")).getPkValue();
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        String tradeBillEntityName = this.getTradeBillEntityName(tradeTypeNumber);
        DynamicObject originalTradeBill = LifeCycleApplyHelper.loadTradeBillWithValidateIsExist((Object)tradeId, (String)tradeBillEntityName);
        String optionType = originalTradeBill.getString("optiontype");
        if (OptionTypeEnum.european.getValue().equals(optionType)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getModel().getValue("deliverydate"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"applydeliverydate"});
        } else if (OptionTypeEnum.american.getValue().equals(optionType)) {
            DynamicObjectCollection workcalendar = originalTradeBill.getDynamicObjectCollection("workcalendar");
            Date opDate = (Date)this.getModel().getValue("opdate");
            if (opDate == null) {
                return;
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"applydeliverydate"});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"applydeliverydate", (Object)this.getOffsetWorkDate(workcalendar, opDate, originalTradeBill.getInt("settledelay")));
        }
    }

    private DynamicObject setOpDate5() {
        Object tradeId = ((DynamicObject)this.getModel().getValue("tradeno")).getPkValue();
        String tradeTypeNumber = ((DynamicObject)this.getModel().getValue("tradetype")).getString("number");
        String tradeBillEntityName = this.getTradeBillEntityName(tradeTypeNumber);
        DynamicObject originalTradeBill = LifeCycleApplyHelper.loadTradeBillWithValidateIsExist((Object)tradeId, (String)tradeBillEntityName);
        Date bizDate = originalTradeBill.getDate("bizdate");
        Date adjExpireDate = originalTradeBill.getDate("adjexpiredate");
        Date applyDate = (Date)this.getModel().getValue("applydate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizDate, adjExpireDate}) || this.getDiffDays(applyDate, adjExpireDate) < 0) {
            this.setNull("opdate");
            this.setMinDate("opdate", TcDateUtils.getNextYear((Date)applyDate, (int)10));
            this.setMaxDate("opdate", TcDateUtils.getNextYear((Date)applyDate, (int)10));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)applyDate);
            this.setMinDate("opdate", this.getMaxDate(applyDate, bizDate));
            this.setMaxDate("opdate", adjExpireDate);
        }
        return originalTradeBill;
    }

    private void setOpDate4() {
        Date applyDate = (Date)this.getModel().getValue("applydate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        if (deliveryDate != null) {
            if (this.getDiffDays(applyDate, deliveryDate) > 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)applyDate);
            } else {
                this.setNull("opdate");
            }
        }
    }

    private void setOpDate6() {
        Date applyDate = (Date)this.getModel().getValue("applydate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        if (deliveryDate != null) {
            if (this.getDiffDays(applyDate, deliveryDate) > 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)applyDate);
            } else {
                this.setNull("opdate");
            }
        }
    }

    private void setOpDate3() {
        Date applyDate = (Date)this.getModel().getValue("applydate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        if (deliveryDate != null) {
            if (this.getDiffDays(applyDate, deliveryDate) >= 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)applyDate);
            } else {
                this.setNull("opdate");
            }
        }
    }

    private void setOpDate2() {
        Date applyDate = (Date)this.getModel().getValue("applydate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        if (deliveryDate != null) {
            if (this.getDiffDays(applyDate, deliveryDate) >= 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)deliveryDate);
            } else {
                this.setNull("opdate");
            }
        }
    }

    private void setOpDate(boolean includeEndDate) {
        Date date;
        Date applyDate = (Date)this.getModel().getValue("applydate");
        Date exDateRangeEndDate = (Date)this.getModel().getValue("exdaterange_enddate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        Object object = deliveryDate == null ? (exDateRangeEndDate == null ? null : exDateRangeEndDate) : (date = deliveryDate);
        if (date != null && this.getDiffDays(applyDate, date) >= 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)applyDate);
        }
        this.setMinDate("opdate", applyDate);
        if (includeEndDate) {
            this.setMaxDate("opdate", date);
        } else {
            this.setMaxDate("opdate", TcDateUtils.getNextDay((Date)date, (int)-1));
        }
    }

    private void setOpDate7() {
        Date date;
        Date applyDate = (Date)this.getModel().getValue("applydate");
        Date exDateRangeEndDate = (Date)this.getModel().getValue("exdaterange_enddate");
        Date deliveryDate = (Date)this.getModel().getValue("deliverydate");
        Object object = deliveryDate == null ? (exDateRangeEndDate == null ? null : exDateRangeEndDate) : (date = deliveryDate);
        if (date != null && this.getDiffDays(applyDate, date) > 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"opdate", (Object)applyDate);
        }
        this.setMinDate("opdate", applyDate);
        this.setMaxDate("opdate", TcDateUtils.getNextDay((Date)date, (int)-1));
    }

    private void initBuyAmountAndSellAmount() {
        this.initBuyAmountAndSellAmount(false);
    }

    private void initBuyAmountAndSellAmount(boolean showSingleAmt) {
        boolean showSellAmount;
        boolean showBuyAmount;
        DynamicObject buycurrency = (DynamicObject)this.getModel().getValue("buycurrency");
        DynamicObject sellcurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
        String pair = (String)this.getModel().getValue("pair");
        String fxQuote = (String)this.getModel().getValue("fxquote");
        if (sellcurrency == null || buycurrency == null || StringUtils.isBlank((CharSequence)pair)) {
            return;
        }
        if (pair.startsWith(buycurrency.getString("number"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buyamount", (Object)this.getModel().getValue("unexpireamount"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buyamountmax", (Object)this.getModel().getValue("unexpireamount"));
            showBuyAmount = true;
            showSellAmount = false;
        } else {
            showBuyAmount = false;
            showSellAmount = true;
            BigDecimal X = pair.equals(fxQuote) ? ((BigDecimal)this.getModel().getValue("unexpireamount")).multiply((BigDecimal)this.getModel().getValue("rate")) : ((BigDecimal)this.getModel().getValue("unexpireamount")).divide((BigDecimal)this.getModel().getValue("rate"), ((DynamicObject)this.getModel().getValue("buycurrency")).getInt("amtprecision"), RoundingMode.HALF_UP);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buyamount", (Object)X);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buyamountmax", (Object)X);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remainingunexpireamount", (Object)BigDecimal.ZERO);
        if (pair.startsWith(sellcurrency.getString("number"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellamount", (Object)this.getModel().getValue("unexpireamount"));
        } else if (pair.startsWith(sellcurrency.getString("number")) && pair.equals(fxQuote) || pair.endsWith(sellcurrency.getString("number")) && !pair.equals(fxQuote)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellamount", (Object)((BigDecimal)this.getModel().getValue("buyamount")).divide((BigDecimal)this.getModel().getValue("rate"), ((DynamicObject)this.getModel().getValue("sellcurrency")).getInt("amtprecision"), RoundingMode.HALF_UP));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellamount", (Object)((BigDecimal)this.getModel().getValue("buyamount")).multiply((BigDecimal)this.getModel().getValue("rate")));
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellamountmax", (Object)this.getModel().getValue("sellamount"));
        if (!showSingleAmt) {
            showBuyAmount = true;
            showSellAmount = true;
        }
        this.getModel().setValue("showbuyamount", (Object)showBuyAmount);
        this.getModel().setValue("showsellamount", (Object)showSellAmount);
    }

    private void setValueWhenValueNotNull(String key, DynamicObject dynamicObject, String columnName) {
        if (dynamicObject != null && dynamicObject.get(columnName) != null) {
            this.getModel().setValue(key, ((DynamicObject)dynamicObject.get(columnName)).getPkValue());
        } else {
            this.getModel().setValue(key, null);
        }
    }

    private void setNull(String key) {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)key, null);
    }

    private void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        value = EMPTY_STR.equals(value) ? "0" : value;
        switch (key) {
            case "buyamount": {
                BigDecimal aBuyAmount = new BigDecimal((String)value);
                BigDecimal aBuyAmountMax = (BigDecimal)this.getModel().getValue("buyamountmax");
                if (aBuyAmount.compareTo(aBuyAmountMax) <= 0 && aBuyAmount.compareTo(BigDecimal.ZERO) > 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u8f93\u5165\u5927\u4e8e\u96f6\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u672a\u4ea4\u5272\u91d1\u989d\u7684\u6570\u503c\u3002", (String)"LifeCycleApplyEdit_11", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("buyamount");
                break;
            }
            case "sellamount": {
                BigDecimal aSellAmount = new BigDecimal((String)value);
                BigDecimal aSellAmountMax = (BigDecimal)this.getModel().getValue("sellamountmax");
                if (aSellAmount.compareTo(aSellAmountMax) <= 0 && aSellAmount.compareTo(BigDecimal.ZERO) > 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u8f93\u5165\u5927\u4e8e\u96f6\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u672a\u4ea4\u5272\u91d1\u989d\u7684\u6570\u503c\u3002", (String)"LifeCycleApplyEdit_11", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("sellamount");
                break;
            }
            case "lifecycleoperation": {
                if (ProductTypeEnum.FOREXFORWARD.getValue().equals(((DynamicObject)this.getModel().getValue("tradetype")).getString("number")) && DeliveryWayEnum.non_deliverable.getValue().equals(this.getModel().getValue("deliveryway")) && OP_TYPE_BDELIVERY.equals(value)) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u5272\u65b9\u5f0f\u4e3a\u65e0\u672c\u91d1\u4ea4\u5272\u65f6\u4e0d\u80fd\u63d0\u524d\u4ea4\u5272\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"LifeCycleApplyEdit_27", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    this.getView().updateView("lifecycleoperation");
                    break;
                }
                if (EmptyUtil.isEmpty((Object)this.getModel().getValue("applydate"))) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7533\u8bf7\u65e5\u3002", (String)"LifeCycleApplyEdit_22", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    this.getView().updateView("lifecycleoperation");
                    break;
                }
            }
            case "applydate": {
                if (!EmptyUtil.isEmpty((Object)value)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LifeCycleApplyEdit_23", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().updateView("applydate");
                break;
            }
            case "opdate": {
                if (!EmptyUtil.isEmpty((Object)value)) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LifeCycleApplyEdit_24", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().updateView("opdate");
            }
        }
    }

    private String getString(String key) {
        return (String)this.getModel().getValue(key);
    }

    private void setMinDate(String key, Date minDate) {
        if (minDate == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{key});
            return;
        }
        ((DateEdit)this.getView().getControl(key)).setMinDate(minDate);
        Date date = (Date)this.getModel().getValue(key);
        if (date != null && date.before(minDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)key, null);
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put(key + "_minDate", TcDateUtils.formatString((Date)minDate, (String)"yyyy-MM-dd"));
        String maxDateStr = pageCache.get(key + "_maxDate");
        if (EmptyUtil.isNoEmpty((String)maxDateStr)) {
            Date maxDate = TcDateUtils.stringToDate((String)maxDateStr, (String)"yyyy-MM-dd");
            if (minDate.after(maxDate)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{key});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{key});
            }
        }
    }

    private void setMaxDate(String key, Date maxDate) {
        if (maxDate == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{key});
            return;
        }
        ((DateEdit)this.getView().getControl(key)).setMaxDate(maxDate);
        Date date = (Date)this.getModel().getValue(key);
        if (date != null && date.after(maxDate)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)key, null);
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put(key + "_maxDate", TcDateUtils.formatString((Date)maxDate, (String)"yyyy-MM-dd"));
        String minDateStr = pageCache.get(key + "_minDate");
        if (EmptyUtil.isNoEmpty((String)minDateStr)) {
            Date minDate = TcDateUtils.stringToDate((String)minDateStr, (String)"yyyy-MM-dd");
            if (minDate.after(maxDate)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{key});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{key});
            }
        }
    }

    private boolean isUnitTest() {
        return "LifeCycleApplyEditUnitTest".equals(this.getModel().getValue("description"));
    }
}

