/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tmbrm.formplugin.archives;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.sdk.tmc.tmbrm.extpoint.IFinOrgArchivesAssociatedBillInterface;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcAttachmentHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tmbrm.common.enums.BankInstNatureEnum;
import kd.tmc.tmbrm.common.helper.EvalInfoHelper;
import kd.tmc.tmbrm.common.model.EvalInfoModel;
import kd.tmc.tmbrm.formplugin.access.AccessApplyPlugin;
import kd.tmc.tmbrm.formplugin.archives.FinOrgGenerateCoDataTask;
import kd.tmc.tmbrm.formplugin.archives.sdk.FinOrgArchivesAssociatedBillDefaultExt;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class FinOrgArchivesEdit
extends AccessApplyPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(FinOrgArchivesEdit.class);
    private static final String CALLBACK_BILL_TEXT = "callback_bill_text";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"datacurrency", (Object)1L);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"dataunit", (Object)"100000000");
        this.showCoDataForm();
        DynamicObject finType = (DynamicObject)model.getValue("fintype");
        TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)FinOrgTypeEnum.BANK.getNumber().equals(finType.getString("number")), (String[])new String[]{"instnature"});
        DynamicObject finOrg = (DynamicObject)model.getValue("finorg");
        if (finOrg != null) {
            DynamicObject orgView = (DynamicObject)model.getValue("orgview");
            this.initFinOrgData(finOrg, orgView);
            this.initEvalInfoData(finOrg);
        }
        this.setDrawLabel();
        model.setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (Objects.nonNull(result) && result.isSuccess() && "gencodata".equals(operateKey)) {
            this.showCoDataForm();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
        switch (name) {
            case "city": {
                DynamicObject country = (DynamicObject)this.getModel().getValue("country");
                QFilter qFilter = new QFilter("iscity", "=", (Object)Boolean.TRUE);
                if (country != null) {
                    String number = country.getString("number");
                    if ("001".equals(number)) {
                        DynamicObject province = (DynamicObject)this.getModel().getValue("province");
                        if (province == null) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7701\u4efd\u3002", (String)"FinOrgArchivesEdit_0", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
                            event.setCancel(true);
                            return;
                        }
                        qFilter = qFilter.and("parent.number", "=", (Object)province.getString("number"));
                    } else {
                        qFilter = qFilter.and("country", "=", country.getPkValue());
                    }
                }
                filterParameter.setFilter(qFilter);
                break;
            }
            case "manageorg": {
                String appId = this.getView().getFormShowParameter().getAppId();
                List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
                filterParameter.setFilter(new QFilter("id", "in", (Object)orgIdList));
                break;
            }
            case "billtype": {
                FinOrgArchivesAssociatedBillDefaultExt defaultExt = new FinOrgArchivesAssociatedBillDefaultExt();
                PluginProxy pluginProxy = PluginProxy.create((Object)defaultExt, IFinOrgArchivesAssociatedBillInterface.class, (String)"kd.sdk.tmc.tmbrm.extpoint.IFinOrgArchivesAssociatedBillInterface");
                List billTypes = pluginProxy.callAfter(IFinOrgArchivesAssociatedBillInterface::getBillType);
                ArrayList allBillTypes = new ArrayList(10);
                billTypes.forEach(allBillTypes::addAll);
                filterParameter.setFilter(new QFilter("number", "in", allBillTypes));
                break;
            }
            case "finorg": {
                DynamicObjectCollection finOrgArchives = QueryServiceHelper.query((String)"tmbrm_finorg_archives", (String)"finorgtype,finorg", (QFilter[])new QFilter("finorgtype", "=", (Object)formShowParameter.getBillFormId()).toArray());
                List selectedFinOrgIds = finOrgArchives.stream().map(e -> e.getLong("finorg")).collect(Collectors.toList());
                if (!EmptyUtil.isNoEmpty(selectedFinOrgIds)) break;
                filterParameter.setFilter(new QFilter("id", "not in", selectedFinOrgIds));
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit finOrgEdit = (BasedataEdit)this.getControl("finorg");
        finOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit cityEdit = (BasedataEdit)this.getControl("city");
        cityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit provinceEdit = (BasedataEdit)this.getControl("province");
        provinceEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("manageorg");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit billTypeEdit = (BasedataEdit)this.getControl("billtype");
        billTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid keyItemEntry = (EntryGrid)this.getControl("keyitementry");
        keyItemEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid evalInfoEntry = (EntryGrid)this.getControl("evalinfoentry");
        evalInfoEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid finOrgEntry = (EntryGrid)this.getControl("finorgentry");
        finOrgEntry.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"billtext", "scorebtn"});
        Button control = (Button)this.getControl("refreshcodata");
        control.addClickListener((ClickListener)this);
        Button viewBtn = (Button)this.getControl("flatviewbtn");
        Button button = viewBtn = null == viewBtn ? (Button)this.getControl("drawviewbtn") : viewBtn;
        if (null != viewBtn) {
            viewBtn.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "billtext".equals(((TextEdit)source).getKey())) {
            EntryGrid keyItemEntry = (EntryGrid)this.getControl("keyitementry");
            int row = keyItemEntry.getSelectRows()[0];
            DynamicObject associatedOrg = ((DynamicObject)this.getModel().getEntryEntity("keyitementry").get(row)).getDynamicObject("associatedorg");
            DynamicObject billType = ((DynamicObject)this.getModel().getEntryEntity("keyitementry").get(row)).getDynamicObject("billtype");
            String entityName = billType.getString("number");
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)entityName, (boolean)Boolean.FALSE);
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            FinOrgArchivesAssociatedBillDefaultExt defaultExt = new FinOrgArchivesAssociatedBillDefaultExt();
            PluginProxy pluginProxy = PluginProxy.create((Object)defaultExt, IFinOrgArchivesAssociatedBillInterface.class, (String)"kd.sdk.tmc.tmbrm.extpoint.IFinOrgArchivesAssociatedBillInterface");
            List filterMaps = pluginProxy.callAfter(e -> e.getBillQFilter(associatedOrg));
            HashMap allFilterMap = new HashMap(16);
            filterMaps.forEach(allFilterMap::putAll);
            QFilter qFilter = (QFilter)allFilterMap.get(entityName);
            filterParameter.setFilter(qFilter);
            this.getPageCache().put("billtext", String.valueOf(row));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_BILL_TEXT));
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (source instanceof Button) {
            String buttonKey = ((Button)source).getKey();
            if ("refreshcodata".equals(buttonKey)) {
                FinOrgGenerateCoDataTask coDataTask = new FinOrgGenerateCoDataTask(RequestContext.get(), this.getView().getPageId(), this.getModel().getDataEntity());
                ThreadPools.executeOnce((String)FinOrgGenerateCoDataTask.class.getName(), (Runnable)coDataTask);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"refreshcodata"});
                this.getView().addClientCallBack("refreshcodata", Integer.valueOf(500));
            } else if ("flatviewbtn".equals(buttonKey) || "drawviewbtn".equals(buttonKey)) {
                String formId = "flatviewbtn".equals(buttonKey) ? "tmbrm_finorgarchives_info" : "tmbrm_finorgarchives_draw";
                this.getPageCache().remove("treeviewap-root-node");
                BillShowParameter parameter = new BillShowParameter();
                parameter.setPkId(this.getModel().getValue("id"));
                parameter.setFormId(formId);
                parameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            } else if ("scorebtn".equals(buttonKey)) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("tmbrm_evalinfo");
                DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorg");
                if (finOrg != null) {
                    parameter.setCustomParam("finOrg", finOrg.getPkValue());
                    parameter.setCustomParam("finOrgType", (Object)finOrg.getDataEntityType().getName());
                }
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if ("refreshcodata".equals(e.getName())) {
            String res = this.getPageCache().get("refreshcodata");
            if ("success".equals(res)) {
                this.showCoDataForm();
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"refreshcodata"});
            } else {
                this.getView().addClientCallBack("refreshcodata", Integer.valueOf(500));
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "billtext".equals(((TextEdit)source).getKey())) {
            EntryGrid keyItemEntry = (EntryGrid)this.getControl("keyitementry");
            int row = keyItemEntry.getSelectRows()[0];
            DynamicObject associatedOrg = ((DynamicObject)this.getModel().getEntryEntity("keyitementry").get(row)).getDynamicObject("associatedorg");
            DynamicObject billType = ((DynamicObject)this.getModel().getEntryEntity("keyitementry").get(row)).getDynamicObject("billtype");
            if (EmptyUtil.isEmpty((DynamicObject)associatedOrg) || EmptyUtil.isEmpty((DynamicObject)billType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u7ec4\u7ec7\u548c\u5173\u8054\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\u3002", (String)"FinOrgArchivesEdit_1", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (source instanceof Button && "refreshcodata".equals(((Button)source).getKey())) {
            DynamicObject entity = this.getModel().getDataEntity();
            if (EmptyUtil.isEmpty((DynamicObject)entity.getDynamicObject("finorg"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u91d1\u878d\u673a\u6784\u3002", (String)"FinOrgArchivesEdit_3", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (EmptyUtil.isEmpty((DynamicObject)entity.getDynamicObject("orgview"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"FinOrgArchivesEdit_4", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (propName) {
            case "finorg": {
                this.processFinOrgDataChanged(newValue);
                break;
            }
            case "orgview": {
                DynamicObject newOrgView = (DynamicObject)newValue;
                DynamicObject finOrg = (DynamicObject)model.getValue("finorg");
                if (finOrg == null || newOrgView == null) break;
                this.initFinOrgData(finOrg, newOrgView);
                break;
            }
            case "fintype": {
                Label scoreLabel;
                String formId;
                FormShowParameter formShowParameter = view.getFormShowParameter();
                Long historyId = (Long)formShowParameter.getCustomParams().get("openHistoryId");
                if (EmptyUtil.isEmpty((Long)historyId)) {
                    TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String[])new String[]{"finorg", "logo"});
                }
                if (null == newValue) break;
                DynamicObject newFinType = (DynamicObject)newValue;
                String number = newFinType.getString("number");
                model.setValue("finorgtype", (Object)(FinOrgTypeEnum.BANK.getNumber().equals(number) ? "bd_bankcgsetting" : "bd_finorginfo"));
                TmcViewInputHelper.registerMustInput((IFormView)view, (boolean)FinOrgTypeEnum.BANK.getNumber().equals(number), (String[])new String[]{"instnature"});
                DynamicObjectCollection evalInfoEntry = model.getDataEntity(true).getDynamicObjectCollection("evalinfoentry");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)evalInfoEntry)) {
                    evalInfoEntry.clear();
                    view.updateView("evalinfoentry");
                }
                if ("tmbrm_finorgarchives_info".equals(formId = formShowParameter.getFormId())) {
                    scoreLabel = (Label)this.getControl("scorelabel_info");
                    scoreLabel.setText(null);
                    Label orgLabel = (Label)this.getControl("orglabel");
                    orgLabel.setText(null);
                    Label dateLabel = (Label)this.getControl("datelabel");
                    dateLabel.setText(null);
                } else if ("tmbrm_finorgarchives_draw".equals(formId)) {
                    scoreLabel = (Label)this.getControl("scorelabel_draw");
                    scoreLabel.setText(null);
                    view.setVisible(Boolean.FALSE, new String[]{"scoredesc", "scorebtn"});
                }
                DynamicObjectCollection finOrgEntry = model.getDataEntity(true).getDynamicObjectCollection("finorgentry");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)finOrgEntry)) {
                    finOrgEntry.clear();
                    view.updateView("finorgentry");
                }
                this.setFinorgLabel(finOrgEntry);
                break;
            }
            case "province": {
                this.getModel().setValue("city", null);
                break;
            }
            case "country": {
                this.getModel().setValue("city", null);
                this.getModel().setValue("province", null);
                break;
            }
            case "associatedorg": 
            case "billtype": {
                DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
                if (!EmptyUtil.isNoEmpty((DynamicObject)oldValue)) break;
                int row = changeData.getRowIndex();
                this.getModel().setValue("billtext", null, row);
                break;
            }
            case "datacurrency": 
            case "dataunit": {
                if (TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)propName)) {
                    this.showCoDataForm();
                    break;
                }
                this.getModel().setValue(propName, changeData.getOldValue());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRowCollection;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (CALLBACK_BILL_TEXT.equals(actionId) && EmptyUtil.isNoEmpty((Object)(selectedRowCollection = (ListSelectedRowCollection)event.getReturnData()))) {
            ListSelectedRow listSelectedRow = selectedRowCollection.get(0);
            int row = Integer.parseInt(this.getPageCache().get("billtext"));
            this.getModel().setValue("billtext", (Object)listSelectedRow.getBillNo(), row);
            this.getModel().setValue("businessbillid", listSelectedRow.getPrimaryKeyValue(), row);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int row = evt.getRowIndex();
        IDataModel model = this.getModel();
        switch (fieldName) {
            case "finorgnumber": {
                DynamicObjectCollection finOrgInfoList = model.getEntryEntity("finorgentry");
                this.showDetailForm("bd_finorginfo", ((DynamicObject)finOrgInfoList.get(row)).getDynamicObject("finorginfo").getPkValue(), null);
                break;
            }
            case "reportbillno": {
                DynamicObjectCollection evalInfoList = model.getEntryEntity("evalinfoentry");
                DynamicObject finOrg = (DynamicObject)model.getValue("finorg");
                DynamicObject evalInfo = (DynamicObject)evalInfoList.get(row);
                String evalBillType = evalInfo.getString("evalbilltype");
                this.showDetailForm(evalBillType, evalInfo.get("reportid"), finOrg.getPkValue());
                break;
            }
            case "billtext": {
                DynamicObjectCollection keyItemList = model.getEntryEntity("keyitementry");
                DynamicObject keyItem = (DynamicObject)keyItemList.get(row);
                DynamicObject billType = keyItem.getDynamicObject("billtype");
                String billId = keyItem.getString("businessbillid");
                this.showDetailForm(billType.getString("number"), billId, null);
                break;
            }
        }
    }

    private void showDetailForm(String formId, Object pkId, Object paramValue) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setFormId(formId);
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("finorg", paramValue);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setDrawLabel() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("tmbrm_finorgarchives_draw".equals(formId)) {
            IDataModel model = this.getModel();
            Label finOrgTypeLabel = (Label)this.getControl("finorgtype_label");
            DynamicObject finOrgType = (DynamicObject)model.getValue("fintype");
            finOrgTypeLabel.setText(finOrgType.getString("name"));
            Label manageOrgLabel = (Label)this.getControl("manageorg_label");
            DynamicObject manageOrg = (DynamicObject)model.getValue("manageorg");
            manageOrgLabel.setText(manageOrg.getString("name"));
            Label orgViewLabel = (Label)this.getControl("orgview_label");
            DynamicObject orgView = (DynamicObject)model.getValue("orgview");
            orgViewLabel.setText(orgView.getString("name"));
            Label instNatureLabel = (Label)this.getControl("instnature_label");
            String instNature = (String)model.getValue("instnature");
            BankInstNatureEnum instNatureEnum = BankInstNatureEnum.getEnumByValue((String)instNature);
            if (instNatureEnum != null) {
                instNatureLabel.setText(instNatureEnum.getEnumBridge());
            }
            Label listedLabel = (Label)this.getControl("listed_label");
            Boolean listed = (Boolean)model.getValue("listed");
            String listedStr = listed != false ? ResManager.loadKDString((String)"\u662f", (String)"FinOrgArchivesEdit_5", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"FinOrgArchivesEdit_6", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]);
            listedLabel.setText(listedStr);
        }
    }

    private void processFinOrgDataChanged(Object newValue) {
        if (EmptyUtil.isNoEmpty((Object)newValue)) {
            DynamicObject newFinOrg = (DynamicObject)newValue;
            Long historyId = (Long)this.getView().getFormShowParameter().getCustomParams().get("openHistoryId");
            if (EmptyUtil.isEmpty((Long)historyId)) {
                DynamicObject finOrg = QueryServiceHelper.queryOne((String)newFinOrg.getDataEntityType().getName(), (String)"logo", (QFilter[])new QFilter("id", "=", newFinOrg.getPkValue()).toArray());
                String realPath = TmcAttachmentHelper.getRealPath((String)finOrg.getString("logo"));
                this.getModel().setValue("logo", (Object)realPath);
            }
            this.getModel().setValue("finorgtext", (Object)newFinOrg.getString("name"));
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
            this.initEvalInfoData(newFinOrg);
            this.initFinOrgData(newFinOrg, orgView);
        }
    }

    private void initFinOrgData(DynamicObject finOrg, DynamicObject orgView) {
        DynamicObjectCollection finOrgEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("finorgentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)finOrgEntry)) {
            this.getModel().deleteEntryData("finorgentry");
        }
        String entityName = finOrg.getDataEntityType().getName();
        List orgIds = TmcOrgDataHelper.getOrgIds((Long)orgView.getLong("id"));
        QFilter qFilter = new QFilter("company", "in", (Object)orgIds);
        qFilter.and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        Object finOrgId = finOrg.getPkValue();
        if ("bd_finorginfo".equals(entityName)) {
            QFilter aFilter = qFilter.copy();
            aFilter.and("bank.parent", "=", finOrgId);
            qFilter.and("bank", "=", finOrgId);
            qFilter.or(aFilter);
        } else if ("bd_bankcgsetting".equals(entityName)) {
            qFilter.and("bank.bank_cate.id", "=", finOrgId);
        }
        Map accountBanks = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"bank", (QFilter[])qFilter.toArray());
        List finOrgPkIds = accountBanks.values().stream().map(e -> e.getDynamicObject("bank").getPkValue()).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", finOrgPkIds);
        Map finOrgMap = BusinessDataServiceHelper.loadFromCache((String)"bd_finorginfo", (String)"number,name,country,province,city,enable", (QFilter[])new QFilter[]{filter});
        for (Map.Entry entry : finOrgMap.entrySet()) {
            Object pkValue = entry.getKey();
            int row = this.getModel().createNewEntryRow("finorgentry");
            this.getModel().setValue("finorginfo", pkValue, row);
        }
        this.setFinorgLabel(finOrgEntry);
    }

    private void initEvalInfoData(DynamicObject finOrg) {
        String formId;
        boolean isDraw;
        String finOrgType = finOrg.getDataEntityType().getName();
        Long finOrgId = (Long)finOrg.getPkValue();
        List evalInfoList = EvalInfoHelper.getEvalInfos((Long)finOrgId, (String)finOrgType);
        IDataModel model = this.getModel();
        DynamicObjectCollection evalInfoEntry = model.getEntryEntity("evalinfoentry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)evalInfoEntry)) {
            model.deleteEntryData("evalinfoentry");
        }
        String labelKey = (isDraw = "tmbrm_finorgarchives_draw".equals(formId = this.getView().getFormShowParameter().getFormId())) ? "scorelabel_draw" : "scorelabel_info";
        Label scoreLabel = (Label)this.getControl(labelKey);
        if (EmptyUtil.isNoEmpty((Object)evalInfoList)) {
            EvalInfoHelper.batchFillEntry((String)"evalinfoentry", (IDataModel)model, (List)evalInfoList);
            EvalInfoModel latestEvalInfo = (EvalInfoModel)evalInfoList.get(0);
            String evalScore = String.valueOf(latestEvalInfo.getEvalSocre().setScale(2, RoundingMode.HALF_UP));
            scoreLabel.setText(evalScore);
            if (!isDraw) {
                Label orgLabel = (Label)this.getControl("orglabel");
                orgLabel.setText(latestEvalInfo.getOrgName());
                Label dateLabel = (Label)this.getControl("datelabel");
                dateLabel.setText(DateUtils.formatString((Date)latestEvalInfo.getEvalDate(), (String)"yyyy-MM-dd"));
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"scoredesc", "scorebtn"});
            }
        } else {
            scoreLabel.setText(null);
            if (!isDraw) {
                Label orgLabel = (Label)this.getControl("orglabel");
                orgLabel.setText(null);
                Label dateLabel = (Label)this.getControl("datelabel");
                dateLabel.setText(null);
            } else {
                scoreLabel.setText(null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"scoredesc", "scorebtn"});
            }
        }
    }

    private void setFinorgLabel(DynamicObjectCollection finOrgEntry) {
        Label label = (Label)this.getControl("finorglabel");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)finOrgEntry)) {
            List domesticCountry = finOrgEntry.stream().map(e -> e.getDynamicObject("finorginfo")).filter(c -> c != null && StringUtils.equalsAny((CharSequence)c.getString("number"), (CharSequence[])new CharSequence[]{"001", "003", "004", "005"})).collect(Collectors.toList());
            int total = finOrgEntry.size();
            int domestic = domesticCountry.size();
            label.setText(String.format(ResManager.loadKDString((String)"\u5171%1$s\u4e2a  \u5883\u5185%2$s\u4e2a  \u5883\u5916%3$s\u4e2a", (String)"FinOrgArchivesEdit_2", (String)"tmc-tmbrm-formplugin", (Object[])new Object[0]), total, domestic, total - domestic));
        } else {
            label.setText(null);
        }
    }

    private void showCoDataForm() {
        IDataModel model = this.getModel();
        DynamicObject manageOrg = (DynamicObject)model.getValue("manageorg");
        DynamicObject finOrg = (DynamicObject)model.getValue("finorg");
        DynamicObject orgView = (DynamicObject)model.getValue("orgview");
        DynamicObject currency = (DynamicObject)model.getValue("datacurrency");
        String unit = (String)model.getValue("dataunit");
        if (ObjectUtils.anyNull((Object[])new Object[]{manageOrg, finOrg, orgView, currency, unit})) {
            logger.info("data empty");
            return;
        }
        DynamicObject object = TmcDataServiceHelper.loadSingle((String)"tmbrm_finorg_codata", (String)"id,datatime", (QFilter[])new QFilter[]{new QFilter("finorgtype", "=", (Object)finOrg.getDataEntityType().getName()), new QFilter("finorg", "=", finOrg.getPkValue())});
        if (EmptyUtil.isEmpty((DynamicObject)object)) {
            logger.info("not found coData");
            return;
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"datatime", (Object)object.getDate("datatime"));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        boolean isDraw = "tmbrm_finorgarchives_draw".equals(this.getView().getFormShowParameter().getShowParameter().getFormId());
        if (isDraw) {
            parameter.setFormId("tmbrm_finorg_codatadraw");
            parameter.getOpenStyle().setTargetKey("codatadraw");
        } else {
            parameter.setFormId("tmbrm_finorg_coddataform");
            parameter.getOpenStyle().setTargetKey("codatapanelap");
        }
        parameter.setCustomParam("manageorg", (Object)manageOrg.getPkValue().toString());
        parameter.setCustomParam("id", (Object)object.getPkValue().toString());
        parameter.setCustomParam("currency", (Object)currency.getPkValue().toString());
        parameter.setCustomParam("unit", (Object)unit);
        this.getView().showForm(parameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObjectType objectType = entity.getDynamicObjectType();
        DataEntityState entityState = entity.getDataEntityState();
        int ordinal = objectType.getProperty("datacurrency_id").getOrdinal();
        entityState.setBizChanged(ordinal, false);
        ordinal = objectType.getProperty("dataunit").getOrdinal();
        entityState.setBizChanged(ordinal, false);
        ordinal = objectType.getProperty("datatime").getOrdinal();
        entityState.setBizChanged(ordinal, false);
    }
}

