/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.h5.action;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.AgentUtil;
import kd.bos.url.UrlService;

public class AIH5Action {
    private static final Log logger = LogFactory.getLog(AIH5Action.class);
    private static final String PC_FORM_ID = "gai_h5_pc_chat";
    private static final String MOBILE_FORM_ID = "gai_h5_mobile_chat";
    private static final Set<String> ALLOWED_PARAMS = new HashSet<String>(Arrays.asList("accountId", "kdcdc", "assistant", "chatType", "redirect", "redirect_uri", "userId"));

    public void cosmicQa(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            this.doAction(request, response);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("traceId", RequestContext.get().getTraceId());
            map.put("errorMessage", e.toString());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)JSON.toJSONString(map));
        }
    }

    private void doAction(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.sentRedirectByClient(request, response);
    }

    private void sentRedirectByClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean mobile = AgentUtil.isMobile((HttpServletRequest)request);
        String domainContextUrl = UrlService.getDomainContextUrl();
        String redirectUrl = this.addString(domainContextUrl);
        StringBuilder builder = new StringBuilder(redirectUrl);
        builder.append("index.html?formId=").append(PC_FORM_ID);
        this.addSafeQueryParams(builder, request);
        response.sendRedirect(builder.toString());
    }

    private void addSafeQueryParams(StringBuilder urlBuilder, HttpServletRequest request) {
        request.getParameterMap().forEach((param, values) -> {
            if (ALLOWED_PARAMS.contains(param) && ((String[])values).length > 0) {
                urlBuilder.append("&").append((String)param).append("=").append(values[0]);
            }
        });
    }

    private String addString(String domain) {
        if (domain.endsWith("/")) {
            return domain;
        }
        return domain + "/";
    }
}

