/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.h5.auth.appauth;

import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.ai.h5.auth.appauth.CloudAuthProvider;
import kd.bos.ai.h5.auth.appauth.CreateCloudUser;
import kd.bos.ai.h5.auth.appauth.UserResult;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.user.LoginUserService;
import kd.bos.permission.model.UserParam;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class CloudAuthManager {
    private static Log logger = LogFactory.getLog(CloudAuthManager.class);

    public AppAuthResult doLogin(HttpServletRequest request, Account currentCenter) throws Exception {
        UserParam user;
        UserResult userResult = new CloudAuthProvider().userAuth(request);
        if (userResult == null) {
            logger.warn("Authentication failed, please log in again.");
            AppAuthResult appAuthResult = new AppAuthResult();
            appAuthResult.setSucceed(false);
            return appAuthResult;
        }
        AppAuthResult userAuthResult = this.buildAuthResult(userResult);
        Map<String, String> userInfo = CloudAuthManager.getUserInfo(userAuthResult, Lang.defaultLang(), currentCenter);
        if ((userInfo == null || userInfo.isEmpty()) && (user = CreateCloudUser.addUser(userResult)).isSuccess()) {
            LicenseServiceHelper.addUserListByGroupId((Object)2026183729222894592L, Collections.singletonList(user.getId()));
        }
        return userAuthResult;
    }

    private static Map<String, String> getUserInfo(AppAuthResult result, Lang lang, Account currentCenter) {
        switch (result.getUserType()) {
            case OPEN_ID: {
                return LoginUserService.getErpUserInfo((Account)currentCenter, (String)result.getUserFlag(), (String)lang.name());
            }
            case YZJUID: 
            case UID: {
                return LoginUserService.getErpUserInfo((Account)currentCenter, (long)Long.parseLong(result.getUserFlag()), (String)lang.name());
            }
            case MOBILE_PHONE: {
                return LoginUserService.getErpUserInfoByPhone((Account)currentCenter, (String)result.getUserFlag(), (String)lang.name());
            }
            case USER_NAME: {
                return LoginUserService.getErpUserInfoByUserName((Account)currentCenter, (String)result.getUserFlag(), (String)lang.name());
            }
            case EMAIL: {
                return LoginUserService.getErpUserInfoByEmail((Account)currentCenter, (String)result.getUserFlag(), (String)lang.name());
            }
            case USER_ID: {
                return LoginUserService.getErpUserInfoByUserId((Account)currentCenter, (String)result.getUserFlag(), (String)lang.name());
            }
            case WORKER_NUMBER: {
                return LoginUserService.getErpUserInfoByNumber((Account)currentCenter, (String)result.getUserFlag(), (String)lang.name());
            }
        }
        return null;
    }

    private AppAuthResult buildAuthResult(UserResult userResult) {
        AppAuthResult appAuthResult = new AppAuthResult();
        appAuthResult.setUserType(userResult.getUserType());
        appAuthResult.setSucceed(true);
        appAuthResult.setUserFlag(userResult.getUser());
        return appAuthResult;
    }
}

