/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.h5.auth.appauth;

import javax.servlet.http.HttpServletRequest;
import kd.bos.ai.h5.auth.appauth.CloudTokenFetch;
import kd.bos.ai.h5.auth.appauth.CloudUserFetch;
import kd.bos.ai.h5.auth.appauth.HttpBuilder;
import kd.bos.ai.h5.auth.appauth.UserResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class CloudAuthProvider {
    private static final Log logger = LogFactory.getLog(CloudAuthProvider.class);

    public UserResult userAuth(HttpServletRequest request) throws Exception {
        String code = request.getParameter("code");
        logger.info(String.format("CloudDeveloperManage-Message: cloud community code is %s", code));
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        HttpBuilder builder = new HttpBuilder();
        if (builder.isEmpty()) {
            logger.info("CloudDeveloperManage-Message: HttpBuilder is Empty");
            return null;
        }
        String accessToken = CloudTokenFetch.getAccessToken(code, request, builder);
        logger.info(String.format("CloudDeveloperManage-Message: cloud community token is %s", accessToken));
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return null;
        }
        CloudUserFetch.UserData userInfo = CloudUserFetch.getUserInfo(accessToken, builder);
        if (userInfo == null) {
            return null;
        }
        logger.info(String.format("CloudDeveloperManage-Message: cloud community userInfo is %s", userInfo.toString()));
        return userInfo.convertUser();
    }
}

