/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.h5.auth.appauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import kd.bos.ai.h5.auth.appauth.CloudHttpService;
import kd.bos.ai.h5.auth.appauth.HttpBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;

class CloudTokenFetch {
    private static Log logger = LogFactory.getLog(CloudTokenFetch.class);

    CloudTokenFetch() {
    }

    public static String getAccessToken(String code, HttpServletRequest request, HttpBuilder builder) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        params.put("redirect_uri", CloudTokenFetch.addEndString(UrlService.getDomainContextUrl()) + "ai/h5/chat.do?" + request.getQueryString());
        params.put("client_id", builder.getClientId());
        params.put("client_secret", builder.getClientSecret());
        String tokenUrl = builder.getUrl() + "/auth/oauth2/access_token";
        logger.info(String.format("CloudDeveloperTokenFetch-Message: getAccessToken params is %s", ((Object)params).toString()));
        String responseBody = null;
        try {
            responseBody = CloudHttpService.sendPostRequest(tokenUrl, params);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
        logger.info(String.format("CloudDeveloperTokenFetch-Message: getAccessToken responseBody is %s", responseBody));
        if (responseBody != null) {
            return CloudTokenFetch.parseAccessToken(responseBody);
        }
        return null;
    }

    private static String parseAccessToken(String jsonString) {
        JSONObject jsonObject = JSON.parseObject((String)jsonString);
        if (!jsonObject.containsKey((Object)"data")) {
            throw new RuntimeException("Data node is missing");
        }
        JSONObject dataObject = jsonObject.getJSONObject("data");
        if (dataObject == null || !dataObject.containsKey((Object)"access_token")) {
            logger.warn(String.format("access_token is missing:%s", jsonObject));
            return null;
        }
        return dataObject.getString("access_token");
    }

    private static String addEndString(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }
}

