/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ai.h5.auth.appauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import kd.bos.ai.h5.auth.appauth.CloudHttpService;
import kd.bos.ai.h5.auth.appauth.HttpBuilder;
import kd.bos.ai.h5.auth.appauth.UserResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.UserType;
import org.apache.commons.lang3.StringUtils;

class CloudUserFetch {
    private static Log logger = LogFactory.getLog(CloudUserFetch.class);

    CloudUserFetch() {
    }

    public static UserData getUserInfo(String accessToken, HttpBuilder builder) {
        String urlString = builder.getUrl() + "/account/user_info?access_token=" + accessToken;
        try {
            logger.info(String.format("CloudDeveloperUserFetch-Message: getUserInfo url is %s", urlString));
            String responseBody = CloudHttpService.sendGetRequest(urlString);
            logger.info(String.format("CloudDeveloperUserFetch-Message: getUserInfo responseBody is %s", responseBody));
            ApiResponse apiResponse = (ApiResponse)JSON.parseObject((String)responseBody, ApiResponse.class);
            if (apiResponse.errCode != 0) {
                throw new RuntimeException("ErrorCode:" + apiResponse.errCode + " - ErrorMsg:" + apiResponse.description);
            }
            return apiResponse.data;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static class UserData {
        private String address;
        private String avatar;
        private String birthday;
        private String email;
        private int gender;
        private String name;
        private String nickname;
        private String phone;
        private long uid;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public long getUid() {
            return this.uid;
        }

        public void setUid(long uid) {
            this.uid = uid;
        }

        public String getAvatar() {
            return this.avatar;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        public String getBirthday() {
            return this.birthday;
        }

        public void setBirthday(String birthday) {
            this.birthday = birthday;
        }

        public int getGender() {
            return this.gender;
        }

        public void setGender(int gender) {
            this.gender = gender;
        }

        public String getNickname() {
            return this.nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public UserResult convertUser() {
            UserResult userResult = new UserResult();
            userResult.setUid(this.uid + "");
            userResult.setAvatar(this.avatar);
            userResult.setEmail(this.email);
            userResult.setGender(this.gender + "");
            userResult.setName(StringUtils.isBlank((CharSequence)this.name) ? this.nickname : this.name);
            userResult.setNickName(this.nickname);
            userResult.setPhone(this.phone);
            userResult.setUserType(UserType.MOBILE_PHONE);
            userResult.setUser(this.phone);
            return userResult;
        }

        public String toString() {
            return "UserData{address='" + this.address + '\'' + ", avatar='" + this.avatar + '\'' + ", birthday='" + this.birthday + '\'' + ", email='" + this.email + '\'' + ", gender=" + this.gender + ", name='" + this.name + '\'' + ", nickname='" + this.nickname + '\'' + ", phone='" + this.phone + '\'' + ", uid=" + this.uid + '}';
        }
    }

    public static class ApiResponse {
        @JSONField(name="errcode")
        private int errCode;
        @JSONField(name="description")
        private String description;
        @JSONField(name="data")
        private UserData data;

        public int getErrCode() {
            return this.errCode;
        }

        public void setErrCode(int errCode) {
            this.errCode = errCode;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public UserData getData() {
            return this.data;
        }

        public void setData(UserData data) {
            this.data = data;
        }

        public String toString() {
            return "ApiResponse{errCode=" + this.errCode + ", description='" + this.description + '\'' + ", data=" + this.data + '}';
        }
    }
}

