/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.entity.param.CustomParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class YZJSSOLoginAuthtication
extends ThirdAppAuthtication {
    private static final Log logger = LogFactory.getLog(YZJSSOLoginAuthtication.class);
    public static final String YZJ_TOKEN_URL = "https://yunzhijia.com/gateway/oauth2/token/getAccessToken";
    public static final String YZJ_TICKET_CHECK_URL = "https://yunzhijia.com/gateway/ticket/user/acquirecontext?accessToken=%s";
    private static final String CUSTOM_PARAM_YZJ_APP_ID_KEY = "yzj_sso_app_id";
    private static final String CUSTOM_PARAM_YZJ_APP_SECRET_KEY = "yzj_sso_app_secret";
    private static final String CUSTOM_PARAM_YZJ_KD_EID_KEY = "yzj_sso_kd_eid";
    private static final String CUSTOM_PARAM_YZJ_DEFAULT_USER_KEY = "yzj_sso_default_user";

    public boolean isNeedHandle(HttpServletRequest request, Account account) {
        boolean isNeed = Boolean.FALSE;
        String ticket = request.getParameter("ticket");
        String appId = StringUtils.getTrimedBlank((String)LoginUtils.getAPPId((HttpServletRequest)request));
        String ticketCache = CacheLoginData.getAttribute((String)account.getAccountId(), (String)ticket);
        logger.info("yzj appid:{},ticket:{},ticketCache:{}", new Object[]{appId, ticket, ticketCache});
        if (StringUtils.isNotEmpty((String)ticketCache)) {
            return isNeed;
        }
        if (StringUtils.isNotEmpty((String)appId) && !StringUtils.isEmpty((String)ticket)) {
            isNeed = Boolean.TRUE;
        }
        return isNeed;
    }

    public AppAuthResult appAuthtication(HttpServletRequest httpServletRequest, Account account) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(Boolean.FALSE.booleanValue());
        String ticket = httpServletRequest.getParameter("ticket");
        Map<String, String> customParams = this.getCustomSSOParams();
        logger.info("yzj ticket :{},custom params:{}", (Object)ticket, customParams);
        if (customParams == null || customParams.isEmpty()) {
            logger.info("\u65e0\u6cd5\u83b7\u53d6\u4e91\u4e4b\u5bb6\u626b\u7801\u767b\u5f55\u7cfb\u7edf\u81ea\u5b9a\u4e49\u53c2\u6570\u3002");
            result.setErrorMessage("\u65e0\u6cd5\u83b7\u53d6\u4e91\u4e4b\u5bb6\u626b\u7801\u767b\u5f55\u7cfb\u7edf\u81ea\u5b9a\u4e49\u53c2\u6570\u3002");
            return result;
        }
        try {
            String appId = customParams.get(CUSTOM_PARAM_YZJ_APP_ID_KEY);
            String appSecret = customParams.get(CUSTOM_PARAM_YZJ_APP_SECRET_KEY);
            String kdEid = customParams.get(CUSTOM_PARAM_YZJ_KD_EID_KEY);
            String defaultUser = customParams.get(CUSTOM_PARAM_YZJ_DEFAULT_USER_KEY);
            String accessToken = this.getAccessToken(appId, appSecret);
            logger.info("yzj access token :{}", (Object)accessToken);
            YzjResult yzjResult = this.parseUser(accessToken, ticket, appId);
            if (yzjResult != null) {
                logger.info("yzjResult:{}", (Object)JSONObject.toJSONString((Object)yzjResult));
                String eid = yzjResult.getEid();
                if (kdEid != null && kdEid.equalsIgnoreCase(eid)) {
                    result.setSucceed(Boolean.TRUE.booleanValue());
                    result.setUserFlag(defaultUser);
                    result.setUserType(UserType.MOBILE_PHONE);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8ba4\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f={}", (Object)e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken(String appId, String appSecret) {
        JSONObject data = new JSONObject();
        data.put("appId", (Object)appId);
        data.put("secret", (Object)appSecret);
        data.put("timestamp", (Object)System.currentTimeMillis());
        data.put("scope", (Object)"app");
        PrintWriter out = null;
        InputStream is = null;
        try {
            StringBuilder result = new StringBuilder();
            URL url = new URL(YZJ_TOKEN_URL);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("Method", "POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            String requestBody = data.toJSONString();
            out = new PrintWriter(connection.getOutputStream());
            out.write(requestBody);
            out.flush();
            out.close();
            is = connection.getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                result.append(new String(buffer, 0, len));
            }
            is.close();
            JSONObject resData = JSONObject.parseObject((String)result.toString());
            if (resData != null) {
                String accessToken;
                JSONObject dataObj = resData.getJSONObject("data");
                String string = accessToken = dataObj.getString("accessToken");
                return string;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e91\u4e4b\u5bb6accessToken\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f={}", (Object)e.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                out = null;
                is = null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YzjResult parseUser(String accessToken, String ticket, String appId) {
        String path = YZJ_TICKET_CHECK_URL;
        path = String.format(path, accessToken);
        JSONObject data = new JSONObject();
        data.put("appid", (Object)appId);
        data.put("ticket", (Object)ticket);
        PrintWriter out = null;
        InputStream is = null;
        YzjResult yzjResult = null;
        try {
            JSONObject dataJo;
            StringBuilder result = new StringBuilder();
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("Method", "POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            String requestBody = data.toJSONString();
            out = new PrintWriter(connection.getOutputStream());
            out.write(requestBody);
            out.flush();
            out.close();
            is = connection.getInputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                result.append(new String(buffer, 0, len));
            }
            is.close();
            JSONObject resData = JSONObject.parseObject((String)result.toString());
            if (resData != null && (dataJo = resData.getJSONObject("data")) != null) {
                yzjResult = new YzjResult();
                yzjResult.setAppid(dataJo.getString("appid"));
                yzjResult.setEid(dataJo.getString("eid"));
                yzjResult.setOpenid(dataJo.getString("openid"));
                yzjResult.setUsername(dataJo.getString("username"));
                yzjResult.setUid(dataJo.getString("uid"));
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e91\u4e4b\u5bb6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f={}", (Object)e.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                out = null;
                is = null;
            }
        }
        return yzjResult;
    }

    private Map<String, String> getCustomSSOParams() {
        CustomParam customParam = new CustomParam();
        customParam.getSearchKeySet().add(CUSTOM_PARAM_YZJ_APP_ID_KEY);
        customParam.getSearchKeySet().add(CUSTOM_PARAM_YZJ_APP_SECRET_KEY);
        customParam.getSearchKeySet().add(CUSTOM_PARAM_YZJ_KD_EID_KEY);
        customParam.getSearchKeySet().add(CUSTOM_PARAM_YZJ_DEFAULT_USER_KEY);
        Map maps = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        return maps;
    }

    public static class YzjResult {
        private String openid;
        private String eid;
        private String appid;
        private String uid;
        private String username;

        public String getOpenid() {
            return this.openid;
        }

        public void setOpenid(String openid) {
            this.openid = openid;
        }

        public String getEid() {
            return this.eid;
        }

        public void setEid(String eid) {
            this.eid = eid;
        }

        public String getAppid() {
            return this.appid;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }
}

