/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.operate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.ai.cvp.utils.AiLicenseUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class TdaHistoryEntityOperate
extends FormOperate {
    private static Log LOGGER = LogFactory.getLog(TdaHistoryEntityOperate.class);
    private static final String FORM_ID = "cvp_tda_info";
    private static final String PAGE_ID = "pageId";
    private static final String BILL_ID = "billid";
    private static final String ACTION_TYPE = "tda_operate_type";
    private static final String ACTION_TYPE_VALUE = "taskhistoryview";
    private static final String ACTION_TYPE_SHOW_ONE_HISTORY_DETAIL = "tda_show_task";
    private static final String KEY_TDA_PLAN_ID = "tda_plan_id";
    private static final String KEY_TDA_BILL_NUMBER = "tda_bill_number";
    private static final String KEY_TDA_BILL_NAME = "tda_bill_name";
    private static final String TDA_ENTITY_KEY = "cvp_tda_plan";
    private static final String BUSINESSO_BJECT = "businessobject";
    private static final String PAGE_CACHE = "ai_cvp_tda_attachment_source";

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        try {
            if (!AiLicenseUtils.validLicenseNew((IFormView)this.getView())) {
                return false;
            }
            IFormView view = this.getView();
            IDataModel model = view.getModel();
            FormShowParameter formShow = new FormShowParameter();
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("90%");
            styleCss.setHeight("90%");
            formShow.setFormId(FORM_ID);
            formShow.setCustomParam(BUSINESSO_BJECT, (Object)this.getEntityId());
            String pageId = view.getPageId();
            String cacheTaskInfo = view.getPageCache().get("lastTaskId_" + pageId);
            String planNumber = "";
            String lastTaskId = "";
            long tdaplanId = 0L;
            if (StringUtils.isNotEmpty((String)cacheTaskInfo)) {
                JSONObject jsonObject = JSON.parseObject((String)cacheTaskInfo);
                lastTaskId = jsonObject.getString("taskId");
                planNumber = jsonObject.getString("planNumber");
                tdaplanId = this.getPlanIdByPlanNumber(planNumber);
            }
            if (StringUtils.isNotEmpty((String)lastTaskId) && StringUtils.isNotEmpty((String)planNumber)) {
                formShow.setCustomParam(ACTION_TYPE, (Object)ACTION_TYPE_SHOW_ONE_HISTORY_DETAIL);
                formShow.setCustomParam("taskId", (Object)lastTaskId);
                formShow.setCustomParam("useTaskId", (Object)true);
                formShow.setCustomParam(KEY_TDA_BILL_NAME, (Object)"");
                formShow.setCustomParam(KEY_TDA_BILL_NUMBER, (Object)"");
                formShow.setCustomParam(KEY_TDA_PLAN_ID, (Object)tdaplanId);
                formShow.setCustomParam(BILL_ID, (Object)"0");
            } else {
                formShow.setCustomParam("useTaskId", (Object)false);
                this.setFormParam(model, formShow);
            }
            formShow.setCustomParam(PAGE_ID, (Object)this.getView().getPageId());
            formShow.getOpenStyle().setShowType(ShowType.Modal);
            formShow.getOpenStyle().setInlineStyleCss(styleCss);
            this.getView().showForm(formShow);
        }
        catch (KDBizException kd) {
            String message = kd.getMessage();
            this.getView().showTipNotification(message);
            LOGGER.error("TDA-\u6587\u672c\u5dee\u5f02\u5206\u6790-showForm,\u64cd\u4f5c\u5f02\u5e38:" + message, (Throwable)kd);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u672c\u5dee\u5f02\u5206\u6790\u6bd4\u5bf9\u5f02\u5e38", (String)"TdaEntityOperate_3", (String)"ai-cvp-plugin", (Object[])new Object[0]));
            LOGGER.error("TDA-\u6587\u672c\u5dee\u5f02\u5206\u6790-showForm,\u64cd\u4f5c\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private long getPlanIdByPlanNumber(String planNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)planNumber);
        DynamicObject tdaPlanObj = QueryServiceHelper.queryOne((String)TDA_ENTITY_KEY, (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        if (tdaPlanObj == null || tdaPlanObj.getLong("id") == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5dee\u5f02\u5206\u6790\u65b9\u6848\uff0c\u8bf7\u5148\u914d\u7f6e", (String)"TdaEntityOperate_2", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
        return tdaPlanObj.getLong("id");
    }

    private void setFormParam(IDataModel model, FormShowParameter formShow) {
        String number;
        String billName;
        long planIdObj = this.getPlanId();
        try {
            Object billNameLocal = model.getValue("name");
            billName = billNameLocal instanceof OrmLocaleValue ? ((OrmLocaleValue)billNameLocal).getLocaleValue() : String.valueOf(billNameLocal);
        }
        catch (Exception e) {
            billName = "";
            LOGGER.info("\u8be5\u5355\u636e\u65e0\u540d\u79f0name\u5c5e\u6027");
        }
        try {
            number = String.valueOf(model.getValue("number"));
        }
        catch (Exception e) {
            number = "";
            LOGGER.info("\u8be5\u5355\u636e\u65e0\u7f16\u7801number\u5c5e\u6027");
        }
        Object pkValue = 0;
        try {
            pkValue = model.getDataEntity().getPkValue();
        }
        catch (Exception e) {
            LOGGER.info("\u8be5\u5355\u636e\u65e0\u4e3b\u952e\u4fe1\u606fPkValue\u5c5e\u6027");
        }
        formShow.setCustomParam(KEY_TDA_BILL_NAME, (Object)billName);
        formShow.setCustomParam(KEY_TDA_BILL_NUMBER, (Object)number);
        formShow.setCustomParam(KEY_TDA_PLAN_ID, (Object)planIdObj);
        formShow.setCustomParam(BILL_ID, (Object)String.valueOf(pkValue));
        formShow.setCustomParam(ACTION_TYPE, (Object)ACTION_TYPE_VALUE);
    }

    private long getPlanId() {
        Object billId = this.getView().getModel().getDataEntity().getPkValue();
        String entityKey = this.getEntityId();
        boolean billExist = QueryServiceHelper.exists((String)entityKey, (Object)billId);
        if (!billExist) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5185\u5bb9\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58", (String)"TdaEntityOperate_1", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter(BUSINESSO_BJECT, "=", (Object)entityKey);
        DynamicObject tdaPlanObj = QueryServiceHelper.queryOne((String)TDA_ENTITY_KEY, (String)"id,number", (QFilter[])new QFilter[]{filter});
        if (tdaPlanObj == null || tdaPlanObj.getLong("id") == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5dee\u5f02\u5206\u6790\u65b9\u6848\uff0c\u8bf7\u5148\u914d\u7f6e", (String)"TdaEntityOperate_2", (String)"ai-cvp-plugin", (Object[])new Object[0]));
        }
        return tdaPlanObj.getLong("id");
    }
}

