/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.ext.ai.cvp.utils.NumberParser;

public class ChineseNumberUtil {
    private static final Map<Character, Character> arabic2CnNumMap = new HashMap<Character, Character>();
    private static final Set<Character> currencyUnitSet = new HashSet<Character>();
    private static final Map<Character, Character> numMap = new HashMap<Character, Character>();
    private static final Map<Character, Integer> numUnitMap = new HashMap<Character, Integer>();
    private static final String[] numChars = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] units = new String[]{"", "\u5341", "\u767e", "\u5343"};
    private static final String[] unitsFourChar = new String[]{"\u4e07", "\u4ebf", "\u4e07", "\u4ebf"};
    private static final Set<Character> dotSet = new HashSet<Character>();
    private static final Pattern chineseNumPattern = Pattern.compile("[\u70b9\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07\u4ebf]{1,}");
    private static final Pattern numberPattern = Pattern.compile("[\\d\u96f6\u4e00\u4e8c\u4e24\u4fe9\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343\u4e07\u4ebf\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396\u62fe\u4f70\u4edf,\u5757\u5706\u5143\u6bdb\u89d2\u5206.\u70b9]+");

    private static void init() {
        ChineseNumberUtil.initNumMap();
        ChineseNumberUtil.initUnitMap();
        ChineseNumberUtil.initCurrencyUnit();
        ChineseNumberUtil.initDotSet();
        ChineseNumberUtil.initArabic2CnNumMap();
    }

    private static void initDotSet() {
        dotSet.add(Character.valueOf('\u70b9'));
        dotSet.add(Character.valueOf('.'));
    }

    private static void initNumMap() {
        numMap.put(Character.valueOf('\u25cb'), Character.valueOf('0'));
        numMap.put(Character.valueOf('\u96f6'), Character.valueOf('0'));
        numMap.put(Character.valueOf('\u4e00'), Character.valueOf('1'));
        numMap.put(Character.valueOf('\u4e8c'), Character.valueOf('2'));
        numMap.put(Character.valueOf('\u4e24'), Character.valueOf('2'));
        numMap.put(Character.valueOf('\u4fe9'), Character.valueOf('2'));
        numMap.put(Character.valueOf('\u4e09'), Character.valueOf('3'));
        numMap.put(Character.valueOf('\u56db'), Character.valueOf('4'));
        numMap.put(Character.valueOf('\u4e94'), Character.valueOf('5'));
        numMap.put(Character.valueOf('\u516d'), Character.valueOf('6'));
        numMap.put(Character.valueOf('\u4e03'), Character.valueOf('7'));
        numMap.put(Character.valueOf('\u516b'), Character.valueOf('8'));
        numMap.put(Character.valueOf('\u4e5d'), Character.valueOf('9'));
        numMap.put(Character.valueOf('\u58f9'), Character.valueOf('1'));
        numMap.put(Character.valueOf('\u8d30'), Character.valueOf('2'));
        numMap.put(Character.valueOf('\u53c1'), Character.valueOf('3'));
        numMap.put(Character.valueOf('\u8086'), Character.valueOf('4'));
        numMap.put(Character.valueOf('\u4f0d'), Character.valueOf('5'));
        numMap.put(Character.valueOf('\u9646'), Character.valueOf('6'));
        numMap.put(Character.valueOf('\u67d2'), Character.valueOf('7'));
        numMap.put(Character.valueOf('\u634c'), Character.valueOf('8'));
        numMap.put(Character.valueOf('\u7396'), Character.valueOf('9'));
        numMap.put(Character.valueOf('0'), Character.valueOf('0'));
        numMap.put(Character.valueOf('1'), Character.valueOf('1'));
        numMap.put(Character.valueOf('2'), Character.valueOf('2'));
        numMap.put(Character.valueOf('3'), Character.valueOf('3'));
        numMap.put(Character.valueOf('4'), Character.valueOf('4'));
        numMap.put(Character.valueOf('5'), Character.valueOf('5'));
        numMap.put(Character.valueOf('6'), Character.valueOf('6'));
        numMap.put(Character.valueOf('7'), Character.valueOf('7'));
        numMap.put(Character.valueOf('8'), Character.valueOf('8'));
        numMap.put(Character.valueOf('9'), Character.valueOf('9'));
        numMap.put(Character.valueOf('.'), Character.valueOf('.'));
        numMap.put(Character.valueOf('\u70b9'), Character.valueOf('.'));
        numMap.put(Character.valueOf('\u5e7a'), Character.valueOf('1'));
        numMap.put(Character.valueOf('\u8981'), Character.valueOf('1'));
        numMap.put(Character.valueOf('\u6211'), Character.valueOf('5'));
        numMap.put(Character.valueOf('\u8def'), Character.valueOf('6'));
    }

    private static void initArabic2CnNumMap() {
        arabic2CnNumMap.put(Character.valueOf('0'), Character.valueOf('\u96f6'));
        arabic2CnNumMap.put(Character.valueOf('1'), Character.valueOf('\u4e00'));
        arabic2CnNumMap.put(Character.valueOf('2'), Character.valueOf('\u4e8c'));
        arabic2CnNumMap.put(Character.valueOf('3'), Character.valueOf('\u4e09'));
        arabic2CnNumMap.put(Character.valueOf('4'), Character.valueOf('\u56db'));
        arabic2CnNumMap.put(Character.valueOf('5'), Character.valueOf('\u4e94'));
        arabic2CnNumMap.put(Character.valueOf('6'), Character.valueOf('\u516d'));
        arabic2CnNumMap.put(Character.valueOf('7'), Character.valueOf('\u4e03'));
        arabic2CnNumMap.put(Character.valueOf('8'), Character.valueOf('\u516b'));
        arabic2CnNumMap.put(Character.valueOf('9'), Character.valueOf('\u4e5d'));
    }

    private static void initCurrencyUnit() {
        currencyUnitSet.add(Character.valueOf('\u5706'));
        currencyUnitSet.add(Character.valueOf('\u5143'));
        currencyUnitSet.add(Character.valueOf('\u5757'));
        currencyUnitSet.add(Character.valueOf('\u89d2'));
        currencyUnitSet.add(Character.valueOf('\u6bdb'));
        currencyUnitSet.add(Character.valueOf('\u5206'));
    }

    private static void initUnitMap() {
        numUnitMap.put(Character.valueOf('\u4e2a'), 1);
        numUnitMap.put(Character.valueOf('\u5341'), 10);
        numUnitMap.put(Character.valueOf('\u767e'), 100);
        numUnitMap.put(Character.valueOf('\u5343'), 1000);
        numUnitMap.put(Character.valueOf('\u4e07'), 10000);
        numUnitMap.put(Character.valueOf('\u4ebf'), 100000000);
        numUnitMap.put(Character.valueOf('\u62fe'), 10);
        numUnitMap.put(Character.valueOf('\u4f70'), 100);
        numUnitMap.put(Character.valueOf('\u4edf'), 1000);
    }

    public static int extractNumber(String str) {
        String sIntValue;
        Matcher m = numberPattern.matcher(str);
        if (m.find() && (sIntValue = ChineseNumberUtil.chineseNum2Digit(m.group(0))) != null) {
            try {
                return Integer.parseInt(sIntValue);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return 0;
    }

    public static String extractNumberToString(String str) {
        Matcher m = numberPattern.matcher(str);
        if (m.find()) {
            return ChineseNumberUtil.chineseNum2Digit(m.group(0));
        }
        return null;
    }

    public static String chineseNum2Digit(String str) {
        return NumberParser.chineseNum2Digit(str);
    }

    public static String convertPureNumber(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (!ChineseNumberUtil.isPureNumber(text)) {
            return text;
        }
        if (ChineseNumberUtil.isContainUnitNumber(text)) {
            return "" + ChineseNumberUtil.chineseNum2Digit(text);
        }
        return ChineseNumberUtil.chineseNumberString2Digit(text);
    }

    public static String chineseNumberString2Digit(String text) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || '.' == c) {
                result.append(c);
                continue;
            }
            Character n = numMap.get(Character.valueOf(c));
            if (n == null) continue;
            result.append(n);
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    public static String digitString2ChineseNumberString(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        for (Map.Entry<Character, Character> e : arabic2CnNumMap.entrySet()) {
            text = text.replace(e.getKey().charValue(), e.getValue().charValue());
        }
        return text;
    }

    public static String clipPureNumber(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder pureNumber = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!numMap.containsKey(Character.valueOf(c)) && !numUnitMap.containsKey(Character.valueOf(c))) continue;
            pureNumber.append(c);
        }
        return pureNumber.toString();
    }

    public static String digit2ChineseNum(String number) {
        int i;
        String[] numbers = number.split("\\.");
        StringBuilder result = new StringBuilder();
        String integerPart = numbers[0];
        int integerPartLength = integerPart.length();
        if (integerPartLength == 1 && "0".equals(integerPart)) {
            result.append("\u96f6");
        } else {
            boolean preReadZero = true;
            for (i = integerPartLength; i > 0; --i) {
                int digit;
                int pos = integerPartLength - i;
                int mod = pos % 4;
                int j = pos / 4;
                String currentUnit = units[mod];
                if (mod == 0) {
                    if (i - 4 >= 0 && "0000".equals(integerPart.substring(i - 4, i))) {
                        if (j > 0 && pos % 8 == 0) {
                            result.append("\u4ebf");
                        }
                        if (!preReadZero) {
                            result.append("\u96f6");
                            preReadZero = true;
                        }
                        i -= 3;
                        continue;
                    }
                    preReadZero = true;
                }
                if ((digit = Character.digit(integerPart.charAt(i - 1), 10)) == 0) {
                    if (!preReadZero) {
                        result.append("\u96f6");
                        preReadZero = true;
                    }
                    if (mod != 0) continue;
                    if (j > 0) {
                        result.append(unitsFourChar[j - 1]);
                    }
                    result.append(currentUnit);
                    continue;
                }
                if (digit == 1 && integerPartLength == 2 && "\u5341".equals(currentUnit)) {
                    result.append(currentUnit);
                    continue;
                }
                if (j > 0 && mod == 0) {
                    result.append(unitsFourChar[j - 1]);
                }
                result.append(currentUnit);
                result.append(numChars[digit]);
                preReadZero = false;
            }
            result.reverse();
        }
        if (numbers.length == 2) {
            result.append("\u70b9");
            String decimalPart = numbers[1];
            for (i = 0; i < decimalPart.length(); ++i) {
                int numberValue = Character.digit(decimalPart.charAt(i), 10);
                result.append(numChars[numberValue]);
            }
        }
        return result.toString();
    }

    public static String replaceDigitPercent2ChineseNum(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (!str.contains("%")) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        int len = str.length();
        int lastPos = len - 1;
        int i = len - 1;
        while (i >= 0) {
            if (str.charAt(i) != '%') {
                --i;
                continue;
            }
            if (i == 0) {
                result.insert(0, str.substring(i, lastPos + 1));
                lastPos = -1;
                break;
            }
            result.insert(0, str.substring(i + 1, lastPos + 1));
            int endIndex = i--;
            char c = str.charAt(i);
            while (i >= 0 && (Character.isDigit(c = str.charAt(i)) || c == '.')) {
                --i;
            }
            if (endIndex > i + 1) {
                String digit = str.substring(i + 1, endIndex);
                result.insert(0, "\u767e\u5206\u4e4b" + ChineseNumberUtil.digit2ChineseNum(digit));
            } else {
                result.insert(0, "%");
            }
            if (i == 0) {
                result.insert(0, str.charAt(i));
                lastPos = -1;
                break;
            }
            lastPos = i--;
        }
        if (lastPos > 0) {
            result.insert(0, str.substring(0, lastPos + 1));
        }
        return result.toString();
    }

    public static String convertAllCharacter2Digit(String sentence) {
        String result = sentence;
        Matcher m = chineseNumPattern.matcher(sentence);
        while (m.find()) {
            String s = m.group();
            String dig = ChineseNumberUtil.chineseNum2Digit(s);
            result = result.replace(s, dig);
        }
        return result;
    }

    private static boolean isContainUnitNumber(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!numUnitMap.containsKey(Character.valueOf(c))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumberString(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || numMap.containsKey(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPureNumber(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || numMap.containsKey(Character.valueOf(c)) || numUnitMap.containsKey(Character.valueOf(c)) || dotSet.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isMoneyNumber(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || numMap.containsKey(Character.valueOf(c)) || numUnitMap.containsKey(Character.valueOf(c)) || currencyUnitSet.contains(Character.valueOf(c)) || dotSet.contains(Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isArabicNumber(String s) {
        String rule = "^[0-9]*\\.?[0-9]*$";
        Pattern pattern = Pattern.compile(rule);
        Matcher matcher = pattern.matcher(s);
        return matcher.matches();
    }

    static {
        ChineseNumberUtil.init();
    }
}

