/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ai.cvp.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.ext.ai.cvp.utils.ChineseNumberUtil;

public class DateUtils {
    public static final int WRONG_VALUE_YEAR = 0;
    private static final String[] patterns = new String[]{"yyyy-MM-dd", "yyyyMMdd", "yyyy/MM/dd", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"};

    public static Date parseMonth(String text) {
        int value;
        int indexOfMonth;
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int startIndex = 0;
        int indexOfYear = text.indexOf("\u5e74");
        if (indexOfYear > 0) {
            int value2 = DateUtils.parseYearValue(year, text.substring(0, indexOfYear + 1));
            if (value2 != 0) {
                year = value2;
            }
            startIndex = indexOfYear + 1;
        }
        if ((indexOfMonth = text.indexOf("\u6708")) > startIndex) {
            value = DateUtils.parseMonthValue(month, text.substring(startIndex, indexOfMonth + 1));
            if (value != -2) {
                if (value == -1) {
                    --year;
                    month = 11;
                } else if (value == 12) {
                    ++year;
                    month = 0;
                } else {
                    month = value;
                }
            }
            startIndex = indexOfMonth + 1;
        }
        if ((value = DateUtils.parseDayValue(day, text.substring(startIndex))) != -1) {
            day = value;
        }
        if (year < 1970) {
            return null;
        }
        calendar.set(5, 1);
        calendar.set(1, year);
        if (month < 0 || month > 11) {
            return null;
        }
        calendar.set(2, month);
        int datMax = calendar.getActualMaximum(5);
        if (day < 1 || day > datMax) {
            return null;
        }
        calendar.set(5, day);
        return calendar.getTime();
    }

    public static Date parseFormatedDate(String inputDate) {
        SimpleDateFormat df = new SimpleDateFormat();
        for (String pattern : patterns) {
            df.applyPattern(pattern);
            df.setLenient(false);
            ParsePosition pos = new ParsePosition(0);
            Date date = df.parse(inputDate, pos);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    public static int parseYearValue(int currentYear, String value) {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        if (value.equals("\u524d\u5e74")) {
            return currentYear - 2;
        }
        if (value.equals("\u53bb\u5e74") || value.equals("\u4e0a\u4e00\u5e74") || value.equals("\u8fc7\u53bb\u4e00\u5e74")) {
            return currentYear - 1;
        }
        if (value.equals("\u4eca\u5e74") || value.equals("\u672c\u5e74") || value.equals("\u5f53\u5e74") || value.equals("\u8fd9\u4e00\u5e74")) {
            return currentYear;
        }
        if (value.equals("\u660e\u5e74") || value.equals("\u4e0b\u4e00\u5e74")) {
            return currentYear + 1;
        }
        int actualYear = ChineseNumberUtil.extractNumber(value);
        if (actualYear == 0) {
            return 0;
        }
        if (actualYear < 100) {
            actualYear += 2000;
        }
        return actualYear;
    }

    public static int parseMonthValue(int currentMonth, String value) {
        if (value == null || value.isEmpty()) {
            return -2;
        }
        if (value.equals("\u4e0a\u6708") || value.equals("\u4e0a\u4e2a\u6708") || value.equals("\u4e0a\u4e00\u6708") || value.equals("\u4e0a\u4e00\u4e2a\u6708") || value.equals("\u524d\u6708") || value.equals("\u524d\u4e2a\u6708") || value.equals("\u524d\u4e00\u6708") || value.equals("\u524d\u4e00\u4e2a\u6708")) {
            return currentMonth - 1;
        }
        if (value.equals("\u672c\u6708") || value.equals("\u8fd9\u4e2a\u6708") || value.equals("\u8fd9\u6708") || value.equals("\u5f53\u6708")) {
            return currentMonth;
        }
        if (value.equals("\u4e0b\u4e2a\u6708") || value.equals("\u4e0b\u6708") || value.equals("\u4e0b\u4e00\u6708")) {
            return currentMonth + 1;
        }
        int num = ChineseNumberUtil.extractNumber(value);
        if (num == 0) {
            return -1;
        }
        return num - 1;
    }

    public static int parseDayValue(int currentDay, String value) {
        int num;
        if (value == null || value.isEmpty()) {
            return -1;
        }
        int index = value.indexOf(21495);
        if (index < 0) {
            index = value.indexOf(26085);
        }
        if (index > 0) {
            value = value.substring(0, index);
        }
        if ((num = ChineseNumberUtil.extractNumber(value)) == 0) {
            return -1;
        }
        return num;
    }
}

