/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.mservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.core.DeployMethod;
import kd.ai.aicc.core.RequestParameter;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.client.LocalClient;
import kd.ai.aicc.core.dao.TaskDao;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;

@ApiController(value="aicc", desc="AI\u80fd\u529b\u4e2d\u5fc3api V2.0 \u63a5\u53e3")
public class AiccApiV2 {
    private static final Log logger = LogFactory.getLog(AiccApiV2.class);

    @ApiPostMapping(value="/service/sync")
    public CustomApiResult<@ApiResponseBody(value="\u7b97\u6cd5(JSON)\u7ed3\u679c", example="TaskResult:ApiResult") TaskResult> syncService(@ApiRequestBody(value="\u7b97\u6cd5\u8bf7\u6c42\u53c2\u6570") RequestParameter apiRequest) throws KDBizException {
        logger.info("\u540c\u6b65\u6a21\u578b\u670d\u52a1{}", (Object)apiRequest.getServiceNumber());
        TaskResult taskResult = this.callService(apiRequest, false);
        return CustomApiResult.success((Object)taskResult);
    }

    @ApiPostMapping(value="/service/async")
    public CustomApiResult<@ApiResponseBody(value="\u4efb\u52a1ID", example="TaskResult:ApiResult") TaskResult> asyncService(@ApiRequestBody(value="\u7b97\u6cd5\u8bf7\u6c42\u53c2\u6570") RequestParameter apiRequest) throws KDBizException {
        logger.info("\u5f02\u6b65\u6a21\u578b\u670d\u52a1{}", (Object)apiRequest.getServiceNumber());
        TaskResult taskResult = this.callService(apiRequest, true);
        return CustomApiResult.success((Object)taskResult);
    }

    private TaskResult callService(RequestParameter apiRequest, boolean isAsync) {
        LocalClient client = new LocalClient();
        this.checkParameter(apiRequest);
        TaskResult taskResult = isAsync ? client.asyncService(apiRequest) : client.syncService(apiRequest);
        return taskResult;
    }

    private void checkParameter(RequestParameter apiRequest) {
        DeployMethod deployMethod = DeployMethod.getDeployMethod();
        if (DeployMethod.PUBLIC_CLOUND_SERVER != deployMethod && DeployMethod.PRIVATE_CLOUND != deployMethod) {
            throw new KDBizException(Constant.ONLY_SUPPORT_CLOUD_SERVER_ERROR, new Object[0]);
        }
        if (StringUtils.isEmpty((String)apiRequest.getProdInstCode())) {
            throw new KDBizException(Constant.nullError((String)"product instant code"), new Object[0]);
        }
        if (StringUtils.isEmpty((String)apiRequest.getTenantId())) {
            throw new KDBizException(Constant.nullError((String)"tenant id"), new Object[0]);
        }
        if (StringUtils.isEmpty((String)apiRequest.getServiceNumber())) {
            throw new KDBizException(Constant.nullError((String)"service number"), new Object[0]);
        }
        if (DataManager.getInstance().findServiceByNumber(RequestContext.get().getAccountId(), apiRequest.getServiceNumber()) == null) {
            throw new KDBizException(Constant.serviceDataError((String)apiRequest.getServiceNumber()), new Object[0]);
        }
    }

    @ApiPostMapping(value="/query/onetask")
    public CustomApiResult<@ApiResponseBody(value="\u4efb\u52a1\u7ed3\u679c", example="TaskResult:ApiResult") TaskResult> queryTaskResult(@ApiParam(value="\u4efb\u52a1ID") @ApiParam(value="\u4efb\u52a1ID") long taskId) {
        TaskResult result;
        List results = TaskDao.queryTaskResult((long[])new long[]{taskId});
        if (!results.isEmpty()) {
            result = (TaskResult)results.get(0);
        } else {
            result = new TaskResult();
            result.setId(taskId);
            result.setStatus(TaskStatusEnum.CREATE.getValue());
            result.setErrMsg("task-not-exists");
        }
        return CustomApiResult.success((Object)result);
    }

    @ApiPostMapping(value="/query/batch")
    public CustomApiResult<@ApiResponseBody(value="\u4efb\u52a1\u7ed3\u679c", example="List<TaskResult>>:ApiResult") List<TaskResult>> queryTaskListResult(@ApiParam(value="\u4efb\u52a1ID\u5217\u8868") @ApiParam(value="\u4efb\u52a1ID\u5217\u8868") long[] taskList) {
        return CustomApiResult.success((Object)TaskDao.queryTaskResult((long[])taskList));
    }

    @ApiPostMapping(value="/initializePublicAiccService")
    public CustomApiResult<Object> initializePublicAiccService(@Valid @ApiParam(required=true, value="\u79df\u6237id") @Valid @ApiParam(required=true, value="\u79df\u6237id") String tenatId, @Valid @ApiParam(required=true, value="\u4ea7\u54c1\u7f16\u7801") @Valid @ApiParam(required=true, value="\u4ea7\u54c1\u7f16\u7801") String prodInstCode, @Valid @ApiParam(required=true, value="\u79df\u6237\u7c7b\u578b") @Valid @ApiParam(required=true, value="\u79df\u6237\u7c7b\u578b") String tenatType, @Valid @ApiParam(required=true, value="\u79df\u6237\u540d\u79f0") @Valid @ApiParam(required=true, value="\u79df\u6237\u540d\u79f0") String tenatName, @Valid @ApiParam(required=true, value="\u79df\u6237\u7f16\u7801") @Valid @ApiParam(required=true, value="\u79df\u6237\u7f16\u7801") String tenatCode) {
        boolean hasPermission = AiccApiV2.validApiPermission();
        if (!hasPermission) {
            return CustomApiResult.fail((String)"1000", (String)ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u63a5\u53e3\u8c03\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002", (String)"AiccApiV2_15178604", (String)"ai-aicc-mservice", (Object[])new Object[0]));
        }
        logger.info("\u521d\u59cb\u5316\u63a5\u53e3\uff0c\u79df\u6237\u540d\u79f0\uff1a" + tenatName);
        QFilter[] qFilter = new QFilter[]{new QFilter("number", "=", (Object)tenatCode), new QFilter("name", "=", (Object)tenatName), new QFilter("tenanttype", "=", (Object)tenatType), new QFilter("cqtenantid", "=", (Object)tenatId), new QFilter("prodinstid", "=", (Object)prodInstCode)};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"aicc_tenant", (QFilter[])qFilter);
        if (obj != null) {
            logger.info("\u91cd\u590d\u7684\u79df\u6237\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c");
            return CustomApiResult.fail((String)"1000", (String)"duplicate TenatInfo,cant not initialize");
        }
        obj = BusinessDataServiceHelper.newDynamicObject((String)"aicc_tenant");
        obj.set("number", (Object)tenatCode);
        obj.set("name", (Object)tenatName);
        obj.set("tenanttype", (Object)tenatType);
        obj.set("cqtenantid", (Object)tenatId);
        obj.set("prodinstid", (Object)prodInstCode);
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        obj.set("status", (Object)"C");
        obj.set("enable", (Object)1);
        Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        Map<String, Object> response = this.getAllAiccService();
        response.put("tenantId", ((DynamicObject)result[0]).getPkValue());
        return CustomApiResult.success(response);
    }

    @ApiPostMapping(value="/updateTenantStatus")
    public CustomApiResult<Object> updateTenantStatus(@Valid @ApiParam(required=true, value="\u79df\u6237id") @Valid @ApiParam(required=true, value="\u79df\u6237id") Long tenantId, @Valid @ApiParam(required=true, value="\u72b6\u6001") @Valid @ApiParam(required=true, value="\u72b6\u6001") int enable) {
        boolean hasPermission = AiccApiV2.validApiPermission();
        if (!hasPermission) {
            return CustomApiResult.fail((String)"1000", (String)ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u63a5\u53e3\u8c03\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002", (String)"AiccApiV2_15178604", (String)"ai-aicc-mservice", (Object[])new Object[0]));
        }
        logger.info("\u66f4\u65b0\u79df\u6237\u4f7f\u7528\u72b6\u6001\u63a5\u53e3\uff0c\u79df\u6237id\uff1a" + tenantId);
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "=", (Object)tenantId)};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"aicc_tenant", (QFilter[])qFilter);
        if (obj != null) {
            logger.info("\u66f4\u65b0\u79df\u6237\u4f7f\u7528\u72b6\u6001,\u79df\u6237\u540d\u79f0\uff1a" + obj.getString("name"));
            logger.info("\u72b6\u6001\uff1a" + enable);
            obj.set("enable", (Object)enable);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            return CustomApiResult.success((Object)"updateTenantStatus success");
        }
        return CustomApiResult.fail((String)"1000", (String)"errror tenantId");
    }

    @ApiPostMapping(value="/getAllService")
    public CustomApiResult<Object> getAllService() {
        Map<String, Object> response = this.getAllAiccService();
        if (response.get("error") != null) {
            return CustomApiResult.fail((String)"-1", (String)response.get("error").toString());
        }
        return CustomApiResult.success(response);
    }

    private Map<String, Object> getAllAiccService() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        boolean hasPermission = AiccApiV2.validApiPermission();
        if (!hasPermission) {
            response.put("error", "\u7528\u6237\u6ca1\u6709\u63a5\u53e3\u8c03\u7528\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e\u3002");
            return response;
        }
        DynamicObjectCollection serviceTypeCollection = QueryServiceHelper.query((String)"aicc_servicetype", (String)"id,number,name", null);
        DynamicObjectCollection serviceCollection = QueryServiceHelper.query((String)"aicc_service", (String)"id,number,name,createtime,supportstream,enable,group,requestsample,requestsample_tag,responsesample,responsesample_tag,version,desc,status", null);
        List services = DynamicObjectUtil.serializeToMap((DynamicObject[])((DynamicObject[])serviceCollection.toArray((Object[])new DynamicObject[serviceCollection.size()])), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"aicc_service"));
        List serviceTypes = DynamicObjectUtil.serializeToMap((DynamicObject[])((DynamicObject[])serviceTypeCollection.toArray((Object[])new DynamicObject[serviceTypeCollection.size()])), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"aicc_servicetype"));
        response.put("serviceTypes", serviceTypes);
        response.put("services", services);
        return response;
    }

    public static boolean validApiPermission() {
        logger.info("\u63a5\u53e3\u6743\u9650\u9a8c\u8bc1\u5f00\u59cb");
        long currUserId = RequestContext.get().getCurrUserId();
        String key_appId = "aicc";
        String appId = AppMetadataCache.getAppInfo((String)key_appId).getAppId();
        String entityNum = "aicc_service";
        return PermissionServiceHelper.checkPermission((Long)currUserId, (String)appId, (String)entityNum, (String)"47150e89000000ac");
    }
}

