/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.mservice;

import com.alibaba.fastjson.JSON;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.aicc.core.AsyncTaskNotifier;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.core.DeployMethod;
import kd.ai.aicc.core.IClient;
import kd.ai.aicc.core.RequestParameter;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.dao.ServiceDao;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.Service;
import kd.ai.aicc.core.domain.enuz.ModelType;
import kd.ai.aicc.mservice.AiccService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class AiccServiceImpl
implements AiccService {
    private static final Log logger = LogFactory.getLog(AiccServiceImpl.class);

    public String postFile(FileInputStream fileInputStream) {
        return null;
    }

    public Map<String, String> syncService(Map<String, String> context, String serviceNumber, String paramStr) {
        return this.callService(context, serviceNumber, paramStr, false);
    }

    public Map<String, String> asyncService(Map<String, String> context, String serviceNumber, String paramStr) {
        return this.callService(context, serviceNumber, paramStr, true);
    }

    public Map<String, String> queryTaskResult(long taskId) {
        List results = TaskDao.queryTaskResult((long[])new long[]{taskId});
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (!results.isEmpty()) {
            TaskResult result = (TaskResult)results.get(0);
            resultMap.put("id", String.valueOf(taskId));
            resultMap.put("status", result.getStatus());
            resultMap.put("result", result.getResult());
            resultMap.put("errorCode", result.getErrCode());
            resultMap.put("message", result.getErrMsg());
        } else {
            resultMap.put("id", String.valueOf(taskId));
            resultMap.put("status", TaskStatusEnum.CREATE.getValue());
            resultMap.put("message", "task-not-exists");
        }
        return resultMap;
    }

    public List<Map<String, String>> queryTaskListResult(long[] taskList) {
        List results = TaskDao.queryTaskResult((long[])taskList);
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>(results.size());
        for (TaskResult result : results) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("id", String.valueOf(result.getId()));
            resultMap.put("status", result.getStatus());
            resultMap.put("result", result.getResult());
            resultMap.put("errorCode", result.getErrCode());
            resultMap.put("message", result.getErrMsg());
            data.add(resultMap);
        }
        return data;
    }

    public void stopStream(long taskId) {
        CacheHelper.putString((String)("ST_ST_" + taskId), (String)"[STOP]");
    }

    private Map<String, String> callService(Map<String, String> contextMap, String serviceNumber, String paramStr, boolean isAsync) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        ErrorCode errorCode = this.checkParameter(contextMap, serviceNumber, paramStr, isAsync);
        if (errorCode != null) {
            stringMap.put("errorCode", errorCode.getCode());
            stringMap.put("message", errorCode.getMessage());
            return stringMap;
        }
        IClient client = IClient.getInstance();
        RequestParameter parameter = new RequestParameter();
        parameter.setProdInstCode(Utils.getProdInstCode());
        parameter.setTenantId(Utils.getTenantID());
        parameter.setServiceNumber(serviceNumber);
        parameter.setServiceParams(paramStr);
        RequestParameter.Context context = new RequestParameter.Context();
        if (contextMap != null && !contextMap.isEmpty()) {
            context.setPriority(this.parseInt(contextMap, "priority"));
            context.setPageCount(this.parseInt(contextMap, "pagecount"));
            context.setStream(this.parseBoolean(contextMap, "stream"));
            context.setEncrypt(this.parseBoolean(contextMap, "isEncrypt"));
        }
        parameter.setContext(context);
        long taskId = TaskDao.genTaskID();
        parameter.getContext().setTaskId(taskId);
        try {
            TaskResult taskResult;
            AsyncTaskNotifier.setAsyncNotifyService((long)taskId, contextMap);
            if (isAsync) {
                taskResult = client.asyncService(parameter);
            } else {
                taskResult = client.syncService(parameter);
                stringMap.put("result", taskResult.getResult());
                stringMap.put("status", taskResult.getStatus());
            }
            stringMap.put("id", String.valueOf(taskResult.getId()));
            stringMap.put("errorCode", taskResult.getErrCode());
            stringMap.put("message", taskResult.getErrMsg());
        }
        catch (Exception exp) {
            logger.error(exp.getMessage(), (Throwable)exp);
            if (exp instanceof KDBizException) {
                errorCode = ((KDBizException)exp).getErrorCode();
            }
            if (errorCode == null || StringUtils.isEmpty((String)errorCode.getCode())) {
                errorCode = Constant.internalError((String)exp.getMessage());
            }
            stringMap.put("errorCode", errorCode.getCode());
            stringMap.put("message", errorCode.getMessage());
            stringMap.put("id", String.valueOf(taskId));
        }
        return stringMap;
    }

    private ErrorCode checkParameter(Map<String, String> contextMap, String serviceNumber, String paramStr, boolean isAsync) {
        Service service = DataManager.getInstance().findServiceByNumber(RequestContext.get().getAccountId(), serviceNumber);
        if (service == null) {
            return Constant.serviceDataError((String)serviceNumber);
        }
        if (service.getInstances() == null || service.getInstances().isEmpty()) {
            return Constant.serviceNoInstanceDataError((String)serviceNumber);
        }
        return null;
    }

    private int parseInt(Map<String, String> contextMap, String key) {
        String val = contextMap.get(key);
        if (StringUtils.isNotEmpty((String)val)) {
            return Integer.parseInt(val);
        }
        return 0;
    }

    private boolean parseBoolean(Map<String, String> contextMap, String key) {
        String val = contextMap.get(key);
        if (StringUtils.isNotEmpty((String)val)) {
            return Boolean.parseBoolean(val);
        }
        return false;
    }

    public Boolean initTenant() {
        DeployMethod deployMethod = Utils.checkLicenseType();
        if (DeployMethod.PUBLIC_CLOUND_CLIENT == deployMethod || DeployMethod.PRIVATE_CLOUND == deployMethod) {
            String T_NUMBER = "900000001";
            logger.info("\u5fae\u670d\u52a1\u63a5\u53e3\u2014\u2014\u2014\u5f00\u59cb\u521d\u59cb\u5316");
            DynamicObject tenant = BusinessDataServiceHelper.loadSingle((String)"aicc_tenant", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)900000001L)});
            if (tenant == null) {
                logger.info("\u5fae\u670d\u52a1\u63a5\u53e3\u2014\u2014\u2014\u65b0\u5efa\u4e00\u6761\u79df\u6237\u4fe1\u606f");
                DynamicObject obj2 = BusinessDataServiceHelper.newDynamicObject((String)"aicc_tenant");
                obj2.set("id", (Object)900000001L);
                obj2.set("number", (Object)T_NUMBER);
                obj2.set("name", (Object)ResManager.loadKDString((String)"\u79c1\u6709\u4e91\u79df\u6237", (String)"TenantListPlugin_0", (String)"ai-aicc-plugin", (Object[])new Object[0]));
                obj2.set("cqtenantid", (Object)Utils.getTenantID());
                obj2.set("prodinstid", (Object)Utils.getProdInstCode());
                obj2.set("enable", (Object)"1");
                obj2.set("status", (Object)"C");
                obj2.set("creator", (Object)1);
                obj2.set("tenanttype", (Object)"private");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj2});
            } else {
                if (!tenant.getString("cqtenantid").equals(Utils.getTenantID())) {
                    logger.info("\u79df\u6237id\u53d1\u751f\u53d8\u5316\uff0c\u66f4\u65b0");
                    tenant.set("cqtenantid", (Object)Utils.getTenantID());
                }
                if (!tenant.getString("prodinstid").equals(Utils.getProdInstCode())) {
                    logger.info("\u4ea7\u54c1\u5b9e\u4f8b\u7801\u53d1\u751f\u53d8\u5316\uff0c\u66f4\u65b0");
                    tenant.set("prodinstid", (Object)Utils.getProdInstCode());
                }
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{tenant});
            }
            return Boolean.TRUE;
        }
        logger.info("\u5fae\u670d\u52a1\u63a5\u53e3\u2014\u2014\u2014\u65e0\u9700\u521d\u59cb\u5316");
        return Boolean.FALSE;
    }

    public List<Map<String, Object>> queryInstance(String groupNumber, String serviceNumber, String instanceNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        if (StringUtils.isNotEmpty((String)groupNumber)) {
            logger.info("groupNumber" + groupNumber);
            filters.add(new QFilter("service.group.number", "=", (Object)groupNumber));
        }
        if (StringUtils.isNotEmpty((String)serviceNumber)) {
            logger.info("serviceNumber" + serviceNumber);
            filters.add(new QFilter("service.number", "=", (Object)serviceNumber));
        }
        if (StringUtils.isNotEmpty((String)instanceNumber)) {
            logger.info("instanceNumber" + instanceNumber);
            filters.add(new QFilter("number", "=", (Object)instanceNumber));
        }
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"aicc_instance", (String)"id,number,name,service.name,service.number,status,enable,maxparallel,authtype,usersecretkey,clientid,secretkey,protocol,contexturl,host,port", (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"createtime desc");
        List tenants = DynamicObjectUtil.serializeToMap((DynamicObject[])((DynamicObject[])objs.toArray((Object[])new DynamicObject[objs.size()])), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"aicc_instance"));
        return tenants;
    }

    public Map<String, String> saveInstance(Map<String, Object> instanceInfo, String serviceNumber, String serviceName, Boolean isSupportstream, String groupNumber) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            HashMap<String, String> response = new HashMap<String, String>(3);
            response.put("id", "");
            response.put("number", "");
            response.put("message", "");
            if (instanceInfo == null) {
                response.put("message", "instanceInfo must input");
                HashMap<String, String> hashMap = response;
                return hashMap;
            }
            if (instanceInfo.get("id") != null && StringUtils.isNotEmpty((String)String.valueOf(instanceInfo.get("id")))) {
                DynamicObject Instance = BusinessDataServiceHelper.loadSingle((String)"aicc_instance", (QFilter[])new QFilter[]{new QFilter("id", "=", instanceInfo.get("id"))});
                if (Instance == null) {
                    response.put("message", "instance data not exist");
                    HashMap<String, String> hashMap = response;
                    return hashMap;
                }
                logger.info("\u5f00\u59cb\u4fee\u6539\u5b9e\u4f8b");
                if (instanceInfo.get("name") != null) {
                    Instance.set("name", instanceInfo.get("name"));
                }
                if (instanceInfo.get("maxparallel") != null) {
                    Instance.set("maxparallel", instanceInfo.get("maxparallel"));
                }
                if (instanceInfo.get("paralleltype") != null) {
                    Instance.set("paralleltype", instanceInfo.get("paralleltype"));
                }
                if (instanceInfo.get("authtype") != null) {
                    Instance.set("authtype", instanceInfo.get("authtype"));
                }
                if (instanceInfo.get("usersecretkey") != null) {
                    Instance.set("usersecretkey", instanceInfo.get("usersecretkey"));
                }
                if (instanceInfo.get("clientid") != null) {
                    Instance.set("clientid", instanceInfo.get("clientid"));
                }
                if (instanceInfo.get("secretkey") != null) {
                    Instance.set("secretkey", instanceInfo.get("secretkey"));
                }
                if (instanceInfo.get("protocol") != null) {
                    Instance.set("protocol", instanceInfo.get("protocol"));
                }
                if (instanceInfo.get("contexturl") != null) {
                    Instance.set("contexturl", instanceInfo.get("contexturl"));
                }
                if (instanceInfo.get("host") != null) {
                    Instance.set("host", instanceInfo.get("host"));
                }
                if (instanceInfo.get("port") != null) {
                    Instance.set("port", instanceInfo.get("port"));
                }
                Instance.set("modifier", (Object)RequestContext.get().getCurrUserId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{Instance});
                response.put("id", Instance.getPkValue().toString());
                response.put("number", Instance.getString("number"));
                response.put("message", "modify instance success");
            } else {
                Object servicId;
                logger.info("\u5f00\u59cb\u521b\u5efa\u5b9e\u4f8b");
                if (StringUtils.isEmpty((String)serviceNumber)) {
                    response.put("message", "serviceNumber must input");
                    HashMap<String, String> Instance = response;
                    return Instance;
                }
                DynamicObject serviceObj = QueryServiceHelper.queryOne((String)"aicc_service", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)serviceNumber)});
                if (serviceObj == null) {
                    logger.info("\u4e0d\u5b58\u5728\u670d\u52a1\uff0c\u521b\u5efa\u670d\u52a1\uff0c\u670d\u52a1\u7f16\u7801\uff1a" + serviceNumber);
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"aicc_service");
                    obj.set("number", (Object)serviceNumber);
                    if (StringUtils.isNotEmpty((String)serviceName)) {
                        obj.set("name", (Object)serviceName);
                    } else {
                        if (QueryServiceHelper.exists((String)"aicc_service", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)serviceName)})) {
                            response.put("message", "duplicate serviceName");
                            HashMap<String, String> hashMap = response;
                            return hashMap;
                        }
                        obj.set("name", (Object)serviceNumber);
                    }
                    if (isSupportstream == null || Boolean.FALSE.equals(isSupportstream)) {
                        obj.set("supportstream", (Object)"0");
                    } else {
                        obj.set("supportstream", (Object)"1");
                    }
                    if (StringUtils.isNotEmpty((String)groupNumber)) {
                        DynamicObject serviceType = QueryServiceHelper.queryOne((String)"aicc_servicetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)groupNumber)});
                        if (serviceType == null) {
                            response.put("message", "groupNumber data not exist");
                            HashMap<String, String> hashMap = response;
                            return hashMap;
                        }
                        obj.set("group", serviceType.get("id"));
                    }
                    obj.set("desc", (Object)"\u63a5\u53e3\u521b\u5efa");
                    obj.set("status", (Object)"A");
                    obj.set("enable", (Object)1);
                    obj.set("creator", (Object)RequestContext.get().getCurrUserId());
                    Object[] reslut = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                    servicId = ((DynamicObject)reslut[0]).getPkValue();
                } else {
                    logger.info("\u670d\u52a1\u5df2\u5b58\u5728\uff0c\u670d\u52a1\u7f16\u7801\uff1a" + serviceNumber);
                    servicId = serviceObj.get("id");
                }
                DynamicObject service = BusinessDataServiceHelper.loadSingle((Object)servicId, (String)"aicc_service");
                DynamicObjectCollection instanceCollection = (DynamicObjectCollection)service.get("entryentity");
                DynamicObject instanceObj = instanceCollection.addNew();
                String number = CodeRuleServiceHelper.getNumber((String)"aicc_instance", (DynamicObject)instanceObj, (String)String.valueOf(RequestContext.get().getOrgId()));
                if (instanceInfo.get("name") == null || StringUtils.isEmpty((String)instanceInfo.get("name").toString())) {
                    response.put("message", "instanceInfo.name must input");
                    HashMap<String, String> hashMap = response;
                    return hashMap;
                }
                if (instanceInfo.get("authtype") == null || StringUtils.isEmpty((String)instanceInfo.get("authtype").toString())) {
                    response.put("message", "instanceInfo.authtype must input");
                    HashMap<String, String> hashMap = response;
                    return hashMap;
                }
                if (instanceInfo.get("paralleltype") == null) {
                    instanceObj.set("paralleltype", (Object)"QPS");
                } else {
                    instanceObj.set("paralleltype", instanceInfo.get("paralleltype"));
                }
                if (instanceInfo.get("maxparallel") == null) {
                    response.put("message", "instanceInfo.maxparallel must input");
                    HashMap<String, String> hashMap = response;
                    return hashMap;
                }
                String modelUrl = "";
                if (instanceInfo.get("host") != null) {
                    modelUrl = String.format("%s://%s:%s/%s", instanceInfo.get("protocol"), instanceInfo.get("host"), instanceInfo.get("port"), instanceInfo.get("contexturl"));
                    instanceObj.set("modelurl", (Object)modelUrl);
                } else {
                    instanceObj.set("modelurl", instanceInfo.get("modelurl"));
                }
                instanceObj.set("maxparallel", instanceInfo.get("maxparallel"));
                instanceObj.set("authtype", instanceInfo.get("authtype"));
                instanceObj.set("usersecretkey", instanceInfo.get("usersecretkey"));
                instanceObj.set("clientid", instanceInfo.get("clientid"));
                instanceObj.set("secretkey", instanceInfo.get("secretkey"));
                if (instanceInfo.get("authurl") != null) {
                    instanceObj.set("authurl", instanceInfo.get("authurl"));
                }
                instanceObj.set("instancestatus", (Object)"C");
                instanceObj.set("instanceenable", (Object)"1");
                instanceObj.set("service", servicId);
                Object[] reslut = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{service});
                response.put("id", ((DynamicObject)reslut[0]).getPkValue().toString());
                response.put("number", number);
                response.put("message", "create instance success");
                logger.info("\u521b\u5efa\u5b9e\u4f8b\u6210\u529f\uff0c\u5b9e\u4f8b\u7f16\u7801\uff1a" + number);
            }
            HashMap<String, String> hashMap = response;
            return hashMap;
        }
        catch (Exception ex) {
            try {
                logger.error("\u66f4\u65b0\u6a21\u578b\u670d\u52a1\u5f02\u5e38:", (Throwable)ex);
                h.markRollback();
                throw ex;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Map<String, String> deleteInstance(String instanceNumber) {
        HashMap<String, String> response = new HashMap<String, String>();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aicc_instance", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)instanceNumber)});
        if (dynamicObject != null) {
            BasedataEntityType userType = (BasedataEntityType)dynamicObject.getDataEntityType();
            BasedataEntityType subEntityType = (BasedataEntityType)userType.getSubEntityType(new ArrayList(0));
            boolean refrenced = BaseDataRefrenceHelper.isRefrenced((BasedataEntityType)subEntityType, (Object)RequestContext.get().getCurrUserId());
            if (refrenced) {
                logger.info("\u6570\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u7981\u7528\u6570\u636e\uff0c\u5b9e\u4f8b\u7f16\u7801\u4e3a\uff1a" + instanceNumber);
                dynamicObject.set("enable", (Object)0);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                response.put("issuccess", "true");
                response.put("message", "delete success,Data referenced");
            } else {
                logger.info("\u6570\u636e\u5220\u9664\uff0c\u5b9e\u4f8b\u7f16\u7801\u4e3a\uff1a" + instanceNumber);
                DeleteServiceHelper.delete((String)"aicc_instance", (QFilter[])new QFilter[]{new QFilter("id", "=", dynamicObject.getPkValue())});
                response.put("issuccess", "true");
                response.put("message", "delete success");
            }
        } else {
            response.put("issuccess", "false");
            response.put("message", "Data not exist ");
        }
        return response;
    }

    public List<Map<String, Object>> getLlmList() {
        List serviceList = ServiceDao.getModelList((String)ModelType.LLM.getValue());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(serviceList.size());
        for (Service service : serviceList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("number", service.getNumber());
            map.put("name", service.getName());
            map.put("active", !CollectionUtils.isEmpty((Collection)service.getInstances()));
            map.put("llmType", service.getLlmType());
            map.put("modelTags", JSON.toJSONString((Object)(service.getLlmModelInfo() != null ? service.getLlmModelInfo() : new ArrayList())));
            map.put("promptIdsTag", service.getPromptIdsTag());
            map.put("processIdsTag", service.getProcessIdsTag());
            map.put("agentIdsTag", service.getAgentIdsTag());
            if (StringUtils.isNotEmpty((String)service.getAgentIdsTag()) || StringUtils.isNotEmpty((String)service.getProcessIdsTag()) || StringUtils.isNotEmpty((String)service.getPromptIdsTag())) {
                map.put("limit", true);
            } else {
                map.put("limit", false);
            }
            result.add(map);
        }
        return result;
    }

    public Map<String, Object> getService(String serviceNumber) {
        return kd.ai.aicc.core.service.AiccService.queryLlmAiccService((String)serviceNumber);
    }

    public List<Map<String, Object>> getRerankList() {
        List serviceList = ServiceDao.getModelList((String)ModelType.RERANK.getValue());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(serviceList.size());
        for (Service service : serviceList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("number", service.getNumber());
            map.put("name", service.getName());
            map.put("active", !CollectionUtils.isEmpty((Collection)service.getInstances()));
            map.put("llmType", service.getLlmType());
            result.add(map);
        }
        return result;
    }

    public Map<String, String> getTaskRunningStatus(List<String> taskIds) {
        return null;
    }
}

