/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.util.StringUtils;

public class AWSAnthropicClaudeInstanceEditPlugin
extends AbstractFormPlugin {
    private static final String AWS_ANTHROPIC_CLAUDE_MESSAGES = "AWS_ANTHROPIC_CLAUDE_MESSAGES";
    private static final String KEY_SERVICE = "service";
    private static final String KEY_CONTEXTURL = "contexturl";
    private static final String URL_AWS_MODEL_ID_LIST = "https://docs.aws.amazon.com/zh_cn/bedrock/latest/userguide/model-ids.html#model-ids-arns";
    private static final String URL_AWS_SUPPORTED_MODEL = "https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters-anthropic-claude-messages.html#claude-messages-supported-models";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateFieldDisplayName();
    }

    private void updateFieldDisplayName() {
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            return;
        }
        Object service = this.getModel().getValue(KEY_SERVICE);
        String serviceNumber = "";
        if (service != null) {
            serviceNumber = ((DynamicObject)service).getString("number");
        }
        TextEdit textEdit = (TextEdit)this.getControl(KEY_CONTEXTURL);
        if (StringUtils.isNotEmpty((String)serviceNumber) && serviceNumber.equals(AWS_ANTHROPIC_CLAUDE_MESSAGES)) {
            textEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u5730\u5740(\u6a21\u578b ID)", (String)"AWSAnthropicClaudeInstanceEditPlugin_0", (String)"ai-aicc-plugin", (Object[])new Object[0])));
            Tips tips = new Tips();
            tips.setType("text");
            StringBuilder sbTips = new StringBuilder();
            sbTips.append(ResManager.loadKDString((String)"\u652f\u6301\u7684\u6a21\u578b\u5217\u8868\uff1a%s\n", (String)"AWSAnthropicClaudeInstanceEditPlugin_1", (String)"ai-aicc-plugin", (Object[])new Object[]{URL_AWS_SUPPORTED_MODEL}));
            sbTips.append(ResManager.loadKDString((String)"\u5177\u4f53\u7684\u6a21\u578bID\uff1a%s\n", (String)"AWSAnthropicClaudeInstanceEditPlugin_2", (String)"ai-aicc-plugin", (Object[])new Object[]{URL_AWS_MODEL_ID_LIST}));
            tips.setContent(new LocaleString(sbTips.toString()));
            textEdit.addTips(tips);
        } else {
            textEdit.setCaption(textEdit.getProperty().getDisplayName());
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e0a\u4e0b\u6587\u5730\u5740", (String)"AWSAnthropicClaudeInstanceEditPlugin_3", (String)"ai-aicc-plugin", (Object[])new Object[0])));
            textEdit.addTips(tips);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals(KEY_SERVICE)) {
            this.updateFieldDisplayName();
            this.getView().updateView();
        }
    }
}

