/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin;

import java.lang.constant.Constable;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.ai.aicc.plugin.common.DateUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AiccHomeServiveCountCardPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(AiccHomeServiveCountCardPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refresh"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            PointLineChart customchart = (PointLineChart)this.getControl("pointlinechartap");
            Date timeBefore30Day = DateUtil.getDateWithoutHour(DateUtil.getDateAdd(new Date(), 6, -29));
            QFilter[] qFilters30Day = new QFilter[]{new QFilter("createtime", ">=", (Object)timeBefore30Day)};
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"aicc_task_count", (String)"aicc_task", (String)"createtime", (QFilter[])qFilters30Day, null);
            DataSet dataSet2 = dataSet.executeSql("select TO_CHAR(createtime,'MM.dd') as day").groupBy(new String[]{"day"}).count("count").finish();
            Map<String, Double> map = this.parseMap(dataSet2);
            this.drawChart(customchart, map);
        }
        catch (ParseException var9) {
            log.error("parse error:", (Object)e);
        }
    }

    private Map<String, Double> parseMap(DataSet dataSet) {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        LocalDate now = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM.dd");
        for (int i = 29; i >= 0; --i) {
            String day = now.minusDays(i).format(formatter);
            if (map.containsKey(day)) continue;
            map.put(day, 0.0);
        }
        for (Row obj : dataSet) {
            map.put(obj.getString("day"), obj.getDouble("count"));
        }
        return map;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("refresh")) {
            this.afterCreateNewData(evt);
        }
    }

    private void drawChart(PointLineChart customchart, Map<String, Double> datas) {
        customchart.clearData();
        this.setHandlechartXaxisTick(customchart, datas);
        this.setHandleChartData(customchart, datas);
        customchart.setMargin(Position.right, "30px");
        customchart.setMargin(Position.top, "90px");
    }

    private void setHandlechartXaxisTick(PointLineChart customchart, Map<String, Double> datas) {
        ArrayList<String> xDimensions = new ArrayList<String>();
        Axis xAxis = customchart.createXAxis(ResManager.loadKDString((String)"\u65e5", (String)"AiccHomeServiveCountCardPlugin_0", (String)"ai-aicc-plugin", (Object[])new Object[0]), AxisType.category);
        Set<String> apiNames = datas.keySet();
        xDimensions.addAll(apiNames);
        if (xAxis != null) {
            xAxis.setCategorys(xDimensions);
            HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
            axisTick.put("interval", Integer.valueOf(0));
            axisTick.put("show", Boolean.FALSE);
            xAxis.setPropValue("axisTick", axisTick);
            this.setLineColor(xAxis, "#999999");
        }
    }

    private void setHandleChartData(PointLineChart customchart, Map<String, Double> datas) {
        Axis yAxis = customchart.createYAxis(ResManager.loadKDString((String)"\u6570\u91cf/\u6b21", (String)"AiccHomeServiveCountCardPlugin_1", (String)"ai-aicc-plugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisTick);
        LineSeries expireSeries = customchart.createSeries(ResManager.loadKDString((String)"API\u8c03\u7528\u603b\u6b21\u6570", (String)"AiccHomeServiveCountCardPlugin_2", (String)"ai-aicc-plugin", (Object[])new Object[0]));
        expireSeries.setItemColor("#2386EE");
        expireSeries.setData((Number[])datas.values().toArray(new Double[datas.size()]));
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(yAxis, "#999999");
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.setLegendVertical(false);
        int[] padding = new int[]{10, 100, 0, 0};
        customchart.setLegendPropValue("padding", (Object)padding);
        customchart.bindData(null);
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

