/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileNameUtils;

public class AiccRedirectPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static Log logger = LogFactory.getLog(AiccRedirectPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnok = (Button)this.getView().getControl("btnok");
        btnok.addClickListener((ClickListener)this);
        Button btnCancle = (Button)this.getView().getControl("btncancel");
        btnCancle.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String text = ResManager.loadKDString((String)"AI\u80fd\u529b\u4e2d\u5fc3\u5df2\u7ecf\u8fc1\u79fb\u81f3Agent\u5e73\u53f0-\u914d\u7f6e\u4e2d\u5fc3-\u6a21\u578b\u914d\u7f6e\u6a21\u5757\uff0c\n\u8bf7\u524d\u5f80\u8be5\u6a21\u5757\u4f7f\u7528\u3002", (String)"AiccRedirectPlugin_001", (String)"ai-aicc-plugin", (Object[])new Object[0]);
        this.getModel().setValue("textareafield", (Object)text);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String fullUrl = "";
        try (InputStream stream = AiccRedirectPlugin.class.getResourceAsStream("/pics/migrate1x.png");){
            if (stream != null) {
                String fullFileName = String.format("%s.%s", "migrate1x_" + System.currentTimeMillis(), "png");
                TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
                fullUrl = tfc.saveAsUrl(fullFileName, stream, 600);
            }
        }
        catch (IOException ex) {
            logger.error("\u8d44\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)ex);
        }
        Image image = (Image)this.getView().getControl("imageap");
        if (StringUtils.isNotEmpty((CharSequence)fullUrl)) {
            image.setUrl(fullUrl);
        }
    }

    private static String saveImageFile(String fileName, InputStream inputStream) {
        RequestContext context = RequestContext.get();
        String tenantId = context.getTenantId();
        String accountId = context.getAccountId();
        long pkid = DB.genLongId((String)"aicc_service_template");
        String path = FileNameUtils.getImageAttFileName((String)tenantId, (String)accountId, (String)"aicc_service_template", (Object)pkid, (String)fileName);
        FileService imageFileService = FileServiceFactory.getImageFileService();
        FileItem item = new FileItem(fileName, path, inputStream);
        return imageFileService.upload(item);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btnok": {
                this.getView().returnDataToParent((Object)"OK");
                break;
            }
            case "btncancel": {
                this.getView().returnDataToParent((Object)"cancel");
            }
        }
        this.getView().close();
    }
}

