/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.aicc.core.DeployMethod;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.domain.Config;
import kd.ai.aicc.plugin.common.AiccServiceDataHelper;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.New;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AiccServiceListPlugin
extends AbstractListPlugin {
    public void beforeBindData(EventObject e) {
        DeployMethod deployMethod = Utils.checkLicenseType();
        if (DeployMethod.PRIVATE_CLOUND == deployMethod || DeployMethod.PUBLIC_CLOUND_SERVER == deployMethod) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"syncservice"});
        }
        if (DeployMethod.PUBLIC_CLOUND_CLIENT == deployMethod) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbldel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblsubmit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblaudit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbldisable"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnnew"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnedit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"btndel"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "syncservice": {
                this.syncService();
                break;
            }
            case "setcentermodel": {
                this.setCenterModel();
                break;
            }
            case "tblnew": {
                this.newData();
            }
        }
    }

    private void newData() {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("aicc_template_alert");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setData"));
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        JSONObject jsonObject;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("setData".equals(actionId) && (jsonObject = JSON.parseObject((String)String.valueOf(closedCallBackEvent.getReturnData()))) != null && !jsonObject.isEmpty()) {
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setFormId("aicc_service");
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCustomParam("templateNo", (Object)jsonObject.getString("templateNo"));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof New) {
            args.setCancel(true);
        }
    }

    private void setCenterModel() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (primaryKeyValues.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AiccServiceListPlugin_5", (String)"ai-aicc-plugin", (Object[])new Object[0]));
            return;
        }
        long fid = (Long)primaryKeyValues[0];
        String getAiccServiceInfoSql = "select fnumber, fenable, fstatus, fname, fmodeltype from t_aicc_service where fid=? ";
        String[] aiccServiceInfos = (String[])DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)getAiccServiceInfoSql, (Object[])new Object[]{fid}, resultSet -> {
            String[] strings = new String[5];
            if (resultSet.next()) {
                strings[0] = resultSet.getString(1);
                strings[1] = resultSet.getString(2);
                strings[2] = resultSet.getString(3);
                strings[3] = resultSet.getString(4);
                strings[4] = resultSet.getString(5);
            }
            return strings;
        });
        if (this.checkAiccService(aiccServiceInfos, fid)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCenterService", (Object[])new Object[]{aiccServiceInfos[0]});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"AiccServiceListPlugin_8", (String)"ai-aicc-plugin", (Object[])new Object[0]));
    }

    private void syncService() {
        DeployMethod deployMethod = Utils.checkLicenseType();
        if (DeployMethod.PRIVATE_CLOUND == deployMethod) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u79c1\u6709\u4e91\u79df\u6237\u65e0\u9700\u540c\u6b65\u6a21\u578b\u670d\u52a1", (String)"AiccServiceListPlugin_0", (String)"ai-aicc-plugin", (Object[])new Object[0]));
            return;
        }
        if (DeployMethod.PUBLIC_CLOUND_SERVER == deployMethod) {
            this.getView().showMessage(ResManager.loadKDString((String)"sass\u670d\u52a1\u7aef\u65e0\u9700\u540c\u6b65\u6a21\u578b\u670d\u52a1", (String)"AiccServiceListPlugin_1", (String)"ai-aicc-plugin", (Object[])new Object[0]));
            return;
        }
        Config config = new Config();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"aicc_config", (String)"publiccloudserverurl,secretkey,usersecretkey", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C")});
        if (dynamicObjects.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5230\u9996\u9875\u8fdb\u884c\u521d\u59cb\u5316\u4fe1\u606f\u3002", (String)"AiccServiceListPlugin_2", (String)"ai-aicc-plugin", (Object[])new Object[0]));
            return;
        }
        config.setPublicCloudServerUrl(((DynamicObject)dynamicObjects.get(0)).getString("publiccloudserverurl"));
        config.setSecretKey(((DynamicObject)dynamicObjects.get(0)).getString("secretkey"));
        config.setProxyUserSecretKey(((DynamicObject)dynamicObjects.get(0)).getString("usersecretkey"));
        String url = "/kapi/v2/aicc/getAllService";
        HashMap body = new HashMap();
        String requestBodyStr = JSON.toJSONString(body);
        Map result = Utils.api2PostRequest((Config)config, (String)url, (String)requestBodyStr);
        if ("0".equals(result.get("errorCode"))) {
            AiccServiceDataHelper.SaveAiccService(result);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u6210\u529f", (String)"AiccServiceListPlugin_3", (String)"ai-aicc-plugin", (Object[])new Object[0]));
            ((IListView)this.getView()).refresh();
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0:", (String)"AiccServiceListPlugin_4", (String)"ai-aicc-plugin", (Object[])new Object[0]) + result.get("message"));
        }
    }

    private boolean checkAiccService(String[] aiccServiceInfos, long fid) {
        if (!StringUtils.equals((CharSequence)aiccServiceInfos[4], (CharSequence)"LLM")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u6a21\u578b\u7c7b\u578b\u4e3a\u201cLLM\u201d\u7684\u6a21\u578b\u670d\u52a1\u3002", (String)"AiccServiceListPlugin_8", (String)"ai-aicc-plugin", (Object[])new Object[0]));
            return true;
        }
        if (!StringUtils.equals((CharSequence)aiccServiceInfos[1], (CharSequence)"1")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u201d\u53ef\u7528\u201c\u7684\u6a21\u578b\u670d\u52a1\u3002", (String)"AiccServiceListPlugin_6", (String)"ai-aicc-plugin", (Object[])new Object[0]));
            return true;
        }
        String getServiceInstanceCountSql = "select count(1) from t_aicc_instance where fserviceid =? and fstatus = 'C' and fenable='1'";
        int instanceServiceCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)getServiceInstanceCountSql, (Object[])new Object[]{fid}, resultSet -> {
            resultSet.next();
            return resultSet.getInt(1);
        });
        if (instanceServiceCount < 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u6a21\u578b\u670d\u52a1\u672a\u914d\u7f6e\u670d\u52a1\u5b9e\u4f8b\u6216\u670d\u52a1\u5b9e\u4f8b\u4e0d\u53ef\u7528\uff0c\u8bf7\u524d\u5f80\u3010Agent\u5e73\u53f0\u3011-\u3010\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u6a21\u578b\u670d\u52a1\u3011\u4e2d\u8fdb\u884c\u68c0\u67e5\u3002", (String)"AiccServiceListPlugin_7", (String)"ai-aicc-plugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        if (formOperate.getOperateKey().equals("audit") || formOperate.getOperateKey().equals("unaudit")) {
            List successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"aicc_service");
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)mainEntityType);
            if (formOperate.getOperateKey().equals("audit")) {
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    dynamicObjects[i].set("enable", (Object)1);
                }
            } else {
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    dynamicObjects[i].set("enable", (Object)0);
                }
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }
}

