/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.aicc.core.domain.ServiceTemplateFilterVO;
import kd.ai.aicc.core.domain.ServiceTemplateRespVO;
import kd.ai.aicc.core.domain.enuz.ModelAbilityEnum;
import kd.ai.aicc.core.domain.enuz.ServiceTempSupEnum;
import kd.ai.aicc.core.domain.enuz.TemplateModelTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class AiccServiceTemplatePlugin
extends AbstractFormPlugin {
    private Log logger = LogFactory.getLog(AiccServiceTemplatePlugin.class);
    private static final String KEY_CONTROL = "customcontrolap";

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        if (key.equals(KEY_CONTROL)) {
            switch (eventName) {
                case "getTemplateList": {
                    this.getTemplateListFilterByParam(eventName, eventArgs);
                    break;
                }
                case "createByTemplate": {
                    this.createByTemplate(eventName, eventArgs);
                    break;
                }
            }
        }
    }

    private void createByTemplate(String eventName, String eventArgs) {
        String templateNo = "";
        if (StringUtils.isNotEmpty((String)eventArgs)) {
            JSONObject jsonObject = JSON.parseObject((String)eventArgs);
            templateNo = jsonObject.getString("templateNo");
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("templateNo", templateNo);
        this.getView().returnDataToParent((Object)JSON.toJSONString(retMap));
        this.getView().close();
    }

    private void getTemplateListFilterByParam(String eventName, String eventArgs) {
        ServiceTemplateFilterVO vo = null;
        if (StringUtils.isNotEmpty((String)eventArgs)) {
            vo = (ServiceTemplateFilterVO)JSON.parseObject((String)eventArgs, ServiceTemplateFilterVO.class);
        }
        this.logger.info("\u5165\u53c2\uff1a{}", (Object)eventArgs);
        QFilter[] filters = this.buildFilterArr(vo);
        DynamicObject[] templateObj = this.getTemplateObjs(filters);
        this.retResult(templateObj, eventName, this.isEmpty(vo));
    }

    private boolean isEmpty(ServiceTemplateFilterVO vo) {
        if (vo == null) {
            return true;
        }
        String modelType = vo.getModelType();
        String supplierKey = vo.getSupplierKey();
        String modelAbility = vo.getModelAbility();
        String contextLength = vo.getContextLength();
        return StringUtils.isEmpty((String)modelType) && StringUtils.isEmpty((String)supplierKey) && StringUtils.isEmpty((String)modelAbility) && StringUtils.isEmpty((String)contextLength);
    }

    private DynamicObject[] getTemplateObjs(QFilter[] filters) {
        String properties = "id,billno,billstatus,modeltype,supplier,context,customcontext,abilitytag,modelname,modeldesc,modelseqno";
        return BusinessDataServiceHelper.load((String)"aicc_service_template", (String)properties, (QFilter[])filters, (String)"modelseqno asc");
    }

    private void retResult(DynamicObject[] templateObj, String key, boolean retDetailValues) {
        Map<String, Object> map = this.buildDetailValues(retDetailValues);
        List<Object> dataList = new ArrayList();
        if (templateObj == null || templateObj.length < 1) {
            map.put("dataList", dataList);
            this.sendCustom(key, map);
            return;
        }
        dataList = this.buildDatas(templateObj);
        map.put("dataList", dataList);
        this.sendCustom(key, map);
    }

    private List<ServiceTemplateRespVO> buildDatas(DynamicObject[] templateObj) {
        ArrayList<ServiceTemplateRespVO> list = new ArrayList<ServiceTemplateRespVO>(16);
        for (DynamicObject obj : templateObj) {
            String billno = obj.getString("billno");
            String modeltype = obj.getString("modeltype");
            String supplier = obj.getString("supplier");
            String context = obj.getString("context");
            String customcontext = obj.getString("customcontext");
            String abilitytag = obj.getString("abilitytag");
            String modelname = obj.getString("modelname");
            String modeldesc = obj.getString("modeldesc");
            ServiceTemplateRespVO vo = new ServiceTemplateRespVO();
            vo.setTemplateNo(billno);
            vo.setModelType(TemplateModelTypeEnum.getTypeName((String)modeltype));
            vo.setModelAbility(this.getModelAbility(abilitytag));
            if ("-1".equals(context)) {
                vo.setContextLength(customcontext + "k");
            } else {
                vo.setContextLength(context);
            }
            vo.setModelName(modelname);
            vo.setSupplierKey(supplier);
            vo.setSupplierName(ServiceTempSupEnum.getSpName((String)supplier));
            vo.setModelDesc(modeldesc);
            list.add(vo);
        }
        return list;
    }

    private String getModelAbility(String abilitytag) {
        if (StringUtils.isNotEmpty((String)abilitytag)) {
            return ModelAbilityEnum.getModelAbilityNameByKey((String)abilitytag);
        }
        return "";
    }

    private Map<String, Object> buildDetailValues(boolean retDetailValues) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (!retDetailValues) {
            return map;
        }
        ArrayList modelTypeList = new ArrayList(16);
        for (TemplateModelTypeEnum modelType : TemplateModelTypeEnum.values()) {
            HashMap<String, String> modelTypeMap = new HashMap<String, String>(16);
            modelTypeMap.put("k", modelType.getTypeKey());
            modelTypeMap.put("v", modelType.getTypeName());
            modelTypeList.add(modelTypeMap);
        }
        map.put("modelType", modelTypeList);
        ArrayList abilityList = new ArrayList(16);
        map.put("modelAbility", abilityList);
        for (ModelAbilityEnum value : ModelAbilityEnum.values()) {
            HashMap<String, String> modelAbilityMap = new HashMap<String, String>(16);
            modelAbilityMap.put("k", value.getAbilityKey());
            modelAbilityMap.put("v", value.getAbilityName());
            abilityList.add(modelAbilityMap);
        }
        List<String> list = Arrays.asList("lte4k,8k,16k,32k,64k,128k,gte256k".split(","));
        map.put("contextLength", list);
        ArrayList supplierList = new ArrayList(16);
        List collect = Arrays.stream(ServiceTempSupEnum.values()).sorted(Comparator.comparingInt(ServiceTempSupEnum::getIndex)).collect(Collectors.toList());
        for (ServiceTempSupEnum value : collect) {
            HashMap<String, String> supplierMap = new HashMap<String, String>();
            supplierMap.put("k", value.getSupplierKey());
            supplierMap.put("name", value.getSupplierName());
            supplierList.add(supplierMap);
        }
        map.put("supplierList", supplierList);
        return map;
    }

    private void sendCustom(String key, Map<String, Object> resp) {
        CustomControl ctrl = (CustomControl)this.getControl(KEY_CONTROL);
        if (ctrl != null) {
            HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
            if (resp != null) {
                resp.put("timestamp", System.currentTimeMillis());
            }
            resultMap.put(key, resp);
            ctrl.setData(resultMap);
        }
    }

    private QFilter[] buildFilterArr(ServiceTemplateFilterVO vo) {
        String[] split;
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        if (this.isEmpty(vo)) {
            return new QFilter[]{billStatusFilter};
        }
        String modelType = vo.getModelType();
        String contextLength = vo.getContextLength();
        String modelAbility = vo.getModelAbility();
        String supplierKey = vo.getSupplierKey();
        QFilter modelTypeFilter = null;
        if (StringUtils.isNotEmpty((String)modelType)) {
            modelType = modelType.replace("\uff0c", ",");
            String[] split2 = modelType.split(",");
            modelTypeFilter = new QFilter("modeltype", "in", (Object)split2);
        }
        QFilter abilityFilter = null;
        if (StringUtils.isNotEmpty((String)modelAbility) && (split = (modelAbility = modelAbility.replace("\uff0c", ",")).split(",")).length > 0) {
            abilityFilter = QFilter.ftlike((String[])split, (String[])new String[]{"abilitytag"});
        }
        QFilter contextLenFilter = null;
        if (StringUtils.isNotEmpty((String)contextLength)) {
            contextLength = contextLength.replace("\uff0c", ",");
            String[] split3 = contextLength.split(",");
            ArrayList<String> list = new ArrayList<String>(16);
            QFilter filter = null;
            boolean queryLargeContext = false;
            for (String str : split3) {
                if ("lte4k,8k,16k,32k,64k,128k".contains(str)) {
                    list.add(str);
                }
                if (!"gte256k".equals(str)) continue;
                list.add("256k");
                queryLargeContext = true;
            }
            if (!list.isEmpty()) {
                filter = new QFilter("context", "in", (Object)list.toArray(new String[0]));
            }
            QFilter largeFilter = new QFilter("customcontext", ">=", (Object)256);
            contextLenFilter = filter != null && queryLargeContext ? filter.or(largeFilter) : (filter != null ? filter : largeFilter);
        }
        QFilter supplierFilter = null;
        if (StringUtils.isNotEmpty((String)supplierKey)) {
            QFilter filter = new QFilter("supplier", "=", (Object)supplierKey);
            QFilter orFilter = null;
            if (supplierKey.equals(ServiceTempSupEnum.DEEPSEEK.getSupplierKey())) {
                QFilter modelNameFilter = new QFilter("modelname", "like", (Object)"%DeepSeek%");
                QFilter qFilter = new QFilter("modelname", "like", (Object)"%Deepseek%");
                orFilter = filter.or(modelNameFilter).or(qFilter);
            }
            supplierFilter = orFilter == null ? filter : orFilter;
        }
        QFilter and = billStatusFilter;
        if (modelTypeFilter != null) {
            and = billStatusFilter.and(modelTypeFilter);
        }
        if (abilityFilter != null) {
            and.and(abilityFilter);
        }
        if (contextLenFilter != null) {
            and.and(contextLenFilter);
        }
        if (supplierFilter != null) {
            and.and(supplierFilter);
        }
        return new QFilter[]{and};
    }
}

