/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.ai.aicc.core.Authorization;
import kd.ai.aicc.core.AuthorizationType;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.Executor;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.XfWebSocketTestRunner;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.AiccResult;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Task;
import kd.ai.aicc.core.domain.enuz.ModelAbilityEnum;
import kd.ai.aicc.core.domain.enuz.ModelType;
import kd.ai.aicc.core.domain.enuz.ServiceToNumberEnum;
import kd.ai.aicc.core.util.EngineCacheUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class ServiceEditPlugin
extends AbstractBillPlugIn {
    private static String modelTypeControl = "modeltype";
    private static String llmTypeControl = "llmtype";
    private static String SERVICE_ENTITY = "aicc_service";
    private static final String BTN_OPEN = "buttonap1";
    private static final String BTN_CLOSE = "buttonap3";
    private static final String CUSTOM_CONFIG = "labelap2";
    private Log logger = LogFactory.getLog(ServiceEditPlugin.class);
    private static final String KEY_ENTRY = "entryentity";

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter;
        Object templateNoObj;
        ComboEdit modelTypeCombo = (ComboEdit)this.getView().getControl(modelTypeControl);
        if (modelTypeCombo != null) {
            modelTypeCombo.setComboItems(ServiceEditPlugin.createModelTypeComboItem());
        }
        if ((templateNoObj = (formShowParameter = this.getView().getFormShowParameter()).getCustomParam("templateNo")) != null && StringUtils.isNotEmpty((CharSequence)templateNoObj.toString())) {
            this.updateModelData(this.getTemplateObj(templateNoObj.toString()));
        }
    }

    public void beforeBindData(EventObject e) {
        Object typeObject;
        String formId = this.getView().getFormShowParameter().getFormId();
        if (formId.equals(SERVICE_ENTITY) && (typeObject = this.getModel().getValue("modeltype")) != null && StringUtils.isNotEmpty((CharSequence)typeObject.toString())) {
            Object contextValue;
            ModelType modelType = ModelType.getModel((String)typeObject.toString());
            if (modelType != null) {
                switch (modelType) {
                    case LLM: {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"chunktoken"});
                        break;
                    }
                    case EMBEDDING: {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"limitconfig"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"contexttoken"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"customtoken"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{llmTypeControl});
                        break;
                    }
                    case RERANK: {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"limitconfig"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"contexttoken"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"chunktoken"});
                        break;
                    }
                    case AUDIO: {
                        this.doAudioChange();
                        break;
                    }
                    default: {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"customtoken"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
                    }
                }
            }
            if ((contextValue = this.getModel().getValue("contexttoken")) != null && contextValue.equals("-1")) {
                int customToken = (Integer)this.getModel().getValue("customtoken");
                this.getModel().setValue("customtoken", (Object)(customToken / 1024));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"customtoken"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"labelap"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"customtoken"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
            }
            String status = (String)this.getModel().getValue("enable");
            this.getModel().setValue("tablestatus", (Object)status);
            DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY);
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject object = (DynamicObject)rows.get(i);
                object.set("num", (Object)(i + 1));
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void updateModelData(DynamicObject templateObj) {
        DynamicObjectCollection entryEntity;
        String serviceNumber;
        String modeltype = templateObj.getString("modeltype");
        String supplier = templateObj.getString("supplier");
        String context = templateObj.getString("context");
        int customcontext = templateObj.getInt("customcontext");
        String abilitytag = templateObj.getString("abilitytag");
        String modelname = templateObj.getString("modelname");
        DynamicObject basellm = templateObj.getDynamicObject("basellm");
        String modelStr = templateObj.getString("model");
        String clientid = templateObj.getString("clientid");
        String url = templateObj.getString("url");
        String authurl = templateObj.getString("authurl");
        long embmaxlen = templateObj.getLong("embmaxlen");
        String authtype = templateObj.getString("authtype");
        IDataModel model = this.getModel();
        model.setValue("name", (Object)modelname);
        model.setValue("version", (Object)"1.0");
        model.setValue("enable", (Object)true);
        model.setValue("status", (Object)"A");
        model.setValue("supportstream", (Object)true);
        model.setValue("tablestatus", (Object)true);
        if (StringUtils.isNotEmpty((CharSequence)modelname) && StringUtils.isNotEmpty((CharSequence)(serviceNumber = ServiceToNumberEnum.getServiceNumberByName((String)modelname)))) {
            model.setValue("number", (Object)serviceNumber);
        }
        if (StringUtils.isNotEmpty((CharSequence)modeltype)) {
            model.setValue("modeltype", (Object)ModelType.getModel((String)modeltype).getValue());
        }
        if (basellm != null) {
            model.setValue("llmtype", basellm.getPkValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)supplier)) {
            model.setValue("modelowner", (Object)supplier);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)context)) {
            model.setValue("contexttoken", (Object)this.getContxtSize(context));
            if ("-1".equals(context)) {
                model.setValue("customtoken", (Object)customcontext);
            }
        }
        if (embmaxlen > 0L) {
            model.setValue("chunktoken", (Object)embmaxlen);
        }
        if (StringUtils.isNotEmpty((CharSequence)abilitytag)) {
            model.setValue("servicetag", (Object)ModelAbilityEnum.getModelValueByAbilityKey((String)abilitytag));
        }
        if (StringUtils.isNotEmpty((CharSequence)modelStr)) {
            model.setValue("configmodel", (Object)modelStr);
        }
        if ((entryEntity = model.getEntryEntity(KEY_ENTRY)) != null && entryEntity.isEmpty()) {
            model.batchCreateNewEntryRow(KEY_ENTRY, 1);
            model.setValue("num", (Object)1, 0);
            model.setValue("paralleltype", (Object)"QPS", 0);
            model.setValue("maxparallel", (Object)10, 0);
            model.setValue("modelurl", (Object)url, 0);
            model.setValue("authtype", (Object)authtype, 0);
            model.setValue("authurl", (Object)authurl, 0);
            model.setValue("instancedesc", (Object)"", 0);
            model.setValue("clientid", (Object)clientid, 0);
        }
    }

    private String getContxtSize(String context) {
        String result = "";
        switch (context) {
            case "lte4k": {
                result = "4096";
                break;
            }
            case "8k": {
                result = "8192";
                break;
            }
            case "16k": {
                result = "16384";
                break;
            }
            case "32k": {
                result = "32768";
                break;
            }
            case "64k": {
                result = "65536";
                break;
            }
            case "128k": {
                result = "131072";
                break;
            }
            case "256k": {
                result = "262144";
                break;
            }
            case "-1": {
                result = "-1";
            }
        }
        return result;
    }

    private DynamicObject getTemplateObj(String templateNo) {
        QFilter qFilter = new QFilter("billno", "=", (Object)templateNo);
        String properties = "id,billno,billstatus,modeltype,supplier,context,customcontext,abilitytag,modelname,modeldesc,url,authurl,authtype,basellm,model,embmaxlen,clientid";
        return BusinessDataServiceHelper.loadSingle((String)"aicc_service_template", (String)properties, (QFilter[])new QFilter[]{qFilter});
    }

    public static List<ComboItem> createModelTypeComboItem() {
        ModelType[] modelTypes = ModelType.values();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(modelTypes.length);
        int i = 0;
        for (ModelType modelType : modelTypes) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(modelType.getName()));
            comboItem.setValue(modelType.getValue());
            comboItem.setId(i + "");
            list.add(comboItem);
            ++i;
        }
        return list;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getChangeSet()[0].getNewValue() != null) {
            String propertyValue = e.getChangeSet()[0].getNewValue().toString();
            if (e.getProperty().getName().equals(modelTypeControl)) {
                this.doModelTypeChange(propertyValue);
            }
            if (e.getProperty().getName().equals("contexttoken")) {
                if (propertyValue.equals("-1")) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"customtoken"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"labelap"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"customtoken"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
                }
            }
        }
    }

    private void doModelTypeChange(String propertyValue) {
        ComboEdit modelTypeCombo = (ComboEdit)this.getView().getControl("modelowner");
        modelTypeCombo.setMustInput(false);
        if (propertyValue.equals(ModelType.LLM.getValue())) {
            this.doLLMModelChage();
        } else if (propertyValue.equals(ModelType.RERANK.getValue())) {
            this.doRerankModelChange();
        } else if (propertyValue.equals(ModelType.EMBEDDING.getValue())) {
            this.doEMBModelChange();
        } else if (propertyValue.equals(ModelType.AUDIO.getValue())) {
            this.doAudioChange();
        }
    }

    private void doAudioChange() {
        ComboEdit modelTypeCombo = (ComboEdit)this.getView().getControl("modelowner");
        modelTypeCombo.setMustInput(true);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"limitconfig", "contexttoken", "customtoken", "labelap", "chunktoken", "servicetag", llmTypeControl, "paralleltype", "maxparallel"});
    }

    private void doEMBModelChange() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"limitconfig"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"contexttoken"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"customtoken"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"chunktoken"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{llmTypeControl});
        this.getModel().setValue("supportstream", (Object)0);
    }

    private void doRerankModelChange() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{llmTypeControl});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"limitconfig"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"contexttoken"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"customtoken"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"chunktoken"});
    }

    private void doLLMModelChage() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{llmTypeControl});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"contexttoken"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"limitconfig"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"chunktoken"});
        this.getModel().setValue("supportstream", (Object)1);
        String contextToken = (String)this.getModel().getValue("CONTEXTTOKEN");
        if (contextToken == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"customtoken"});
        } else if (contextToken.equals("-1")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"labelap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"customtoken"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"customtoken"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            IDataModel iDataModel = this.getView().getModel();
            String type = (String)iDataModel.getValue("paralleltype");
            if (type != null) {
                int maxParallel = (Integer)iDataModel.getValue("maxparallel");
                switch (type) {
                    case "QPS": {
                        if (maxParallel <= 1000) break;
                        String message = "QPS\u7b56\u7565\u6700\u5927\u5e76\u53d1\u6570\u8d85\u51fa1000\u9650\u5236";
                        this.getView().showTipNotification(message);
                        args.setCancelMessage(message);
                        args.setCancel(true);
                        break;
                    }
                    case "RPM": {
                        if (maxParallel <= 60000) break;
                        String message = "RPM\u7b56\u7565\u6700\u5927\u5e76\u53d1\u6570\u8d85\u51fa60000\u9650\u5236";
                        this.getView().showTipNotification(message);
                        args.setCancelMessage(message);
                        args.setCancel(true);
                    }
                }
            }
            int customToken = (Integer)iDataModel.getValue("customtoken") * 1024;
            iDataModel.setValue("customtoken", (Object)customToken);
            boolean tableStatus = (Boolean)this.getModel().getValue("tablestatus");
            this.getModel().setValue("enable", (Object)(!tableStatus ? "0" : "1"));
            long serviceId = (Long)this.getModel().getValue("id");
            this.logger.info("save serviceId:{}", (Object)serviceId);
            if (serviceId == 0L) {
                serviceId = DB.genLongId((String)SERVICE_ENTITY);
                this.getModel().setValue("id", (Object)serviceId);
                String number = (String)this.getModel().getValue("number");
                this.logger.info("save number:{}", (Object)number);
                if (!number.equals("Algo_\u968f\u673a\u7801")) {
                    Iterator qFilter = new QFilter("number", "=", (Object)number);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)SERVICE_ENTITY, (QFilter[])new QFilter[]{qFilter});
                    if (dynamicObject != null) {
                        String msg = String.format("\u201c\u670d\u52a1\u7f16\u7801\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c", number);
                        throw new KDBizException(msg);
                    }
                    IAppCache appCache = CacheHelper.getAppCache();
                    appCache.put("aicc_service_save_" + serviceId, (Object)number);
                }
            }
            DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY);
            for (DynamicObject rowObject : rows) {
                rowObject.set("service_id", (Object)serviceId);
                rowObject.set("modifydatefield", (Object)new Timestamp(System.currentTimeMillis()));
                rowObject.set("instancestatus", (Object)"C");
                String clientId = (String)rowObject.get("clientid");
                String secretKey = (String)rowObject.get("secretkey");
                String userSecretKey = (String)rowObject.get("usersecretkey");
                if (StringUtils.isNotEmpty((CharSequence)clientId) && !Encrypters.isEncrypted((String)clientId)) {
                    rowObject.set("clientid", (Object)Encrypters.encode((String)clientId));
                }
                if (StringUtils.isNotEmpty((CharSequence)secretKey) && !Encrypters.isEncrypted((String)secretKey)) {
                    rowObject.set("secretkey", (Object)Encrypters.encode((String)secretKey));
                }
                if (!StringUtils.isNotEmpty((CharSequence)userSecretKey) || Encrypters.isEncrypted((String)userSecretKey)) continue;
                rowObject.set("usersecretkey", (Object)Encrypters.encode((String)userSecretKey));
            }
            this.paramCheck();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)SERVICE_ENTITY);
            DataEntityCacheManager cacheManager = new DataEntityCacheManager((IDataEntityType)entityType);
            cacheManager.removeByDt();
            MainEntityType instanceEntityType = EntityMetadataCache.getDataEntityType((String)"aicc_instance");
            DataEntityCacheManager instanceCacheManager = new DataEntityCacheManager((IDataEntityType)instanceEntityType);
            instanceCacheManager.removeByDt();
        }
        if (args.getSource() instanceof Donothing) {
            String operate;
            Donothing donothing = (Donothing)args.getSource();
            switch (operate = donothing.getOperateKey()) {
                case "connecttest": {
                    DynamicObject currentService = this.getModel().getDataEntity();
                    String modelType = currentService.getString(modelTypeControl);
                    if (modelType.equals("EMBEDDING") || modelType.equals("DOC_PARSE") || modelType.equals("AUDIO")) {
                        this.getView().showTipNotification("\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u578b\u7c7b\u578b\u6d4b\u8bd5");
                        throw new KDBizException("\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u578b\u7c7b\u578b\u6d4b\u8bd5");
                    }
                    long llmId = currentService.getLong("llmtype.id");
                    DynamicObject llmObject = BusinessDataServiceHelper.loadSingle((Object)llmId, (String)"aicc_llm");
                    String connectParam = llmObject.getString("testparams");
                    Map bodyMap = (Map)JSON.parseObject((String)connectParam, Map.class);
                    String serviceModelConfig = (String)this.getModel().getValue("configmodel");
                    EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRY);
                    int[] selectRows = entryGrid.getSelectRows();
                    DynamicObjectCollection entity = this.getModel().getEntryEntity(KEY_ENTRY);
                    if (selectRows == null || selectRows.length <= 0) break;
                    for (int selectRow : selectRows) {
                        DynamicObject dynamicObject = (DynamicObject)entity.get(selectRow);
                        Instance instance = this.buildInstance(dynamicObject);
                        String customParam = (String)dynamicObject.get("customparam");
                        if (StringUtils.isNotEmpty((CharSequence)customParam)) {
                            Map customParamMap = (Map)JSON.parseObject((String)customParam, Map.class);
                            for (Map.Entry entry : customParamMap.entrySet()) {
                                String key = (String)entry.getKey();
                                Object value = entry.getValue();
                                if (bodyMap.containsKey(key)) continue;
                                bodyMap.put(key, value);
                            }
                        }
                        if (bodyMap.get("model") == null && StringUtils.isNotEmpty((CharSequence)serviceModelConfig)) {
                            bodyMap.put("model", serviceModelConfig);
                        }
                        this.connectSample(instance, JSON.toJSONString((Object)bodyMap));
                    }
                    break;
                }
            }
        }
    }

    public void paramCheck() {
        String authUrl;
        DynamicObject llmType;
        String modelType = (String)this.getModel().getValue(modelTypeControl);
        if (!modelType.equals("LLM")) {
            this.getModel().setValue("contexttoken", (Object)Character.valueOf('0'));
        }
        if (!modelType.equals("EMBEDDING") && !modelType.equals(ModelType.AUDIO.getValue()) && (llmType = (DynamicObject)this.getModel().getValue(llmTypeControl)) == null) {
            this.getView().showTipNotification("\u8bf7\u586b\u5199API\u51fa\u5165\u53c2\u6837\u5f0f");
            throw new KDBizException("\u8bf7\u586b\u5199API\u51fa\u5165\u53c2\u6837\u5f0f");
        }
        String authType = (String)this.getModel().getValue("authtype");
        if (authType != null && (authType.equals("BAIDU") || authType.equals("XMINDAI")) && StringUtils.isEmpty((CharSequence)(authUrl = (String)this.getModel().getValue("authurl")))) {
            this.getView().showTipNotification("\u8bf7\u586b\u5199\u8ba4\u8bc1URL\u5730\u5740");
            throw new KDBizException("\u8bf7\u586b\u5199\u8ba4\u8bc1URL\u5730\u5740");
        }
        String customParams = (String)this.getModel().getValue("customparam");
        String customHeader = (String)this.getModel().getValue("customheader");
        try {
            JSONObject jSONObject = JSON.parseObject((String)customParams);
        }
        catch (Exception e) {
            throw new KDBizException("\u8bf7\u6c42\u4f53body\u5b57\u6bb5\u89e3\u6790\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7b26\u5408JSON\u89c4\u8303\u3002");
        }
        try {
            JSONObject e = JSON.parseObject((String)customHeader);
        }
        catch (Exception e) {
            throw new KDBizException("\u8bf7\u6c42\u5934header\u5b57\u6bb5\u89e3\u6790\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7b26\u5408JSON\u89c4\u8303\u3002");
        }
    }

    private Instance buildInstance(DynamicObject dynamicObject) {
        String authtype = dynamicObject.getString("authtype");
        String modelurl = dynamicObject.getString("modelurl");
        String authurl = dynamicObject.getString("authurl");
        String clientid = dynamicObject.getString("clientid");
        String secretkey = dynamicObject.getString("secretkey");
        String usersecretkey = dynamicObject.getString("usersecretkey");
        String paralleltype = dynamicObject.getString("paralleltype");
        String maxparallel = dynamicObject.getString("maxparallel");
        Instance instance = new Instance();
        instance.setAuthType(AuthorizationType.parse((String)authtype));
        instance.setModelUrl(modelurl);
        instance.setAuthUrl(authurl);
        if (StringUtils.isNotEmpty((CharSequence)clientid)) {
            instance.setClientId(Encrypters.decode((String)clientid));
        }
        if (StringUtils.isNotEmpty((CharSequence)secretkey)) {
            instance.setSecretKey(Encrypters.decode((String)secretkey));
        }
        if (StringUtils.isNotEmpty((CharSequence)usersecretkey)) {
            instance.setProxyUserSecretKey(Encrypters.decode((String)usersecretkey));
        }
        instance.setParallelType(paralleltype);
        instance.setMaxParallel(Integer.parseInt(maxparallel));
        return instance;
    }

    private void connectSample(Instance instance, String params) {
        boolean wsReq = false;
        Task task = new Task();
        task.setId(TaskDao.genTaskID());
        task.setStream(true);
        String modelUrl = instance.getModelUrl();
        if (StringUtils.isNotEmpty((CharSequence)modelUrl) && (modelUrl.startsWith("wss") || modelUrl.startsWith("ws"))) {
            wsReq = true;
            params = this.buildParams(params);
        }
        task.setRequestBody(params);
        try {
            if (!wsReq) {
                this.reqByHttp(instance, task);
            } else {
                this.reqByWS(instance, task);
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification("\u6d4b\u8bd5\u5931\u8d25\uff1a" + e.getMessage());
            throw new KDBizException("\u6d4b\u8bd5\u5931\u8d25\uff1a\u6784\u9020httpPost\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    private void reqByWS(Instance instance, Task task) {
        this.logger.info("\u5f00\u59cbws\u6d4b\u8bd5\u8bf7\u6c42\u3002\u3002\u3002");
        XfWebSocketTestRunner xfWebSocketRunner = new XfWebSocketTestRunner();
        Executor.TaskRunner runner = new Executor.TaskRunner(task, instance);
        xfWebSocketRunner.run(runner);
        LocalMemoryCache localCache = EngineCacheUtil.getLocalCache((String)"aicc");
        String wsTag = "wsTest_" + task.getId();
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l <= 300000L) {
            JSONObject jsonObject;
            String result;
            Object o = localCache.get(wsTag);
            if (o == null || (result = (jsonObject = JSON.parseObject((String)o.toString())).getString("result")) == null) continue;
            if (result.equals("success")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d4b\u8bd5\u6210\u529f\uff0c\u8fde\u63a5\u6b63\u5e38\u3002", (String)"ServiceEditPlugin_001", (String)"ai-aicc-plugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)String.format("\u6d4b\u8bd5\u5931\u8d25\uff1a%s", jsonObject.getString("errMsg")), (String)"ServiceEditPlugin_002", (String)"ai-aicc-plugin", (Object[])new Object[0]));
            return;
        }
        localCache.remove(new String[]{wsTag});
    }

    private void reqByHttp(Instance instance, Task task) {
        HttpPost httpPost = Authorization.createPost((Instance)instance, (Task)task);
        RequestContext context = RequestContext.get();
        String traceId = Strings.isNullOrEmpty((String)context.getTraceId()) ? UUID.randomUUID().toString() : context.getTraceId();
        httpPost.addHeader("X-Request-Id", traceId);
        AiccResult result = new AiccResult();
        try (CloseableHttpResponse httpResponse = Utils.getClient().execute((HttpUriRequest)httpPost);){
            this.logger.info("execute test task : {}  response", (Object)task.getId());
            int errCode = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            if (errCode == 200) {
                result.setErrorCode(String.valueOf(0));
                this.getView().showSuccessNotification("\u6d4b\u8bd5\u6210\u529f");
            } else {
                String resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                result.setErrorCode(String.valueOf(errCode));
                result.setMessage(resp);
                this.getView().showTipNotification("\u6d4b\u8bd5\u5931\u8d25\uff1a" + resp);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage() + "," + httpPost.getURI().toString(), (Throwable)e);
            ErrorCode errorCode = Constant.httpError((String)instance.getHost(), (String)e.getMessage());
            result.setErrorCode(errorCode.getCode());
            result.setMessage(errorCode.getMessage());
            this.getView().showTipNotification("\u6d4b\u8bd5\u5931\u8d25\uff1a" + errorCode.getMessage());
        }
    }

    private String buildParams(String params) {
        JSONObject jsonObject;
        if (StringUtils.isNotEmpty((CharSequence)params) && (jsonObject = JSON.parseObject((String)params)) != null) {
            String model = jsonObject.getString("model");
            HashMap<String, Object> parameter = new HashMap<String, Object>();
            parameter.put("domain", model);
            parameter.put("temperature", 0.5);
            HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>();
            map.put("chat", parameter);
            jsonObject.put("parameter", map);
            return jsonObject.toJSONString();
        }
        return params;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObject object;
        int i;
        int size;
        DynamicObjectCollection rows;
        if (afterDoOperationEventArgs.getSource() instanceof NewEntry) {
            rows = this.getModel().getEntryEntity(KEY_ENTRY);
            size = rows.size();
            for (i = 0; i < size; ++i) {
                object = (DynamicObject)rows.get(i);
                object.set("num", (Object)(i + 1));
                this.getView().updateView("num", i);
            }
        }
        if (afterDoOperationEventArgs.getSource() instanceof DeleteEntry) {
            rows = this.getModel().getEntryEntity(KEY_ENTRY);
            size = rows.size();
            for (i = 0; i < size; ++i) {
                object = (DynamicObject)rows.get(i);
                object.set("num", (Object)(i + 1));
                this.getView().updateView("num", i);
            }
        }
        if (afterDoOperationEventArgs.getSource() instanceof Save) {
            int customToken = (Integer)this.getModel().getValue("customtoken");
            this.getModel().setValue("customtoken", (Object)(customToken / 1024));
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            String serviceId = dynamicObject.getString("id");
            IAppCache appCache = CacheHelper.getAppCache();
            String serviceNumber = (String)appCache.get("aicc_service_save_" + serviceId, String.class);
            if (serviceNumber != null) {
                dynamicObject.set("number", (Object)serviceNumber);
                this.getModel().setValue("number", (Object)serviceNumber);
                this.getView().updateView("number");
                OperationResult result = SaveServiceHelper.saveOperate((String)SERVICE_ENTITY, (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
                boolean success = result.isSuccess();
                if (success) {
                    appCache.remove("aicc_service_save_" + serviceId);
                }
            }
        }
    }
}

