/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.plugin.agent;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.ai.aicc.core.service.AiccService;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class AiccAgentServicePlugin
extends AbstractBasePlugIn {
    private String language_model = "llm";
    private String agent_service_form = "aicc_agent_service";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String id = (String)showParameter.getCustomParam("id");
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(this.agent_service_form);
        bsp.setPkId((Object)id);
        bsp.getOpenStyle().setShowType(ShowType.InCurrentForm);
        if (StringUtils.isNotEmpty((String)id)) {
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map listItems = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiLLMUtilService", (String)"getAllLLMs", (Object[])new Object[0]);
        int itemSize = listItems.size();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(itemSize);
        for (Map.Entry map : listItems.entrySet()) {
            ComboItem comboItem = new ComboItem();
            String caption = (String)map.getKey();
            String value = (String)map.getValue();
            comboItem.setCaption(new LocaleString(caption));
            comboItem.setValue(value);
            list.add(comboItem);
        }
        ComboEdit languageModel = (ComboEdit)this.getView().getControl(this.language_model);
        languageModel.setComboItems(list);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        String fieldName = e.getKey();
        if (this.language_model.equals(fieldName)) {
            String language_model = (String)e.getValue();
            List list = AiccService.queryInstance(null, null, null);
            ArrayList<String> instanceList = new ArrayList<String>(10);
            if (list != null && !list.isEmpty()) {
                for (Map map : list) {
                    String serviceNumber = (String)map.get("service.number");
                    if (!StringUtils.isNotEmpty((String)serviceNumber)) continue;
                    instanceList.add(serviceNumber);
                }
            }
            if (!instanceList.contains(language_model)) {
                this.getView().updateView(fieldName);
                e.setCancel(true);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u8bed\u8a00\u6a21\u578b\uff0c\u8bf7\u8fdb\u5165\u3010Agent\u5e73\u53f0\u3011-\u3010\u914d\u7f6e\u4e2d\u5fc3\u3011-\u3010\u6a21\u578b\u670d\u52a1\u3011\u4e2d\u914d\u7f6e\u6a21\u578bAPI\u53c2\u6570", (String)"AiccAgentServicePlugin_0", (String)"ai-aicc-plugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            }
        }
    }
}

