/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.DistributeLocker;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Service;
import kd.ai.aicc.core.domain.Task;
import kd.ai.aicc.core.volcengine.auth.SignerV4Impl;
import kd.ai.aicc.core.volcengine.model.Credentials;
import kd.ai.aicc.core.volcengine.service.SignableRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class Authorization {
    private static Log logger = LogFactory.getLog(Authorization.class);

    private Authorization() {
    }

    public static String auth(HttpPost request, Instance instance, Task task, String requestBody) {
        switch (instance.getAuthType()) {
            case API2SIGN: {
                Utils.openApiSign((HttpUriRequest)request, "", instance.getSecretKey(), instance.getProxyUserSecretKey());
                break;
            }
            case OAUTHTOKEN: {
                Utils.oAuth2Token((HttpUriRequest)request, instance.getSecretKey());
                break;
            }
            case APIKEY: {
                Utils.azureApiKeyToken((HttpUriRequest)request, instance.getSecretKey());
                break;
            }
            case XMINDAI: {
                String apiKey = Authorization.getXmindAIToken(instance, 0);
                Utils.oAuth2Token((HttpUriRequest)request, apiKey);
                break;
            }
            case BAIDU: {
                String accessToken = Authorization.getBaiduAccessToken(instance, 0);
                if (accessToken == null) break;
                String url = instance.getModelUrl();
                url = url.contains("?") ? url + "&access_token=" + accessToken : url + "?access_token=" + accessToken;
                request.setURI(URI.create(url));
                break;
            }
            case AWS_SIGN_V4: {
                Utils.awsSignV4(request, instance, task, requestBody);
                break;
            }
            case TENCENT_HUNYUAN_V1: {
                return Utils.tencentAuthV1((HttpUriRequest)request, instance.getProxyUserSecretKey(), instance.getClientId(), instance.getSecretKey(), requestBody);
            }
            case TENCENT_HUNYUAN_PRO_V3: {
                return Utils.tencentAuthV3((HttpUriRequest)request, instance.getClientId(), instance.getSecretKey(), requestBody);
            }
            case KINGDEE: {
                Utils.getKingdeeHeader((HttpUriRequest)request, instance.getSecretKey(), requestBody);
            }
            case DOUBAO: {
                String ak = instance.getClientId();
                String sk = instance.getSecretKey();
                String modelUrl = instance.getModelUrl();
                Authorization.prepareDouBaoRerankRequest(request, ak, sk, modelUrl, requestBody);
            }
        }
        return requestBody;
    }

    public static HttpPost createPost(Instance instance, Task task) {
        HttpPost httpPost = new HttpPost(instance.getModelUrl());
        String requestBody = task.getRequestBody();
        boolean isEncrypted = Encrypters.isEncrypted((String)requestBody);
        if (isEncrypted) {
            requestBody = Encrypters.decode((String)requestBody);
        }
        requestBody = Authorization.auth(httpPost, instance, task, requestBody);
        requestBody = Authorization.prepareParamHeader(httpPost, instance, task, requestBody);
        if (null == httpPost.getEntity()) {
            httpPost.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
        }
        return httpPost;
    }

    public static String prepareParamHeader(HttpPost httpPost, Instance instance, Task task, String requestBody) {
        String customParam = instance.getCustomParam();
        String customHeader = instance.getCustomHeader();
        Map bodyMap = (Map)JSON.parseObject((String)requestBody, Map.class);
        Service service = task.getService();
        String serviceModelConfig = null;
        if (service != null) {
            serviceModelConfig = service.getModelConfig();
        }
        if (StringUtils.isNotEmpty((CharSequence)customParam)) {
            Map customParamMap = (Map)JSON.parseObject((String)customParam, Map.class);
            for (Map.Entry entry : customParamMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (bodyMap.containsKey(key)) continue;
                bodyMap.put(key, value);
            }
        }
        if (bodyMap.get("model") == null && StringUtils.isNotEmpty((CharSequence)serviceModelConfig)) {
            bodyMap.put("model", serviceModelConfig);
        }
        if (StringUtils.isNotEmpty((CharSequence)customHeader)) {
            Map customHeaderMap = (Map)JSON.parseObject((String)customHeader, Map.class);
            for (Map.Entry entry : customHeaderMap.entrySet()) {
                httpPost.addHeader((String)entry.getKey(), entry.getValue().toString());
            }
        }
        task.setRequestBody(JSON.toJSONString((Object)bodyMap));
        TaskDao.updatePrepareParam(task);
        return JSON.toJSONString((Object)bodyMap);
    }

    public static String getBaiduAccessToken(Instance instance, int tryCount) {
        String accessToken = CacheHelper.getString("BAIDU_ACCESS_TOKEN_" + instance.getId());
        if (accessToken != null) {
            String expireTimeStr = CacheHelper.getString("BAIDU_ACCESS_TOKEN_EXPIRE_TIME_" + instance.getId());
            long expire = Long.parseLong(expireTimeStr == null ? "0" : expireTimeStr);
            if (System.currentTimeMillis() < expire) {
                return accessToken;
            }
            CacheHelper.removeKey("BAIDU_ACCESS_TOKEN_" + instance.getId());
            CacheHelper.removeKey("BAIDU_ACCESS_TOKEN_EXPIRE_TIME_" + instance.getId());
        }
        if (tryCount > 3) {
            throw new KDBizException(Constant.GET_BAIDUTOKEN_ERROR, new Object[0]);
        }
        boolean locked = DistributeLocker.lock("BAIDU_ACCESS_TOKEN_LOCK_" + instance.getId());
        if (locked) {
            try {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("client_id", instance.getClientId());
                dataMap.put("client_secret", instance.getSecretKey());
                long startTime = System.currentTimeMillis();
                String authUrl = instance.getAuthUrl();
                logger.info("baidu getToken url:{}", (Object)authUrl);
                String result = Utils.postByUrlEncodedForm(authUrl, null, dataMap);
                JSONObject resultObj = JSON.parseObject((String)result);
                if (resultObj == null) {
                    String string = null;
                    return string;
                }
                if (resultObj.containsKey((Object)"access_token")) {
                    accessToken = resultObj.getString("access_token");
                    long expiresIn = resultObj.getLong("expires_in");
                    long expireTime = startTime + expiresIn;
                    CacheHelper.putString("BAIDU_ACCESS_TOKEN_" + instance.getId(), accessToken);
                    CacheHelper.putString("BAIDU_ACCESS_TOKEN_EXPIRE_TIME_" + instance.getId(), String.valueOf(expireTime));
                    String string = accessToken;
                    return string;
                }
                String errMsg = resultObj.getString("error_description");
                throw new KDBizException(Constant.biaduAuthenticationError(errMsg), new Object[0]);
            }
            finally {
                DistributeLocker.releaseLock("BAIDU_ACCESS_TOKEN_LOCK_" + instance.getId());
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KDBizException(Constant.internalError(e.getMessage()), new Object[0]);
        }
        return Authorization.getBaiduAccessToken(instance, ++tryCount);
    }

    public static String getXmindAIToken(Instance instance, int tryCount) {
        String accessToken = CacheHelper.getString("XMINDAI_ACCESS_TOKEN");
        if (accessToken != null) {
            String expireTimeStr = CacheHelper.getString("XMINDAI_ACCESS_TOKEN_EXPIRE_TIME");
            long expire = Long.parseLong(expireTimeStr == null ? "0" : expireTimeStr);
            if (System.currentTimeMillis() < expire) {
                return accessToken;
            }
            CacheHelper.removeKey("XMINDAI_ACCESS_TOKEN");
            CacheHelper.removeKey("XMINDAI_ACCESS_TOKEN_EXPIRE_TIME");
        }
        if (tryCount > 3) {
            throw new KDBizException(Constant.GET_BAIDUTOKEN_ERROR, new Object[0]);
        }
        boolean locked = DistributeLocker.lock("XMINDAI_ACCESS_TOKEN_LOCK");
        if (locked) {
            try {
                long startTime = System.currentTimeMillis();
                String fullUrl = null;
                try {
                    fullUrl = instance.getAuthUrl() + "?clientId=" + instance.getClientId() + "&clientSecret=" + URLEncoder.encode(instance.getSecretKey(), "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new KDBizException("url encode\u9519\u8bef");
                }
                String result = Utils.doGet(fullUrl, null);
                JSONObject resultObj = JSON.parseObject((String)result);
                if (resultObj.containsKey((Object)"access_Token")) {
                    accessToken = resultObj.getString("access_Token");
                    long expiresIn = resultObj.getLong("expires_in");
                    long expireTime = startTime + expiresIn;
                    CacheHelper.putString("XMINDAI_ACCESS_TOKEN", accessToken);
                    CacheHelper.putString("XMINDAI_ACCESS_TOKEN_EXPIRE_TIME", String.valueOf(expireTime));
                    String string = accessToken;
                    return string;
                }
                String errMsg = resultObj.getString("error_description");
                throw new KDBizException(Constant.xmindAiAuthenticationError(errMsg), new Object[0]);
            }
            finally {
                DistributeLocker.releaseLock("XMINDAI_ACCESS_TOKEN_LOCK");
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KDBizException(Constant.internalError(e.getMessage()), new Object[0]);
        }
        return Authorization.getXmindAIToken(instance, ++tryCount);
    }

    public static void prepareDouBaoRerankRequest(HttpPost request, String ak, String sk, String modelUrl, String body) {
        try {
            String[] parseUrl = Authorization.parseUrl(modelUrl);
            if (null == parseUrl) {
                throw new KDBizException(ResManager.loadKDString((String)"url encode\u9519\u8bef", (String)"Authorization_15174999", (String)"ai-aicc-core", (Object[])new Object[0]));
            }
            String scheme = parseUrl[0];
            String host = parseUrl[1];
            String rerankPath = parseUrl[2];
            SignableRequest signableRequest = new SignableRequest();
            signableRequest.setMethod("POST");
            signableRequest.setHeader("Accept", "application/json");
            signableRequest.setHeader("Content-Type", "application/json");
            signableRequest.setHeader("Host", host);
            signableRequest.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
            URIBuilder builder = signableRequest.getUriBuilder();
            builder.setScheme(scheme);
            builder.setHost(host);
            builder.setPath(rerankPath);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(12000).build();
            signableRequest.setConfig(requestConfig);
            Credentials credentials = new Credentials("cn-north-1", "air");
            credentials.setAccessKeyID(ak);
            credentials.setSecretAccessKey(sk);
            SignerV4Impl ISigner = new SignerV4Impl();
            ISigner.sign(signableRequest, credentials);
            logger.info("prepareDouBaoRerankRequest headers:{}", (Object)Arrays.stream(signableRequest.getAllHeaders()).map(e -> e.getName() + ":" + e.getValue()).collect(Collectors.joining(";\n")));
            request.setConfig(signableRequest.getConfig());
            request.setEntity(signableRequest.getEntity());
            for (Header header : signableRequest.getAllHeaders()) {
                request.setHeader(header.getName(), header.getValue());
            }
        }
        catch (Exception e2) {
            logger.error("prepareDouBaoRerankRequest error", (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    public static String[] parseUrl(String urlString) {
        try {
            URI uri = new URI(urlString);
            String protocol = uri.getScheme();
            String domain = uri.getHost();
            if (uri.getPort() != -1) {
                domain = domain + ":" + uri.getPort();
            }
            String path = uri.getRawPath();
            if (uri.getQuery() != null) {
                path = path + "?" + uri.getQuery();
            }
            if (path == null || path.isEmpty()) {
                path = "/";
            }
            return new String[]{protocol, domain, path};
        }
        catch (URISyntaxException e) {
            logger.error("URL\u683c\u5f0f\u9519\u8bef: " + e.getMessage());
            return null;
        }
    }
}

