/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kd.ai.aicc.core.AsyncTaskNotifier;
import kd.ai.aicc.core.DistributeLocker;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.dao.ConfigDao;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.Config;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class BatchQueryService
implements Runnable {
    private static final Log log = LogFactory.getLog(BatchQueryService.class);
    public static final int WAIT_TIME_MS = 3000;
    private static final int BATCH_SIZE = 100;
    private static final String BATCHQUERY_URL = "/kapi/v2/aicc/query/batch";
    private static final String LOCK_KEY = "aicc-BatchQueryService";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ai-aicc-BatchQueryService-threadpool", (int)1, (String)"aicc");
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Object notifyObject = new Object();
    private static BatchQueryService instance = null;

    public static synchronized BatchQueryService getInstance() {
        if (instance == null) {
            instance = new BatchQueryService();
        }
        return instance;
    }

    public void start() {
        if (!this.running.get()) {
            this.running.set(true);
            threadPool.execute((Runnable)this);
            log.info("\u521d\u59cb\u5316\u5b8c\u6210");
        }
    }

    public void stop() {
        this.running.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newAsyncTask() {
        Object object = this.notifyObject;
        synchronized (object) {
            this.notifyObject.notifyAll();
        }
    }

    public void query() {
        if (DistributeLocker.lock(LOCK_KEY)) {
            try {
                Config config = ConfigDao.getConfig();
                long[] taskIdArray = TaskDao.queryRunningAsyncTasks();
                this.splitTasks(taskIdArray, 100, data -> this.queryBatchTasks(config, (long[])data));
            }
            finally {
                DistributeLocker.releaseLock(LOCK_KEY);
            }
        }
    }

    public void splitTasks(long[] taskIdArray, int batchSize, Consumer<long[]> consumer) {
        if (taskIdArray == null || taskIdArray.length == 0) {
            return;
        }
        if (taskIdArray.length <= batchSize) {
            consumer.accept(taskIdArray);
        } else {
            long[] batchTasks = new long[batchSize];
            int batchIndex = 0;
            for (long l : taskIdArray) {
                batchTasks[batchIndex++] = l;
                if (batchIndex != batchSize) continue;
                consumer.accept(batchTasks);
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                long[] batchTasks2 = new long[batchIndex];
                System.arraycopy(batchTasks, 0, batchTasks2, 0, batchIndex);
                consumer.accept(batchTasks2);
            }
        }
    }

    public void queryBatchTasks(Config config, long[] batchTasks) {
        String requestBodyStr = JSON.toJSONString((Object)batchTasks);
        Map<String, Object> result = Utils.api2PostRequest(config, BATCHQUERY_URL, requestBodyStr);
        if ("0".equals(result.get("errorCode"))) {
            ArrayList<Long> notifyTaskList = new ArrayList<Long>();
            JSONArray array = (JSONArray)result.get("data");
            List taskResultList = array.toJavaList(TaskResult.class);
            for (TaskResult r : taskResultList) {
                TaskDao.updateTaskResult(r);
                if (!TaskStatusEnum.SUCCESS.getValue().equalsIgnoreCase(r.getStatus()) && !TaskStatusEnum.FAILED.getValue().equalsIgnoreCase(r.getStatus())) continue;
                notifyTaskList.add(r.getId());
            }
            if (!notifyTaskList.isEmpty()) {
                AsyncTaskNotifier.notifyTasks(notifyTaskList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running.get()) {
            this.query();
            if (!this.running.get()) continue;
            Object object = this.notifyObject;
            synchronized (object) {
                try {
                    this.notifyObject.wait(3000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public boolean isStarted() {
        return this.running.get();
    }
}

