/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.ai.aicc.core.dao.ServiceDao;
import kd.ai.aicc.core.dao.TenantDao;
import kd.ai.aicc.core.domain.Service;
import kd.ai.aicc.core.domain.Tenant;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataManager {
    private static DataManager dataManager = null;
    private final ConcurrentMap<Long, RequestContext> taskRequestContextMap = new ConcurrentHashMap<Long, RequestContext>();
    private Log logger = LogFactory.getLog(DataManager.class);

    private DataManager() {
    }

    public static synchronized DataManager getInstance() {
        if (dataManager == null) {
            dataManager = new DataManager();
        }
        return dataManager;
    }

    public Service findService(String accountId, long serviceId) {
        return ServiceDao.getService(serviceId);
    }

    public Service findServiceByNumber(String accountId, String serviceNumber) {
        return ServiceDao.getService(serviceNumber);
    }

    public Tenant findTenantByCqTenantIdAndProdInstId(String accountId, String cqTenantId, String prodInstId) {
        return TenantDao.findTenantByCqTenantIdAndProdInstId(cqTenantId, prodInstId);
    }

    public Tenant findTenantById(String accountId, long id) {
        return TenantDao.findTenantById(id);
    }
}

