/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.ai.aicc.core.DistributeLocker;
import kd.ai.aicc.core.Executor;
import kd.ai.aicc.core.Queue;
import kd.ai.aicc.core.client.SyncTaskLockManager;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.Task;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class Dispatcher
implements Runnable {
    private static final Log log = LogFactory.getLog(Dispatcher.class);
    public static final String DISPATCHER_THREAD_POOL_NAME = "ai-aicc-dispatcher-threadpool";
    private static Dispatcher instance = null;
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ai-aicc-dispatcher-threadpool", (int)1, (String)"aicc");
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private Queue queue;
    private Executor executor;
    private DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache((String)null, new DistributeCacheHAPolicy());
    public static String aiccTaskRegion = "aicc_task_region";
    public static String aiccAccountRegion = "aicc_accountId_region";
    private String taskLockKey = "retryTaskLock";
    private int taskTimeout = 86400;
    private final Object notifyObject = new Object();

    private Dispatcher() {
    }

    public static synchronized Dispatcher getInstance() {
        if (instance == null) {
            instance = new Dispatcher();
            instance.init();
        }
        return instance;
    }

    private void init() {
        this.queue = new Queue();
        this.queue.init();
        this.executor = new Executor();
        this.executor.init();
        this.isRunning.set(true);
        threadPool.execute((Runnable)this);
        this.handleInterruptTask();
        log.info("\u521d\u59cb\u5316\u5b8c\u6210");
    }

    public void start() {
        this.isRunning.set(true);
        log.info("\u670d\u52a1\u542f\u52a8");
    }

    public void stop() {
        log.warn("\u6536\u5230\u670d\u52a1\u505c\u6b62\u4fe1\u53f7");
        this.isRunning.set(false);
    }

    public boolean isStarted() {
        return this.isRunning.get();
    }

    public void handleInterruptTask() {
        if (DistributeLocker.lockNoCache(this.taskLockKey)) {
            log.info("\u521d\u59cb\u5316\u4efb\u52a1\u72b6\u6001");
            List<String> serviceIdList = TaskDao.getRestartService();
            for (String serviceId : serviceIdList) {
                String serviceFlag = RequestContext.get().getAccountId() + "_" + serviceId;
                this.queue.addServiceFlag(serviceFlag);
                Queue.serviceSet.add(serviceFlag);
            }
            if (this.cache.get("aicc_instance", "taskUpdate") == null) {
                int updateTimeout = 480000;
                this.cache.put("aicc_instance", "taskUpdate", "1", updateTimeout);
                TaskDao.updataRestartTaskStaus();
            }
        }
        DistributeLocker.releaseLockNoCache(this.taskLockKey);
    }

    public void newSyncTask(Task task) {
        this.newASyncTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newASyncTask(Task task) {
        task.getAccountId();
        this.setTaskRequestContext(String.valueOf(task.getId()));
        this.queue.enqueue(task, RequestContext.get());
        Object object = this.notifyObject;
        synchronized (object) {
            this.notifyObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCompleted(Task task) {
        Object object = this.notifyObject;
        synchronized (object) {
            this.notifyObject.notifyAll();
        }
        SyncTaskLockManager.release(task.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("\u4efb\u52a1\u5206\u53d1\u5668\u5f00\u59cb\u8fd0\u884c");
        while (this.isRunning.get()) {
            try {
                this.running();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (!this.isRunning.get()) continue;
            Object object = this.notifyObject;
            synchronized (object) {
                try {
                    this.notifyObject.wait(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        log.info("\u4efb\u52a1\u5206\u53d1\u5668\u7ed3\u675f\u8fd0\u884c");
    }

    private void running() {
        Task task = this.queue.next();
        while (this.isRunning.get() && task != null) {
            try {
                RequestContext requestContext = this.getTaskRequestContext(String.valueOf(task.getId()), aiccTaskRegion);
                if (requestContext == null) {
                    requestContext = RequestContext.get();
                }
                this.executor.executeTask(task, task.getInstance(), requestContext);
            }
            catch (Exception e) {
                task.getInstance().releaseResource();
                log.error((Throwable)e);
            }
            task = this.queue.next();
        }
    }

    public RequestContext getTaskRequestContext(String taskId, String aiccKey) {
        String taskKey = "task_" + taskId;
        String contextStr = (String)this.cache.get(aiccKey, taskKey);
        Gson gson = new Gson();
        RequestContext context = (RequestContext)gson.fromJson(contextStr, RequestContext.class);
        return context;
    }

    public void setTaskRequestContext(String taskId) {
        String taskKey = "task_" + taskId;
        RequestContext requestContext = RequestContext.get();
        ObjectMapper mapper = new ObjectMapper();
        String value = "";
        try {
            value = mapper.writeValueAsString((Object)requestContext);
        }
        catch (JsonProcessingException e) {
            log.error("\u4efb\u52a1\u4e0a\u4e0b\u6587\u7f13\u5b58\u5931\u8d25\uff0ctaskId\uff1a{}", (Object)taskId);
        }
        this.cache.put(aiccTaskRegion, taskKey, value, this.taskTimeout);
    }

    private void setAccountRequestContext(String accountId) {
        String accountKey = "aicc_accountId_" + accountId;
        RequestContext requestContext = RequestContext.get();
        ObjectMapper mapper = new ObjectMapper();
        String value = "";
        try {
            value = mapper.writeValueAsString((Object)requestContext);
        }
        catch (JsonProcessingException e) {
            log.error("\u6570\u636e\u4e2d\u5fc3\u4e0a\u4e0b\u6587\u7f13\u5b58\u5931\u8d25\uff0caccountId\uff1a{}", (Object)accountId);
        }
        this.cache.put(aiccAccountRegion, accountKey, value, this.taskTimeout);
    }

    public RequestContext getAccountIdRequestContext(String accountId, String accountKey) {
        String accountKeyKey = "aicc_accountId_" + accountId;
        String contextStr = (String)this.cache.get(accountKey, accountKeyKey);
        Gson gson = new Gson();
        RequestContext context = (RequestContext)gson.fromJson(contextStr, RequestContext.class);
        return context;
    }

    public void removeTaskRequestContext(String taskId) {
        String taskKey = "task_" + taskId;
        this.cache.remove(aiccTaskRegion, taskKey);
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }
}

