/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSONObject;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.Constant;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;

public class DistributeCounter {
    private DistributeCounter() {
    }

    public static void reset(String key) {
        CacheHelper.removeKey(key);
    }

    public static int getValue(String key) {
        return CacheHelper.getInt(key);
    }

    public static int addOne(String key) {
        return DistributeCounter.add(key, 1);
    }

    public static int subOne(String key) {
        return DistributeCounter.add(key, -1);
    }

    public static int add(String key, int value) {
        try (DLock dLock = DLock.create((String)key);){
            if (dLock.fastMode().tryLock(3000L)) {
                int currentValue = DistributeCounter.getValue(key);
                int sum = currentValue + value;
                CacheHelper.putInt(key, sum);
                int n = sum;
                return n;
            }
        }
        throw new KDBizException(Constant.DISTRIBUTECOUNT_ERROR, new Object[0]);
    }

    public static int addOneByJSON(String type, String key) {
        return DistributeCounter.addByJSON(type, key, 1);
    }

    public static int subOneByJSON(String type, String key) {
        return DistributeCounter.addByJSON(type, key, -1);
    }

    public static int addByJSON(String type, String key, int value) {
        try (DLock dLock = DLock.create((String)key);){
            if (dLock.fastMode().tryLock(3000L)) {
                JSONObject currentJson = CacheHelper.getJSONObject(type);
                if (currentJson == null) {
                    int n = 0;
                    return n;
                }
                int currentValue = currentJson.getInteger(key);
                int sum = currentValue + value;
                currentJson.put(key, (Object)sum);
                CacheHelper.putJSONObject(type, currentJson);
                int n = sum;
                return n;
            }
        }
        throw new KDBizException(Constant.DISTRIBUTECOUNT_ERROR, new Object[0]);
    }
}

