/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kd.ai.aicc.core.AsyncTaskNotifier;
import kd.ai.aicc.core.Authorization;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.Dispatcher;
import kd.ai.aicc.core.ExecutorThreadCache;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.Utils;
import kd.ai.aicc.core.XfWebSocketRunner;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Task;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class Executor {
    private static final Log log = LogFactory.getLog(Executor.class);
    public static final String TASK_EXEC_THREAD_POOL_NAME = "ai-aicc-task_exec-threadpool";
    public static final int TASK_EXEC_MIN_THREAD_NUM = 10;
    public static final int TASK_EXEC_MAX_THREAD_NUM = 1000;
    private static ThreadPool threadPool = null;

    public synchronized void init() {
        if (threadPool == null) {
            threadPool = ThreadPools.newCachedThreadPool((String)TASK_EXEC_THREAD_POOL_NAME, (int)10, (int)1000, (String)"aicc");
        }
        log.info("\u5b8c\u6210\u521d\u59cb\u5316");
    }

    public void executeTask(Task task, Instance atInstance, RequestContext requestContext) {
        threadPool.execute((Runnable)new TaskRunner(task, atInstance), requestContext);
    }

    public static class TaskRunner
    implements Runnable {
        private static final Log log = LogFactory.getLog(TaskRunner.class);
        private final Task task;
        private final Instance atInstance;
        protected JSONObject msInfoObj;
        protected StreamDataBuffer streamDataBuffer = new StreamDataBuffer();

        public Task getTask() {
            return this.task;
        }

        public JSONObject getMsInfoObj() {
            return this.msInfoObj;
        }

        public Instance getAtInstance() {
            return this.atInstance;
        }

        public TaskRunner(Task task, Instance atInstance) {
            this.task = task;
            this.atInstance = atInstance;
            this.msInfoObj = AsyncTaskNotifier.getTaskMsInfo(task.getId());
        }

        @Override
        public void run() {
            try {
                log.info("\u7ebf\u7a0b{}\u5f00\u59cb\u5904\u7406\u4efb\u52a1,taskid:{}...", (Object)Thread.currentThread().getName(), (Object)this.task.getId());
                if (this.before()) {
                    if (this.parseProtocol().equalsIgnoreCase("http") || this.parseProtocol().equalsIgnoreCase("https")) {
                        this.httpRunning();
                    } else if (this.parseProtocol().equalsIgnoreCase("ws") || this.parseProtocol().equalsIgnoreCase("wss")) {
                        XfWebSocketRunner wsRunner = new XfWebSocketRunner();
                        wsRunner.run(this);
                    } else {
                        ErrorCode errorCode = Constant.notSupportProtocol(this.parseProtocol());
                        this.execTaskFailed(errorCode.getCode(), errorCode.getMessage(), this.msInfoObj);
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                ErrorCode errorCode = Constant.internalError(e.getMessage());
                this.execTaskFailed(errorCode.getCode(), errorCode.getMessage(), this.msInfoObj);
            }
            finally {
                this.releaseTask();
            }
        }

        public String parseProtocol() {
            String protoCol = null;
            String modelUrl = this.atInstance.getModelUrl();
            if (StringUtils.isNotEmpty((CharSequence)modelUrl)) {
                protoCol = modelUrl.split(":")[0];
            } else if (this.atInstance.getProtocol() != null) {
                protoCol = this.atInstance.getProtocol();
            }
            return protoCol;
        }

        public void releaseTask() {
            this.releaseResources();
            Dispatcher.getInstance().taskCompleted(this.task);
        }

        private boolean before() {
            String taskStopKey = "ST_ST_" + this.task.getId();
            if ("[STOP]".equals(CacheHelper.getString(taskStopKey))) {
                CacheHelper.removeKey(taskStopKey);
                this.task.setStatusEnum(TaskStatusEnum.STOPPED);
                TaskDao.updateStatus(this.task);
                this.notifyStopped(this.msInfoObj);
                log.info("task stopped : {}", (Object)this.task.getId());
                return false;
            }
            this.task.setStatusEnum(TaskStatusEnum.RUNNING);
            this.task.setInstance(this.atInstance);
            TaskDao.updateStatus(this.task);
            return true;
        }

        private void httpRunning() {
            log.info("running task : {}", (Object)this.task.getId());
            HttpUriRequest httpRequest = this.buildRequest();
            if (this.task.isStream() && this.atInstance.getService().isSupportStream()) {
                log.info("execute stream task : {}", (Object)this.task.getId());
                this.httpStreamExecute(httpRequest);
                log.info("execute stream task : {} done", (Object)this.task.getId());
            } else {
                log.info("execute task : {}", (Object)this.task.getId());
                this.task.setStream(false);
                TaskDao.updateStreamFlag(this.task);
                this.httpExecute(httpRequest);
                log.info("execute task : {} done", (Object)this.task.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void httpStreamExecute000(HttpUriRequest httpRequest) {
            block38: {
                log.info("execute stream task : {}  request", (Object)this.task.getId());
                try (CloseableHttpResponse httpResponse = Utils.getClient().execute(httpRequest);){
                    log.info("execute stream task : {}  response", (Object)this.task.getId());
                    int errCode = httpResponse.getStatusLine().getStatusCode();
                    HttpEntity entity = httpResponse.getEntity();
                    if (200 == errCode) {
                        boolean isContainDONE = false;
                        StringBuilder contentBuffer = new StringBuilder();
                        int seq = 0;
                        boolean isStopped = false;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                            String line;
                            String taskStopKey = "ST_ST_" + this.task.getId();
                            while ((line = reader.readLine()) != null) {
                                String stopVal;
                                if (seq == 0) {
                                    this.task.setStatusEnum(TaskStatusEnum.RESPONSE);
                                    TaskDao.updateStatus(this.task);
                                }
                                contentBuffer.append(line);
                                if (this.isStreamDone(line)) {
                                    this.notifyStreamDone(seq++, this.msInfoObj);
                                    isContainDONE = true;
                                } else {
                                    this.notifyStream(line, seq++, this.msInfoObj);
                                }
                                if (!"[STOP]".equals(stopVal = CacheHelper.getString(taskStopKey))) continue;
                                CacheHelper.removeKey(taskStopKey);
                                isStopped = true;
                                break;
                            }
                        }
                        if (isStopped) {
                            this.stopTask(contentBuffer.toString());
                        } else {
                            if (!isContainDONE) {
                                this.notifyStreamDone(seq, this.msInfoObj);
                            }
                            this.execTaskSuccess(contentBuffer.toString(), false, this.msInfoObj);
                        }
                        break block38;
                    }
                    String resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    log.error("resp:{}, url:{}", (Object)resp, (Object)httpRequest.getURI().toString());
                    this.execTaskFailed(String.valueOf(errCode), resp, this.msInfoObj);
                }
                catch (Exception e) {
                    log.error(e.getMessage() + "," + httpRequest.getURI().toString(), (Throwable)e);
                    ErrorCode errorCode = Constant.httpError(this.removeToken(httpRequest.getURI().toString()), e.getMessage());
                    this.execTaskFailed(errorCode.getCode(), errorCode.getMessage(), this.msInfoObj);
                }
                finally {
                    ExecutorThreadCache.clear();
                }
            }
        }

        private void httpStreamExecute(HttpUriRequest httpRequest) {
            block35: {
                log.info("execute stream task : {}  request", (Object)this.task.getId());
                try (CloseableHttpResponse httpResponse = Utils.getClient().execute(httpRequest);){
                    log.info("execute stream task : {}  response", (Object)this.task.getId());
                    int errCode = httpResponse.getStatusLine().getStatusCode();
                    HttpEntity entity = httpResponse.getEntity();
                    if (200 == errCode) {
                        boolean isContainDONE = false;
                        StringBuilder contentBuffer = new StringBuilder();
                        int seq = 0;
                        boolean isStopped = false;
                        long ts = System.currentTimeMillis();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                            String line;
                            String taskStopKey = "ST_ST_" + this.task.getId();
                            log.info("taskid:{},aicc\u539f\u59cb\u6d41\u5f0f\u6279\u6b21\uff1a{},\u5f53\u524d\u65f6\u95f4\uff1a{}", new Object[]{this.task.getId(), seq, this.getAiccCurrentTime()});
                            while ((line = reader.readLine()) != null) {
                                String stopVal;
                                if (seq == 0) {
                                    this.task.setStatusEnum(TaskStatusEnum.RESPONSE);
                                    TaskDao.updateStatus(this.task);
                                }
                                contentBuffer.append(line);
                                if (this.isStreamDone(line)) {
                                    this.notifyStreamDone(seq++, this.msInfoObj);
                                    isContainDONE = true;
                                } else {
                                    this.notifyStream(line, seq++, this.msInfoObj);
                                }
                                if (!"[STOP]".equals(stopVal = CacheHelper.getString(taskStopKey))) continue;
                                CacheHelper.removeKey(taskStopKey);
                                isStopped = true;
                                break;
                            }
                        }
                        if (isStopped) {
                            this.stopTask(contentBuffer.toString());
                        } else {
                            if (!isContainDONE) {
                                this.notifyStreamDone(seq, this.msInfoObj);
                            }
                            this.execTaskSuccess(contentBuffer.toString(), false, this.msInfoObj);
                        }
                        break block35;
                    }
                    String resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    log.error("resp:{}, url:{}", (Object)resp, (Object)httpRequest.getURI().toString());
                    this.execTaskFailed(String.valueOf(errCode), resp, this.msInfoObj);
                }
                catch (Exception e) {
                    log.error(e.getMessage() + "," + httpRequest.getURI().toString(), (Throwable)e);
                    ErrorCode errorCode = Constant.httpError(this.removeToken(httpRequest.getURI().toString()), e.getMessage());
                    this.execTaskFailed(errorCode.getCode(), errorCode.getMessage(), this.msInfoObj);
                }
            }
        }

        private String getAiccCurrentTime() {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            return LocalDateTime.now().format(formatter);
        }

        private String removeToken(String url) {
            int pos = url.indexOf("access_token");
            if (pos > 0) {
                return url.substring(0, pos);
            }
            return url;
        }

        private boolean isStreamDone(String streamLine) {
            return streamLine != null && streamLine.contains("data: [DONE]");
        }

        public void notifyStopped(JSONObject mserviceInfo) {
            TaskResult result = new TaskResult();
            result.setId(this.task.getId());
            result.setErrCode(Constant.USER_STOPPED.getCode());
            result.setErrMsg(Constant.USER_STOPPED.getMessage());
            result.setStatus(TaskStatusEnum.STOPPED.getValue());
            AsyncTaskNotifier.notifyTaskResult(result, mserviceInfo);
        }

        public void notifyError(String errCode, String errMsg, JSONObject mserviceInfo) {
            TaskResult result = new TaskResult();
            result.setId(this.task.getId());
            result.setErrCode(errCode);
            result.setErrMsg(errMsg);
            result.setStatus(TaskStatusEnum.FAILED.getValue());
            AsyncTaskNotifier.notifyTaskResult(result, mserviceInfo);
        }

        public void notifyStream(String streamLine, int seqNo, JSONObject mserviceInfo) {
            this.streamDataBuffer.addData(streamLine);
            if (this.streamDataBuffer.bufferIsFull()) {
                this.notifyStreamBuffer(seqNo, mserviceInfo);
            }
        }

        public void notifyStreamBuffer(int seqNo, JSONObject mserviceInfo) {
            List<String> lines = this.streamDataBuffer.peekData();
            if (!lines.isEmpty()) {
                ArrayList<TaskResult> taskResults = new ArrayList<TaskResult>(lines.size());
                for (String line : lines) {
                    TaskResult result = new TaskResult();
                    result.setId(this.task.getId());
                    result.setErrCode("0");
                    result.setStatus(TaskStatusEnum.RUNNING.getValue());
                    result.setResult(line);
                    result.setStream(true);
                    result.setStreamSeqNO(seqNo);
                    taskResults.add(result);
                }
                AsyncTaskNotifier.notifyResult(taskResults, mserviceInfo);
            }
        }

        public void notifyStreamDone(int seqNo, JSONObject mserviceInfo) {
            this.notifyStreamBuffer(seqNo, mserviceInfo);
            TaskResult result = new TaskResult();
            result.setId(this.task.getId());
            result.setErrCode("0");
            result.setStatus(TaskStatusEnum.SUCCESS.getValue());
            result.setResult("data: [DONE]");
            result.setStream(true);
            result.setStreamSeqNO(seqNo);
            AsyncTaskNotifier.notifyTaskResult(result, mserviceInfo);
        }

        private void httpExecute(HttpUriRequest httpRequest) {
            log.info("execute task : {}  request", (Object)this.task.getId());
            try (CloseableHttpResponse httpResponse = Utils.getClient().execute(httpRequest);){
                log.info("execute task : {}  response", (Object)this.task.getId());
                int errCode = httpResponse.getStatusLine().getStatusCode();
                HttpEntity entity = httpResponse.getEntity();
                String resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                if (200 == errCode && !resp.startsWith("<!doctype html>")) {
                    this.execTaskSuccess(resp, true, this.msInfoObj);
                } else {
                    log.error(resp);
                    this.execTaskFailed(String.valueOf(errCode), resp, this.msInfoObj);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage() + "," + httpRequest.getURI().toString(), (Throwable)e);
                ErrorCode errorCode = Constant.httpError(this.removeToken(httpRequest.getURI().toString()), e.getMessage());
                this.execTaskFailed(errorCode.getCode(), errorCode.getMessage(), this.msInfoObj);
            }
        }

        private void releaseResources() {
            this.atInstance.releaseResource();
            AsyncTaskNotifier.removeTaskMsInfo(this.task.getId());
        }

        private void stopTask(String result) {
            this.task.setStatusEnum(TaskStatusEnum.STOPPED);
            this.task.setResult(result);
            TaskDao.updateStatus(this.task);
        }

        public void execTaskSuccess(String result, boolean needNotify, JSONObject mserviceInfo) {
            this.task.setStatusEnum(TaskStatusEnum.SUCCESS);
            this.task.setErrCode("0");
            this.task.setResult(result);
            TaskDao.updateStatus(this.task);
            if (this.task.isAsyncTask() && needNotify) {
                TaskResult taskResult = new TaskResult();
                taskResult.setId(this.task.getId());
                taskResult.setErrCode("0");
                taskResult.setStatus(TaskStatusEnum.SUCCESS.getValue());
                taskResult.setResult(result);
                AsyncTaskNotifier.notifyTaskResult(taskResult, mserviceInfo);
            }
        }

        public void execTaskFailed(String errorCode, String errMsg, JSONObject msInfoObj) {
            this.task.setStatusEnum(TaskStatusEnum.FAILED);
            this.task.setErrCode(errorCode);
            this.task.setErrMsg(errMsg);
            TaskDao.updateStatus(this.task);
            if (this.task.isAsyncTask()) {
                this.notifyError(errorCode, errMsg, msInfoObj);
            }
        }

        private HttpUriRequest buildRequest() {
            TaskDao.queryRequestParameters(this.task);
            HttpPost httpPost = Authorization.createPost(this.atInstance, this.task);
            RequestContext context = RequestContext.get();
            String traceId = Strings.isNullOrEmpty((String)context.getTraceId()) ? UUID.randomUUID().toString() : context.getTraceId();
            httpPost.addHeader("X-Request-Id", traceId);
            return httpPost;
        }
    }

    public static class StreamDataBuffer {
        private final List<String> data = new ArrayList<String>();
        private long startTime = 0L;

        public void addData(String data) {
            if (data.isEmpty()) {
                this.startTime = System.currentTimeMillis();
            }
            this.data.add(data);
        }

        public boolean bufferIsFull() {
            return System.currentTimeMillis() - this.startTime > 150L || this.data.size() > 16;
        }

        public List<String> peekData() {
            ArrayList<String> dataClone = new ArrayList<String>(this.data);
            this.data.clear();
            this.startTime = 0L;
            return dataClone;
        }
    }
}

