/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import kd.ai.aicc.core.AsyncTaskNotifier;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.core.DistributeLocker;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.dao.TaskDao;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Service;
import kd.ai.aicc.core.domain.Task;
import kd.ai.aicc.core.domain.enuz.ModelType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class Queue {
    private static final Log log = LogFactory.getLog(Queue.class);
    public static final int SERVICE_QUEUE_INIT_SIZE = 100;
    private final Map<String, PriorityBlockingQueue<Task>> serviceQueueMap = new ConcurrentHashMap<String, PriorityBlockingQueue<Task>>();
    private int currentServiceIndex = 0;
    public List<String> serviceList = new ArrayList<String>(50);
    public static Set<String> serviceSet = Collections.synchronizedSet(new HashSet(20));
    private Map<String, RequestContext> accountContextMap = new HashMap<String, RequestContext>(1);
    private int EmbeddingQueueMaxSize = 500;
    private int waitTimeLimit = 10000;

    public void init() {
        this.serviceList.clear();
        this.currentServiceIndex = 0;
        log.info("\u961f\u5217\u521d\u59cb\u5316\u5b8c\u6210");
    }

    public void addServiceFlag(String serviceFlag) {
        this.serviceList.add(serviceFlag);
    }

    public void enqueue(Task task, RequestContext context) {
        boolean existed = false;
        String serviceFlag = this.getServiceFlag(task);
        for (String serviceFlag2 : this.serviceList) {
            if (!serviceFlag.equals(serviceFlag2)) continue;
            existed = true;
            break;
        }
        if (!existed) {
            this.serviceList.add(serviceFlag);
        }
        this.addTaskQueue(task, context);
        log.info("\u6570\u636e\u4e2d\u5fc3{}, \u670d\u52a1{}\u6709\u65b0\u4efb\u52a1{}\u5165\u961f", new Object[]{task.getAccountId(), task.getService().getName(), task.getId()});
    }

    public String getServiceFlag(Task task) {
        return String.format("%s_%s", task.getAccountId(), task.getServiceId());
    }

    private void addTaskQueue(Task task, RequestContext context) {
        if (task.getService() == null) {
            task.setService(DataManager.getInstance().findService(task.getAccountId(), task.getServiceId()));
        }
        if (task.getTenant() == null) {
            task.setTenant(DataManager.getInstance().findTenantById(task.getAccountId(), task.getTenantId()));
        }
        PriorityBlockingQueue serviceQueue = this.serviceQueueMap.computeIfAbsent(this.getServiceFlag(task), k -> new PriorityBlockingQueue<Task>(100, new TaskCompare()));
        if (this.accountContextMap.get(task.getAccountId()) == null) {
            this.accountContextMap.put(task.getAccountId(), context);
        }
        if (task.getPriority() == 0) {
            serviceQueue.put(task);
        } else if (serviceQueue.size() <= this.EmbeddingQueueMaxSize && !serviceSet.contains(this.getServiceFlag(task))) {
            serviceQueue.put(task);
        } else {
            serviceSet.add(this.getServiceFlag(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void controllerQueue(String serviceFlag) {
        if (serviceSet.contains(serviceFlag)) {
            try {
                if (DistributeLocker.lockNoCache("service_queue")) {
                    PriorityBlockingQueue serviceQueue = this.serviceQueueMap.computeIfAbsent(serviceFlag, k -> new PriorityBlockingQueue<Task>(100, new TaskCompare()));
                    String serviceId = serviceFlag.split("_")[1];
                    Map<String, Object> taskMap = TaskDao.queryExecuteTaskByTimeSort(serviceId, this.EmbeddingQueueMaxSize);
                    List taskList = (List)taskMap.get("taskList");
                    DynamicObject[] taskCollection = (DynamicObject[])taskMap.get("taskDynamic");
                    for (Task dbTask : taskList) {
                        serviceQueue.put(dbTask);
                    }
                    SaveServiceHelper.update((DynamicObject[])taskCollection);
                    if (taskList.size() < this.EmbeddingQueueMaxSize) {
                        serviceSet.remove(serviceFlag);
                    }
                    log.info("\u670d\u52a1\u961f\u5217\u8865\u5145\u540e\u4efb\u52a1\u5927\u5c0f:{}", (Object)serviceQueue.size());
                }
            }
            finally {
                DistributeLocker.releaseLockNoCache("service_queue");
            }
        }
    }

    public Task next() {
        if (this.serviceList.isEmpty()) {
            return null;
        }
        Task task = null;
        int theIndex = this.currentServiceIndex = this.currentServiceIndex < this.serviceList.size() ? this.currentServiceIndex : 0;
        do {
            String serviceFlag = this.serviceList.get(this.currentServiceIndex);
            String[] serviceData = serviceFlag.split("_");
            String accountId = serviceData[0];
            RequestContext accountContext = this.accountContextMap.get(accountId);
            RequestContext.set((RequestContext)accountContext);
            log.info("\u4efb\u52a1\u5207\u6362\u4e0a\u4e0b\u6587\uff0c\u6570\u636e\u4e2d\u5fc3\uff1a{}", (Object)accountContext.getAccountId());
            long serviceId = Long.parseLong(serviceData[1]);
            Service service = DataManager.getInstance().findService(accountId, serviceId);
            if (service != null) {
                task = this.findTask(service, serviceFlag);
                ++this.currentServiceIndex;
            } else {
                log.error("\u6570\u636e\u4e2d\u5fc3{}, \u670d\u52a1{} \u5931\u6548\uff0c\u79fb\u9664\u4efb\u52a1", (Object)accountId, (Object)serviceId);
                this.serviceList.remove(this.currentServiceIndex);
                this.serviceQueueMap.remove(serviceFlag);
            }
            int n = this.currentServiceIndex = this.currentServiceIndex < this.serviceList.size() ? this.currentServiceIndex : 0;
        } while (task == null && this.currentServiceIndex != theIndex);
        if (task != null) {
            log.info("\u627e\u5230\u6570\u636e\u4e2d\u5fc3{},  \u670d\u52a1{}\u7684\u53ef\u6267\u884c\u4efb\u52a1{}\u8fd0\u884c\u5728\u670d\u52a1\u5b9e\u4f8b{}", new Object[]{task.getAccountId(), task.getService().getName(), task.getId(), task.getInstance().getId()});
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task findTask(Service service, String serviceFlag) {
        Task task = null;
        Instance atInstance = null;
        try {
            PriorityBlockingQueue<Task> serviceQueue = this.serviceQueueMap.get(serviceFlag);
            if (serviceQueue != null && !serviceQueue.isEmpty()) {
                log.info("\u670d\u52a1{}\u6709{}\u4e2a\u4efb\u52a1\u7b49\u5f85\u6267\u884c", (Object)service.getName(), (Object)serviceQueue.size());
                this.checkQueue(service, serviceQueue);
                Task preTask = serviceQueue.peek();
                if (preTask == null) {
                    log.info("\u670d\u52a1{}\u6ca1\u6709\u4efb\u52a1\u7b49\u5f85\u6267\u884c", (Object)service.getName());
                    Task task2 = null;
                    return task2;
                }
                atInstance = service.findIdleInstance(preTask);
                if (atInstance != null) {
                    task = serviceQueue.poll();
                    if (task != null) {
                        task.setService(service);
                        task.setInstance(atInstance);
                    } else {
                        this.controllerQueue(serviceFlag);
                    }
                }
            } else {
                this.controllerQueue(serviceFlag);
                log.info("\u670d\u52a1{}\u6ca1\u6709\u4efb\u52a1\u7b49\u5f85\u6267\u884c", (Object)service.getName());
            }
        }
        catch (KDBizException exp) {
            log.error(exp.getMessage(), (Throwable)exp);
        }
        finally {
            if (atInstance != null && task == null) {
                atInstance.releaseResource();
            }
        }
        return task;
    }

    public void checkQueue(Service service, PriorityBlockingQueue<Task> serviceQueue) {
        if (service.getModelType().equals(ModelType.LLM.getValue())) {
            long limitTime;
            Iterator<Task> itertor = serviceQueue.iterator();
            long l = limitTime = service.getWaitTime() * 1000 == 0 ? (long)this.waitTimeLimit : (long)(service.getWaitTime() * 1000);
            while (itertor.hasNext()) {
                Task task = itertor.next();
                long waitTime = System.currentTimeMillis() - task.getCreateTime().getTime();
                if (waitTime <= limitTime) continue;
                JSONObject mserivceInfo = AsyncTaskNotifier.getTaskMsInfo(task.getId());
                TaskResult result = new TaskResult();
                result.setId(task.getId());
                result.setErrCode(Constant.TimeLimitError((int)(limitTime / 1000L)).getCode());
                result.setErrMsg(Constant.TimeLimitError((int)(limitTime / 1000L)).getMessage());
                result.setStatus(TaskStatusEnum.TIMEOUT.getValue());
                AsyncTaskNotifier.notifyTaskResult(result, mserivceInfo);
                itertor.remove();
            }
        }
    }

    public int serviceQueueSize(String serviceFlag) {
        PriorityBlockingQueue<Task> serviceQueue = this.serviceQueueMap.get(serviceFlag);
        if (serviceQueue != null) {
            return serviceQueue.size();
        }
        return 0;
    }

    public static class TaskCompare
    implements Comparator<Task> {
        @Override
        public int compare(Task task1, Task task2) {
            if (task1.getServiceId() > task2.getServiceId()) {
                return 1;
            }
            if (task1.getServiceId() < task2.getServiceId()) {
                return -1;
            }
            if (task1.getPriority() > task2.getPriority()) {
                return 1;
            }
            if (task1.getPriority() < task2.getPriority()) {
                return -1;
            }
            return task1.getCreateTime().compareTo(task2.getCreateTime());
        }
    }
}

