/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.xml.bind.DatatypeConverter;
import kd.ai.aicc.core.Utils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.codec.digest.DigestUtils;

public class TencentAuthUtils {
    private static final Log logger = LogFactory.getLog(TencentAuthUtils.class);

    public static Map<String, String> authHeaderV1(String urlString, String secretKey, JSONObject requestBody) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            logger.error("url\u683c\u5f0f\u5316\u9519\u8bef" + e.getMessage());
            throw new KDBizException("url\u683c\u5f0f\u5316\u9519\u8bef" + e.getMessage());
        }
        String host = url.getHost();
        String path = url.getPath();
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("app_id", String.valueOf(requestBody.getString("app_id")));
        params.put("secret_id", String.valueOf(requestBody.getString("secret_id")));
        params.put("query_id", String.valueOf(requestBody.getString("query_id")));
        params.put("temperature", BigDecimal.valueOf(requestBody.getDouble("temperature")).stripTrailingZeros().toPlainString());
        params.put("top_p", BigDecimal.valueOf(requestBody.getDouble("top_p")).stripTrailingZeros().toPlainString());
        params.put("stream", String.valueOf(requestBody.getString("stream")));
        JSONArray messages = requestBody.getJSONArray("messages");
        StringBuilder messageStr = new StringBuilder();
        for (int i = 0; i < messages.size(); ++i) {
            JSONObject message = messages.getJSONObject(i);
            String string = message.getString("role");
            String content = message.getString("content");
            messageStr.append("{\"role\":\"").append(string).append("\",\"content\":\"").append(content).append("\"},");
        }
        messageStr.deleteCharAt(messageStr.length() - 1);
        params.put("messages", "[" + messageStr + ']');
        params.put("timestamp", String.valueOf(requestBody.getString("timestamp")));
        params.put("expired", String.valueOf(requestBody.getString("expired")));
        StringBuilder signStr = new StringBuilder(host).append(path).append('?');
        for (Map.Entry entry : params.entrySet()) {
            signStr.append((String)entry.getKey()).append('=').append((String)entry.getValue()).append('&');
        }
        signStr = new StringBuilder(signStr.substring(0, signStr.length() - 1));
        String signature = Utils.base64HmacSha1(signStr.toString(), secretKey);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/json");
        hashMap.put("Authorization", signature);
        return hashMap;
    }

    public static Map<String, String> authHeaderV3(String urlString, String secretId, String secretKey, JSONObject requestBody, String version, String action) throws Exception {
        URL url;
        String service = "hunyuan";
        String algorithm = "TC3-HMAC-SHA256";
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            logger.error("url\u683c\u5f0f\u5316\u9519\u8bef" + e.getMessage());
            throw new KDBizException("url\u683c\u5f0f\u5316\u9519\u8bef" + e.getMessage());
        }
        String host = url.getHost();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = sdf.format(new Date(Long.parseLong(timestamp + "000")));
        String httpRequestMethod = "POST";
        String canonicalUri = "/";
        String canonicalQueryString = "";
        String contentType = "application/json";
        String canonicalHeaders = "content-type:" + contentType + "\nhost:" + host + "\nx-tc-action:" + action.toLowerCase() + "\n";
        String signedHeaders = "content-type;host;x-tc-action";
        String payload = requestBody.toString();
        String hashedRequestPayload = DigestUtils.sha256Hex((String)payload);
        String canonicalRequest = httpRequestMethod + "\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + hashedRequestPayload;
        String credentialScope = date + "/" + service + "/tc3_request";
        String hashedCanonicalRequest = DigestUtils.sha256Hex((String)canonicalRequest);
        String stringToSign = algorithm + "\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
        byte[] secretDate = Utils.hmacSHA256(date, ("TC3" + secretKey).getBytes("UTF-8"));
        byte[] secretService = Utils.hmacSHA256(service, secretDate);
        byte[] secretSigning = Utils.hmacSHA256("tc3_request", secretService);
        String signature = DatatypeConverter.printHexBinary((byte[])Utils.hmacSHA256(stringToSign, secretSigning)).toLowerCase();
        String authorization = algorithm + " Credential=" + secretId + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("Content-Type", contentType);
        headers.put("Host", host);
        headers.put("X-TC-Action", action);
        headers.put("X-TC-Timestamp", timestamp);
        headers.put("X-TC-Version", version);
        headers.put("Authorization", authorization);
        return headers;
    }
}

