/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.ai.aicc.core.AWSV4Utils;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.DeployMethod;
import kd.ai.aicc.core.TencentAuthUtils;
import kd.ai.aicc.core.domain.Config;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Task;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final int CONNECTION_REQUEST_TIMEOUT = 300000;
    private static final int CONNECTION_TIMEOUT = 30000;
    private static final int SOCKET_TIMEOUT = 300000;
    private static final int RETRY_COUNT = 3;
    private static final int MAX_CONN_TOTAL = 1000;
    private static final int MAX_CONN_PER_ROUTE = 1000;
    private static final RequestConfig REQUEST_CONFIG = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(300000).build();

    private Utils() {
    }

    public static CloseableHttpClient getClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultRequestConfig(REQUEST_CONFIG);
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true));
        return httpClientBuilder.build();
    }

    public static String getProdInstCode() {
        Map info = LicenseServiceHelper.getProductInfo();
        return (String)info.get("prodInstCode");
    }

    public static String getTenantID() {
        String tenantId = RequestContext.get().getTenantId();
        String jsonStr = System.getProperty("mc.tenant.ids");
        if (StringUtils.isEmpty((String)jsonStr)) {
            return tenantId;
        }
        JSONArray jsonArray = JSON.parseArray((String)jsonStr);
        if (jsonArray == null) {
            return tenantId;
        }
        String tenantNum = RequestContext.get().getTenantCode();
        if (tenantNum == null) {
            return tenantId;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!tenantNum.equals(jsonObject.getString("tenantnumber"))) continue;
            String val = jsonArray.getJSONObject(i).getString("tenantid");
            if (!StringUtils.isNotEmpty((String)val)) break;
            return val;
        }
        return tenantId;
    }

    public static String base64HmacSha1(String originalText, String secretKey) {
        String encode = "UTF-8";
        String signType = "HmacSHA1";
        try {
            Mac hmac = Mac.getInstance(signType);
            hmac.init(new SecretKeySpec(secretKey.getBytes(encode), signType));
            byte[] hash = hmac.doFinal(originalText.getBytes(encode));
            return Base64.encodeBase64String((byte[])hash);
        }
        catch (Exception e) {
            log.error("\u7b7e\u540d\u9519\u8bef", (Throwable)e);
            throw new KDBizException("\u7b7e\u540d\u9519\u8bef" + e.getMessage());
        }
    }

    public static String hmacSHA256(String plainText, String key, Charset charset) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] keyBytes = key.getBytes(charset);
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(signingKey);
        return Utils.bytesToHex(mac.doFinal(plainText.getBytes(charset)));
    }

    public static byte[] hmacSHA256(String data, byte[] key) throws Exception {
        Mac sha256Hmac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA256");
        sha256Hmac.init(secretKey);
        return sha256Hmac.doFinal(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    public static void openApiSign(HttpUriRequest httpPost, String requestParamStr, String secretKey, String proxyUserSecretKey) {
        httpPost.addHeader("OpenApiAuth", "2");
        httpPost.addHeader("openApiSign", proxyUserSecretKey);
        String nonce = UUID.randomUUID().toString();
        httpPost.addHeader("signatureNonce", nonce);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = simpleDateFormat.format(new Date());
        httpPost.addHeader("timestamp", timestamp);
        try {
            String signature = Utils.hmacSHA256(String.format("%s%s%s", requestParamStr, timestamp, nonce), secretKey, StandardCharsets.ISO_8859_1);
            httpPost.addHeader("signature", signature);
        }
        catch (Exception e) {
            throw new KDBizException(Constant.HMACSHA256_ERROR, new Object[0]);
        }
    }

    public static void oAuth2Token(HttpUriRequest httpPost, String secretKey) {
        httpPost.addHeader("Authorization", String.format("Bearer %s", secretKey));
    }

    public static void azureApiKeyToken(HttpUriRequest httpPost, String secretKey) {
        httpPost.addHeader("api-key", secretKey);
    }

    public static void awsSignV4(HttpUriRequest httpPost, String ak, String sk, String payload) {
        String url = httpPost.getURI().toString();
        Map<String, String> headers = AWSV4Utils.authHeader(url, ak, sk, payload);
        for (Map.Entry<String, String> item : headers.entrySet()) {
            httpPost.addHeader(item.getKey(), item.getValue());
        }
    }

    public static void getKingdeeHeader(HttpUriRequest httpPost, String secretKey, String requestBody) {
        httpPost.addHeader("Authorization", String.format("Bearer %s", secretKey));
        String nonce = UUID.randomUUID().toString();
        httpPost.addHeader("signatureNonce", nonce);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = simpleDateFormat.format(new Date());
        RequestContext rc = RequestContext.get();
        String tenantId = rc.getTenantId();
        String tenantName = null;
        try {
            tenantName = URLEncoder.encode(rc.getTenantCode(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            log.error("header\u5934\u4fe1\u606f\u4e2d\u6587\u8f6c\u7801\u5f02\u5e38");
            e.printStackTrace();
        }
        httpPost.addHeader("tenantId", tenantId);
        httpPost.addHeader("tenantName", tenantName);
        httpPost.addHeader("timestamp", timestamp);
        httpPost.addHeader("secretKey", secretKey);
        try {
            String signature = Utils.hmacSHA256(String.format("%s%s%s", requestBody, timestamp, nonce), secretKey, StandardCharsets.UTF_8);
            httpPost.addHeader("signature", signature);
        }
        catch (Exception e) {
            throw new KDBizException(Constant.HMACSHA256_ERROR, new Object[0]);
        }
    }

    public static void awsSignV4(HttpPost request, Instance instance, Task task, String requestBody) {
        if (instance.getService().getNumber().equals("AWS_ANTHROPIC_CLAUDE_MESSAGES")) {
            String modelId = instance.getContextUrl();
            String contextUrl = "";
            contextUrl = task.isStream() && instance.getService().isSupportStream() ? String.format("/model/%s/invoke-with-response-stream", modelId) : String.format("/model/%s/invoke", modelId);
            String url = String.format("%s://%s:%s%s", instance.getProtocol().toLowerCase(Locale.ENGLISH), instance.getHost(), instance.getPort(), contextUrl);
            request.setURI(URI.create(url));
        }
        Utils.awsSignV4((HttpUriRequest)request, instance.getClientId(), instance.getSecretKey(), requestBody);
    }

    public static String tencentAuthV1(HttpUriRequest httpPost, String appIdString, String secretId, String secretKey, String payload) {
        Long appId = StringUtils.isEmpty((String)appIdString) ? 0L : Long.parseLong(appIdString);
        if (appId == 0L) {
            appId = 1318573568L;
        }
        if (StringUtils.isEmpty((String)secretId) || StringUtils.isEmpty((String)secretKey)) {
            log.error("auth\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a(appId\u3001secretId\u3001secretKey)");
            throw new KDBizException("auth\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject requestBody = JSON.parseObject((String)payload);
        requestBody.put("app_id", (Object)appId);
        requestBody.put("secret_id", (Object)secretId);
        long timestamp = System.currentTimeMillis() / 1000L + 10000L;
        requestBody.put("timestamp", (Object)timestamp);
        requestBody.put("expired", (Object)(timestamp + 86400L));
        String url = httpPost.getURI().toString();
        Map<String, String> headers = TencentAuthUtils.authHeaderV1(url, secretKey, requestBody);
        for (Map.Entry<String, String> item : headers.entrySet()) {
            httpPost.addHeader(item.getKey(), item.getValue());
        }
        log.info("tencent:requestBody{}", (Object)requestBody);
        return requestBody.toString();
    }

    public static String tencentAuthV3(HttpUriRequest httpPost, String secretId, String secretKey, String payload) {
        if (StringUtils.isEmpty((String)secretId) || StringUtils.isEmpty((String)secretKey)) {
            log.error("auth\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a(secretId\u3001secretKey)");
            throw new KDBizException("auth\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject requestBody = JSON.parseObject((String)payload);
        String url = httpPost.getURI().toString();
        String version = "2023-09-01";
        String action = "ChatCompletions";
        Map<String, String> headers = null;
        try {
            headers = TencentAuthUtils.authHeaderV3(url, secretId, secretKey, requestBody, version, action);
        }
        catch (Exception e) {
            log.error("tencentV3\u6784\u5efa\u8ba4\u8bc1\u5931\u8d25", (Throwable)e);
            return null;
        }
        for (Map.Entry<String, String> item : headers.entrySet()) {
            httpPost.addHeader(item.getKey(), item.getValue());
        }
        log.info("tencentV3:requestBody{}", (Object)requestBody);
        return requestBody.toString();
    }

    public static Map<String, Object> api2PostRequest(Config config, String contextUrl, String requestBodyStr) {
        HttpPost httpPost = new HttpPost();
        String host = config.getPublicCloudServerUrl();
        String url = String.format("%s%s", host, contextUrl);
        httpPost.setURI(URI.create(url));
        httpPost.setEntity((HttpEntity)new StringEntity(requestBodyStr, ContentType.APPLICATION_JSON));
        Utils.openApiSign((HttpUriRequest)httpPost, "", config.getSecretKey(), config.getProxyUserSecretKey());
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (CloseableHttpResponse httpResponse = Utils.getClient().execute((HttpUriRequest)httpPost);){
            int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            String resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (200 == httpStatusCode && !resp.startsWith("<!doctype html>")) {
                JSONObject resultObj = JSON.parseObject((String)resp);
                String errCode = resultObj.getString("errorCode");
                result.put("errorCode", errCode);
                if (!"0".equalsIgnoreCase(errCode)) {
                    result.put("message", resultObj.getString("message"));
                } else {
                    result.put("data", resultObj.get((Object)"data"));
                }
            } else {
                String errMsg = String.format("httpcode:%s,message:%s", httpStatusCode, resp);
                ErrorCode errorCode = Constant.httpError(url, errMsg);
                result.put("errorCode", errorCode.getCode());
                result.put("message", errorCode.getMessage());
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
            ErrorCode errorCode = Constant.httpError(url, e.getMessage());
            result.put("errorCode", errorCode.getCode());
            result.put("message", errorCode.getMessage());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postByUrlEncodedForm(String url, Map<String, String> headerMap, Map<String, String> bodyMap) {
        HttpPost httppost = new HttpPost(url);
        if (headerMap == null) {
            headerMap = new HashMap<String, String>();
        }
        headerMap.put("User-Agent", "java/ai");
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            httppost.setHeader(entry.getKey(), entry.getValue());
        }
        if (bodyMap != null) {
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : bodyMap.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                pairList.add(pair);
            }
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(pairList, StandardCharsets.UTF_8);
            httppost.setEntity((HttpEntity)urlEncodedFormEntity);
        }
        try {
            Throwable throwable = null;
            try (CloseableHttpResponse response = Utils.getClient().execute((HttpUriRequest)httppost);){
                HttpEntity httpEntity = response.getEntity();
                String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                return string;
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new KDBizException(Constant.httpError(url, e.getMessage()), new Object[0]);
        }
    }

    public static String doGet(String url, Map<String, String> headerMap) {
        String result;
        block16: {
            HttpGet httpGet;
            try {
                URIBuilder uriBuilder = new URIBuilder(url);
                httpGet = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException e) {
                log.error("url\u7ec4\u88c5\u9519\u8bef", (Throwable)e);
                throw new KDBizException("url\u7ec4\u88c5\u9519\u8bef");
            }
            CloseableHttpResponse response = null;
            result = "";
            if (headerMap == null) {
                headerMap = new HashMap<String, String>();
            }
            headerMap.put("User-Agent", "java/ai");
            for (Map.Entry<String, String> item : headerMap.entrySet()) {
                httpGet.setHeader(item.getKey(), item.getValue());
            }
            try {
                HttpEntity entity;
                response = Utils.getClient().execute((HttpUriRequest)httpGet);
                int httpCode = response.getStatusLine().getStatusCode();
                if (httpCode == 200) {
                    entity = response.getEntity();
                    if (entity == null) {
                        log.error("\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a" + response);
                        throw new KDBizException(Constant.httpError(url, "http get return null"), new Object[0]);
                    }
                    result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                    EntityUtils.consume((HttpEntity)entity);
                    break block16;
                }
                entity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                EntityUtils.consume((HttpEntity)entity);
                log.error("http err code {} ,result {}", (Object)httpCode, (Object)result);
                throw new KDBizException(Constant.httpError(url, "http get http code" + httpCode), new Object[0]);
            }
            catch (IOException e) {
                log.error((Throwable)e);
                throw new KDBizException(Constant.httpError(url, "http get io exception " + e.getMessage()), new Object[0]);
            }
            finally {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        log.error("http get response close err", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public static DeployMethod checkLicenseType() {
        return DeployMethod.PRIVATE_CLOUND;
    }
}

