/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.XfWebSocketRunner;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.Task;
import kd.ai.aicc.core.util.EngineCacheUtil;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class XfWebSocketTestRunner
extends XfWebSocketRunner {
    private final Log logger = LogFactory.getLog(XfWebSocketTestRunner.class);
    private final LocalMemoryCache localCache = EngineCacheUtil.getLocalCache("aicc");

    @Override
    public void onMessage() throws InterruptedException {
        this.logger.info("\u6d4b\u8bd5ws\u63a5\u6536\u6d88\u606f\u5f00\u59cb");
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 300000L) {
            String text = (String)this.messageQueue.poll(100L, TimeUnit.MILLISECONDS);
            while (text != null) {
                if (text.startsWith("ERROR:")) {
                    this.onError(text.substring("ERROR:".length()));
                    return;
                }
                int status = this.processMessage(text);
                if (status == 2 || status == 9) {
                    return;
                }
                text = (String)this.messageQueue.poll(100L, TimeUnit.MILLISECONDS);
            }
        }
        if (System.currentTimeMillis() - startTime > 300000L) {
            ErrorCode errorCode = Constant.taskTimeOutError(String.valueOf(this.taskRunner.getTask().getId()));
            this.taskRunner.execTaskFailed(errorCode.getCode(), errorCode.getMessage(), this.taskRunner.getMsInfoObj());
        }
    }

    @Override
    public void onError(String errorMsg) {
        Instance atInstance = this.taskRunner.getAtInstance();
        Task task = this.taskRunner.getTask();
        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
            ErrorCode errorCode = Constant.connectXfError(atInstance.getModelUrl());
            errorMsg = errorCode.getMessage();
        }
        this.putMsg(task, "error", errorMsg);
    }

    private void onSucc() {
        Task task = this.taskRunner.getTask();
        this.putMsg(task, "success", "");
    }

    private void putMsg(Task task, String status, String errorMsg) {
        String wsTag = "wsTest_" + task.getId();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("result", status);
        map.put("errMsg", errorMsg);
        this.localCache.put(wsTag, (Object)JSON.toJSONString(map));
    }

    private int processMessage(String text) {
        try {
            JSONObject responseObj = JSON.parseObject((String)text);
            JSONObject header = responseObj.getJSONObject("header");
            int code = header.getIntValue("code");
            String message = header.getString("message");
            if (code == 0) {
                int status = header.getIntValue("status");
                JSONArray textArr = responseObj.getJSONObject("payload").getJSONObject("choices").getJSONArray("text");
                StringBuilder textSb = new StringBuilder();
                for (int i = 0; i < textArr.size(); ++i) {
                    textSb.append(textArr.getJSONObject(i).getString("content"));
                }
                this.logger.info("\u6d4b\u8bd5ws\u6d88\u606f\uff1a{}", (Object)textSb.toString());
                if (status == 2) {
                    this.onSucc();
                    return 2;
                }
                return 0;
            }
            this.onError(message);
            return 9;
        }
        catch (Exception e) {
            this.logger.error(String.format("xunfei task id : %s ,error : %s", this.taskRunner.getTask().getId(), e.getMessage()), (Throwable)e);
            ErrorCode errorCode = Constant.internalError(e.getMessage());
            this.onError(errorCode.getMessage());
            return 9;
        }
    }
}

