/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.dao;

import kd.ai.aicc.core.Constant;
import kd.ai.aicc.core.domain.Config;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ConfigDao {
    public static final String ENTITY_NAME = "aicc_config";
    public static final long CONFIG_ID = 1767599069259225288L;

    private ConfigDao() {
    }

    public static Config getConfig() {
        String properties = String.format("%s,%s,%s,%s", "id", "publiccloudserverurl", "secretkey", "usersecretkey");
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)1767599069259225288L, (String)ENTITY_NAME, (String)properties);
        if (obj == null) {
            throw new KDBizException(Constant.CONFIG_NOT_INIT_ERROR, new Object[0]);
        }
        Config config = new Config();
        config.setId(1767599069259225288L);
        config.setPublicCloudServerUrl(obj.getString("publiccloudserverurl"));
        String secretKey = obj.getString("secretkey");
        config.setSecretKey(Encrypters.decode((String)secretKey));
        config.setProxyUserSecretKey(Encrypters.decode((String)obj.getString("usersecretkey")));
        return config;
    }

    public static void saveConfig(Config config) {
        DynamicObject obj = ConfigDao.toObj(config);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    public static void updateConfig(Config config) {
        DynamicObject obj = ConfigDao.toObj(config);
        SaveServiceHelper.update((DynamicObject)obj);
    }

    public static DynamicObject toObj(Config config) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        obj.set("id", (Object)1767599069259225288L);
        obj.set("publiccloudserverurl", (Object)config.getPublicCloudServerUrl());
        obj.set("secretkey", (Object)Encrypters.encode((String)config.getSecretKey()));
        obj.set("usersecretkey", (Object)Encrypters.encode((String)config.getProxyUserSecretKey()));
        return obj;
    }
}

