/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.dao;

import java.util.ArrayList;
import java.util.List;
import kd.ai.aicc.core.AuthorizationType;
import kd.ai.aicc.core.domain.Instance;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class InstanceDao {
    public static final String INSTANCE_ENTITY_NAME = "aicc_instance";
    private static final Log log = LogFactory.getLog(InstanceDao.class);

    private InstanceDao() {
    }

    public static List<Instance> queryAllInstance() {
        return InstanceDao.queryInstanceByServiceIdList(null);
    }

    public static List<Instance> getServiceInstances(long serviceId) {
        String properties = String.format("%s,%s,%s,%s,%s,%s,%s.id,%s,%s,%s", "name", "maxparallel", "modelurl", "authurl", "service", "authtype", "clientid", "secretkey", "usersecretkey", "paralleltype");
        QFilter filterStatus = new QFilter("enable", "=", (Object)"1");
        QFilter filterService = new QFilter("service", "=", (Object)serviceId);
        DynamicObject[] instanceObjs = BusinessDataServiceHelper.load((String)INSTANCE_ENTITY_NAME, (String)properties, (QFilter[])new QFilter[]{filterService, filterStatus});
        ArrayList<Instance> instanceList = new ArrayList<Instance>(instanceObjs.length);
        for (DynamicObject obj : instanceObjs) {
            String proxyUserSecretKey;
            String secretKey;
            Instance instance = new Instance();
            instance.setId(obj.getLong("id"));
            instance.setModelUrl(obj.getString("modelurl"));
            instance.setAuthUrl(obj.getString("authurl"));
            instance.setMaxParallel(obj.getInt("maxparallel"));
            instance.setParallelType(obj.getString("paralleltype"));
            instance.setAuthType(AuthorizationType.parse(obj.getString("authtype")));
            String clientId = obj.getString("clientid");
            if (StringUtils.isNotEmpty((String)clientId)) {
                instance.setClientId(Encrypters.decode((String)clientId));
            }
            if (StringUtils.isNotEmpty((String)(secretKey = obj.getString("secretkey")))) {
                instance.setSecretKey(Encrypters.decode((String)secretKey));
            }
            if (StringUtils.isNotEmpty((String)(proxyUserSecretKey = obj.getString("usersecretkey")))) {
                instance.setProxyUserSecretKey(Encrypters.decode((String)proxyUserSecretKey));
            }
            instance.setServiceId(obj.getLong(String.format("%s.id", "service")));
            instanceList.add(instance);
        }
        return instanceList;
    }

    public static List<Instance> queryInstanceByServiceIdList(List<Long> idList) {
        String properties = String.format("%s,%s,%s,%s,%s,%s,%s.id,%s,%s,%s", "name", "maxparallel", "modelurl", "authurl", "service", "authtype", "clientid", "secretkey", "usersecretkey", "paralleltype");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("enable", "=", (Object)"1");
        filters.add(filterStatus);
        if (idList != null && !idList.isEmpty()) {
            QFilter filter2 = new QFilter("service", "in", idList);
            filters.add(filter2);
        }
        DynamicObject[] instanceObjs = BusinessDataServiceHelper.load((String)INSTANCE_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Instance> instanceList = new ArrayList<Instance>(instanceObjs.length);
        for (DynamicObject obj : instanceObjs) {
            String proxyUserSecretKey;
            String secretKey;
            Instance instance = new Instance();
            instance.setId(obj.getLong("id"));
            instance.setMaxParallel(obj.getInt("maxparallel"));
            instance.setParallelType(obj.getString("paralleltype"));
            instance.setModelUrl(obj.getString("modelurl"));
            instance.setAuthUrl(obj.getString("authurl"));
            instance.setAuthType(AuthorizationType.parse(obj.getString("authtype")));
            String clientId = obj.getString("clientid");
            if (StringUtils.isNotEmpty((String)clientId)) {
                instance.setClientId(Encrypters.decode((String)clientId));
            }
            if (StringUtils.isNotEmpty((String)(secretKey = obj.getString("secretkey")))) {
                instance.setSecretKey(Encrypters.decode((String)secretKey));
            }
            if (StringUtils.isNotEmpty((String)(proxyUserSecretKey = obj.getString("usersecretkey")))) {
                instance.setProxyUserSecretKey(Encrypters.decode((String)proxyUserSecretKey));
            }
            instance.setServiceId(obj.getLong(String.format("%s.id", "service")));
            InstanceDao.decryptedInstanceData(instance);
            instanceList.add(instance);
        }
        return instanceList;
    }

    public static void decryptedInstanceData(Instance instance) {
        String clientId = instance.getClientId();
        String secretKey = instance.getSecretKey();
        String userSecretKey = instance.getProxyUserSecretKey();
        if (StringUtils.isNotEmpty((String)clientId) && Encrypters.isEncrypted((String)clientId)) {
            instance.setClientId(Encrypters.decode((String)clientId));
        }
        if (StringUtils.isNotEmpty((String)secretKey) && Encrypters.isEncrypted((String)secretKey)) {
            instance.setSecretKey(Encrypters.decode((String)secretKey));
        }
        if (StringUtils.isNotEmpty((String)userSecretKey) && Encrypters.isEncrypted((String)userSecretKey)) {
            instance.setProxyUserSecretKey(Encrypters.decode((String)userSecretKey));
        }
    }

    public static Instance queryInstanceById(Long id) {
        String proxyUserSecretKey;
        String secretKey;
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)INSTANCE_ENTITY_NAME);
        Instance instance = new Instance();
        instance.setId(obj.getLong("id"));
        instance.setModelUrl(obj.getString("modelurl"));
        instance.setAuthUrl(obj.getString("authurl"));
        instance.setMaxParallel(obj.getInt("maxparallel"));
        instance.setParallelType(obj.getString("paralleltype"));
        instance.setAuthType(AuthorizationType.parse(obj.getString("authtype")));
        String clientId = obj.getString("clientid");
        if (StringUtils.isNotEmpty((String)clientId)) {
            instance.setClientId(Encrypters.decode((String)clientId));
        }
        if (StringUtils.isNotEmpty((String)(secretKey = obj.getString("secretkey")))) {
            instance.setSecretKey(Encrypters.decode((String)secretKey));
        }
        if (StringUtils.isNotEmpty((String)(proxyUserSecretKey = obj.getString("usersecretkey")))) {
            instance.setProxyUserSecretKey(Encrypters.decode((String)proxyUserSecretKey));
        }
        instance.setServiceId(obj.getLong(String.format("%s.id", "service")));
        return instance;
    }
}

