/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.aicc.core.AuthorizationType;
import kd.ai.aicc.core.dao.InstanceDao;
import kd.ai.aicc.core.domain.BaseModelInfo;
import kd.ai.aicc.core.domain.Instance;
import kd.ai.aicc.core.domain.ModelTagEnum;
import kd.ai.aicc.core.domain.Service;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class ServiceDao {
    private static Log logger = LogFactory.getLog(ServiceDao.class);
    public static final String SERVICE_ENTITY_NAME = "aicc_service";
    public static final String modelType = "modeltype";

    private ServiceDao() {
    }

    public static Service getService(String serviceNumber) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter serviceNumberFilter = new QFilter("number", "=", (Object)serviceNumber);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(enableFilter);
        qFilters.add(serviceNumberFilter);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)SERVICE_ENTITY_NAME, (QFilter[])qFilters.toArray(new QFilter[0]));
        if (obj != null) {
            return ServiceDao.findOnlyOneService(obj);
        }
        return null;
    }

    public static Service getService(long serviceId) {
        String enable;
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)serviceId, (String)SERVICE_ENTITY_NAME);
        if (obj == null) {
            logger.warn("\u7f13\u5b58\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230service\uff0c\u4ece\u8868\u4e2d\u53d6,serviceid:{}", (Object)serviceId);
            obj = BusinessDataServiceHelper.loadSingle((Object)serviceId, (String)SERVICE_ENTITY_NAME);
        }
        if (obj != null && (enable = obj.getString("enable")).equals("1")) {
            return ServiceDao.findOnlyOneService(obj);
        }
        return null;
    }

    private static Service findOnlyOneService(DynamicObject obj) {
        Service service = new Service();
        service.setId(obj.getLong("id"));
        service.setNumber(obj.getString("number"));
        service.setName(obj.getString("name"));
        service.setSupportStream(obj.getBoolean("supportstream"));
        service.setModelType(obj.getString(modelType));
        service.setQueueLength(obj.getInt("queuelength"));
        service.setWaitTime(obj.getInt("waittime"));
        service.setModelConfig(obj.getString("configmodel"));
        DynamicObjectCollection instanceCollection = (DynamicObjectCollection)obj.get("entryentity");
        ArrayList<Instance> serviceInstances = new ArrayList<Instance>(instanceCollection.size());
        for (DynamicObject instanceObj : instanceCollection) {
            String proxyUserSecretKey;
            String secretKey;
            String enable = instanceObj.getString("instanceenable");
            if (!enable.equals("true")) continue;
            Instance instance = new Instance();
            instance.setId(instanceObj.getLong("id"));
            instance.setModelUrl(instanceObj.getString("modelurl"));
            instance.setAuthUrl(instanceObj.getString("authurl"));
            instance.setMaxParallel(instanceObj.getInt("maxparallel"));
            instance.setParallelType(instanceObj.getString("paralleltype"));
            instance.setAuthType(AuthorizationType.parse(instanceObj.getString("authtype")));
            instance.setCustomHeader(instanceObj.getString("customheader"));
            instance.setCustomParam(instanceObj.getString("customparam"));
            String clientId = instanceObj.getString("clientid");
            if (StringUtils.isNotEmpty((String)clientId)) {
                instance.setClientId(Encrypters.decode((String)clientId));
            }
            if (StringUtils.isNotEmpty((String)(secretKey = instanceObj.getString("secretkey")))) {
                instance.setSecretKey(Encrypters.decode((String)secretKey));
            }
            if (StringUtils.isNotEmpty((String)(proxyUserSecretKey = instanceObj.getString("usersecretkey")))) {
                instance.setProxyUserSecretKey(Encrypters.decode((String)proxyUserSecretKey));
            }
            instance.setServiceId(instanceObj.getLong(String.format("%s.id", "service")));
            instance.setService(service);
            serviceInstances.add(instance);
        }
        service.setInstances(serviceInstances);
        return service;
    }

    public static List<Service> getModelList(String modelType) {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "in", (Object)"1"), new QFilter(modelType, "=", (Object)modelType), new QFilter("isvisible", "=", (Object)"1")};
        String properties = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "id", "number", "name", modelType, "llmtype", "servicetag", "requestsample_tag", "responsesample_tag", "supportstream", "promptids_tag", "processids_tag", "agentids_tag");
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)SERVICE_ENTITY_NAME, (String)properties, (QFilter[])filters);
        ArrayList<Service> services = new ArrayList<Service>(dynamicObjectArray.length);
        ArrayList<Long> serviceIdList = new ArrayList<Long>();
        List<Instance> instances = InstanceDao.queryInstanceByServiceIdList(serviceIdList);
        Map<String, List<BaseModelInfo>> modelTagsRef = ServiceDao.getModelTags(Arrays.asList(dynamicObjectArray));
        for (DynamicObject obj : dynamicObjectArray) {
            serviceIdList.add(obj.getLong("id"));
            Service service = new Service();
            service.setId(obj.getLong("id"));
            service.setNumber(obj.getString("number"));
            service.setName(obj.getString("name"));
            service.setModelType(obj.getString(modelType));
            service.setPromptIdsTag(obj.getString("promptids_tag"));
            service.setProcessIdsTag(obj.getString("processids_tag"));
            service.setAgentIdsTag(obj.getString("agentids_tag"));
            DynamicObject dynamicObject = (DynamicObject)obj.get("llmtype");
            if (dynamicObject != null) {
                service.setLlmType(dynamicObject.getString("number"));
                List<BaseModelInfo> baseModelInfos = modelTagsRef.get(String.valueOf(obj.getLong("id")));
                if (baseModelInfos != null && !baseModelInfos.isEmpty()) {
                    service.setLlmModelInfo(baseModelInfos);
                }
            }
            service.setSupportStream(obj.getBoolean("supportstream"));
            service.setRequestSample(obj.getString("requestsample_tag"));
            service.setResponseSample(obj.getString("responsesample_tag"));
            services.add(service);
            ArrayList<Instance> serviceInstances = new ArrayList<Instance>();
            for (Instance instance : instances) {
                if (service.getId() != instance.getServiceId()) continue;
                instance.setService(service);
                serviceInstances.add(instance);
            }
            service.setInstances(serviceInstances);
        }
        return services;
    }

    private static Map<String, List<BaseModelInfo>> getModelTags(List<DynamicObject> serviceObjs) {
        HashMap<String, List<BaseModelInfo>> map = new HashMap<String, List<BaseModelInfo>>(16);
        if (serviceObjs != null && !serviceObjs.isEmpty()) {
            for (DynamicObject serviceObj : serviceObjs) {
                String servicePKStr = String.valueOf(serviceObj.getPkValue());
                String servicetag = serviceObj.getString("servicetag");
                if (StringUtils.isNotEmpty((String)servicetag)) {
                    map.put(servicePKStr, ServiceDao.buildModelInfo(servicetag));
                    continue;
                }
                map.put(servicePKStr, new ArrayList(1));
            }
        }
        return map;
    }

    private static List<BaseModelInfo> buildModelInfo(String tagStrs) {
        ArrayList<BaseModelInfo> list = new ArrayList<BaseModelInfo>(16);
        if (StringUtils.isNotEmpty((String)tagStrs)) {
            String[] split;
            for (String str : split = tagStrs.split(",")) {
                ModelTagEnum tagEnum = ModelTagEnum.getTagNameByValue(str);
                if (tagEnum == null) continue;
                BaseModelInfo baseModelInfo = new BaseModelInfo();
                baseModelInfo.setTagKey(tagEnum.getTagKey());
                baseModelInfo.setTagName(tagEnum.getTagName());
                list.add(baseModelInfo);
            }
        }
        return list;
    }
}

