/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.aicc.core.DataManager;
import kd.ai.aicc.core.Queue;
import kd.ai.aicc.core.RequestParameter;
import kd.ai.aicc.core.TaskResult;
import kd.ai.aicc.core.TaskStatusEnum;
import kd.ai.aicc.core.domain.Service;
import kd.ai.aicc.core.domain.Task;
import kd.ai.aicc.core.domain.Tenant;
import kd.ai.aicc.core.domain.enuz.ModelType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class TaskDao {
    public static final int TOP_TASK_COUNT = 500;
    public static final int DEFAULT_QUEUE_LENGTH = 200;
    public static final String TASK_ENTITY_NAME = "aicc_task";
    public static final String TASK_TABLE_NAME = "t_aicc_task";
    public static final String TASK_HISTORY_ENTITY_NAME = "aicc_task_history";
    public static Log logger = LogFactory.getLog(TaskDao.class);

    private TaskDao() {
    }

    public static long genTaskID() {
        return DB.genLongId((String)TASK_TABLE_NAME);
    }

    public static Task saveRequestAsTask(long taskId, RequestParameter parameter, boolean isAsync, Queue queue) {
        Task task = TaskDao.convert2Task(taskId, parameter, isAsync);
        String accountId = RequestContext.get().getAccountId();
        task.setAccountId(accountId);
        Tenant tenant = DataManager.getInstance().findTenantByCqTenantIdAndProdInstId(accountId, parameter.getTenantId(), parameter.getProdInstCode());
        task.setTenant(tenant);
        Service service = DataManager.getInstance().findServiceByNumber(accountId, parameter.getServiceNumber());
        task.setService(service);
        if (service != null && service.getModelType().equals(ModelType.LLM.getValue())) {
            int queueLength;
            String serviceFlag = queue.getServiceFlag(task);
            int queueSize = queue.serviceQueueSize(serviceFlag);
            int n = queueLength = service.getQueueLength() == 0 ? 200 : service.getQueueLength();
            if (queueSize > queueLength) {
                task.setStatusEnum(TaskStatusEnum.OUTLIMIT);
            }
        }
        TaskDao.saveTask(task);
        return task;
    }

    public static Task convert2Task(long taskId, RequestParameter parameter, boolean isAsync) {
        Task task = new Task();
        task.setId(taskId);
        if (parameter.getContext() != null && parameter.getContext().isEncrypt()) {
            task.setRequestBody(Encrypters.encode((String)parameter.getServiceParams()));
        } else {
            task.setRequestBody(parameter.getServiceParams());
        }
        if (parameter.getContext() != null) {
            task.setPriority(parameter.getContext().getPriority());
        } else {
            task.setPriority(1);
        }
        if (isAsync && parameter.getContext() != null) {
            task.setStream(parameter.getContext().isStream());
        }
        task.setAsyncTask(isAsync);
        task.setStatusEnum(TaskStatusEnum.CREATE);
        Date createTime = new Date();
        task.setCreateTime(createTime);
        task.setLastUpdateTime(createTime);
        return task;
    }

    public static void saveTask(Task task) {
        if (QueryServiceHelper.exists((String)TASK_ENTITY_NAME, (Object)task.getId())) {
            return;
        }
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_ENTITY_NAME);
        taskObj.set("id", (Object)task.getId());
        taskObj.set("createtime", (Object)task.getCreateTime());
        taskObj.set("lastupdatetime", (Object)task.getLastUpdateTime());
        taskObj.set("status", (Object)task.getStatusEnum().getValue());
        taskObj.set("isasync", (Object)task.isAsyncTask());
        taskObj.set("isstream", (Object)task.isStream());
        taskObj.set("requestbody_tag", (Object)task.getRequestBody());
        taskObj.set("priority", (Object)task.getPriority());
        if (StringUtils.isNotEmpty((String)task.getErrCode())) {
            taskObj.set("errcode", (Object)task.getErrCode());
        }
        if (StringUtils.isNotEmpty((String)task.getErrMsg())) {
            if (task.getErrMsg().length() > 1024) {
                taskObj.set("errmsg", (Object)task.getErrMsg().substring(0, 1024));
            } else {
                taskObj.set("errmsg", (Object)task.getErrMsg());
            }
        }
        if (StringUtils.isNotEmpty((String)task.getResult())) {
            taskObj.set("result_tag", (Object)task.getResult());
        }
        if (task.getService() != null) {
            taskObj.set("service", (Object)task.getService().getId());
        }
        if (task.getTenant() != null) {
            taskObj.set("tenant", (Object)task.getTenant().getId());
        }
        if (task.getInstance() != null) {
            taskObj.set("instance", (Object)task.getInstance().getId());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskObj});
    }

    public static void updateStatus(Task task) {
        task.setLastUpdateTime(new Date());
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_ENTITY_NAME);
        taskObj.set("id", (Object)task.getId());
        taskObj.set("lastupdatetime", (Object)task.getLastUpdateTime());
        taskObj.set("status", (Object)task.getStatusEnum().getValue());
        if (task.getStatusEnum() == TaskStatusEnum.RUNNING && task.getInstance() != null) {
            taskObj.set("instance", (Object)task.getInstance().getId());
        }
        if (StringUtils.isNotEmpty((String)task.getResult())) {
            taskObj.set("result_tag", (Object)task.getResult());
        }
        if (StringUtils.isNotEmpty((String)task.getErrCode())) {
            taskObj.set("errcode", (Object)task.getErrCode());
        }
        if (StringUtils.isNotEmpty((String)task.getErrMsg())) {
            if (task.getErrMsg().length() > 1024) {
                taskObj.set("errmsg", (Object)task.getErrMsg().substring(0, 1024));
            } else {
                taskObj.set("errmsg", (Object)task.getErrMsg());
            }
        }
        SaveServiceHelper.update((DynamicObject)taskObj);
        TaskDao.saveStatusHistory(task);
    }

    public static void updateStreamFlag(Task task) {
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_ENTITY_NAME);
        taskObj.set("id", (Object)task.getId());
        taskObj.set("isstream", (Object)task.isStream());
        SaveServiceHelper.update((DynamicObject)taskObj);
    }

    public static void updatePrepareParam(Task task) {
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_ENTITY_NAME);
        taskObj.set("id", (Object)task.getId());
        taskObj.set("requestbody_tag", (Object)task.getRequestBody());
        SaveServiceHelper.update((DynamicObject)taskObj);
    }

    private static void saveStatusHistory(Task task) {
        DynamicObject statusHistoryObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_HISTORY_ENTITY_NAME);
        statusHistoryObj.set("task", (Object)task.getId());
        statusHistoryObj.set("lastupdatetime", (Object)task.getLastUpdateTime());
        statusHistoryObj.set("status", (Object)task.getStatusEnum().getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{statusHistoryObj});
    }

    public static void queryRequestParameters(Task task) {
        if (task.getRequestBody() == null) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)task.getId(), (String)TASK_ENTITY_NAME, (String)String.format("%s,%s", "id", "requestbody_tag"));
            task.setRequestBody(obj.getString("requestbody_tag"));
        }
    }

    public static Map<String, Object> queryExecuteTaskByTimeSort(String serviceId, int topNum) {
        String properties = String.format("%s,%s,%s,%s.id,%s.id,%s,%s", "status", "priority", "isstream", "service", "tenant", "createtime", "requestbody_tag");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("status", "=", (Object)TaskStatusEnum.CREATE.getValue());
        filters.add(filterStatus);
        QFilter serviceFilter = new QFilter(String.format("%s.id", "service"), "=", (Object)Long.parseLong(serviceId));
        filters.add(serviceFilter);
        HashMap<String, Object> taskMap = new HashMap<String, Object>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date rangeDate = calendar.getTime();
        QFilter filterTime = new QFilter("createtime", ">=", (Object)rangeDate);
        filters.add(filterTime);
        String orderBy = String.format("%s", "createtime");
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBy, (int)topNum);
        ArrayList<Task> tasks = new ArrayList<Task>(taskCol.length);
        for (DynamicObject taskObj : taskCol) {
            Task task = new Task();
            task.setId(taskObj.getLong("id"));
            task.setPriority(taskObj.getInt("priority"));
            task.setCreateTime(taskObj.getDate("createtime"));
            task.setStatusEnum(TaskStatusEnum.parse("waiting"));
            task.setServiceId(taskObj.getLong(String.format("%s.id", "service")));
            task.setTenantId(taskObj.getLong(String.format("%s.id", "tenant")));
            task.setAsyncTask(true);
            task.setStream(true);
            task.setRequestBody((String)taskObj.get("requestbody_tag"));
            task.setAccountId(RequestContext.get().getAccountId());
            tasks.add(task);
            taskObj.set("status", (Object)TaskStatusEnum.WAITING.getValue());
        }
        taskMap.put("taskList", tasks);
        taskMap.put("taskDynamic", taskCol);
        return taskMap;
    }

    public static List<Task> queryRunningTasks(Date fromTime) {
        String properties = String.format("%s,%s.id,%s.id", "id", "instance", "tenant");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String[] status = new String[]{TaskStatusEnum.RUNNING.getValue()};
        QFilter filterStatus = new QFilter("status", "in", (Object)status);
        filters.add(filterStatus);
        QFilter filterTime = new QFilter("createtime", ">=", (Object)fromTime);
        filters.add(filterTime);
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Task> tasks = new ArrayList<Task>(taskCol.length);
        for (DynamicObject taskObj : taskCol) {
            Task task = new Task();
            task.setId(taskObj.getLong("id"));
            task.setInstanceId(taskObj.getLong(String.format("%s.id", "instance")));
            task.setTenantId(taskObj.getLong(String.format("%s.id", "tenant")));
            tasks.add(task);
        }
        return tasks;
    }

    public static List<String> getRestartService() {
        long oneDayInMillis = 86400000L;
        long previousDayTimestamp = System.currentTimeMillis() - oneDayInMillis;
        String sql = "select distinct fserviceid from t_aicc_task where fcreatetime > ? and   fstatus in (?,?,?) ";
        List serviceList = (List)DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)sql, (Object[])new Object[]{new Timestamp(previousDayTimestamp), TaskStatusEnum.CREATE.getValue(), TaskStatusEnum.WAITING.getValue(), TaskStatusEnum.RUNNING.getValue()}, resultSet -> {
            ArrayList<String> serviceIdList = new ArrayList<String>(3);
            while (resultSet.next()) {
                String serviceId = resultSet.getString(1);
                serviceIdList.add(serviceId);
            }
            return serviceIdList;
        });
        return serviceList;
    }

    public static void updataRestartTaskStaus() {
        long oneDayInMillis = 86400000L;
        long previousDayTimestamp = System.currentTimeMillis() - oneDayInMillis;
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_aicc_task set fstatus=? where fcreatetime > ? and fstatus in (?,?)", (Object[])new Object[]{TaskStatusEnum.CREATE.getValue(), new Timestamp(previousDayTimestamp), TaskStatusEnum.WAITING.getValue(), TaskStatusEnum.RUNNING.getValue()});
    }

    public static Map<Long, String> queryTaskStatus(long[] taskIdStrList) {
        String properties = String.format("%s,%s", "id", "status");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("id", "in", (Object)taskIdStrList);
        filters.add(filterStatus);
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        HashMap<Long, String> taskStatusMap = new HashMap<Long, String>(taskCol.length);
        for (DynamicObject taskObj : taskCol) {
            long id = taskObj.getLong("id");
            String status = taskObj.getString("status");
            taskStatusMap.put(id, status);
        }
        return taskStatusMap;
    }

    public static long[] queryRunningAsyncTasks() {
        String properties = String.format("%s", "id");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String[] status = new String[]{TaskStatusEnum.CREATE.getValue(), TaskStatusEnum.RUNNING.getValue()};
        QFilter filterStatus = new QFilter("status", "in", (Object)status);
        filters.add(filterStatus);
        QFilter filterAsync = new QFilter("isasync", "=", (Object)Boolean.TRUE);
        filters.add(filterAsync);
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        long[] taskIdArray = new long[taskCol.length];
        int i = 0;
        for (DynamicObject taskObj : taskCol) {
            taskIdArray[i++] = taskObj.getLong("id");
        }
        return taskIdArray;
    }

    public static List<TaskResult> queryTaskResult(long[] taskIdList) {
        String properties = String.format("%s,%s,%s,%s,%s", "id", "result_tag", "status", "errcode", "errmsg");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filterStatus = new QFilter("id", "in", (Object)taskIdList);
        filters.add(filterStatus);
        DynamicObject[] taskCol = BusinessDataServiceHelper.load((String)TASK_ENTITY_NAME, (String)properties, (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<TaskResult> results = new ArrayList<TaskResult>(taskCol.length);
        for (DynamicObject taskObj : taskCol) {
            TaskResult taskResult = new TaskResult();
            taskResult.setId(taskObj.getLong("id"));
            taskResult.setStatus(taskObj.getString("status"));
            taskResult.setResult(taskObj.getString("result_tag"));
            taskResult.setErrCode(taskObj.getString("errcode"));
            taskResult.setErrMsg(taskObj.getString("errmsg"));
            results.add(taskResult);
        }
        return results;
    }

    public static long[] convertIdType(String[] taskIdStrList) {
        long[] taskIdLongList = new long[taskIdStrList.length];
        for (int i = 0; i < taskIdStrList.length; ++i) {
            taskIdLongList[i] = Long.parseLong(taskIdStrList[i]);
        }
        return taskIdLongList;
    }

    public static void updateTaskResult(TaskResult taskResult) {
        DynamicObject taskObj = BusinessDataServiceHelper.newDynamicObject((String)TASK_ENTITY_NAME);
        taskObj.set("id", (Object)taskResult.getId());
        taskObj.set("lastupdatetime", (Object)new Date());
        taskObj.set("status", (Object)taskResult.getStatus());
        if (StringUtils.isNotEmpty((String)taskResult.getErrCode())) {
            taskObj.set("result_tag", (Object)taskResult.getErrCode());
        }
        if (StringUtils.isNotEmpty((String)taskResult.getResult())) {
            taskObj.set("result_tag", (Object)taskResult.getResult());
        }
        if (StringUtils.isNotEmpty((String)taskResult.getErrMsg())) {
            taskObj.set("errmsg", (Object)taskResult.getErrMsg());
        }
        SaveServiceHelper.update((DynamicObject)taskObj);
    }

    public static boolean isStreamTask(long taskId) {
        String properties = String.format("%s,%s", "id", "isstream");
        try {
            DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)TASK_ENTITY_NAME, (String)properties);
            return taskObj != null && taskObj.getBoolean("isstream");
        }
        catch (KDException e) {
            return false;
        }
    }

    public static Task queryTaskStatus(long taskId) {
        String properties = String.format("%s,%s,%s", "id", "status", "createtime");
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)TASK_ENTITY_NAME, (String)properties);
        Task task = new Task();
        task.setId(taskId);
        task.setStatusEnum(TaskStatusEnum.parse(taskObj.getString("status")));
        task.setCreateTime(taskObj.getDate("createtime"));
        return task;
    }
}

