/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.domain;

import com.alibaba.fastjson.JSONObject;
import kd.ai.aicc.core.AuthorizationType;
import kd.ai.aicc.core.CacheHelper;
import kd.ai.aicc.core.DistributeCounter;
import kd.ai.aicc.core.domain.Service;

public class Instance {
    private Service service;
    private long serviceId;
    private long id;
    private String name;
    private String parallelType;
    private int maxParallel;
    private String host;
    private int port;
    private String contextUrl;
    private String protocol = "http";
    private AuthorizationType authType;
    private String clientId;
    private String secretKey;
    private String proxyUserSecretKey;
    private String modelUrl;
    private String authUrl;
    private String customParam;
    private String customHeader;

    public String getCustomParam() {
        return this.customParam;
    }

    public void setCustomParam(String customParam) {
        this.customParam = customParam;
    }

    public String getCustomHeader() {
        return this.customHeader;
    }

    public void setCustomHeader(String customHeader) {
        this.customHeader = customHeader;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(long serviceId) {
        this.serviceId = serviceId;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }

    public void setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getContextUrl() {
        return this.contextUrl;
    }

    public void setContextUrl(String contextUrl) {
        this.contextUrl = contextUrl;
    }

    public String getParallelType() {
        return this.parallelType;
    }

    public void setParallelType(String parallelType) {
        this.parallelType = parallelType;
    }

    public String getModelUrl() {
        return this.modelUrl;
    }

    public void setModelUrl(String modelUrl) {
        this.modelUrl = modelUrl;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public void setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
    }

    public AuthorizationType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthorizationType authType) {
        this.authType = authType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getProxyUserSecretKey() {
        return this.proxyUserSecretKey;
    }

    public void setProxyUserSecretKey(String proxyUserSecretKey) {
        this.proxyUserSecretKey = proxyUserSecretKey;
    }

    public int taskCount() {
        int runningCount = 0;
        String lastSecKey = this.buildRunningTaskLastSecKey();
        String taskCountKey = this.buildRunningTaskCountKey();
        String instanceKy = this.buildInstanceKey();
        JSONObject valStr = CacheHelper.getJSONObject(instanceKy);
        if (valStr == null) {
            this.reCycle();
        } else {
            String lastTaskSpec = valStr.getString(lastSecKey);
            long lastSec = Long.parseLong(lastTaskSpec);
            if (this.parallelType.equals("QPS") && System.currentTimeMillis() - lastSec <= 1000L) {
                runningCount = valStr.getInteger(taskCountKey);
            } else if (this.parallelType.equals("RPM") && System.currentTimeMillis() - lastSec <= 60000L) {
                runningCount = valStr.getInteger(taskCountKey);
            } else {
                this.reCycle();
            }
        }
        return runningCount;
    }

    private void reCycle() {
        long lastSec = System.currentTimeMillis();
        JSONObject instanceSpecJSON = new JSONObject();
        instanceSpecJSON.put(this.buildRunningTaskLastSecKey(), (Object)String.valueOf(lastSec));
        instanceSpecJSON.put(this.buildRunningTaskCountKey(), (Object)0);
        CacheHelper.putJSONObject(this.buildInstanceKey(), instanceSpecJSON);
    }

    public int idleCount() {
        return Math.max(0, this.maxParallel - this.taskCount());
    }

    public int requestResource() {
        this.taskCount();
        return DistributeCounter.addOneByJSON(this.buildInstanceKey(), this.buildRunningTaskCountKey());
    }

    public void releaseResource() {
    }

    private String buildRunningTaskCountKey() {
        return "I_R_TC_" + this.getId();
    }

    private String buildRunningTaskLastSecKey() {
        return "I_R_LS_" + this.getId();
    }

    private String buildInstanceKey() {
        return "I_D_K_" + this.getId();
    }
}

