/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.domain.enuz;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;

public enum ModelAbilityEnum {
    THINK("think", "\u6df1\u5ea6\u601d\u8003", "A"),
    FUNCTION_CALL("functioncall", "Function Call", "B"),
    SEARCH_ONLINE("search", "\u8054\u7f51\u641c\u7d22", "C"),
    PICTURE_PRECEIVE("picpreceive", "\u56fe\u7247\u7406\u89e3", "D");

    private String abilityKey;
    private String abilityName;
    private String modelValue;

    private ModelAbilityEnum(String abilityKey, String abilityName, String modelValue) {
        this.abilityKey = abilityKey;
        this.abilityName = abilityName;
        this.modelValue = modelValue;
    }

    public String getAbilityKey() {
        return this.abilityKey;
    }

    public String getAbilityName() {
        return this.abilityName;
    }

    public String getModelValue() {
        return this.modelValue;
    }

    public static String getModelValueByAbilityKey(String keys) {
        List<ModelAbilityEnum> abilitys = ModelAbilityEnum.getAbilitys(keys);
        return abilitys.stream().map(ModelAbilityEnum::getModelValue).collect(Collectors.joining(","));
    }

    private static List<ModelAbilityEnum> getAbilitys(String keys) {
        ArrayList<ModelAbilityEnum> list = new ArrayList<ModelAbilityEnum>();
        if (StringUtils.isNotEmpty((CharSequence)keys)) {
            String[] split;
            block0: for (String s : split = keys.split(",")) {
                for (ModelAbilityEnum value : ModelAbilityEnum.values()) {
                    if (!value.getAbilityKey().equals(s)) continue;
                    list.add(value);
                    continue block0;
                }
            }
        }
        return list;
    }

    public static String getModelAbilityNameByKey(String keys) {
        List<ModelAbilityEnum> abilitys = ModelAbilityEnum.getAbilitys(keys);
        return abilitys.stream().map(ModelAbilityEnum::getAbilityName).collect(Collectors.joining(","));
    }
}

