/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class AiccService {
    private static Log logger = LogFactory.getLog(AiccService.class);

    public static List<Map<String, Object>> queryInstance(String groupNumber, String serviceNumber, String instanceNumber) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("enable", "=", (Object)"1"));
        filters.add(new QFilter("status", "=", (Object)"C"));
        if (StringUtils.isNotEmpty((String)groupNumber)) {
            logger.info("groupNumber" + groupNumber);
            filters.add(new QFilter("service.group.number", "=", (Object)groupNumber));
        }
        if (StringUtils.isNotEmpty((String)serviceNumber)) {
            logger.info("serviceNumber" + serviceNumber);
            filters.add(new QFilter("service.number", "=", (Object)serviceNumber));
        }
        if (StringUtils.isNotEmpty((String)instanceNumber)) {
            logger.info("instanceNumber" + instanceNumber);
            filters.add(new QFilter("number", "=", (Object)instanceNumber));
        }
        String properties = "id,number,name,service.name,service.number,status,enable,maxparallel,authtype,usersecretkey,clientid,secretkey,protocol,contexturl,host,port";
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"aicc_instance", (String)properties, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"createtime desc");
        List<Map<String, Object>> tenants = AiccService.dynamicCollectionToMapByProperties(objs, properties);
        return tenants;
    }

    public static List<Map<String, Object>> queryLlmAiccServiceList() {
        ArrayList filters = new ArrayList();
        String properties = "id,number,name,createtime,supportstream,enable,group,requestsample,requestsample_tag,llmtype,responsesample,responsesample_tag,version,desc,status";
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"aicc_service", (String)properties, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"createtime desc");
        List<Map<String, Object>> tenants = AiccService.dynamicCollectionToMapByProperties(objs, properties);
        for (Map<String, Object> tenant : tenants) {
            List<Map<String, Object>> instances;
            tenant.put("hasInstance", false);
            String serviceNumber = tenant.getOrDefault("number", "").toString();
            if (!StringUtils.isNotEmpty((String)serviceNumber) || !CollectionUtils.isNotEmpty(instances = AiccService.queryInstance(null, serviceNumber, null))) continue;
            tenant.put("hasInstance", true);
        }
        return tenants;
    }

    public static Map<String, Object> queryLlmAiccService(String serviceNumber) {
        DynamicObject obj;
        Long llmtype;
        List<Map<String, Object>> instances;
        if (StringUtils.isEmpty((String)serviceNumber)) {
            logger.warn("queryLlmAiccService without serviceNumber");
            return Maps.newHashMap();
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("number", "=", (Object)serviceNumber));
        String properties = "id,number,name,createtime,supportstream,enable,group,requestsample,requestsample_tag,responsesample,responsesample_tag,version,llmtype,desc,status";
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"aicc_service", (String)properties, (QFilter[])filters.toArray(new QFilter[filters.size()]), (String)"createtime desc");
        List<Map<String, Object>> services = AiccService.dynamicCollectionToMapByProperties(objs, properties);
        if (CollectionUtils.isEmpty(services)) {
            return Maps.newHashMap();
        }
        if (services.size() > 1) {
            logger.warn("queryLlmAiccService with serviceNumber\uff1a{},has more than one result", (Object)serviceNumber);
        }
        Map<String, Object> service = services.get(0);
        service.put("hasInstance", false);
        if (StringUtils.isNotEmpty((String)serviceNumber) && CollectionUtils.isNotEmpty(instances = AiccService.queryInstance(null, serviceNumber, null))) {
            service.put("hasInstance", true);
        }
        if ((llmtype = (Long)service.get("llmtype")) != null && !llmtype.equals(0L) && (obj = BusinessDataServiceHelper.loadSingle((Object)llmtype, (String)"aicc_llm")) != null) {
            String llmNumber = (String)obj.get("number");
            service.put("llm", llmNumber);
        }
        return service;
    }

    public static List<Map<String, Object>> dynamicCollectionToMapByProperties(DynamicObjectCollection objs, String properties) {
        ArrayList<Map<String, Object>> dynamicMapList = new ArrayList<Map<String, Object>>();
        String[] propertyArray = properties.split(",");
        for (DynamicObject dynamicObject : objs) {
            HashMap<String, Object> dynamicObjectMap = new HashMap<String, Object>(propertyArray.length);
            for (String column : propertyArray) {
                String trimColumn = column.trim();
                dynamicObjectMap.put(trimColumn, dynamicObject.get(trimColumn));
            }
            dynamicMapList.add(dynamicObjectMap);
        }
        return dynamicMapList;
    }
}

