/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.service;

import java.util.ArrayList;
import java.util.List;
import kd.ai.aicc.core.domain.Llm;
import kd.ai.aicc.core.domain.enuz.KnowledgeBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class LlmService {
    public static final String LLM_FORM_ID = "aicc_llm";
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String LLM_FACTORY = "llmfactory";
    public static final String PARAM_DEMO = "paramdemo";
    public static final String MARK = "mark";
    public static final String MAX_INPUT_TOKEN = "maxinputtoken";
    public static final String STREAM_JSON = "streamjson";
    public static final String NO_STREAM_JSON = "nostreamjson";
    public static final String CREATIVITY = "creativity";
    public static final String PRECISION = "precision";
    public static final String BALANCE = "balance";
    public static final String KNOWLEDGE_BASE = "knowledgebase";
    private static final String QUERY_4_LIST_FIELDS = "id,number,name,llmfactory,paramdemo,mark,maxinputtoken,streamjson,nostreamjson,creativity,precision,balance,knowledgebase";

    public static List<Llm> getList() {
        QFilter[] qFilters = new QFilter[]{new QFilter(ID, ">", (Object)0L)};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)LLM_FORM_ID, (String)QUERY_4_LIST_FIELDS, (QFilter[])qFilters, (String)"id desc ");
        ArrayList<Llm> llms = new ArrayList<Llm>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Llm llm = new Llm();
            String number = dynamicObject.getString(NUMBER);
            String name = dynamicObject.getString(NAME);
            String paramDemo = dynamicObject.getString(PARAM_DEMO);
            String mark = dynamicObject.getString(MARK);
            int maxInputToken = dynamicObject.getInt(MAX_INPUT_TOKEN);
            String streamJson = dynamicObject.getString(STREAM_JSON);
            String noStreamJson = dynamicObject.getString(NO_STREAM_JSON);
            String creativity = dynamicObject.getString(CREATIVITY);
            String precision = dynamicObject.getString(PRECISION);
            String balance = dynamicObject.getString(BALANCE);
            KnowledgeBase knowledgeBase = null;
            try {
                String knowledgeBaseString = dynamicObject.getString(KNOWLEDGE_BASE);
                knowledgeBase = StringUtils.isEmpty((CharSequence)knowledgeBaseString) ? KnowledgeBase.DEFAULT : KnowledgeBase.valueOf(knowledgeBaseString);
            }
            catch (Exception e) {
                System.out.println("\u77e5\u8bc6\u5e93\u6a21\u578b\u4e0d\u5b58\u5728\u8be5\u7c7b\u578b");
            }
            llm.setNumber(number);
            llm.setName(name);
            llm.setParamDemo(paramDemo);
            llm.setMark(mark);
            llm.setMaxInputToken(maxInputToken);
            llm.setStreamJson(streamJson);
            llm.setNoStreamJson(noStreamJson);
            llm.setCreativity(creativity);
            llm.setPrecision(precision);
            llm.setBalance(balance);
            llm.setKnowledgeBase(knowledgeBase);
            llms.add(llm);
        }
        return llms;
    }
}

