/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.util;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;

public class EngineCacheUtil {
    private static final Map<String, LocalMemoryCache> cacheMap = new ConcurrentHashMap<String, LocalMemoryCache>();
    private static final String region = UUID.randomUUID().toString();
    private static final int MAX_KEY_LENGTH = 4;
    public static final ErrorCode APPCACHE_KEY_ISNULL = new ErrorCode("aicc.core.000014", ResManager.loadKDString((String)"APP cache \u4e00\u7ea7\u7f13\u5b58key\u4e3a\u7a7a", (String)"aicc.core.000014", (String)"ai-aicc-core", (Object[])new Object[0]));

    public static LocalMemoryCache getLocalCache(String key) {
        if (Objects.nonNull(key)) {
            int length = key.length();
            if (length > 4) {
                key = key.substring(0, 4);
            }
        } else {
            throw new KDBizException(APPCACHE_KEY_ISNULL, new Object[0]);
        }
        LocalMemoryCache localMemoryCache = cacheMap.get(key);
        if (localMemoryCache == null) {
            CacheConfigInfo cacheConfigInfo = new CacheConfigInfo();
            cacheConfigInfo.setMaxItemSize(30000);
            cacheConfigInfo.setTimeout(500);
            String type = CacheKeyUtil.getAcctId() + '.' + key + "_localcache_";
            localMemoryCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, type, cacheConfigInfo);
            cacheMap.put(key, localMemoryCache);
        }
        return localMemoryCache;
    }
}

