/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.aicc.core.volcengine.helper;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class Utils {
    private static Random random;

    public static List<NameValuePair> mapToPairList(Map<String, String> params) {
        ArrayList<NameValuePair> res = new ArrayList<NameValuePair>();
        if (params != null) {
            Iterator<String> var2 = params.keySet().iterator();
            Set<Map.Entry<String, String>> entries = params.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                res.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        return res;
    }

    public static String hashSHA256(byte[] content) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return Hex.encodeHexString((byte[])md.digest(content));
        }
        catch (Exception var2) {
            throw new Exception("Unable to compute hash while signing request: " + var2.getMessage(), var2);
        }
    }

    public static byte[] hmacSHA256(byte[] key, String content) throws Exception {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(content.getBytes());
        }
        catch (Exception var3) {
            throw new Exception("Unable to calculate a request signature: " + var3.getMessage(), var3);
        }
    }

    static {
        try {
            random = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

