/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.common.Enum;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.ai.cvp.utils.StreamHandleUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public enum FileTypeValidEnum {
    PDF("pdf", "25504446"),
    JPG("jpg", "FFD8FFE0,FFD8FFE1,FFD8FFDB,89504E47"),
    JPEG("jpeg", "FFD8FFE0,FFD8FFE1,FFD8FFDB,89504E47"),
    PNG("png", "89504E47,FFD8FFE0,FFD8FFE1,FFD8FFDB"),
    DOC("doc", "D0CF11E0"),
    DOCX("docx", "504B0304"),
    OFD("ofd", "504B0304"),
    WPS("wps", "D0CF11E0");

    private static final Log log;
    private String declareName;
    private String suitableType;

    private FileTypeValidEnum(String declareName, String suitableType) {
        this.declareName = declareName;
        this.suitableType = suitableType;
    }

    public String getDeclareName() {
        return this.declareName;
    }

    public String getSuitableType() {
        return this.suitableType;
    }

    public static List<String> getSuitableTypeByName(String name) {
        FileTypeValidEnum[] values = FileTypeValidEnum.values();
        List lists = Arrays.stream(values).filter(v -> v.getDeclareName().equalsIgnoreCase(name)).map(FileTypeValidEnum::getSuitableType).collect(Collectors.toList());
        if (!lists.isEmpty()) {
            return Arrays.asList(((String)lists.get(0)).split(","));
        }
        return Collections.emptyList();
    }

    public static String getFileTypeDetail(String suitableType, byte[] bytes) throws IOException {
        for (FileTypeValidEnum e : FileTypeValidEnum.values()) {
            if (!e.suitableType.contains(suitableType)) continue;
            if (!"504B0304".equals(suitableType)) {
                return e.getDeclareName();
            }
            return FileTypeValidEnum.DistinguishFileType(bytes);
        }
        return null;
    }

    private static String DistinguishFileType(byte[] bytes) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            String longHeadStr = StreamHandleUtils.getTypeResultByLength(inputStream, 10);
            log.info("\u957f\u6587\u4ef6\u7c7b\u578b\uff1a{}", (Object)longHeadStr);
            if ("504B0304140006000800,504B0304140008080800,504B0304140008000800,504B03040A0000000000".contains(longHeadStr)) {
                String string = "docx";
                return string;
            }
            if ("504B0304140000000800".equals(longHeadStr)) {
                String string = "ofd";
                return string;
            }
            String string = "";
            return string;
        }
    }

    static {
        log = LogFactory.getLog(FileTypeValidEnum.class);
    }
}

