/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.core.ocr.rec;

import com.alibaba.fastjson.JSON;
import java.util.Objects;
import kd.ai.cvp.common.Enum.AlgoMapClassEnum;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.common.Enum.perset.BRNlpEnum;
import kd.ai.cvp.common.Enum.perset.BankCardEnum;
import kd.ai.cvp.common.Enum.perset.CODEnum;
import kd.ai.cvp.common.Enum.perset.COREnum;
import kd.ai.cvp.common.Enum.perset.DLFEnum;
import kd.ai.cvp.common.Enum.perset.DiplomaEnum;
import kd.ai.cvp.common.Enum.perset.GSEnum;
import kd.ai.cvp.common.Enum.perset.GeneralTablePresetEnum;
import kd.ai.cvp.common.Enum.perset.IDCBEnum;
import kd.ai.cvp.common.Enum.perset.IDCFEnum;
import kd.ai.cvp.common.Enum.perset.InvoiceFivEnum;
import kd.ai.cvp.common.Enum.perset.PassportEnum;
import kd.ai.cvp.common.Enum.perset.PaymentRecordEnum;
import kd.ai.cvp.common.Enum.perset.PersetEnum;
import kd.ai.cvp.core.ocr.rec.OcrRecImpl;
import kd.ai.cvp.core.ocr.rec.PerRecImpl;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.entity.classifier.param.ClsRecOcrParams;
import kd.ai.cvp.entity.classifier.param.ClsRecPreParams;
import kd.ai.cvp.entity.distinguish.OcrAlgoDistingshInfo;
import kd.ai.cvp.utils.OcrDistinguisUtils;
import kd.ai.cvp.utils.PresetTemplateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RecDispatcherService {
    private static final Log LOGGER = LogFactory.getLog(RecDispatcherService.class);

    public static OcrAlgoDistingshInfo dispatcherByBill(StorageTypeEnum storageType, String templateNumber, String ocrId, String path) {
        String recResultStr = RecDispatcherService.dispatcher(storageType, templateNumber, ocrId, path);
        Class<? extends PersetEnum> clazz = AlgoMapClassEnum.getValue(templateNumber);
        OcrAlgoDistingshInfo info = Objects.nonNull(clazz) ? PresetTemplateUtils.algoInfoConvert(clazz, recResultStr) : (OcrAlgoDistingshInfo)JSON.parseObject((String)recResultStr, OcrAlgoDistingshInfo.class);
        return info;
    }

    public static AlgoResultData dispatcherByMService(StorageTypeEnum storageType, String templateNumber, String ocrId, String path) {
        String recResultStr = RecDispatcherService.dispatcher(storageType, templateNumber, ocrId, path);
        Class<? extends PersetEnum> clazz = AlgoMapClassEnum.getValue(templateNumber);
        int requestType = Objects.nonNull(clazz) ? 2 : 1;
        AlgoResultData algoResultData = OcrDistinguisUtils.getAlgoResultData(templateNumber, requestType, recResultStr);
        return algoResultData;
    }

    private static String dispatcher(StorageTypeEnum storageType, String templateNumber, String ocrId, String path) {
        String info;
        switch (templateNumber) {
            case "OPM-CertificateOfResignation": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/demission/recognize", COREnum.class));
                break;
            }
            case "OPM-CertificateOfDegree": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/education/recognize", CODEnum.class));
                break;
            }
            case "OPM-Diploma": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/diploma/recognize", DiplomaEnum.class));
                break;
            }
            case "OPM-Invoice": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/vatinvoice/recognition/five", InvoiceFivEnum.class));
                break;
            }
            case "OPM-BankReceipt": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/template/bankTicket", BRNlpEnum.class));
                break;
            }
            case "OPM-BankCard": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/presetocr/bankcard/recognize", BankCardEnum.class));
                break;
            }
            case "OPM-IDCardFront": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/presetocr/idcard/recognize", IDCFEnum.class));
                break;
            }
            case "OPM-IdCardBack": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/presetocr/idcard/recognize", IDCBEnum.class));
                break;
            }
            case "OPM-DrivingLicenseFront": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/presetocr/drivingLicense/recognize/front", DLFEnum.class));
                break;
            }
            case "OPM-Passport": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/presetocr/passport/recognize", PassportEnum.class));
                break;
            }
            case "OPM-GeneralSpotting": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/presetocr/general/spotting", GSEnum.class));
                break;
            }
            case "OPM-GeneralTablePreset": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/table/generalTableRec/rec", GeneralTablePresetEnum.class));
                break;
            }
            case "OPM-PaymentRecord": {
                info = new PerRecImpl().recognize(new ClsRecPreParams(templateNumber, path, storageType, "/nlpservice/paymentExtract", PaymentRecordEnum.class));
                break;
            }
            default: {
                info = new OcrRecImpl().recognize(new ClsRecOcrParams(templateNumber, path, storageType, "/template/recognize", ocrId));
            }
        }
        return info;
    }
}

