/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.core.op;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.ocr.rec.RecDispatcherService;
import kd.ai.cvp.core.op.ClassifierOperateProxy;
import kd.ai.cvp.entity.classifier.ClsAlgoResultData;
import kd.ai.cvp.entity.classifier.ClsFileInfo;
import kd.ai.cvp.entity.classifier.ClsProcessResult;
import kd.ai.cvp.entity.classifier.ClsRecoginzeData;
import kd.ai.cvp.entity.classifier.ClsTargetFile;
import kd.ai.cvp.entity.classifier.ClsTaskDataVO;
import kd.ai.cvp.entity.distinguish.OcrAlgoDistingshInfo;
import kd.ai.cvp.entity.template.DistinguishPos;
import kd.ai.cvp.entity.template.Table;
import kd.ai.cvp.entity.template.TemplateDistInfo;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class ClassifierOperateTest
extends ClassifierOperateProxy {
    private static Log LOGGER = LogFactory.getLog(ClassifierOperateTest.class);
    private static final String systemType = "ai-cvp-plugin";
    public static final ClassifierOperateTest instance = new ClassifierOperateTest();

    public ClsTaskDataVO operate(List<ClsTargetFile> files, long classifierId) {
        if (Objects.isNull(files)) {
            throw new KDBizException(String.format("%s\uff0c\u5206\u7c7b\u76ee\u6807\u6587\u4ef6\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u9644\u4ef6\u670d\u52a1\u662f\u5426\u6b63\u5e38", this.getOperateName()));
        }
        StopWatch watch = new StopWatch();
        watch.start();
        for (ClsTargetFile file : files) {
            file.setStorageType(StorageTypeEnum.TMP);
            String path = file.getUrl();
            if (StringUtils.isNotBlank((CharSequence)path)) {
                String tempPath = CvpFileServiceUtils.attFile2Temp(path);
                FileServiceFactory.getAttachmentFileService().delete(path);
                file.setUrl(tempPath);
                continue;
            }
            throw new KDBizException(String.format("%s\uff0c\u5206\u7c7b\u76ee\u6807\u6587\u4ef6\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u9644\u4ef6\u670d\u52a1\u662f\u5426\u6b63\u5e38", this.getOperateName()));
        }
        watch.stop();
        LOGGER.info(String.format("\u7ec4\u5408\u8bc6\u522b-\u6d4b\u8bd5\uff0c\u5f00\u59cb>>>> \u5206\u7c7b\u5668ID:%s ,\u6587\u4ef6\u4fe1\u606f:%s,\u6587\u4ef6\u8f6c\u6362\u8017\u65f6\uff1a%s\u79d2", classifierId, files.toString(), watch.getTime(TimeUnit.SECONDS)));
        ClsProcessResult cla = this.run(files, classifierId);
        List<ClsFileInfo> claFileInfos = cla.getClsFileInfos();
        List<ClsAlgoResultData.ClassifierInfo> clsSuccess = cla.getClsResult().getClsSuccess();
        ArrayList<ClsRecoginzeData> claRecoginzeDatas = new ArrayList<ClsRecoginzeData>(clsSuccess.size());
        clsSuccess.forEach(c -> {
            ClsRecoginzeData claRecoginzeData;
            String imagesId = c.getFileId();
            String imagePath = claFileInfos.stream().filter(f -> imagesId.equals(f.getImageId())).findAny().get().getImagePath();
            String ocrId = c.getOcrId();
            String templateNum = c.getTemplateNum();
            DynamicObject template = OcrControlUtils.getBindingObjCacheByNumber("cvp_template", templateNum);
            String templateName = template.getString("name");
            OcrAlgoDistingshInfo respData = RecDispatcherService.dispatcherByBill(this.getStorageType(), templateNum, ocrId, imagePath);
            if (0 == respData.getErrorCode()) {
                String infoStr = template.getString("temptageinfo");
                TemplateDistInfo templateDistInfo = (TemplateDistInfo)JSON.parseObject((String)infoStr, TemplateDistInfo.class);
                DistinguishPos distPos = templateDistInfo.getDistinguishPos();
                List<Table> tables = distPos.getTable();
                claRecoginzeData = ClsRecoginzeData.SUCCESS(imagesId, c.gettId(), templateNum, templateName, tables, respData.getData().getOcrResult(), respData.getDescription());
            } else {
                String message = respData.getDescription();
                claRecoginzeData = ClsRecoginzeData.ERROR(imagesId, c.gettId(), templateNum, templateName, message);
            }
            claRecoginzeDatas.add(claRecoginzeData);
        });
        List failureData = cla.getClsResult().getClsFailure().stream().map(f -> ClsRecoginzeData.NO_REC(f.getFileId(), f.getDescription())).collect(Collectors.toList());
        claRecoginzeDatas.addAll(failureData);
        ClsTaskDataVO claData = new ClsTaskDataVO(claFileInfos, claRecoginzeDatas);
        return claData;
    }

    @Override
    protected int covertPageMaxSize() {
        return 5;
    }

    @Override
    protected StorageTypeEnum getStorageType() {
        return StorageTypeEnum.TMP;
    }

    @Override
    protected String getOperateName() {
        return ResManager.loadKDString((String)"\u3010\u7ec4\u5408\u8bc6\u522b-\u6d4b\u8bd5\u670d\u52a1\u3011", (String)"ClassifierOperateTest_0", (String)systemType, (Object[])new Object[0]);
    }
}

