/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.factory;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class OcrEsFactory {
    private static ConcurrentHashMap<String, RestHighLevelClient> highLevelMap = new ConcurrentHashMap();

    public static RestHighLevelClient getEsClient(String region) {
        return highLevelMap.computeIfAbsent(region, k -> OcrEsFactory.getRestHighLevelClient(region));
    }

    private static RestHighLevelClient getRestHighLevelClient(String region) {
        Map<String, String> configMap = OcrEsFactory.getServerConfig(region);
        String ip = configMap.get("ip");
        int port = Integer.parseInt(configMap.get("port"));
        String userName = configMap.get("username");
        String pwd = configMap.get("password");
        if (userName != null && pwd != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, pwd));
            return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, port)}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                {
                    this.val$credentialsProvider = credentialsProvider;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                    httpClientBuilder.disableAuthCaching();
                    return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                }
            }));
        }
        return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, port, "http")}));
    }

    public static Map<String, String> getServerConfig(String region) {
        String password;
        String username;
        String key = "elasticsearch.server." + region;
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new KDBizException(BosErrorCode.fulltextException, new Object[]{key + " the fulltext service is not configured."});
        }
        HashMap<String, String> result = new HashMap<String, String>(12);
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.fulltextException, key + " configuration resolution error.", (Throwable)e);
        }
        String ipStr = prop.getProperty("ip");
        if (StringUtils.isEmpty((CharSequence)ipStr)) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{key + " configuration error: ip can't be empty."});
        }
        result.put("ip", ipStr.trim().toLowerCase());
        String portStr = prop.getProperty("port");
        if (StringUtils.isEmpty((CharSequence)portStr)) {
            throw new KDException(BosErrorCode.fulltextException, new Object[]{key + " configuration error: port can't be empty."});
        }
        result.put("port", portStr.trim().toLowerCase());
        String httpPortStr = prop.getProperty("httpport");
        if (!StringUtils.isEmpty((CharSequence)httpPortStr)) {
            result.put("httpport", httpPortStr.trim().toLowerCase());
        }
        if ((username = prop.getProperty("username")) != null) {
            result.put("username", username);
        }
        if ((password = prop.getProperty("password")) != null) {
            result.put("password", password);
        }
        String enableStr = prop.getProperty("enable", "true");
        result.put("enable", enableStr.trim().toLowerCase());
        String indexStr = prop.getProperty("index", region);
        result.put("index", indexStr.trim().toLowerCase());
        String clusterNameStr = prop.getProperty("clustername", "elasticsearch");
        result.put("clustername", clusterNameStr);
        String totalFieldsStr = prop.getProperty("totalfields", String.valueOf(8000));
        result.put("totalfields", totalFieldsStr);
        String shardsNumberStr = prop.getProperty("shardsnumber", String.valueOf(5));
        result.put("shardsnumber", shardsNumberStr);
        String perlicasNumverStr = prop.getProperty("replicasnumber", String.valueOf(2));
        result.put("replicasnumber", perlicasNumverStr);
        return result;
    }
}

