/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.msdemo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.io.Files;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.entity.AlgoResultData;
import kd.ai.cvp.utils.CvpFileServiceUtils;
import kd.ai.cvp.utils.OcrControlUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.pdfbox.io.IOUtils;

public class CvpMserviceTestPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log logger = LogFactory.getLog(CvpMserviceTestPlugin.class);
    private static final String KEY_INTERFACE = "interface_service";
    private static final String ATTACHMENT = "attachmentfield";
    private static final String BUSINESSOBJECT = "businessobject";
    private static final String CLOUDID = "cloudid";
    private static final String APPID = "appid";
    private static final String CLASSIFY = "classify";
    private static final String KEY_CLASSIFY = "classify";
    private static final String KEY_TEMPLATENUMBER = "templatenumber";
    private static final String KEY_BANKACCOUNTS = "bankaccounts";
    private static final String KEY_ACCOUNTNAMES = "accountnames";
    private static final String KEY_ATTACHMENTFIELD = "attachmentfield";
    private static final String KEY_ATTACHMENTFIELD_2 = "attachmentpanelap";
    private static final String KEY_GENERALTABLEPRESET = "generaltablepreset";
    private static final String KEY_RESULTAP = "resultap";
    private static final String KEY_EXTRACT_VARIABLE_SITE = "exparam";
    private static final String KEY_EXTRACT_VARIABLE_SITE_TAG = "exparam_tag";
    private static final String KEY_TIE_PLAN = "multieplan";
    private static final String KEY_TDA_PLAN = "tdaplannumber";
    private static final String KEY_AGENT_FLOW_FLEX = "flexpanelap3";
    private static final String KEY_AGENT_FLOW_TEMPLATEID = "templateid";
    private static final String KEY_AGENT_FLOW_TEMPLATETYPE = "templatetype";
    private static final String KEY_AGENT_FLOW_BIZ_OBJ = "bizobj";
    private static final String KEY_AGENT_FLOW_MAPID = "mapid";
    private static final String KEY_RED_STR = "redstr";
    private static final String FIELD_RED_STR_TAG = "redstr_tag";
    private static final String KEY_PAGE_LIST_STR = "pagestr";
    private static final String KEY_BILL_ID = "billid";
    private static final String NUMBER = "number";
    private static final String BILLID = "billId";
    private static final String TASKID = "taskid";
    private static final String VALUE_TIEFIELDS = "OcrService#getAllTieFields";
    private static final String VALUE_EXTRACTVARIABLESSITE = "OcrService#extractVariablesSite";
    private static final String VALUE_RED_CLAUSE_CHANGE = "OcrService#getContractRedClauseAlter";
    private static final String VALUE_TIE_CREATE_TASK = "OcrService#createTieTask";
    private static final String VALUE_TIE_CREATE_TASK_WITH_PLANINFO = "OcrService#createTieTaskV2";
    private static final String VALUE_TIE_QUERY_TASK = "OcrService#queryTieTaskResult";
    private static final String VALUE_TDA_CREATE_TASK = "OcrService#createTdaTask";
    private static final String VALUE_QUICK_TDA_TASK = "OcrQuickDocDiffService#quickDocDiff";
    private static final String VALUE_TDA_QUERY_TASK = "OcrService#queryTdaTaskResult";
    private static final String VALUE_COMPLEX_EXTRACT_CREATE_TASK = "OcrService#complexDocExtract";
    private static final String VALUE_COMPLEXT_EXTRACT_TASK_QUERY = "OcrService#queryComplexDocExtractInfo";
    private static final String VALUE_CLASSIFY = "OcrClassifierService#singleClassify";
    private static final String VALUE_AGENT_FLOW_OCR = "AgentFlowService#getBizObjList";
    private static final String VALUE_AGENT_FLOW_TREE = "AgentFlowService#getTemplateAndMappingFields";
    private static final String VALUE_OCR_WITH_URL = "OcrService#distinguishOcrByUrl";
    private static final String VALUE_OCRIMAGE = "OcrService#distinguishOcrImageWithParam";
    private static final String VALUE_CHECKELICENSE = "OcrService#checkCVPLicense";
    private static final String VALUE_VALID_AIS_USABLE = "AisEntityService#validAisUsable";
    private static final String VALUE_GET_RED_CLAUSE_CHANGE = "OcrService#getContractRedClauseAlter";
    private static final String VALUE_CHECKBOX = "checkboxfield";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentEdit = (AttachmentPanel)this.getView().getControl("attachmentfield");
        if (attachmentEdit != null) {
            attachmentEdit.addUploadListener((UploadListener)this);
        }
        Button btnok = (Button)this.getView().getControl("btnok");
        btnok.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IFormView view = this.getView();
        if ("btnok".equals(key)) {
            this.callCVPmservice(view);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        view.setVisible(Boolean.TRUE, new String[]{KEY_TEMPLATENUMBER});
        view.setVisible(Boolean.FALSE, new String[]{"classify", "attachmentfield", KEY_ATTACHMENTFIELD_2, KEY_GENERALTABLEPRESET, VALUE_CHECKBOX, KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_AGENT_FLOW_FLEX});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String key = property.getName();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        try {
            for (ChangeData changeData : changeSet) {
                Object newValue = changeData.getNewValue();
                String newValueStr = "";
                if (newValue != null) {
                    newValueStr = newValue.toString();
                }
                Object value = model.getValue(KEY_INTERFACE);
                if (KEY_INTERFACE.equals(key)) {
                    model.setValue(KEY_RESULTAP, (Object)"");
                    switch (newValueStr) {
                        case "OcrClassifierService#singleClassify": {
                            view.setVisible(Boolean.TRUE, new String[]{"classify", "attachmentfield"});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, KEY_ATTACHMENTFIELD_2, VALUE_CHECKBOX, KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "AgentFlowService#getBizObjList": {
                            view.setVisible(Boolean.TRUE, new String[]{KEY_AGENT_FLOW_FLEX, KEY_AGENT_FLOW_TEMPLATEID, KEY_AGENT_FLOW_TEMPLATETYPE});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, "classify", KEY_GENERALTABLEPRESET, VALUE_CHECKBOX, "attachmentfield", KEY_ATTACHMENTFIELD_2, KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_MAPID, KEY_AGENT_FLOW_BIZ_OBJ});
                            break;
                        }
                        case "AgentFlowService#getTemplateAndMappingFields": {
                            view.setVisible(Boolean.TRUE, new String[]{KEY_AGENT_FLOW_FLEX, KEY_AGENT_FLOW_TEMPLATEID, KEY_AGENT_FLOW_TEMPLATETYPE, KEY_AGENT_FLOW_MAPID, KEY_AGENT_FLOW_BIZ_OBJ});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, "classify", KEY_GENERALTABLEPRESET, VALUE_CHECKBOX, "attachmentfield", KEY_ATTACHMENTFIELD_2, KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN});
                            break;
                        }
                        case "OcrService#distinguishOcrByUrl": {
                            view.setVisible(Boolean.TRUE, new String[]{KEY_TEMPLATENUMBER, VALUE_CHECKBOX, "attachmentfield"});
                            view.setVisible(Boolean.FALSE, new String[]{"classify", KEY_ATTACHMENTFIELD_2, KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_FLEX, KEY_AGENT_FLOW_FLEX, KEY_AGENT_FLOW_TEMPLATEID, KEY_AGENT_FLOW_TEMPLATETYPE});
                            break;
                        }
                        case "OcrTemplateFiledsService#getFiledInfoByNumber": {
                            view.setVisible(Boolean.TRUE, new String[]{KEY_TEMPLATENUMBER});
                            view.setVisible(Boolean.FALSE, new String[]{"classify", "attachmentfield", KEY_ATTACHMENTFIELD_2, VALUE_CHECKBOX, KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "OcrService#distinguishOcrImageWithParam": {
                            view.setVisible(Boolean.TRUE, new String[]{KEY_TEMPLATENUMBER, VALUE_CHECKBOX, "attachmentfield"});
                            view.setVisible(Boolean.FALSE, new String[]{"classify", KEY_ATTACHMENTFIELD_2, KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "OcrService#checkCVPLicense": {
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, "attachmentfield", KEY_ATTACHMENTFIELD_2, VALUE_CHECKBOX, KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "AisEntityService#validAisUsable": {
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, "classify", KEY_GENERALTABLEPRESET, VALUE_CHECKBOX, "attachmentfield", KEY_ATTACHMENTFIELD_2, KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "OcrService#getAllTieFields": {
                            view.setVisible(Boolean.TRUE, new String[]{KEY_TIE_PLAN});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, VALUE_CHECKBOX, "classify", KEY_GENERALTABLEPRESET, "attachmentfield", KEY_ATTACHMENTFIELD_2, KEY_EXTRACT_VARIABLE_SITE, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "OcrService#extractVariablesSite": {
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, VALUE_CHECKBOX, "classify", KEY_GENERALTABLEPRESET, "attachmentfield", KEY_ATTACHMENTFIELD_2, KEY_TIE_PLAN, KEY_RED_STR, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_FLEX});
                            view.setVisible(Boolean.TRUE, new String[]{KEY_EXTRACT_VARIABLE_SITE});
                            break;
                        }
                        case "OcrService#getContractRedClauseAlter": {
                            view.setVisible(Boolean.TRUE, new String[]{"attachmentfield", KEY_RED_STR});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, KEY_ATTACHMENTFIELD_2, VALUE_CHECKBOX, KEY_GENERALTABLEPRESET, "classify", KEY_TIE_PLAN, KEY_EXTRACT_VARIABLE_SITE, KEY_PAGE_LIST_STR, KEY_BILL_ID, KEY_TDA_PLAN, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "OcrService#createTieTask": {
                            view.setVisible(Boolean.TRUE, new String[]{"attachmentfield", KEY_TIE_PLAN, KEY_PAGE_LIST_STR, KEY_BILL_ID});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, KEY_ATTACHMENTFIELD_2, VALUE_CHECKBOX, KEY_GENERALTABLEPRESET, "classify", KEY_EXTRACT_VARIABLE_SITE, KEY_TDA_PLAN, KEY_RED_STR, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "OcrService#createTdaTask": {
                            view.setVisible(Boolean.TRUE, new String[]{"attachmentfield", KEY_ATTACHMENTFIELD_2, KEY_TDA_PLAN, KEY_BILL_ID});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, VALUE_CHECKBOX, KEY_GENERALTABLEPRESET, "classify", KEY_EXTRACT_VARIABLE_SITE, KEY_TIE_PLAN, KEY_PAGE_LIST_STR, KEY_RED_STR, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "OcrQuickDocDiffService#quickDocDiff": {
                            view.setVisible(Boolean.TRUE, new String[]{"attachmentfield", KEY_ATTACHMENTFIELD_2});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, VALUE_CHECKBOX, KEY_GENERALTABLEPRESET, "classify", KEY_EXTRACT_VARIABLE_SITE, KEY_TIE_PLAN, KEY_PAGE_LIST_STR, KEY_RED_STR, KEY_TDA_PLAN, KEY_BILL_ID, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "OcrService#complexDocExtract": {
                            view.setVisible(Boolean.TRUE, new String[]{"attachmentfield", "biztaskid", "callback"});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, KEY_ATTACHMENTFIELD_2, VALUE_CHECKBOX, KEY_GENERALTABLEPRESET, "classify", KEY_EXTRACT_VARIABLE_SITE, KEY_TDA_PLAN, KEY_RED_STR, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                        case "OcrService#createTieTaskV2": {
                            view.setVisible(Boolean.TRUE, new String[]{"attachmentfield", KEY_TIE_PLAN, KEY_PAGE_LIST_STR, "callback"});
                            view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER, KEY_ATTACHMENTFIELD_2, VALUE_CHECKBOX, KEY_GENERALTABLEPRESET, "classify", KEY_EXTRACT_VARIABLE_SITE, KEY_TDA_PLAN, KEY_RED_STR, KEY_BILL_ID, "promptwords", "biztaskid", "useattachpath", "extracttable", "extractimageindoc", "tableouttype", "docwithsiteandpage", KEY_BANKACCOUNTS, KEY_ACCOUNTNAMES, KEY_AGENT_FLOW_FLEX});
                            break;
                        }
                    }
                    continue;
                }
                if (!VALUE_CHECKBOX.equals(key)) continue;
                if (value.toString().equals(VALUE_OCRIMAGE)) {
                    if (newValue != null && newValue.equals(Boolean.TRUE)) {
                        view.setVisible(Boolean.TRUE, new String[]{"attachmentfield", KEY_GENERALTABLEPRESET});
                        view.setVisible(Boolean.FALSE, new String[]{KEY_TEMPLATENUMBER});
                        continue;
                    }
                    view.setVisible(Boolean.TRUE, new String[]{KEY_TEMPLATENUMBER});
                    view.setVisible(Boolean.FALSE, new String[]{KEY_GENERALTABLEPRESET});
                    continue;
                }
                view.showTipNotification("\u4ec5\u652f\u6301\u6ce8\u518c\u670d\u52a1\u4e3a\uff1a\u201c\u81ea\u5b9a\u4e49\u6a21\u677f+\u9884\u7f6e\u6a21\u677f\u5fae\u670d\u52a1\u6d4b\u8bd5\u201d\u65f6\u4f7f\u7528\u3002");
                model.setValue(VALUE_CHECKBOX, (Object)Boolean.FALSE);
                model.setDataChanged(false);
            }
        }
        catch (KDBizException kde) {
            logger.error("\u4e1a\u52a1\u5f02\u5e38\uff0c\u5fae\u670d\u52a1\u6d4b\u8bd5\u5f02\u5e38\u3002", (Throwable)kde);
            this.getView().showTipNotification(!StringUtils.isEmpty((String)kde.getMessage()) ? kde.getMessage() : "\u5fae\u670d\u52a1\u6d4b\u8bd5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
        catch (Exception ex) {
            logger.error("\u7cfb\u7edf\u5f02\u5e38\u3002", (Throwable)ex);
            this.getView().showTipNotification("\u5fae\u670d\u52a1\u6d4b\u8bd5\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
    }

    private void callCVPmservice(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject entity = model.getDataEntity();
        String businessobject = entity.getString(BUSINESSOBJECT);
        String cloudid = entity.getString(CLOUDID);
        String appid = entity.getString(APPID);
        String interfaceMethod = entity.getString(KEY_INTERFACE);
        String[] s = interfaceMethod.split("#");
        String interfaceName = s[0];
        String methodName = s[1];
        try {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put(CLOUDID, cloudid);
            map.put(APPID, appid);
            map.put("interfaceName", interfaceName);
            map.put("methodName", methodName);
            map.put(BUSINESSOBJECT, businessobject);
            Object resultObj = null;
            ArrayList<Object> resultList = new ArrayList<Object>(16);
            String templatenumber = "";
            switch (interfaceMethod) {
                case "OcrService#checkCVPLicense": {
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[0]);
                    resultList.add(resultObj);
                    break;
                }
                case "AgentFlowService#getBizObjList": {
                    Object templateId = model.getValue(KEY_AGENT_FLOW_TEMPLATEID);
                    Object templateType = model.getValue(KEY_AGENT_FLOW_TEMPLATETYPE);
                    HashMap param = new HashMap();
                    Object result = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{templateId, templateType, param});
                    resultList.add(result);
                    break;
                }
                case "AgentFlowService#getTemplateAndMappingFields": {
                    Object templateId = model.getValue(KEY_AGENT_FLOW_TEMPLATEID);
                    Object templateType = model.getValue(KEY_AGENT_FLOW_TEMPLATETYPE);
                    Object biz = model.getValue(KEY_AGENT_FLOW_BIZ_OBJ);
                    Object mapId = model.getValue(KEY_AGENT_FLOW_MAPID);
                    String bizFormId = "";
                    if (biz instanceof DynamicObject) {
                        bizFormId = ((DynamicObject)biz).getString(NUMBER);
                    }
                    Object result = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{templateId, templateType, bizFormId, mapId.toString()});
                    resultList.add(result);
                    break;
                }
                case "OcrService#distinguishOcrByUrl": {
                    Object value = model.getValue(VALUE_CHECKBOX);
                    templatenumber = value.equals(Boolean.TRUE) ? String.valueOf(model.getValue(KEY_GENERALTABLEPRESET)) : entity.getDynamicObject(KEY_TEMPLATENUMBER).getString(NUMBER);
                    map.put(KEY_TEMPLATENUMBER, templatenumber);
                    this.getTempFileAndReqMservice(this.getView(), map, resultList, interfaceMethod);
                    break;
                }
                case "OcrService#distinguishOcrImageWithParam": {
                    Object value = model.getValue(VALUE_CHECKBOX);
                    templatenumber = value.equals(Boolean.TRUE) ? String.valueOf(model.getValue(KEY_GENERALTABLEPRESET)) : entity.getDynamicObject(KEY_TEMPLATENUMBER).getString(NUMBER);
                    map.put(KEY_TEMPLATENUMBER, templatenumber);
                    Object bankAccounts = model.getValue(KEY_BANKACCOUNTS);
                    String bankAccStr = "";
                    if (bankAccounts != null && StringUtils.isNotEmpty((String)bankAccounts.toString().trim())) {
                        bankAccStr = bankAccounts.toString().trim();
                        map.put(KEY_BANKACCOUNTS, bankAccStr);
                    }
                    Object accountNames = model.getValue(KEY_ACCOUNTNAMES);
                    String accNameStr = "";
                    if (accountNames != null && StringUtils.isNotEmpty((String)accountNames.toString().trim())) {
                        accNameStr = accountNames.toString().trim();
                        map.put(KEY_ACCOUNTNAMES, accNameStr);
                    }
                    this.getTempFileAndReqMservice(this.getView(), map, resultList, interfaceMethod);
                    break;
                }
                case "OcrTemplateFiledsService#getFiledInfoByNumber": {
                    templatenumber = entity.getDynamicObject(KEY_TEMPLATENUMBER).getString(NUMBER);
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{businessobject, templatenumber});
                    resultList.add(resultObj);
                    break;
                }
                case "OcrClassifierService#singleClassify": {
                    map.put("classifyId", entity.getDynamicObject("classify").getPkValue());
                    this.getTempFileAndReqMservice(this.getView(), map, resultList, interfaceMethod);
                    break;
                }
                case "AisEntityService#validAisUsable": {
                    resultObj = DispatchServiceHelper.invokeBOSService((String)"ais", (String)interfaceName, (String)methodName, (Object[])new Object[0]);
                    resultList.add(resultObj);
                    break;
                }
                case "OcrService#getContractRedClauseAlter": {
                    String redStr = entity.getString(FIELD_RED_STR_TAG);
                    if (StringUtils.isEmpty((String)redStr)) {
                        throw new KDBizException("\u7ea2\u7ebf\u6761\u6b3e\u5185\u5bb9\u4e3a\u7a7a.");
                    }
                    map.put("redStr", redStr);
                    this.getTempFileAndReqMservice(this.getView(), map, resultList, interfaceMethod);
                    break;
                }
                case "OcrService#getAllTieFields": {
                    DynamicObjectCollection plans = entity.getDynamicObjectCollection(KEY_TIE_PLAN);
                    String numbers = plans.stream().map(plan -> ((DynamicObject)((DynamicObject)plans.get(0)).get("fbasedataid")).getString(NUMBER)).collect(Collectors.joining(","));
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{numbers});
                    resultList.add(resultObj);
                    break;
                }
                case "OcrService#createTieTask": {
                    String pageListStr = entity.getString(KEY_PAGE_LIST_STR);
                    String billIdStr = entity.getString(KEY_BILL_ID);
                    DynamicObjectCollection planObjCol = entity.getDynamicObjectCollection(KEY_TIE_PLAN);
                    String planNumber = planObjCol.stream().map(plan -> ((DynamicObject)((DynamicObject)planObjCol.get(0)).get("fbasedataid")).getString(NUMBER)).collect(Collectors.joining(","));
                    map.put("planNumber", planNumber);
                    if (StringUtils.isEmpty((String)billIdStr)) {
                        throw new KDBizException("\u7ea2\u7ebf\u6761\u6b3e\u5185\u5bb9\u4e3a\u7a7a.");
                    }
                    map.put("pageListStr", pageListStr);
                    map.put(BILLID, billIdStr);
                    this.getTempFileAndReqMservice(this.getView(), map, resultList, interfaceMethod);
                    break;
                }
                case "OcrService#createTieTaskV2": {
                    String pageListStr = entity.getString(KEY_PAGE_LIST_STR);
                    DynamicObjectCollection planObjCol = entity.getDynamicObjectCollection(KEY_TIE_PLAN);
                    String planNumber = planObjCol.stream().map(plan -> ((DynamicObject)((DynamicObject)planObjCol.get(0)).get("fbasedataid")).getString(NUMBER)).collect(Collectors.joining(","));
                    String planInfoStr = entity.getString("planinfo_tag");
                    String callback = entity.getString("callback");
                    map.put("planNumber", planNumber);
                    map.put("pageListStr", pageListStr);
                    map.put("planInfo", planInfoStr);
                    map.put("callBackInfo", callback);
                    this.getTempFileAndReqMservice(this.getView(), map, resultList, interfaceMethod);
                    break;
                }
                case "OcrService#queryTieTaskResult": 
                case "OcrService#queryTdaTaskResult": 
                case "OcrService#queryComplexDocExtractInfo": {
                    String taskId = entity.getString(TASKID);
                    if (StringUtils.isEmpty((String)taskId)) {
                        view.showTipNotification("\u4efb\u52a1id\u4e3a\u7a7a\uff0c\u8bf7\u6c42\u5931\u8d25\u3002");
                        return;
                    }
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{taskId});
                    resultList.add(resultObj);
                    break;
                }
                case "OcrService#createTdaTask": {
                    String tdaplannumber = entity.getString(KEY_TDA_PLAN);
                    String billIdStr = entity.getString(KEY_BILL_ID);
                    map.put(BILLID, billIdStr);
                    map.put("tdaPlanNumber", tdaplannumber);
                    this.getTempFileAndReqMservice(this.getView(), map, resultList, interfaceMethod);
                    break;
                }
                case "OcrQuickDocDiffService#quickDocDiff": {
                    boolean useAttachPath = entity.getBoolean("useattachpath");
                    map.put("useAttachPath", useAttachPath);
                    this.getTempFileAndReqMservice(this.getView(), map, resultList, interfaceMethod);
                    break;
                }
                case "OcrService#extractVariablesSite": {
                    String extractStr = entity.getString(KEY_EXTRACT_VARIABLE_SITE_TAG);
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{extractStr});
                    resultList.add(resultObj);
                    break;
                }
                case "OcrService#complexDocExtract": {
                    long bizTaskId = entity.getLong("biztaskid");
                    String callbackStr = entity.getString("callback");
                    boolean useAttachPath = entity.getBoolean("useattachpath");
                    boolean extracttable = entity.getBoolean("extracttable");
                    boolean extractimageindoc = entity.getBoolean("extractimageindoc");
                    String tableouttype = entity.getString("tableouttype");
                    boolean docwithsiteandpage = entity.getBoolean("docwithsiteandpage");
                    map.put("taskId", bizTaskId);
                    map.put("callBackInfo", callbackStr);
                    map.put("useAttachPath", useAttachPath);
                    map.put("tableOutType", tableouttype);
                    map.put("extracttable", extracttable);
                    map.put("extractimageindoc", extractimageindoc);
                    map.put("docwithsiteandpage", docwithsiteandpage);
                    this.getTempFileAndReqMservice(this.getView(), map, resultList, interfaceMethod);
                    break;
                }
                default: {
                    view.showTipNotification("\u672a\u77e5\u5904\u7406\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
                    return;
                }
            }
            model.setValue(KEY_RESULTAP, (Object)String.join((CharSequence)"\n", SerializationUtils.toJsonString(resultList)));
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528mservice\u5931\u8d25...", (Throwable)e);
            view.showTipNotification("\u8bf7\u6c42\u5931\u8d25\uff0c\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002");
        }
    }

    private void getTempFileAndReqMservice(IFormView view, Map<String, Object> map, List<Object> resultList, String interfaceMethod) throws IOException {
        if (map.isEmpty()) {
            logger.error("\u5fc5\u8981\u5165\u53c2\u4e3a\u7a7a\uff0c\u7ed3\u675f\u3002\u3002\u3002");
        }
        Object cloudidObj = map.get(CLOUDID);
        Object appidObj = map.get(APPID);
        Object interfaceNameObj = map.get("interfaceName");
        Object methodNameObj = map.get("methodName");
        Object businessobjectObj = map.get(BUSINESSOBJECT);
        Object classifyIdObj = map.get("classifyId");
        Object templatenumberObj = map.get(KEY_TEMPLATENUMBER);
        Object planNumberObj = map.get("planNumber");
        Object redStrObj = map.get("redStr");
        Object pageListObj = map.get("pageListStr");
        Object billId = map.get(BILLID);
        Object tdaPlanNumberObj = map.get("tdaPlanNumber");
        Object taskIdObj = map.get("taskId");
        Object callBackInfoObj = map.get("callBackInfo");
        Object useAttachPath = map.get("useAttachPath");
        Object extracttableObj = map.get("extracttable");
        Object docwithsiteandpageObj = map.get("docwithsiteandpage");
        Object bankAccountObj = map.get(KEY_BANKACCOUNTS);
        Object accountNamesObj = map.get(KEY_ACCOUNTNAMES);
        Object planInfoObj = map.get("planInfo");
        String planInfoStr = "";
        String bankAccStr = "";
        if (bankAccountObj != null) {
            bankAccStr = bankAccountObj.toString().replace("\uff0c", ",");
        }
        if (planInfoObj != null) {
            planInfoStr = planInfoObj.toString();
        }
        String accountNameStr = "";
        if (accountNamesObj != null) {
            accountNameStr = accountNamesObj.toString().replace("\uff0c", ",");
        }
        boolean extractTable = true;
        if (extracttableObj != null) {
            extractTable = Boolean.parseBoolean(extracttableObj.toString());
        }
        Object extractimageindocObj = map.get("extractimageindoc");
        boolean extractimageindoc = true;
        if (extractimageindocObj != null) {
            extractimageindoc = Boolean.parseBoolean(extractimageindocObj.toString());
        }
        boolean docWithSiteAndPage = false;
        if (docwithsiteandpageObj != null) {
            docWithSiteAndPage = Boolean.parseBoolean(docwithsiteandpageObj.toString());
        }
        Object tableOutTypeObj = map.get("tableOutType");
        String tableOutType = "";
        if (tableOutTypeObj != null) {
            tableOutType = tableOutTypeObj.toString();
        }
        String bizTaskId = null;
        if (taskIdObj != null) {
            bizTaskId = taskIdObj.toString();
        }
        JSONObject callBackInfo = null;
        if (callBackInfoObj != null) {
            callBackInfo = JSON.parseObject((String)callBackInfoObj.toString());
        }
        boolean useAttachPathBool = false;
        String cloudid = "";
        String appid = "";
        String interfaceName = "";
        String methodName = "";
        String businessobject = "";
        long classifyId = 0L;
        String templatenumber = "";
        String redStr = "";
        String pageListStr = "";
        String billIdStr = "";
        String planNumber = "";
        String tdaPlanNumber = "";
        if (cloudidObj != null) {
            cloudid = cloudidObj.toString();
        }
        if (appidObj != null) {
            appid = appidObj.toString();
        }
        if (interfaceNameObj != null) {
            interfaceName = interfaceNameObj.toString();
        }
        if (methodNameObj != null) {
            methodName = methodNameObj.toString();
        }
        if (businessobjectObj != null) {
            businessobject = businessobjectObj.toString();
        }
        if (classifyIdObj != null) {
            classifyId = Long.parseLong(classifyIdObj.toString());
        }
        if (templatenumberObj != null) {
            templatenumber = templatenumberObj.toString();
        }
        if (redStrObj != null) {
            redStr = redStrObj.toString();
        }
        if (pageListObj != null) {
            pageListStr = pageListObj.toString();
        }
        if (billId != null) {
            billIdStr = billId.toString();
        }
        if (planNumberObj != null) {
            planNumber = planNumberObj.toString();
        }
        if (tdaPlanNumberObj != null) {
            tdaPlanNumber = tdaPlanNumberObj.toString();
        }
        if (useAttachPath != null) {
            useAttachPathBool = Boolean.parseBoolean(useAttachPath.toString());
        }
        String storageType = "tmp";
        IPageCache cache = (IPageCache)view.getService(IPageCache.class);
        String tmpAttInfo = cache.get("TampAttCache" + this.getView().getPageId());
        JSONObject attMap = (JSONObject)JSON.parse((String)tmpAttInfo);
        JSONArray atts = (JSONArray)attMap.get((Object)"attachmentfield");
        JSONArray atts2 = null;
        List<String> strings = Arrays.asList(VALUE_TDA_CREATE_TASK, VALUE_QUICK_TDA_TASK);
        if (strings.contains(interfaceMethod)) {
            atts2 = (JSONArray)attMap.get((Object)KEY_ATTACHMENTFIELD_2);
        }
        block22: for (int i = 0; i < atts.size(); ++i) {
            String filePath = String.valueOf(((JSONObject)atts.get(i)).get((Object)"url"));
            String fileName = String.valueOf(((JSONObject)atts.get(i)).get((Object)"name"));
            String fileType = Files.getFileExtension((String)fileName);
            long fileSize = Long.parseLong(String.valueOf(((JSONObject)atts.get(i)).get((Object)"size")));
            Object resultObj = null;
            switch (interfaceMethod) {
                case "OcrService#distinguishOcrImageWithParam": {
                    HashMap<String, String> bizParam = new HashMap<String, String>(16);
                    if (StringUtils.isNotEmpty((String)bankAccStr)) {
                        bizParam.put("bankAccounts", bankAccStr);
                    }
                    if (StringUtils.isNotEmpty((String)accountNameStr)) {
                        bizParam.put("accountNames", accountNameStr);
                    }
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{businessobject, templatenumber, this.getBase64StrByUrl(filePath, fileName), bizParam});
                    resultList.add(resultObj);
                    continue block22;
                }
                case "OcrService#distinguishOcrByUrl": {
                    String name;
                    byte[] bytes;
                    InputStream in;
                    if (useAttachPathBool) {
                        in = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, filePath);
                        bytes = IOUtils.toByteArray((InputStream)in);
                        name = UUID.randomUUID().toString().replace("-", "").concat(".").concat(fileType);
                        filePath = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, name, bytes);
                    }
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{businessobject, templatenumber, filePath});
                    resultList.add(resultObj);
                    continue block22;
                }
                case "OcrClassifierService#singleClassify": {
                    StorageTypeEnum temp = StorageTypeEnum.getStorageTypeEnum(storageType);
                    storageType = "att";
                    InputStream fileIn = CvpFileServiceUtils.getFileIn(temp, filePath);
                    byte[] fileBytes = IOUtils.toByteArray((InputStream)fileIn);
                    String file = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, "ces1.jpg", fileBytes);
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{businessobject, classifyId, fileName, fileType, fileSize, file, storageType});
                    resultList.add(resultObj);
                    FileServiceFactory.getAttachmentFileService().delete(file);
                    continue block22;
                }
                case "OcrService#getContractRedClauseAlter": {
                    InputStream docInputStream = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, filePath);
                    byte[] docBytes = IOUtils.toByteArray((InputStream)docInputStream);
                    String fname = UUID.randomUUID().toString().replace("-", "").concat(".").concat(fileType);
                    String docAttaPath = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, fname, docBytes);
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{docAttaPath, redStr});
                    resultList.add(resultObj);
                    continue block22;
                }
                case "OcrService#createTieTask": {
                    String taskId;
                    JSONObject jsonObject;
                    Object data;
                    AlgoResultData algoResultData;
                    InputStream in = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, filePath);
                    byte[] bytes = IOUtils.toByteArray((InputStream)in);
                    String name = UUID.randomUUID().toString().replace("-", "").concat(".").concat(fileType);
                    String attPath = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, name, bytes);
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{attPath, pageListStr, planNumber, businessobject, billIdStr});
                    if (resultObj != null && (algoResultData = (AlgoResultData)JSON.parseObject((String)resultObj.toString(), AlgoResultData.class)) != null && 0 == algoResultData.getErrorCode() && algoResultData.getData() != null && (data = algoResultData.getData()) != null) {
                        jsonObject = JSON.parseObject((String)data.toString());
                        taskId = jsonObject.getString("taskId");
                        this.getModel().setValue(TASKID, (Object)taskId);
                    }
                    resultList.add(resultObj);
                    continue block22;
                }
                case "OcrService#createTieTaskV2": {
                    String taskId;
                    JSONObject jsonObject;
                    Object data;
                    AlgoResultData algoResultData;
                    InputStream in = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, filePath);
                    byte[] bytes = IOUtils.toByteArray((InputStream)in);
                    String name = UUID.randomUUID().toString().replace("-", "").concat(".").concat(fileType);
                    String attPath = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, name, bytes);
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{attPath, pageListStr, planNumber, JSON.parseObject((String)planInfoStr), callBackInfo});
                    if (resultObj != null && (algoResultData = (AlgoResultData)JSON.parseObject((String)resultObj.toString(), AlgoResultData.class)) != null && 0 == algoResultData.getErrorCode() && algoResultData.getData() != null && (data = algoResultData.getData()) != null) {
                        jsonObject = JSON.parseObject((String)data.toString());
                        taskId = jsonObject.getString("taskId");
                        this.getModel().setValue(TASKID, (Object)taskId);
                    }
                    resultList.add(resultObj);
                    continue block22;
                }
                case "OcrService#createTdaTask": {
                    Object data;
                    AlgoResultData algoResultData;
                    InputStream compareIn;
                    byte[] compareBytes;
                    InputStream baseIn = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, filePath);
                    byte[] baseBytes = IOUtils.toByteArray((InputStream)baseIn);
                    String baseAttPath = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, fileName, baseBytes);
                    if (atts2 == null) {
                        view.showTipNotification("\u8bf7\u4e0a\u4f20\u6bd4\u5bf9\u6587\u4ef6\u3002");
                        return;
                    }
                    String compareUrl = String.valueOf(((JSONObject)atts2.get(i)).get((Object)"url"));
                    String compareName = String.valueOf(((JSONObject)atts2.get(i)).get((Object)"name"));
                    String compareAttPath = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, compareName, compareBytes = IOUtils.toByteArray((InputStream)(compareIn = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, compareUrl))));
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{baseAttPath, compareAttPath, tdaPlanNumber, billIdStr});
                    if (resultObj != null && (algoResultData = (AlgoResultData)JSON.parseObject((String)resultObj.toString(), AlgoResultData.class)) != null && 0 == algoResultData.getErrorCode() && algoResultData.getData() != null && (data = algoResultData.getData()) != null) {
                        JSONObject jsonObject = JSON.parseObject((String)data.toString());
                        String taskId = jsonObject.getString("taskId");
                        this.getModel().setValue(TASKID, (Object)taskId);
                    }
                    resultList.add(resultObj);
                    continue block22;
                }
                case "OcrQuickDocDiffService#quickDocDiff": {
                    if (useAttachPathBool) {
                        InputStream quickBaseIn = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, filePath);
                        byte[] quickaseBytes = IOUtils.toByteArray((InputStream)quickBaseIn);
                        filePath = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, fileName, quickaseBytes);
                    }
                    if (atts2 == null) {
                        view.showTipNotification("\u8bf7\u4e0a\u4f20\u6bd4\u5bf9\u6587\u4ef6\u3002");
                        return;
                    }
                    String quickCompareUrl = String.valueOf(((JSONObject)atts2.get(i)).get((Object)"url"));
                    if (useAttachPathBool) {
                        String quickCompareName = String.valueOf(((JSONObject)atts2.get(i)).get((Object)"name"));
                        InputStream quickCompareIn = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, quickCompareUrl);
                        byte[] quickCompareBytes = IOUtils.toByteArray((InputStream)quickCompareIn);
                        quickCompareUrl = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, quickCompareName, quickCompareBytes);
                    }
                    HashMap<String, String> map1 = new HashMap<String, String>();
                    map1.put("baseUrl", filePath);
                    map1.put("compareUrl", quickCompareUrl);
                    resultObj = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{map1});
                    resultList.add(resultObj);
                    continue block22;
                }
                case "OcrService#complexDocExtract": {
                    String name;
                    byte[] bytes;
                    InputStream in;
                    if (useAttachPathBool) {
                        in = CvpFileServiceUtils.getFileIn(StorageTypeEnum.TMP, filePath);
                        bytes = IOUtils.toByteArray((InputStream)in);
                        name = UUID.randomUUID().toString().replace("-", "").concat(".").concat(fileType);
                        filePath = CvpFileServiceUtils.saveFile(StorageTypeEnum.ATTACHMENT, name, bytes);
                    }
                    HashMap<String, Object> bizParamMap = new HashMap<String, Object>(10);
                    bizParamMap.put("bizTaskId", bizTaskId);
                    bizParamMap.put("fileUrl", filePath);
                    bizParamMap.put("extractTable", extractTable);
                    bizParamMap.put("extractImageInDoc", extractimageindoc);
                    bizParamMap.put("docWithSiteAndPage", docWithSiteAndPage);
                    bizParamMap.put("tableOutType", tableOutType);
                    Object result = DispatchServiceHelper.invokeBizService((String)cloudid, (String)appid, (String)interfaceName, (String)methodName, (Object[])new Object[]{bizParamMap, callBackInfo});
                    if (result != null) {
                        Object data;
                        logger.info("result:{}", result);
                        AlgoResultData algoResultData = (AlgoResultData)JSON.parseObject((String)result.toString(), AlgoResultData.class);
                        if (0 == algoResultData.getErrorCode() && algoResultData.getData() != null && (data = algoResultData.getData()) != null) {
                            this.getModel().setValue(TASKID, (Object)data.toString());
                        }
                    }
                    resultList.add(result);
                    continue block22;
                }
                default: {
                    view.showTipNotification("\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBase64StrByUrl(String tempUrl, String fileName) {
        String suffixStr = fileName != null && fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
        if (StringUtils.isEmpty((String)suffixStr)) throw new KDBizException("\u6587\u4ef6\u683c\u5f0f\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        if (StringUtils.isEmpty((String)suffixStr.trim())) {
            throw new KDBizException("\u6587\u4ef6\u683c\u5f0f\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
        TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = downLoad.getInputStream(tempUrl);){
            String fileBase64Str = OcrControlUtils.getFileBase64ByIO(inputStream);
            switch (suffixStr.toLowerCase(Locale.ENGLISH)) {
                case "jpg": 
                case "jpeg": {
                    fileBase64Str = "data:image/jpeg;base64,".concat(fileBase64Str);
                    break;
                }
                case "png": {
                    fileBase64Str = "data:image/png;base64,".concat(fileBase64Str);
                    break;
                }
                case "pdf": {
                    fileBase64Str = "data:application/pdf;base64,".concat(fileBase64Str);
                    break;
                }
                default: {
                    throw new KDBizException("\u672a\u77e5\u6587\u4ef6\u683c\u5f0f\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
                }
            }
            String string2 = fileBase64Str;
            return string2;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u8fc7\u7a0b\u5904\u7406\u5931\u8d25", (Throwable)e);
            throw new KDBizException("\u4e0a\u4f20\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
        }
    }
}

