/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.ai.cvp.common.Enum.OcrLayoutTypeEnum;
import kd.ai.cvp.common.Enum.SourceTypeEnum;
import kd.ai.cvp.common.Enum.TableOutputTypeEnum;
import kd.ai.cvp.entity.ie.CtiePullResultVO;
import kd.ai.cvp.entity.ie.CtieRequestVO;
import kd.ai.cvp.entity.ie.CtieResponse;
import kd.ai.cvp.entity.ie.CtieResultVO;
import kd.ai.cvp.entity.ie.DocTotalRecLayoutDataVO;
import kd.ai.cvp.entity.ie.HtmlImage;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.LicenseUtils;
import kd.ai.cvp.utils.OcrHttpClientUtils;
import kd.ai.cvp.utils.TdaUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class CtiePullResultServiceNew {
    private static Log logger = LogFactory.getLog(CtiePullResultServiceNew.class);
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ai-cvp-pool-ctieUpdate", (int)1);
    private static volatile AtomicBoolean off = new AtomicBoolean(true);
    private static final long LOCK_WAIT_TIME = 10000L;
    private static final String DLOCK_KEY_QUERY = "cvp_updateCtieTask_";
    private static final String RUNNING_STATE = "running";

    private CtiePullResultServiceNew() {
    }

    public static void executeQuery(RequestContext rc) {
        try {
            logger.info("\u67e5\u8be2\u590d\u6742\u6587\u6863\u63d0\u53d6\u7ed3\u679c\u5f00\u59cb ai-cvp-pool-ctieUpdate");
            DynamicObject[] ctieObjArr = CtiePullResultServiceNew.queryDBForRunningTasks();
            if (ctieObjArr != null && ctieObjArr.length > 0) {
                if (off.compareAndSet(true, false)) {
                    logger.info("\u51c6\u5907\u6267\u884c\u590d\u6742\u6587\u6863\u63d0\u53d6\u4efb\u52a1\u7ed3\u679c\u62c9\u53d6\u3002");
                    ComplexTaskCallBackService service = new ComplexTaskCallBackService();
                    threadPool.execute((Runnable)service, rc);
                } else {
                    logger.info("\u590d\u6742\u6587\u6863\u63d0\u53d6\u67e5\u8be2\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u4e0d\u9700\u8981\u518d\u6b21\u89e6\u53d1...");
                }
            } else {
                logger.info("\u672a\u67e5\u8be2\u5230\u7684\u9700\u8981\u62c9\u53d6\u7ed3\u679c\u7684\u590d\u6742\u6587\u6863\u63d0\u53d6\u4efb\u52a1\uff0c\u7ed3\u675f\u6267\u884c\u3002");
            }
        }
        catch (Exception e) {
            logger.error("cvp-\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u67e5\u8be2\u590d\u6742\u6587\u6863\u63d0\u53d6\u7ed3\u679c-\u4efb\u52a1\u542f\u52a8\u5931\u8d25 ai-cvp-pool-ctieUpdate \u6267\u884c\u5668\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            off.compareAndSet(false, true);
        }
    }

    private static DynamicObject[] queryDBForRunningTasks() {
        QFilter runningFilter = new QFilter("extractstatus", "=", (Object)RUNNING_STATE);
        return BusinessDataServiceHelper.load((String)"cvp_ctie_history", (String)"id,taskid,extractstatus", (QFilter[])new QFilter[]{runningFilter});
    }

    private static CtieResultVO doAfterReq(CtieResultVO resultVO, long taskId) throws Exception {
        List<DocTotalRecLayoutDataVO> layoutData = resultVO.getLayoutData();
        CtiePullResultServiceNew.uploadImages(layoutData, taskId);
        resultVO.setLayoutData(layoutData);
        if ("success".equalsIgnoreCase(resultVO.getStatus())) {
            logger.info("\u6838\u9500\u8bb8\u53ef\uff1ataskId:{}", (Object)taskId);
            LicenseUtils.ensureCallNumToAlgoAsync(true, String.valueOf(taskId), SourceTypeEnum.COMPLEX_DOC_EXTRACT);
            logger.info("\u6838\u9500\u5b8c\u6bd5\u3002\u3002\u3002taskId:{}", (Object)taskId);
        }
        return resultVO;
    }

    private static void uploadImages(List<DocTotalRecLayoutDataVO> layoutData, long taskId) throws Exception {
        if (layoutData != null && !layoutData.isEmpty()) {
            for (DocTotalRecLayoutDataVO layoutDatum : layoutData) {
                List<HtmlImage> images = layoutDatum.getImages();
                int layoutIdx = layoutDatum.getLayoutIdx();
                String layoutType = layoutDatum.getLayoutType();
                String millStr = String.valueOf(System.currentTimeMillis());
                String millSubStr = millStr.substring(millStr.length() - 5);
                String fileName = String.format("%d%d%s", taskId, layoutIdx, millSubStr);
                logger.info("\u540d\u79f0:{}", (Object)fileName);
                if (!OcrLayoutTypeEnum.FIGURE.getType().equals(layoutType) || images == null || images.isEmpty()) continue;
                for (HtmlImage image : images) {
                    String imageName = image.getImageName();
                    if (!StringUtils.isNotEmpty((String)imageName)) continue;
                    String cosmicImageUrl = CommonUtil.getPermanentUrlByImagePath(imageName, "jpg", fileName, "cvp_ctie_history");
                    image.setImageName(cosmicImageUrl);
                }
            }
        }
    }

    private static List<CtieResultVO> doReqAlgoResult(List<Long> taskIds) throws Exception {
        RequestContext requestContext = RequestContext.get();
        String tenantCode = requestContext.getTenantCode();
        String tenantName = requestContext.getTenantInfo().getName();
        String sourceType = "cvp";
        CtieRequestVO ctieRequestVO = new CtieRequestVO();
        ArrayList<Long> taskIdLists = new ArrayList<Long>(taskIds);
        ctieRequestVO.setTaskIds(taskIds);
        ctieRequestVO.setSourceType(sourceType);
        ctieRequestVO.setTenantCode(tenantCode);
        ctieRequestVO.setTenantName(tenantName);
        StringEntity paramStr = new StringEntity(JSON.toJSONString((Object)ctieRequestVO), ContentType.APPLICATION_JSON);
        paramStr.setContentEncoding("UTF-8");
        logger.info("\u8bf7\u6c42\u4efb\u52a1{}\uff0c{},\u5f00\u59cb", (Object)JSON.toJSONString(taskIdLists), (Object)"/vrsp/complexTie/queryComplexExtractResult");
        String resultQuery = OcrHttpClientUtils.kdCloudHttpClientPost("/vrsp/complexTie/queryComplexExtractResult", (HttpEntity)paramStr);
        logger.info("\u8bf7\u6c42\u4efb\u52a1{}\uff0c{},\u7ed3\u675f", (Object)JSON.toJSONString(taskIdLists), (Object)"/vrsp/complexTie/queryComplexExtractResult");
        CtieResponse response = (CtieResponse)JSON.parseObject((String)resultQuery, CtieResponse.class);
        int errorCode = response.getErrorCode();
        if (errorCode != 0) {
            throw new KDBizException(new ErrorCode("402001", ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u4efb\u52a1\u8fd4\u56de\u5f02\u5e38", (String)"OcrServiceImpl_202", (String)"ai-cvp-mservice", (Object[])new Object[0])), new Object[0]);
        }
        return (List)response.getData();
    }

    public static class ComplexTaskCallBackService
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RequestContext rc = RequestContext.get();
                String lockKey = CtiePullResultServiceNew.DLOCK_KEY_QUERY.concat(rc.getTenantCode()).concat("_").concat(rc.getAccountId());
                DLock lock = ComplexTaskCallBackService.getLock(lockKey);
                try {
                    if (lock.tryLock(10000L)) {
                        ComplexTaskCallBackService.doQuery();
                    }
                }
                finally {
                    logger.info("cvp-\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u67e5\u8be2\u590d\u6742\u6587\u6863\u7ed3\u675f\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u9501\u3002");
                    off.compareAndSet(false, true);
                    lock.unlock();
                }
            }
            catch (Exception e) {
                logger.error("\u590d\u6742\u6587\u6863\u7ed3\u679c\u62c9\u53d6\u670d\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
                off.compareAndSet(false, true);
            }
        }

        private static DLock getLock(String lockKey) {
            DLock lock = DLock.create((String)lockKey, (String)String.format("\u9501:%s,\u590d\u6742\u6587\u6863\u63d0\u53d6\u4efb\u52a1\u66f4\u65b0\u9501", lockKey));
            lock.fastMode();
            return lock;
        }

        private static DynamicObject queryDBForUpdate(String taskId) {
            QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
            return BusinessDataServiceHelper.loadSingle((String)"cvp_ctie_history", (String)"id,taskid,docname,extractimageindoc,tableoutputtype,extractstatus,docwithsiteandpage,progressinfo,callback,callbackresult,layoutdata_tag,pageinfo_tag,modifytime", (QFilter[])new QFilter[]{qFilter});
        }

        private static void doQuery() {
            DynamicObject[] runningTaskArr;
            do {
                try {
                    runningTaskArr = CtiePullResultServiceNew.queryDBForRunningTasks();
                    if (runningTaskArr != null && runningTaskArr.length > 0) {
                        List taskIds = Arrays.stream(runningTaskArr).map(obj -> obj.getLong("taskid")).collect(Collectors.toList());
                        List resultList = CtiePullResultServiceNew.doReqAlgoResult(taskIds);
                        List<CtieResultVO> doneList = resultList.stream().filter(result -> !result.getStatus().equals(CtiePullResultServiceNew.RUNNING_STATE)).collect(Collectors.toList());
                        List<CtieResultVO> runningList = resultList.stream().filter(result -> result.getStatus().equals(CtiePullResultServiceNew.RUNNING_STATE)).collect(Collectors.toList());
                        ComplexTaskCallBackService.dealDoneList(doneList);
                        ComplexTaskCallBackService.dealRunningList(runningList);
                    }
                }
                catch (Throwable e) {
                    logger.error("\u67e5\u8be2\u5f02\u5e38\uff0c\u7b49\u5f85\u4e0b\u6b21\u6267\u884c", e);
                }
                ComplexTaskCallBackService.waitForNextQuery();
            } while ((runningTaskArr = CtiePullResultServiceNew.queryDBForRunningTasks()) != null && runningTaskArr.length > 0);
        }

        private static void waitForNextQuery() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                logger.error("\u7b49\u5f85\u88ab\u6253\u65ad,\u7ee7\u7eed\u8fdb\u884c", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }

        private static void dealRunningList(List<CtieResultVO> runningList) {
            if (!runningList.isEmpty()) {
                ArrayList dobjs = new ArrayList(16);
                runningList.forEach(run -> {
                    String taskId = run.getTaskId();
                    TdaUtils.refreshCache(taskId);
                    String progress = run.getProgress();
                    DynamicObject ctieHistoryTaskObj = ComplexTaskCallBackService.queryDBForUpdate(taskId);
                    if (ctieHistoryTaskObj != null) {
                        ctieHistoryTaskObj.set("progressinfo", (Object)progress);
                        dobjs.add(ctieHistoryTaskObj);
                    }
                });
                if (!dobjs.isEmpty()) {
                    SaveServiceHelper.update((DynamicObject[])dobjs.toArray(new DynamicObject[0]));
                }
            }
        }

        private static void dealDoneList(List<CtieResultVO> doneList) {
            if (!doneList.isEmpty()) {
                ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(16);
                for (CtieResultVO ctieResultVO : doneList) {
                    DynamicObject doneObj = ComplexTaskCallBackService.doDealOneTask(ctieResultVO);
                    if (doneObj == null) continue;
                    objs.add(doneObj);
                }
                if (!objs.isEmpty()) {
                    logger.info("\u6279\u91cf\u66f4\u65b0");
                    SaveServiceHelper.update((DynamicObject[])objs.toArray(new DynamicObject[0]));
                }
            }
        }

        private static DynamicObject doDealOneTask(CtieResultVO ctieResultVO) {
            DynamicObject ctieHistoryTaskObj;
            block14: {
                String taskId = ctieResultVO.getTaskId();
                ctieHistoryTaskObj = null;
                try {
                    String progressInfo;
                    ctieHistoryTaskObj = ComplexTaskCallBackService.queryDBForUpdate(taskId);
                    String callback = ctieHistoryTaskObj.getString("callback");
                    String status = ctieResultVO.getStatus();
                    ctieHistoryTaskObj.set("extractstatus", (Object)status);
                    switch (status) {
                        case "success": {
                            progressInfo = "\u590d\u6742\u6587\u6863\u63d0\u53d6\u5b8c\u6210";
                            break;
                        }
                        case "cancel": {
                            progressInfo = "\u53d6\u6d88\u4efb\u52a1";
                            break;
                        }
                        default: {
                            progressInfo = ctieResultVO.getProgress();
                            logger.info("\u8c03\u5ea6\u8fd4\u56de\u7ed3\u679c\u63d0\u793a:{}", (Object)progressInfo);
                            progressInfo = StringUtils.isEmpty((String)progressInfo) ? "\u63d0\u53d6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002" : (progressInfo.length() > 200 ? progressInfo.substring(0, 199) : progressInfo);
                        }
                    }
                    ctieHistoryTaskObj.set("progressinfo", (Object)progressInfo);
                    long taskIdLong = Long.parseLong(taskId);
                    CtieResultVO result = CtiePullResultServiceNew.doAfterReq(ctieResultVO, taskIdLong);
                    ctieHistoryTaskObj.set("layoutdata_tag", (Object)JSON.toJSONString(result.getLayoutData()));
                    ctieHistoryTaskObj.set("pageinfo_tag", (Object)JSON.toJSONString(result.getPageInfo()));
                    boolean recallResult = false;
                    if (StringUtils.isNotEmpty((String)callback) && !"null".equals(callback)) {
                        CtiePullResultVO ctiePullResultVO = (CtiePullResultVO)JSON.parseObject((String)callback, CtiePullResultVO.class);
                        ComplexTaskCallBackService.preHandler(result, ctieHistoryTaskObj);
                        recallResult = CommonUtil.recallService(ctiePullResultVO, JSON.toJSONString((Object)result));
                        logger.info("\u56de\u8c03\u7ed3\u675f,\u4efb\u52a1\uff1a{},\u56de\u8c03\u7ed3\u679c\uff1a{}", (Object)taskId, (Object)recallResult);
                    }
                    ctieHistoryTaskObj.set("callbackresult", (Object)(recallResult + ""));
                    ctieHistoryTaskObj.set("modifytime", (Object)System.currentTimeMillis());
                }
                catch (KDBizException ke) {
                    logger.error("\u5904\u7406\u4efb\u52a1{}\u5f02\u5e38\u3002", (Object)taskId, (Object)ke);
                    if (ctieHistoryTaskObj != null) {
                        ErrorCode errorCode = ke.getErrorCode();
                        String alertMsg = ke.getMessage();
                        if (errorCode != null) {
                            alertMsg = errorCode.getMessage();
                        }
                        ComplexTaskCallBackService.setError(alertMsg, ctieHistoryTaskObj);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5904\u7406\u4efb\u52a1{}\u5f02\u5e38\uff0c\u7b49\u5f85\u4e0b\u6b21\u7ee7\u7eed\u5904\u7406\u3002", (Object)taskId, (Object)e);
                    if (ctieHistoryTaskObj == null) break block14;
                    String message = e.getMessage();
                    ComplexTaskCallBackService.setError(message, ctieHistoryTaskObj);
                }
            }
            return ctieHistoryTaskObj;
        }

        private static void setError(String alertMsg, DynamicObject ctieHistoryTaskObj) {
            alertMsg = StringUtils.isEmpty((String)alertMsg) ? ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u3002", (String)"CtiePullResultServiceNew_100", (String)"ai-cvp-common", (Object[])new Object[0]) : alertMsg;
            ctieHistoryTaskObj.set("extractstatus", (Object)"error");
            ctieHistoryTaskObj.set("progressinfo", (Object)alertMsg);
            ctieHistoryTaskObj.set("modifytime", (Object)System.currentTimeMillis());
        }

        private static void preHandler(CtieResultVO result, DynamicObject ctieHistoryTaskObj) {
            String[] split;
            List<DocTotalRecLayoutDataVO> docTotalRecLayoutDataVOS = result.getLayoutData();
            String tableOutputType = ctieHistoryTaskObj.getString("tableoutputtype");
            String docName = ctieHistoryTaskObj.getString("docname");
            boolean docWithSiteAndPage = ctieHistoryTaskObj.getBoolean("docwithsiteandpage");
            if (StringUtils.isEmpty((String)tableOutputType)) {
                logger.info("\u67e5\u8be2\u6807\u8bb0\u4e3a\uff1a{}", (Object)tableOutputType);
                tableOutputType = TableOutputTypeEnum.JSON.getType();
            }
            String docType = "";
            if (StringUtils.isNotEmpty((String)docName)) {
                docType = docName.substring(docName.lastIndexOf(".") + 1);
            }
            if ((split = tableOutputType.split(",")).length > 0) {
                tableOutputType = split[0];
            }
            if (docTotalRecLayoutDataVOS != null && !docTotalRecLayoutDataVOS.isEmpty()) {
                String markdownStr = CommonUtil.getMarkDownContentAndUpdateVO(docTotalRecLayoutDataVOS, docType, docWithSiteAndPage, tableOutputType);
                result.setDocContent(StringUtils.isEmpty((String)markdownStr) ? "" : markdownStr);
            }
        }
    }
}

