/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.task;

import kd.ai.cvp.common.Enum.VisualTypeEnum;
import kd.ai.cvp.entity.tda.TdaCancelTaskResultVO;
import kd.ai.cvp.utils.CommonUtil;
import kd.ai.cvp.utils.ThreadUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.util.StringUtils;

public class TdaCancelTaskService {
    private static final Log logger = LogFactory.getLog(TdaCancelTaskService.class);

    private TdaCancelTaskService() {
    }

    public static void asyncCancelTdaTask(RequestContext rc, String taskId, VisualTypeEnum type) {
        boolean flag = TdaCancelTaskService.validCanCancel(taskId, type);
        if (flag) {
            ThreadPool threadPool = ThreadUtils.get();
            Runnable run = () -> {
                logger.info("\u5f00\u59cb\u5f02\u6b65\u53d6\u6d88\u6d4b\u8bd5\u4efb\u52a1\u3002");
                TdaCancelTaskService.cancelTask(taskId, rc);
            };
            threadPool.execute(run, rc);
            logger.info("\u5f02\u6b65\u53d6\u6d88\u4efb\u52a1\u5b8c\u6210\u3002");
        }
    }

    private static void cancelTask(String taskId, RequestContext rc) {
        try {
            TdaCancelTaskResultVO resultVO = CommonUtil.doCancelTask(taskId, rc.getTraceId(), rc.getCurrUserId());
            if (resultVO != null && resultVO.getCancelResult()) {
                logger.info("\u5f02\u6b65\u53d6\u6d88\u4efb\u52a1\u6210\u529f\u3002");
            } else {
                logger.info("\u5f02\u6b65\u53d6\u6d88\u4efb\u52a1\u5931\u8d25,\u8bf7\u68c0\u67e5\u4efb\u52a1\u8fd0\u884c\u60c5\u51b5\u3002");
            }
        }
        catch (KDBizException e) {
            logger.error("\u5f02\u6b65\u8bf7\u6c42\u7b97\u6cd5\u8c03\u5ea6\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\u3002", (Throwable)e);
            String code = e.getErrorCode().getCode();
            if (Integer.parseInt(code) == 40007) {
                logger.error("\u7b97\u6cd5\u8c03\u5ea6\u63d0\u793a\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u7ba1\u7406\u5458\u68c0\u67e5\u7b97\u6cd5\u8c03\u5ea6\u65e5\u5fd7\u3002");
            }
        }
        catch (Exception ex) {
            logger.error("\u53d6\u6d88\u5931\u8d25\uff0c\u672a\u77e5\u5f02\u5e38\u3002", (Throwable)ex);
        }
    }

    private static boolean validCanCancel(String taskId, VisualTypeEnum type) {
        if (StringUtils.isEmpty((String)taskId)) {
            logger.error("\u4efb\u52a1id\u8fd8\u672a\u751f\u6210\uff0c\u53d6\u6d88\u5931\u8d25\u3002");
            return false;
        }
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject taskObj = null;
        if (type == VisualTypeEnum.DIFF_COMPARISON) {
            taskObj = BusinessDataServiceHelper.loadSingle((String)"cvp_tda_task_history", (String)"id,taskid,billstatus,progressinfo,billenddate", (QFilter[])qFilters);
        } else if (type == VisualTypeEnum.INFO_EXTRACT) {
            taskObj = BusinessDataServiceHelper.loadSingle((String)"cvp_ie_history", (String)"id,taskid,extractstatus,progressinfo,billenddate", (QFilter[])qFilters);
        }
        if (taskObj != null) {
            logger.error("\u4efb\u52a1\u975e\u6d4b\u8bd5\u4efb\u52a1\uff0c\u5f02\u6b65\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\u3002");
            return false;
        }
        return true;
    }
}

