/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.task.cls;

import java.util.Objects;
import kd.ai.cvp.common.Enum.StorageTypeEnum;
import kd.ai.cvp.core.ocr.rec.RecDispatcherService;
import kd.ai.cvp.entity.distinguish.OcrAlgoDistingshInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class RecService {
    private static Log LOGGER = LogFactory.getLog(RecService.class);
    private static ThreadPool ES = ThreadPools.newFixedThreadPool((String)"ai-cvp-pool-rec", (int)1);

    public static synchronized void excuteTask() {
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"cvp_classifier_rec_task", (String)"id", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"new")}, (String)"createtime asc");
        for (DynamicObject idObj : ids) {
            long id = idObj.getLong("id");
            ES.execute((Runnable)new RecTask(id));
        }
    }

    public static class RecTask
    implements Runnable {
        private final long recTaskId;
        private RequestContext rc = RequestContext.get();
        private static final long LOCK_WAIT_TIME = 3000L;
        private static final String LOCK_KEY_PER = "cvp_classifier_rec";

        public RecTask(long recTaskId) {
            this.recTaskId = recTaskId;
        }

        @Override
        public void run() {
            DynamicObject task;
            block9: {
                task = null;
                try {
                    boolean isExec = QueryServiceHelper.exists((String)"cvp_classifier_rec_task", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.recTaskId).and("billstatus", "=", (Object)"new")});
                    String lockKey = LOCK_KEY_PER.concat(this.rc.getTenantCode()).concat(this.rc.getAccountId()).concat(String.valueOf(this.recTaskId));
                    DLock lock = this.getLock(lockKey);
                    if (!isExec || !lock.tryLock(3000L)) {
                        LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u8bc6\u522b\u5668-\u8bc6\u522b\u4efb\u52a1,\u83b7\u4efb\u52a1\u6267\u884c\u6743\u5931\u8d25\uff0c\u4e2d\u65ad\u672c\u6b21\u4efb\u52a1\uff0c\u5206\u7c7b\u4efb\u52a1ID: %s ,\u67e5\u8be2\u65b0\u5efa\u72b6\u6001: %s", this.recTaskId, isExec));
                        return;
                    }
                    try {
                        task = BusinessDataServiceHelper.loadSingle((Object)this.recTaskId, (String)"cvp_classifier_rec_task");
                        task.set("billstatus", (Object)"running");
                        SaveServiceHelper.update((DynamicObject)task);
                        String storageTypeStr = task.getString("storagetype");
                        String templateNunber = task.getString("templatenum");
                        String ocrId = task.getString("ocrid");
                        String path = task.getString("filepath");
                        StorageTypeEnum storageType = StorageTypeEnum.getStorageTypeEnum(storageTypeStr);
                        OcrAlgoDistingshInfo result = RecDispatcherService.dispatcherByBill(storageType, templateNunber, ocrId, path);
                        int errorCode = result.getErrorCode();
                        if (0 == errorCode) {
                            task.set("billstatus", (Object)"success");
                        } else {
                            task.set("billstatus", (Object)"error");
                        }
                        task.set("recdata", (Object)result.getData());
                        task.set("process", (Object)result.getDescription());
                    }
                    catch (Exception e) {
                        try {
                            String message = String.format("\u5355\u524d\u4efb\u52a1\u6267\u884c\u7684traceId:%s ,\u5f02\u5e38\u4fe1\u606f\uff1a%s", this.rc.getTraceId(), e.getMessage().length() > 300 ? e.getMessage().substring(0, 299) : e.getMessage());
                            LOGGER.error(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u8bc6\u522b\u5668-\u8bc6\u522b\u4efb\u52a1 \u5f02\u5e38\uff0c\u5f85\u4e0b\u6b21\u66f4\u65b0: %s", message), (Throwable)e);
                            throw new KDBizException(message);
                        }
                        catch (Throwable throwable) {
                            LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u8bc6\u522b\u5668-\u8bc6\u522b\u4efb\u52a1, \u91ca\u653e\u9501\uff1a%s", lockKey));
                            lock.unlock();
                            throw throwable;
                        }
                    }
                    LOGGER.info(String.format("\u89c6\u89c9\u8bc6\u522b\u670d\u52a1-\u5206\u7c7b\u8bc6\u522b\u5668-\u8bc6\u522b\u4efb\u52a1, \u91ca\u653e\u9501\uff1a%s", lockKey));
                    lock.unlock();
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u7ec4\u5408\u8bc6\u522b-\u8bc6\u522b\u4efb\u52a1\uff0c\u5931\u8d25 >>>> \u8bc6\u522b\u4efb\u52a1ID:%s", this.recTaskId));
                    if (!Objects.nonNull(task)) break block9;
                    task.set("billstatus", (Object)"error");
                    task.set("process", (Object)e.getMessage());
                }
            }
            SaveServiceHelper.update(task);
        }

        private DLock getLock(String lockKey) {
            DLock lock = DLock.create((String)lockKey, (String)String.format("\u9501:%s,\u5dee\u5f02\u5206\u6790\u4efb\u52a1\u66f4\u65b0\u9501", lockKey));
            lock.fastMode();
            return lock;
        }
    }
}

