/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ClsUtils {
    private static final String pattern_regex = "^[\\u4e00-\\u9fa5,a-zA-Z0-9]+$";
    private static final String split_regex = ",";
    private static final String BILL_PLUGIN_NAME = "ai-cvp-plugin";

    public static void includedOp(ChangeData change, IFormView view) {
        int index = change.getRowIndex();
        DynamicObject newObj = (DynamicObject)change.getNewValue();
        if (Objects.nonNull(newObj)) {
            long newPk = (Long)newObj.getPkValue();
            DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)newPk, (String)"cvp_template");
            String desc = template.getString("description");
            Integer rowIndex = index;
            view.getModel().setValue("template_desc", (Object)desc, rowIndex.intValue());
        }
    }

    public static void initDescData(IFormView view) {
        DynamicObjectCollection rows;
        IDataModel model = view.getModel();
        String billno = (String)model.getValue("number");
        if (StringUtil.isBlank((CharSequence)billno)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
            model.setValue("number", (Object)String.format("CLS-%s%s", sdf.format(new Date()), Integer.toHexString(UUID.randomUUID().hashCode())));
        }
        if (Objects.nonNull(rows = model.getEntryEntity("template_infos"))) {
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)((DynamicObject)rows.get(i)).get("included_template");
                if (!Objects.nonNull(row)) continue;
                Object tPk = row.getPkValue();
                DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)tPk, (String)"cvp_template");
                String desc = template.getString("description");
                view.getModel().setValue("template_desc", (Object)desc, i);
            }
        }
        view.getModel().setDataChanged(false);
    }

    public static boolean checkKeywords(ChangeData change, IFormView view) {
        String newStr = (String)change.getNewValue();
        String oldStr = (String)change.getOldValue();
        IDataModel model = view.getModel();
        DynamicObjectCollection entryDatas = model.getEntryEntity("template_infos");
        Pattern pattern = Pattern.compile(pattern_regex);
        EntryGrid entrys = (EntryGrid)view.getControl("template_infos");
        int index = entrys.getSelectRows()[0];
        if (!StringUtils.isNotBlank((CharSequence)newStr)) {
            if (Objects.nonNull(newStr)) {
                model.setValue("keyoword", (Object)"", index);
            }
            return true;
        }
        boolean status = !pattern.matcher(newStr).find();
        model.setDataChanged(false);
        if (status) {
            view.showTipNotification(String.format("\u6a21\u7248\u5206\u7c7b\u5173\u952e\u5b57\u3010\u7b2c%s\u884c\u3011\u8f93\u5165\u6570\u636e\u4e0d\u5408\u89c4", index + 1));
            model.setValue("keyoword", (Object)oldStr, index);
            return false;
        }
        String[] keywords = newStr.split(split_regex);
        int length = keywords.length;
        if (length == 0) {
            model.setValue("keyoword", (Object)oldStr, index);
            return false;
        }
        if (length > 5) {
            view.showTipNotification(String.format("\u6a21\u7248\u5206\u7c7b\u5173\u952e\u5b57\u3010\u7b2c%s\u884c\u3011\u6700\u591a\u652f\u6301\u8f93\u51655\u4e2a\u5173\u952e\u8bcd", index + 1));
            model.setValue("keyoword", (Object)oldStr, index);
            return false;
        }
        Set kset = Arrays.stream(keywords).collect(Collectors.toSet());
        if (length != kset.size()) {
            model.setValue("keyoword", (Object)oldStr, index);
            view.showTipNotification(String.format("\u6a21\u7248\u5206\u7c7b\u5173\u952e\u5b57\u3010\u7b2c%s\u884c\u3011\u5173\u952e\u8bcd\u91cd\u590d", index + 1));
            return false;
        }
        for (int i = 0; i < entryDatas.size(); ++i) {
            String[] ks;
            String k;
            if (i == index || !StringUtils.isNotBlank((CharSequence)(k = ((DynamicObject)entryDatas.get(i)).getString("keyoword"))) || !Objects.nonNull(ks = k.split(split_regex))) continue;
            for (String s : ks) {
                boolean isAdd = kset.add(s);
                if (isAdd) continue;
                model.setValue("keyoword", (Object)oldStr, index);
                view.showTipNotification(String.format("\u6a21\u7248\u5206\u7c7b\u5173\u952e\u5b57\u3010\u7b2c%s\u884c\u3011\u5173\u952e\u8bcd\u91cd\u590d", index + 1));
                return false;
            }
        }
        return true;
    }

    public static void beforSaveOp(IFormView view, BeforeItemClickEvent evt) {
        DynamicObjectCollection rows;
        String billname;
        String status = view.getModel().getDataEntity().getString("status");
        if ("C".equals(status)) {
            view.getModel().setValue("status", (Object)"B");
        }
        if (StringUtils.isBlank((CharSequence)(billname = view.getModel().getDataEntity().getString("name")))) {
            String message = ResManager.loadKDString((String)"\u7ec4\u5408\u8bc6\u522b\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ClassifierInfoBillPlugin_0", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]);
            view.showTipNotification(message);
            evt.setCancel(true);
        }
        if (Objects.nonNull(rows = view.getModel().getEntryEntity("template_infos")) && rows.size() < 2) {
            String message = ResManager.loadKDString((String)"\u7ec4\u5408\u8bc6\u522b\u914d\u7f6e\u81f3\u5c11\u4e24\u4e2a\u6a21\u7248\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ClassifierInfoBillPlugin_0", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]);
            view.showTipNotification(message);
            evt.setCancel(true);
        }
        if (Objects.nonNull(rows)) {
            HashSet<Long> pkSet = new HashSet<Long>(rows.size());
            ArrayList<Integer> delIndex = new ArrayList<Integer>(rows.size());
            ArrayList<String> templateNames = new ArrayList<String>(rows.size());
            for (int i = 0; i < rows.size(); ++i) {
                long tpk;
                DynamicObject row = (DynamicObject)((DynamicObject)rows.get(i)).get("included_template");
                if (!Objects.nonNull(row) || pkSet.add(tpk = ((Long)row.getPkValue()).longValue())) continue;
                delIndex.add(i);
                templateNames.add(row.getString("name"));
            }
            if (Objects.nonNull(delIndex) && delIndex.size() > 0) {
                String message;
                int[] ints = delIndex.stream().mapToInt(Integer::intValue).toArray();
                view.getModel().deleteEntryRows("template_infos", ints);
                if (rows.size() - delIndex.size() < 2) {
                    evt.setCancel(true);
                    message = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5b58\u5728\u91cd\u590d\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u81f3\u5c11\u4e24\u4e2a\u4e0d\u540c\u7684\u6a21\u677f\u3002", (String)"ClassifierInfoBillPlugin_1", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]);
                    view.showTipNotification(message);
                } else {
                    message = ResManager.loadKDString((String)String.format("\u7ec4\u5408\u8bc6\u522b\u5668\u914d\u7f6e\u5b58\u5728\u91cd\u590d\u6a21\u7248:%s\uff0c\u5df2\u8fc7\u6ee4\u3002", ((Object)templateNames).toString()), (String)"ClassifierInfoBillPlugin_2", (String)BILL_PLUGIN_NAME, (Object[])new Object[0]);
                    view.showTipNotification(message);
                }
            }
        }
    }

    public static boolean complete(DynamicObject cls) {
        String billstatus = cls.getString("status");
        Object billPk = cls.getPkValue();
        boolean exists = QueryServiceHelper.exists((String)"cvp_cls_push_template", (QFilter[])new QFilter[]{new QFilter("classifyid", "=", billPk)});
        DynamicObjectCollection templates = cls.getDynamicObjectCollection("template_infos");
        if (templates != null && templates.size() > 0) {
            int delNum;
            if (exists && (delNum = DeleteServiceHelper.delete((String)"cvp_cls_push_template", (QFilter[])new QFilter[]{new QFilter("classifyid", "=", billPk)})) <= 0) {
                return false;
            }
            DynamicObject[] ds = new DynamicObject[templates.size()];
            for (int i = 0; i < templates.size(); ++i) {
                DynamicObject t = (DynamicObject)templates.get(i);
                DynamicObject dataEntity = ORM.create().newDynamicObject("cvp_cls_push_template");
                dataEntity.set("classifyid", billPk);
                dataEntity.set("included_template", t.get("included_template"));
                dataEntity.set("keyoword", t.get("keyoword"));
                ds[i] = dataEntity;
            }
            SaveServiceHelper.save((DynamicObject[])ds);
        }
        return true;
    }
}

