/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.cvp.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateUtils {
    private static String PATTERN_YYYY_MM_DD = "yyyy-MM-dd";
    private static String[] PATTERNS = new String[]{"yyyy-MM-dd", "yyyyMMdd", "yyyy/MM/dd", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"};

    public static Date parseFormatedDate(String inputDate) {
        SimpleDateFormat df = new SimpleDateFormat();
        for (String pattern : PATTERNS) {
            df.applyPattern(pattern);
            df.setLenient(false);
            ParsePosition pos = new ParsePosition(0);
            Date date = df.parse(inputDate, pos);
            if (date == null) continue;
            return date;
        }
        return null;
    }

    public static String dateToStringByYYYY_MM_DD(Date date) {
        SimpleDateFormat sf = new SimpleDateFormat(PATTERN_YYYY_MM_DD);
        return sf.format(date);
    }

    public static Map<String, LocalDate> getCurrentPeriod(Date beginDate, Date expireDate) {
        HashMap<String, LocalDate> map = new HashMap<String, LocalDate>(10);
        LocalDate beginLocalDate = DateUtils.getLocalDateByDate(beginDate);
        LocalDate expireLocalDate = DateUtils.getLocalDateByDate(expireDate);
        LocalDate nowLocalDate = DateUtils.getLocalDateByDate(new Date());
        Period between = Period.between(nowLocalDate, expireLocalDate);
        int years = between.getYears();
        int months = between.getMonths();
        int days = between.getDays();
        LocalDate nearlyLocalDate = expireLocalDate.minusYears(years);
        LocalDate beforeLocale = null;
        LocalDate expireLocale = null;
        if (months == 0 && days == 0) {
            beforeLocale = nearlyLocalDate;
            expireLocale = nearlyLocalDate.plusYears(1L);
        } else {
            LocalDate beginLocale = nearlyLocalDate.minusYears(1L);
            beforeLocale = beginLocale.isBefore(beginLocalDate) ? beginLocalDate : beginLocale;
            expireLocale = nearlyLocalDate;
        }
        map.put("beginLocalDate", beforeLocale);
        map.put("expireLocalDate", expireLocale);
        return map;
    }

    public static Map<String, Date> getCurrentSubScriptionDate(Date beginDate, Date expireDate) {
        HashMap<String, Date> resultMap = new HashMap<String, Date>(10);
        Map<String, LocalDate> currentPeriod = DateUtils.getCurrentPeriod(beginDate, expireDate);
        LocalDate currentBeginLocalDate = currentPeriod.get("beginLocalDate");
        LocalDate currentExpireLocalDate = currentPeriod.get("expireLocalDate");
        if (currentBeginLocalDate != null && currentExpireLocalDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            Instant beginInstant = currentBeginLocalDate.atStartOfDay().atZone(zone).toInstant();
            Instant expireInstant = currentExpireLocalDate.atStartOfDay().atZone(zone).toInstant();
            resultMap.put("beginDate", Date.from(beginInstant));
            resultMap.put("expireDate", Date.from(expireInstant));
        }
        return resultMap;
    }

    private static LocalDate getLocalDateByDate(Date date) {
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = date.toInstant();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
        return localDateTime.toLocalDate();
    }

    public static Map<String, String> getCurrentSubscriptionDateStr(Date beginDate, Date expireDate) {
        HashMap<String, String> resultMap = new HashMap<String, String>(10);
        Map<String, LocalDate> currentPeriod = DateUtils.getCurrentPeriod(beginDate, expireDate);
        LocalDate currentBeginLocalDate = currentPeriod.get("beginLocalDate");
        LocalDate currentExpireLocalDate = currentPeriod.get("expireLocalDate");
        if (currentBeginLocalDate != null && currentExpireLocalDate != null) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern(PATTERN_YYYY_MM_DD);
            String currentBeginStr = currentBeginLocalDate.format(df);
            String currentExpireStr = currentExpireLocalDate.format(df);
            resultMap.put("beginTimeStr", currentBeginStr);
            resultMap.put("expireStr", currentExpireStr);
        }
        return resultMap;
    }
}

